/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs.encrypt;

import org.h2.security.BlockCipher;

class XTS {
    private static final int GF_128_FEEDBACK = 135;
    private static final int CIPHER_BLOCK_SIZE = 16;
    private final BlockCipher cipher;

    XTS(BlockCipher cipher) {
        this.cipher = cipher;
    }

    void encrypt(long id, int len, byte[] data, int offset) {
        byte[] tweak = this.initTweak(id);
        int i = 0;
        while (i + 16 <= len) {
            if (i > 0) {
                XTS.updateTweak(tweak);
            }
            XTS.xorTweak(data, i + offset, tweak);
            this.cipher.encrypt(data, i + offset, 16);
            XTS.xorTweak(data, i + offset, tweak);
            i += 16;
        }
        if (i < len) {
            XTS.updateTweak(tweak);
            XTS.swap(data, i + offset, i - 16 + offset, len - i);
            XTS.xorTweak(data, i - 16 + offset, tweak);
            this.cipher.encrypt(data, i - 16 + offset, 16);
            XTS.xorTweak(data, i - 16 + offset, tweak);
        }
    }

    void decrypt(long id, int len, byte[] data, int offset) {
        byte[] tweak;
        byte[] tweakEnd = tweak = this.initTweak(id);
        int i = 0;
        while (i + 16 <= len) {
            if (i > 0) {
                XTS.updateTweak(tweak);
                if (i + 16 + 16 > len && i + 16 < len) {
                    tweakEnd = (byte[])tweak.clone();
                    XTS.updateTweak(tweak);
                }
            }
            XTS.xorTweak(data, i + offset, tweak);
            this.cipher.decrypt(data, i + offset, 16);
            XTS.xorTweak(data, i + offset, tweak);
            i += 16;
        }
        if (i < len) {
            XTS.swap(data, i, i - 16 + offset, len - i + offset);
            XTS.xorTweak(data, i - 16 + offset, tweakEnd);
            this.cipher.decrypt(data, i - 16 + offset, 16);
            XTS.xorTweak(data, i - 16 + offset, tweakEnd);
        }
    }

    private byte[] initTweak(long id) {
        byte[] tweak = new byte[16];
        int j = 0;
        while (j < 16) {
            tweak[j] = (byte)(id & 0xFFL);
            ++j;
            id >>>= 8;
        }
        this.cipher.encrypt(tweak, 0, 16);
        return tweak;
    }

    private static void xorTweak(byte[] data, int pos, byte[] tweak) {
        for (int i = 0; i < 16; ++i) {
            int n = pos + i;
            data[n] = (byte)(data[n] ^ tweak[i]);
        }
    }

    private static void updateTweak(byte[] tweak) {
        int ci = 0;
        byte co = 0;
        for (int i = 0; i < 16; ++i) {
            co = (byte)(tweak[i] >> 7 & 1);
            tweak[i] = (byte)((tweak[i] << 1) + ci & 0xFF);
            ci = co;
        }
        if (co != 0) {
            tweak[0] = (byte)(tweak[0] ^ 0x87);
        }
    }

    private static void swap(byte[] data, int source, int target, int len) {
        for (int i = 0; i < len; ++i) {
            byte temp = data[source + i];
            data[source + i] = data[target + i];
            data[target + i] = temp;
        }
    }
}

