/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs.niomem;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileLock;
import java.nio.channels.NonWritableChannelException;
import org.h2.store.fs.FakeFileChannel;
import org.h2.store.fs.FileBaseDefault;
import org.h2.store.fs.niomem.FileNioMemData;

class FileNioMem
extends FileBaseDefault {
    final FileNioMemData data;
    private final boolean readOnly;
    private volatile boolean closed;

    FileNioMem(FileNioMemData data, boolean readOnly) {
        this.data = data;
        this.readOnly = readOnly;
    }

    @Override
    public long size() {
        return this.data.length();
    }

    @Override
    protected void implTruncate(long newLength) throws IOException {
        if (this.readOnly) {
            throw new NonWritableChannelException();
        }
        if (this.closed) {
            throw new ClosedChannelException();
        }
        if (newLength < this.size()) {
            this.data.touch(this.readOnly);
            this.data.truncate(newLength);
        }
    }

    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
        this.data.touch(this.readOnly);
        long newPosition = this.data.readWrite(position, src, 0, src.remaining(), true);
        int len = (int)(newPosition - position);
        src.position(src.position() + len);
        return len;
    }

    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
        int len = dst.remaining();
        if (len == 0) {
            return 0;
        }
        long newPos = this.data.readWrite(position, dst, dst.position(), len, false);
        len = (int)(newPos - position);
        if (len <= 0) {
            return -1;
        }
        dst.position(dst.position() + len);
        return len;
    }

    @Override
    public void implCloseChannel() throws IOException {
        this.closed = true;
    }

    @Override
    public void force(boolean metaData) throws IOException {
    }

    @Override
    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
        if (shared ? !this.data.lockShared() : !this.data.lockExclusive()) {
            return null;
        }
        return new FileLock(FakeFileChannel.INSTANCE, position, size, shared){

            @Override
            public boolean isValid() {
                return true;
            }

            @Override
            public void release() throws IOException {
                FileNioMem.this.data.unlock();
            }
        };
    }

    public String toString() {
        return this.closed ? "<closed>" : this.data.getName();
    }
}

