/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import org.h2.command.dml.DataChangeStatement;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.result.ResultTarget;
import org.h2.result.Row;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.table.VirtualConstructedTable;

public class DataChangeDeltaTable
extends VirtualConstructedTable {
    private final DataChangeStatement statement;
    private final ResultOption resultOption;
    private final Expression[] expressions;

    public static void collectInsertedFinalRow(SessionLocal session, Table table, ResultTarget deltaChangeCollector, ResultOption deltaChangeCollectionMode, Row newRow) {
        Column column;
        if (session.getMode().takeInsertedIdentity && (column = table.getIdentityColumn()) != null) {
            session.setLastIdentity(newRow.getValue(column.getColumnId()));
        }
        if (deltaChangeCollectionMode == ResultOption.FINAL) {
            deltaChangeCollector.addRow(newRow.getValueList());
        }
    }

    public DataChangeDeltaTable(Schema schema, SessionLocal session, DataChangeStatement statement, ResultOption resultOption) {
        super(schema, 0, statement.getStatementName());
        this.statement = statement;
        this.resultOption = resultOption;
        Table table = statement.getTable();
        Column[] tableColumns = table.getColumns();
        int columnCount = tableColumns.length;
        Column[] c = new Column[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            c[i] = tableColumns[i].getClone();
        }
        this.setColumns(c);
        Expression[] expressions = new Expression[columnCount];
        String tableName = this.getName();
        for (int i = 0; i < columnCount; ++i) {
            expressions[i] = new ExpressionColumn(this.database, null, tableName, c[i].getName());
        }
        this.expressions = expressions;
    }

    @Override
    public boolean canGetRowCount(SessionLocal session) {
        return false;
    }

    @Override
    public long getRowCount(SessionLocal session) {
        return Long.MAX_VALUE;
    }

    @Override
    public long getRowCountApproximation(SessionLocal session) {
        return Long.MAX_VALUE;
    }

    @Override
    public ResultInterface getResult(SessionLocal session) {
        this.statement.prepare();
        int columnCount = this.expressions.length;
        LocalResult result = new LocalResult(session, this.expressions, columnCount, columnCount);
        result.setForDataChangeDeltaTable();
        this.statement.update(result, this.resultOption);
        return result;
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        return builder.append(this.resultOption.name()).append(" TABLE (").append(this.statement.getSQL()).append(')');
    }

    @Override
    public boolean isDeterministic() {
        return false;
    }

    public static enum ResultOption {
        OLD,
        NEW,
        FINAL;

    }
}

