/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.util.HashMap;
import org.h2.result.Row;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.Table;
import org.h2.value.Value;
import org.h2.value.ValueBigint;

class GeneratedColumnResolver
implements ColumnResolver {
    private final Table table;
    private Column[] columns;
    private HashMap<String, Column> columnMap;
    private Row current;

    GeneratedColumnResolver(Table table) {
        this.table = table;
    }

    void set(Row current) {
        this.current = current;
    }

    @Override
    public Column[] getColumns() {
        Column[] columns = this.columns;
        if (columns == null) {
            columns = this.createColumns();
            this.columns = columns;
        }
        return columns;
    }

    private Column[] createColumns() {
        int totalCount;
        Column[] allColumns = this.table.getColumns();
        int baseCount = totalCount = allColumns.length;
        for (int i = 0; i < totalCount; ++i) {
            if (!allColumns[i].isGenerated()) continue;
            --baseCount;
        }
        Column[] baseColumns = new Column[baseCount];
        int j = 0;
        for (int i = 0; i < totalCount; ++i) {
            Column c = allColumns[i];
            if (c.isGenerated()) continue;
            baseColumns[j++] = c;
        }
        return baseColumns;
    }

    @Override
    public Column findColumn(String name) {
        HashMap<String, Column> columnMap = this.columnMap;
        if (columnMap == null) {
            columnMap = this.table.getDatabase().newStringMap();
            for (Column c : this.getColumns()) {
                columnMap.put(c.getName(), c);
            }
            this.columnMap = columnMap;
        }
        return columnMap.get(name);
    }

    @Override
    public Value getValue(Column column) {
        int columnId = column.getColumnId();
        if (columnId == -1) {
            return ValueBigint.get(this.current.getKey());
        }
        return this.current.getValue(columnId);
    }

    @Override
    public Column getRowIdColumn() {
        return this.table.getRowIdColumn();
    }
}

