/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.h2.api.IntervalQualifier;
import org.h2.command.Command;
import org.h2.command.Parser;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintCheck;
import org.h2.constraint.ConstraintDomain;
import org.h2.constraint.ConstraintReferential;
import org.h2.constraint.ConstraintUnique;
import org.h2.engine.Constants;
import org.h2.engine.DbObject;
import org.h2.engine.QueryStatisticsData;
import org.h2.engine.Right;
import org.h2.engine.RightOwner;
import org.h2.engine.Role;
import org.h2.engine.SessionLocal;
import org.h2.engine.Setting;
import org.h2.engine.User;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.index.Index;
import org.h2.index.MetaIndex;
import org.h2.message.DbException;
import org.h2.mvstore.FileStore;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.db.Store;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.schema.Constant;
import org.h2.schema.Domain;
import org.h2.schema.FunctionAlias;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.schema.UserDefinedFunction;
import org.h2.store.InDoubtTransaction;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.MetaTable;
import org.h2.table.Table;
import org.h2.table.TableSynonym;
import org.h2.table.TableView;
import org.h2.util.DateTimeUtils;
import org.h2.util.MathUtils;
import org.h2.util.NetworkConnectionInfo;
import org.h2.util.StringUtils;
import org.h2.util.TimeZoneProvider;
import org.h2.util.Utils;
import org.h2.util.geometry.EWKTUtils;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.ExtTypeInfoEnum;
import org.h2.value.ExtTypeInfoGeometry;
import org.h2.value.ExtTypeInfoRow;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBigint;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueDouble;
import org.h2.value.ValueInteger;
import org.h2.value.ValueNull;
import org.h2.value.ValueToObjectConverter2;
import org.h2.value.ValueVarchar;

public final class InformationSchemaTable
extends MetaTable {
    private static final String CHARACTER_SET_NAME = "Unicode";
    private static final int INFORMATION_SCHEMA_CATALOG_NAME = 0;
    private static final int CHECK_CONSTRAINTS = 1;
    private static final int COLLATIONS = 2;
    private static final int COLUMNS = 3;
    private static final int COLUMN_PRIVILEGES = 4;
    private static final int CONSTRAINT_COLUMN_USAGE = 5;
    private static final int DOMAINS = 6;
    private static final int DOMAIN_CONSTRAINTS = 7;
    private static final int ELEMENT_TYPES = 8;
    private static final int FIELDS = 9;
    private static final int KEY_COLUMN_USAGE = 10;
    private static final int PARAMETERS = 11;
    private static final int REFERENTIAL_CONSTRAINTS = 12;
    private static final int ROUTINES = 13;
    private static final int SCHEMATA = 14;
    private static final int SEQUENCES = 15;
    private static final int TABLES = 16;
    private static final int TABLE_CONSTRAINTS = 17;
    private static final int TABLE_PRIVILEGES = 18;
    private static final int TRIGGERS = 19;
    private static final int VIEWS = 20;
    private static final int CONSTANTS = 21;
    private static final int ENUM_VALUES = 22;
    private static final int INDEXES = 23;
    private static final int INDEX_COLUMNS = 24;
    private static final int IN_DOUBT = 25;
    private static final int LOCKS = 26;
    private static final int QUERY_STATISTICS = 27;
    private static final int RIGHTS = 28;
    private static final int ROLES = 29;
    private static final int SESSIONS = 30;
    private static final int SESSION_STATE = 31;
    private static final int SETTINGS = 32;
    private static final int SYNONYMS = 33;
    private static final int USERS = 34;
    public static final int META_TABLE_TYPE_COUNT = 35;
    private final boolean isView;

    public InformationSchemaTable(Schema schema, int id, int type) {
        super(schema, id, type);
        Column[] cols;
        String indexColumnName = null;
        boolean isView = true;
        switch (type) {
            case 0: {
                this.setMetaTableName("INFORMATION_SCHEMA_CATALOG_NAME");
                isView = false;
                cols = new Column[]{this.column("CATALOG_NAME")};
                break;
            }
            case 1: {
                this.setMetaTableName("CHECK_CONSTRAINTS");
                cols = new Column[]{this.column("CONSTRAINT_CATALOG"), this.column("CONSTRAINT_SCHEMA"), this.column("CONSTRAINT_NAME"), this.column("CHECK_CLAUSE")};
                indexColumnName = "CONSTRAINT_NAME";
                break;
            }
            case 2: {
                this.setMetaTableName("COLLATIONS");
                cols = new Column[]{this.column("COLLATION_CATALOG"), this.column("COLLATION_SCHEMA"), this.column("COLLATION_NAME"), this.column("PAD_ATTRIBUTE"), this.column("LANGUAGE_TAG")};
                break;
            }
            case 3: {
                this.setMetaTableName("COLUMNS");
                cols = new Column[]{this.column("TABLE_CATALOG"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("COLUMN_NAME"), this.column("ORDINAL_POSITION", TypeInfo.TYPE_INTEGER), this.column("COLUMN_DEFAULT"), this.column("IS_NULLABLE"), this.column("DATA_TYPE"), this.column("CHARACTER_MAXIMUM_LENGTH", TypeInfo.TYPE_BIGINT), this.column("CHARACTER_OCTET_LENGTH", TypeInfo.TYPE_BIGINT), this.column("NUMERIC_PRECISION", TypeInfo.TYPE_INTEGER), this.column("NUMERIC_PRECISION_RADIX", TypeInfo.TYPE_INTEGER), this.column("NUMERIC_SCALE", TypeInfo.TYPE_INTEGER), this.column("DATETIME_PRECISION", TypeInfo.TYPE_INTEGER), this.column("INTERVAL_TYPE"), this.column("INTERVAL_PRECISION", TypeInfo.TYPE_INTEGER), this.column("CHARACTER_SET_CATALOG"), this.column("CHARACTER_SET_SCHEMA"), this.column("CHARACTER_SET_NAME"), this.column("COLLATION_CATALOG"), this.column("COLLATION_SCHEMA"), this.column("COLLATION_NAME"), this.column("DOMAIN_CATALOG"), this.column("DOMAIN_SCHEMA"), this.column("DOMAIN_NAME"), this.column("MAXIMUM_CARDINALITY", TypeInfo.TYPE_INTEGER), this.column("DTD_IDENTIFIER"), this.column("IS_IDENTITY"), this.column("IDENTITY_GENERATION"), this.column("IDENTITY_START", TypeInfo.TYPE_BIGINT), this.column("IDENTITY_INCREMENT", TypeInfo.TYPE_BIGINT), this.column("IDENTITY_MAXIMUM", TypeInfo.TYPE_BIGINT), this.column("IDENTITY_MINIMUM", TypeInfo.TYPE_BIGINT), this.column("IDENTITY_CYCLE"), this.column("IS_GENERATED"), this.column("GENERATION_EXPRESSION"), this.column("DECLARED_DATA_TYPE"), this.column("DECLARED_NUMERIC_PRECISION", TypeInfo.TYPE_INTEGER), this.column("DECLARED_NUMERIC_SCALE", TypeInfo.TYPE_INTEGER), this.column("GEOMETRY_TYPE"), this.column("GEOMETRY_SRID", TypeInfo.TYPE_INTEGER), this.column("IDENTITY_BASE", TypeInfo.TYPE_BIGINT), this.column("IDENTITY_CACHE", TypeInfo.TYPE_BIGINT), this.column("COLUMN_ON_UPDATE"), this.column("IS_VISIBLE", TypeInfo.TYPE_BOOLEAN), this.column("DEFAULT_ON_NULL", TypeInfo.TYPE_BOOLEAN), this.column("SELECTIVITY", TypeInfo.TYPE_INTEGER), this.column("REMARKS")};
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 4: {
                this.setMetaTableName("COLUMN_PRIVILEGES");
                cols = new Column[]{this.column("GRANTOR"), this.column("GRANTEE"), this.column("TABLE_CATALOG"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("COLUMN_NAME"), this.column("PRIVILEGE_TYPE"), this.column("IS_GRANTABLE")};
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 5: {
                this.setMetaTableName("CONSTRAINT_COLUMN_USAGE");
                cols = new Column[]{this.column("TABLE_CATALOG"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("COLUMN_NAME"), this.column("CONSTRAINT_CATALOG"), this.column("CONSTRAINT_SCHEMA"), this.column("CONSTRAINT_NAME")};
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 6: {
                this.setMetaTableName("DOMAINS");
                cols = new Column[]{this.column("DOMAIN_CATALOG"), this.column("DOMAIN_SCHEMA"), this.column("DOMAIN_NAME"), this.column("DATA_TYPE"), this.column("CHARACTER_MAXIMUM_LENGTH", TypeInfo.TYPE_BIGINT), this.column("CHARACTER_OCTET_LENGTH", TypeInfo.TYPE_BIGINT), this.column("CHARACTER_SET_CATALOG"), this.column("CHARACTER_SET_SCHEMA"), this.column("CHARACTER_SET_NAME"), this.column("COLLATION_CATALOG"), this.column("COLLATION_SCHEMA"), this.column("COLLATION_NAME"), this.column("NUMERIC_PRECISION", TypeInfo.TYPE_INTEGER), this.column("NUMERIC_PRECISION_RADIX", TypeInfo.TYPE_INTEGER), this.column("NUMERIC_SCALE", TypeInfo.TYPE_INTEGER), this.column("DATETIME_PRECISION", TypeInfo.TYPE_INTEGER), this.column("INTERVAL_TYPE"), this.column("INTERVAL_PRECISION", TypeInfo.TYPE_INTEGER), this.column("DOMAIN_DEFAULT"), this.column("MAXIMUM_CARDINALITY", TypeInfo.TYPE_INTEGER), this.column("DTD_IDENTIFIER"), this.column("DECLARED_DATA_TYPE"), this.column("DECLARED_NUMERIC_PRECISION", TypeInfo.TYPE_INTEGER), this.column("DECLARED_NUMERIC_SCALE", TypeInfo.TYPE_INTEGER), this.column("GEOMETRY_TYPE"), this.column("GEOMETRY_SRID", TypeInfo.TYPE_INTEGER), this.column("DOMAIN_ON_UPDATE"), this.column("PARENT_DOMAIN_CATALOG"), this.column("PARENT_DOMAIN_SCHEMA"), this.column("PARENT_DOMAIN_NAME"), this.column("REMARKS")};
                indexColumnName = "DOMAIN_NAME";
                break;
            }
            case 7: {
                this.setMetaTableName("DOMAIN_CONSTRAINTS");
                cols = new Column[]{this.column("CONSTRAINT_CATALOG"), this.column("CONSTRAINT_SCHEMA"), this.column("CONSTRAINT_NAME"), this.column("DOMAIN_CATALOG"), this.column("DOMAIN_SCHEMA"), this.column("DOMAIN_NAME"), this.column("IS_DEFERRABLE"), this.column("INITIALLY_DEFERRED"), this.column("REMARKS")};
                indexColumnName = "DOMAIN_NAME";
                break;
            }
            case 8: {
                this.setMetaTableName("ELEMENT_TYPES");
                cols = new Column[]{this.column("OBJECT_CATALOG"), this.column("OBJECT_SCHEMA"), this.column("OBJECT_NAME"), this.column("OBJECT_TYPE"), this.column("COLLECTION_TYPE_IDENTIFIER"), this.column("DATA_TYPE"), this.column("CHARACTER_MAXIMUM_LENGTH", TypeInfo.TYPE_BIGINT), this.column("CHARACTER_OCTET_LENGTH", TypeInfo.TYPE_BIGINT), this.column("CHARACTER_SET_CATALOG"), this.column("CHARACTER_SET_SCHEMA"), this.column("CHARACTER_SET_NAME"), this.column("COLLATION_CATALOG"), this.column("COLLATION_SCHEMA"), this.column("COLLATION_NAME"), this.column("NUMERIC_PRECISION", TypeInfo.TYPE_INTEGER), this.column("NUMERIC_PRECISION_RADIX", TypeInfo.TYPE_INTEGER), this.column("NUMERIC_SCALE", TypeInfo.TYPE_INTEGER), this.column("DATETIME_PRECISION", TypeInfo.TYPE_INTEGER), this.column("INTERVAL_TYPE"), this.column("INTERVAL_PRECISION", TypeInfo.TYPE_INTEGER), this.column("MAXIMUM_CARDINALITY", TypeInfo.TYPE_INTEGER), this.column("DTD_IDENTIFIER"), this.column("DECLARED_DATA_TYPE"), this.column("DECLARED_NUMERIC_PRECISION", TypeInfo.TYPE_INTEGER), this.column("DECLARED_NUMERIC_SCALE", TypeInfo.TYPE_INTEGER), this.column("GEOMETRY_TYPE"), this.column("GEOMETRY_SRID", TypeInfo.TYPE_INTEGER)};
                break;
            }
            case 9: {
                this.setMetaTableName("FIELDS");
                cols = new Column[]{this.column("OBJECT_CATALOG"), this.column("OBJECT_SCHEMA"), this.column("OBJECT_NAME"), this.column("OBJECT_TYPE"), this.column("ROW_IDENTIFIER"), this.column("FIELD_NAME"), this.column("ORDINAL_POSITION", TypeInfo.TYPE_INTEGER), this.column("DATA_TYPE"), this.column("CHARACTER_MAXIMUM_LENGTH", TypeInfo.TYPE_BIGINT), this.column("CHARACTER_OCTET_LENGTH", TypeInfo.TYPE_BIGINT), this.column("CHARACTER_SET_CATALOG"), this.column("CHARACTER_SET_SCHEMA"), this.column("CHARACTER_SET_NAME"), this.column("COLLATION_CATALOG"), this.column("COLLATION_SCHEMA"), this.column("COLLATION_NAME"), this.column("NUMERIC_PRECISION", TypeInfo.TYPE_INTEGER), this.column("NUMERIC_PRECISION_RADIX", TypeInfo.TYPE_INTEGER), this.column("NUMERIC_SCALE", TypeInfo.TYPE_INTEGER), this.column("DATETIME_PRECISION", TypeInfo.TYPE_INTEGER), this.column("INTERVAL_TYPE"), this.column("INTERVAL_PRECISION", TypeInfo.TYPE_INTEGER), this.column("MAXIMUM_CARDINALITY", TypeInfo.TYPE_INTEGER), this.column("DTD_IDENTIFIER"), this.column("DECLARED_DATA_TYPE"), this.column("DECLARED_NUMERIC_PRECISION", TypeInfo.TYPE_INTEGER), this.column("DECLARED_NUMERIC_SCALE", TypeInfo.TYPE_INTEGER), this.column("GEOMETRY_TYPE"), this.column("GEOMETRY_SRID", TypeInfo.TYPE_INTEGER)};
                break;
            }
            case 10: {
                this.setMetaTableName("KEY_COLUMN_USAGE");
                cols = new Column[]{this.column("CONSTRAINT_CATALOG"), this.column("CONSTRAINT_SCHEMA"), this.column("CONSTRAINT_NAME"), this.column("TABLE_CATALOG"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("COLUMN_NAME"), this.column("ORDINAL_POSITION", TypeInfo.TYPE_INTEGER), this.column("POSITION_IN_UNIQUE_CONSTRAINT", TypeInfo.TYPE_INTEGER)};
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 11: {
                this.setMetaTableName("PARAMETERS");
                cols = new Column[]{this.column("SPECIFIC_CATALOG"), this.column("SPECIFIC_SCHEMA"), this.column("SPECIFIC_NAME"), this.column("ORDINAL_POSITION", TypeInfo.TYPE_INTEGER), this.column("PARAMETER_MODE"), this.column("IS_RESULT"), this.column("AS_LOCATOR"), this.column("PARAMETER_NAME"), this.column("DATA_TYPE"), this.column("CHARACTER_MAXIMUM_LENGTH", TypeInfo.TYPE_BIGINT), this.column("CHARACTER_OCTET_LENGTH", TypeInfo.TYPE_BIGINT), this.column("CHARACTER_SET_CATALOG"), this.column("CHARACTER_SET_SCHEMA"), this.column("CHARACTER_SET_NAME"), this.column("COLLATION_CATALOG"), this.column("COLLATION_SCHEMA"), this.column("COLLATION_NAME"), this.column("NUMERIC_PRECISION", TypeInfo.TYPE_INTEGER), this.column("NUMERIC_PRECISION_RADIX", TypeInfo.TYPE_INTEGER), this.column("NUMERIC_SCALE", TypeInfo.TYPE_INTEGER), this.column("DATETIME_PRECISION", TypeInfo.TYPE_INTEGER), this.column("INTERVAL_TYPE"), this.column("INTERVAL_PRECISION", TypeInfo.TYPE_INTEGER), this.column("MAXIMUM_CARDINALITY", TypeInfo.TYPE_INTEGER), this.column("DTD_IDENTIFIER"), this.column("DECLARED_DATA_TYPE"), this.column("DECLARED_NUMERIC_PRECISION", TypeInfo.TYPE_INTEGER), this.column("DECLARED_NUMERIC_SCALE", TypeInfo.TYPE_INTEGER), this.column("PARAMETER_DEFAULT"), this.column("GEOMETRY_TYPE"), this.column("GEOMETRY_SRID", TypeInfo.TYPE_INTEGER)};
                break;
            }
            case 12: {
                this.setMetaTableName("REFERENTIAL_CONSTRAINTS");
                cols = new Column[]{this.column("CONSTRAINT_CATALOG"), this.column("CONSTRAINT_SCHEMA"), this.column("CONSTRAINT_NAME"), this.column("UNIQUE_CONSTRAINT_CATALOG"), this.column("UNIQUE_CONSTRAINT_SCHEMA"), this.column("UNIQUE_CONSTRAINT_NAME"), this.column("MATCH_OPTION"), this.column("UPDATE_RULE"), this.column("DELETE_RULE")};
                indexColumnName = "CONSTRAINT_NAME";
                break;
            }
            case 13: {
                this.setMetaTableName("ROUTINES");
                cols = new Column[]{this.column("SPECIFIC_CATALOG"), this.column("SPECIFIC_SCHEMA"), this.column("SPECIFIC_NAME"), this.column("ROUTINE_CATALOG"), this.column("ROUTINE_SCHEMA"), this.column("ROUTINE_NAME"), this.column("ROUTINE_TYPE"), this.column("DATA_TYPE"), this.column("CHARACTER_MAXIMUM_LENGTH", TypeInfo.TYPE_BIGINT), this.column("CHARACTER_OCTET_LENGTH", TypeInfo.TYPE_BIGINT), this.column("CHARACTER_SET_CATALOG"), this.column("CHARACTER_SET_SCHEMA"), this.column("CHARACTER_SET_NAME"), this.column("COLLATION_CATALOG"), this.column("COLLATION_SCHEMA"), this.column("COLLATION_NAME"), this.column("NUMERIC_PRECISION", TypeInfo.TYPE_INTEGER), this.column("NUMERIC_PRECISION_RADIX", TypeInfo.TYPE_INTEGER), this.column("NUMERIC_SCALE", TypeInfo.TYPE_INTEGER), this.column("DATETIME_PRECISION", TypeInfo.TYPE_INTEGER), this.column("INTERVAL_TYPE"), this.column("INTERVAL_PRECISION", TypeInfo.TYPE_INTEGER), this.column("MAXIMUM_CARDINALITY", TypeInfo.TYPE_INTEGER), this.column("DTD_IDENTIFIER"), this.column("ROUTINE_BODY"), this.column("ROUTINE_DEFINITION"), this.column("EXTERNAL_NAME"), this.column("EXTERNAL_LANGUAGE"), this.column("PARAMETER_STYLE"), this.column("IS_DETERMINISTIC"), this.column("DECLARED_DATA_TYPE"), this.column("DECLARED_NUMERIC_PRECISION", TypeInfo.TYPE_INTEGER), this.column("DECLARED_NUMERIC_SCALE", TypeInfo.TYPE_INTEGER), this.column("GEOMETRY_TYPE"), this.column("GEOMETRY_SRID", TypeInfo.TYPE_INTEGER), this.column("REMARKS")};
                break;
            }
            case 14: {
                this.setMetaTableName("SCHEMATA");
                cols = new Column[]{this.column("CATALOG_NAME"), this.column("SCHEMA_NAME"), this.column("SCHEMA_OWNER"), this.column("DEFAULT_CHARACTER_SET_CATALOG"), this.column("DEFAULT_CHARACTER_SET_SCHEMA"), this.column("DEFAULT_CHARACTER_SET_NAME"), this.column("SQL_PATH"), this.column("DEFAULT_COLLATION_NAME"), this.column("REMARKS")};
                break;
            }
            case 15: {
                this.setMetaTableName("SEQUENCES");
                cols = new Column[]{this.column("SEQUENCE_CATALOG"), this.column("SEQUENCE_SCHEMA"), this.column("SEQUENCE_NAME"), this.column("DATA_TYPE"), this.column("NUMERIC_PRECISION", TypeInfo.TYPE_INTEGER), this.column("NUMERIC_PRECISION_RADIX", TypeInfo.TYPE_INTEGER), this.column("NUMERIC_SCALE", TypeInfo.TYPE_INTEGER), this.column("START_VALUE", TypeInfo.TYPE_BIGINT), this.column("MINIMUM_VALUE", TypeInfo.TYPE_BIGINT), this.column("MAXIMUM_VALUE", TypeInfo.TYPE_BIGINT), this.column("INCREMENT", TypeInfo.TYPE_BIGINT), this.column("CYCLE_OPTION"), this.column("DECLARED_DATA_TYPE"), this.column("DECLARED_NUMERIC_PRECISION", TypeInfo.TYPE_INTEGER), this.column("DECLARED_NUMERIC_SCALE", TypeInfo.TYPE_INTEGER), this.column("BASE_VALUE", TypeInfo.TYPE_BIGINT), this.column("CACHE", TypeInfo.TYPE_BIGINT), this.column("REMARKS")};
                indexColumnName = "SEQUENCE_NAME";
                break;
            }
            case 16: {
                this.setMetaTableName("TABLES");
                cols = new Column[]{this.column("TABLE_CATALOG"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("TABLE_TYPE"), this.column("IS_INSERTABLE_INTO"), this.column("COMMIT_ACTION"), this.column("STORAGE_TYPE"), this.column("REMARKS"), this.column("LAST_MODIFICATION", TypeInfo.TYPE_BIGINT), this.column("TABLE_CLASS"), this.column("ROW_COUNT_ESTIMATE", TypeInfo.TYPE_BIGINT)};
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 17: {
                this.setMetaTableName("TABLE_CONSTRAINTS");
                cols = new Column[]{this.column("CONSTRAINT_CATALOG"), this.column("CONSTRAINT_SCHEMA"), this.column("CONSTRAINT_NAME"), this.column("CONSTRAINT_TYPE"), this.column("TABLE_CATALOG"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("IS_DEFERRABLE"), this.column("INITIALLY_DEFERRED"), this.column("ENFORCED"), this.column("INDEX_CATALOG"), this.column("INDEX_SCHEMA"), this.column("INDEX_NAME"), this.column("REMARKS")};
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 18: {
                this.setMetaTableName("TABLE_PRIVILEGES");
                cols = new Column[]{this.column("GRANTOR"), this.column("GRANTEE"), this.column("TABLE_CATALOG"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("PRIVILEGE_TYPE"), this.column("IS_GRANTABLE"), this.column("WITH_HIERARCHY")};
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 19: {
                this.setMetaTableName("TRIGGERS");
                cols = new Column[]{this.column("TRIGGER_CATALOG"), this.column("TRIGGER_SCHEMA"), this.column("TRIGGER_NAME"), this.column("EVENT_MANIPULATION"), this.column("EVENT_OBJECT_CATALOG"), this.column("EVENT_OBJECT_SCHEMA"), this.column("EVENT_OBJECT_TABLE"), this.column("ACTION_ORIENTATION"), this.column("ACTION_TIMING"), this.column("IS_ROLLBACK", TypeInfo.TYPE_BOOLEAN), this.column("JAVA_CLASS"), this.column("QUEUE_SIZE", TypeInfo.TYPE_INTEGER), this.column("NO_WAIT", TypeInfo.TYPE_BOOLEAN), this.column("REMARKS")};
                indexColumnName = "EVENT_OBJECT_TABLE";
                break;
            }
            case 20: {
                this.setMetaTableName("VIEWS");
                cols = new Column[]{this.column("TABLE_CATALOG"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("VIEW_DEFINITION"), this.column("CHECK_OPTION"), this.column("IS_UPDATABLE"), this.column("INSERTABLE_INTO"), this.column("IS_TRIGGER_UPDATABLE"), this.column("IS_TRIGGER_DELETABLE"), this.column("IS_TRIGGER_INSERTABLE_INTO"), this.column("STATUS"), this.column("REMARKS")};
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 21: {
                this.setMetaTableName("CONSTANTS");
                isView = false;
                cols = new Column[]{this.column("CONSTANT_CATALOG"), this.column("CONSTANT_SCHEMA"), this.column("CONSTANT_NAME"), this.column("VALUE_DEFINITION"), this.column("DATA_TYPE"), this.column("CHARACTER_MAXIMUM_LENGTH", TypeInfo.TYPE_BIGINT), this.column("CHARACTER_OCTET_LENGTH", TypeInfo.TYPE_BIGINT), this.column("CHARACTER_SET_CATALOG"), this.column("CHARACTER_SET_SCHEMA"), this.column("CHARACTER_SET_NAME"), this.column("COLLATION_CATALOG"), this.column("COLLATION_SCHEMA"), this.column("COLLATION_NAME"), this.column("NUMERIC_PRECISION", TypeInfo.TYPE_INTEGER), this.column("NUMERIC_PRECISION_RADIX", TypeInfo.TYPE_INTEGER), this.column("NUMERIC_SCALE", TypeInfo.TYPE_INTEGER), this.column("DATETIME_PRECISION", TypeInfo.TYPE_INTEGER), this.column("INTERVAL_TYPE"), this.column("INTERVAL_PRECISION", TypeInfo.TYPE_INTEGER), this.column("MAXIMUM_CARDINALITY", TypeInfo.TYPE_INTEGER), this.column("DTD_IDENTIFIER"), this.column("DECLARED_DATA_TYPE"), this.column("DECLARED_NUMERIC_PRECISION", TypeInfo.TYPE_INTEGER), this.column("DECLARED_NUMERIC_SCALE", TypeInfo.TYPE_INTEGER), this.column("GEOMETRY_TYPE"), this.column("GEOMETRY_SRID", TypeInfo.TYPE_INTEGER), this.column("REMARKS")};
                indexColumnName = "CONSTANT_NAME";
                break;
            }
            case 22: {
                this.setMetaTableName("ENUM_VALUES");
                isView = false;
                cols = new Column[]{this.column("OBJECT_CATALOG"), this.column("OBJECT_SCHEMA"), this.column("OBJECT_NAME"), this.column("OBJECT_TYPE"), this.column("ENUM_IDENTIFIER"), this.column("VALUE_NAME"), this.column("VALUE_ORDINAL")};
                break;
            }
            case 23: {
                this.setMetaTableName("INDEXES");
                isView = false;
                cols = new Column[]{this.column("INDEX_CATALOG"), this.column("INDEX_SCHEMA"), this.column("INDEX_NAME"), this.column("TABLE_CATALOG"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("INDEX_TYPE_NAME"), this.column("IS_GENERATED", TypeInfo.TYPE_BOOLEAN), this.column("REMARKS"), this.column("INDEX_CLASS")};
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 24: {
                this.setMetaTableName("INDEX_COLUMNS");
                isView = false;
                cols = new Column[]{this.column("INDEX_CATALOG"), this.column("INDEX_SCHEMA"), this.column("INDEX_NAME"), this.column("TABLE_CATALOG"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("COLUMN_NAME"), this.column("ORDINAL_POSITION", TypeInfo.TYPE_INTEGER), this.column("ORDERING_SPECIFICATION"), this.column("NULL_ORDERING"), this.column("IS_UNIQUE", TypeInfo.TYPE_BOOLEAN)};
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 25: {
                this.setMetaTableName("IN_DOUBT");
                isView = false;
                cols = new Column[]{this.column("TRANSACTION_NAME"), this.column("TRANSACTION_STATE")};
                break;
            }
            case 26: {
                this.setMetaTableName("LOCKS");
                isView = false;
                cols = new Column[]{this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("SESSION_ID", TypeInfo.TYPE_INTEGER), this.column("LOCK_TYPE")};
                break;
            }
            case 27: {
                this.setMetaTableName("QUERY_STATISTICS");
                isView = false;
                cols = new Column[]{this.column("SQL_STATEMENT"), this.column("EXECUTION_COUNT", TypeInfo.TYPE_INTEGER), this.column("MIN_EXECUTION_TIME", TypeInfo.TYPE_DOUBLE), this.column("MAX_EXECUTION_TIME", TypeInfo.TYPE_DOUBLE), this.column("CUMULATIVE_EXECUTION_TIME", TypeInfo.TYPE_DOUBLE), this.column("AVERAGE_EXECUTION_TIME", TypeInfo.TYPE_DOUBLE), this.column("STD_DEV_EXECUTION_TIME", TypeInfo.TYPE_DOUBLE), this.column("MIN_ROW_COUNT", TypeInfo.TYPE_BIGINT), this.column("MAX_ROW_COUNT", TypeInfo.TYPE_BIGINT), this.column("CUMULATIVE_ROW_COUNT", TypeInfo.TYPE_BIGINT), this.column("AVERAGE_ROW_COUNT", TypeInfo.TYPE_DOUBLE), this.column("STD_DEV_ROW_COUNT", TypeInfo.TYPE_DOUBLE)};
                break;
            }
            case 28: {
                this.setMetaTableName("RIGHTS");
                isView = false;
                cols = new Column[]{this.column("GRANTEE"), this.column("GRANTEETYPE"), this.column("GRANTEDROLE"), this.column("RIGHTS"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME")};
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 29: {
                this.setMetaTableName("ROLES");
                isView = false;
                cols = new Column[]{this.column("ROLE_NAME"), this.column("REMARKS")};
                break;
            }
            case 30: {
                this.setMetaTableName("SESSIONS");
                isView = false;
                cols = new Column[]{this.column("SESSION_ID", TypeInfo.TYPE_INTEGER), this.column("USER_NAME"), this.column("SERVER"), this.column("CLIENT_ADDR"), this.column("CLIENT_INFO"), this.column("SESSION_START", TypeInfo.TYPE_TIMESTAMP_TZ), this.column("ISOLATION_LEVEL"), this.column("EXECUTING_STATEMENT"), this.column("EXECUTING_STATEMENT_START", TypeInfo.TYPE_TIMESTAMP_TZ), this.column("CONTAINS_UNCOMMITTED", TypeInfo.TYPE_BOOLEAN), this.column("SESSION_STATE"), this.column("BLOCKER_ID", TypeInfo.TYPE_INTEGER), this.column("SLEEP_SINCE", TypeInfo.TYPE_TIMESTAMP_TZ)};
                break;
            }
            case 31: {
                this.setMetaTableName("SESSION_STATE");
                isView = false;
                cols = new Column[]{this.column("STATE_KEY"), this.column("STATE_COMMAND")};
                break;
            }
            case 32: {
                this.setMetaTableName("SETTINGS");
                isView = false;
                cols = new Column[]{this.column("SETTING_NAME"), this.column("SETTING_VALUE")};
                break;
            }
            case 33: {
                this.setMetaTableName("SYNONYMS");
                isView = false;
                cols = new Column[]{this.column("SYNONYM_CATALOG"), this.column("SYNONYM_SCHEMA"), this.column("SYNONYM_NAME"), this.column("SYNONYM_FOR"), this.column("SYNONYM_FOR_SCHEMA"), this.column("TYPE_NAME"), this.column("STATUS"), this.column("REMARKS")};
                indexColumnName = "SYNONYM_NAME";
                break;
            }
            case 34: {
                this.setMetaTableName("USERS");
                isView = false;
                cols = new Column[]{this.column("USER_NAME"), this.column("IS_ADMIN", TypeInfo.TYPE_BOOLEAN), this.column("REMARKS")};
                break;
            }
            default: {
                throw DbException.getInternalError("type=" + type);
            }
        }
        this.setColumns(cols);
        if (indexColumnName == null) {
            this.indexColumn = -1;
            this.metaIndex = null;
        } else {
            this.indexColumn = this.getColumn(this.database.sysIdentifier(indexColumnName)).getColumnId();
            IndexColumn[] indexCols = IndexColumn.wrap(new Column[]{cols[this.indexColumn]});
            this.metaIndex = new MetaIndex(this, indexCols, false);
        }
        this.isView = isView;
    }

    @Override
    public ArrayList<Row> generateRows(SessionLocal session, SearchRow first, SearchRow last) {
        Value indexFrom = null;
        Value indexTo = null;
        if (this.indexColumn >= 0) {
            if (first != null) {
                indexFrom = first.getValue(this.indexColumn);
            }
            if (last != null) {
                indexTo = last.getValue(this.indexColumn);
            }
        }
        ArrayList<Row> rows = Utils.newSmallArrayList();
        String catalog = this.database.getShortName();
        switch (this.type) {
            case 0: {
                this.informationSchemaCatalogName(session, rows, catalog);
                break;
            }
            case 1: {
                this.checkConstraints(session, indexFrom, indexTo, rows, catalog);
                break;
            }
            case 2: {
                this.collations(session, rows, catalog);
                break;
            }
            case 3: {
                this.columns(session, indexFrom, indexTo, rows, catalog);
                break;
            }
            case 4: {
                this.columnPrivileges(session, indexFrom, indexTo, rows, catalog);
                break;
            }
            case 5: {
                this.constraintColumnUsage(session, indexFrom, indexTo, rows, catalog);
                break;
            }
            case 6: {
                this.domains(session, indexFrom, indexTo, rows, catalog);
                break;
            }
            case 7: {
                this.domainConstraints(session, indexFrom, indexTo, rows, catalog);
                break;
            }
            case 8: {
                this.elementTypesFields(session, rows, catalog, 8);
                break;
            }
            case 9: {
                this.elementTypesFields(session, rows, catalog, 9);
                break;
            }
            case 10: {
                this.keyColumnUsage(session, indexFrom, indexTo, rows, catalog);
                break;
            }
            case 11: {
                this.parameters(session, rows, catalog);
                break;
            }
            case 12: {
                this.referentialConstraints(session, indexFrom, indexTo, rows, catalog);
                break;
            }
            case 13: {
                this.routines(session, rows, catalog);
                break;
            }
            case 14: {
                this.schemata(session, rows, catalog);
                break;
            }
            case 15: {
                this.sequences(session, indexFrom, indexTo, rows, catalog);
                break;
            }
            case 16: {
                this.tables(session, indexFrom, indexTo, rows, catalog);
                break;
            }
            case 17: {
                this.tableConstraints(session, indexFrom, indexTo, rows, catalog);
                break;
            }
            case 18: {
                this.tablePrivileges(session, indexFrom, indexTo, rows, catalog);
                break;
            }
            case 19: {
                this.triggers(session, indexFrom, indexTo, rows, catalog);
                break;
            }
            case 20: {
                this.views(session, indexFrom, indexTo, rows, catalog);
                break;
            }
            case 21: {
                this.constants(session, indexFrom, indexTo, rows, catalog);
                break;
            }
            case 22: {
                this.elementTypesFields(session, rows, catalog, 22);
                break;
            }
            case 23: {
                this.indexes(session, indexFrom, indexTo, rows, catalog, false);
                break;
            }
            case 24: {
                this.indexes(session, indexFrom, indexTo, rows, catalog, true);
                break;
            }
            case 25: {
                this.inDoubt(session, rows);
                break;
            }
            case 26: {
                this.locks(session, rows);
                break;
            }
            case 27: {
                this.queryStatistics(session, rows);
                break;
            }
            case 28: {
                this.rights(session, indexFrom, indexTo, rows);
                break;
            }
            case 29: {
                this.roles(session, rows);
                break;
            }
            case 30: {
                this.sessions(session, rows);
                break;
            }
            case 31: {
                this.sessionState(session, rows);
                break;
            }
            case 32: {
                this.settings(session, rows);
                break;
            }
            case 33: {
                this.synonyms(session, rows, catalog);
                break;
            }
            case 34: {
                this.users(session, rows);
                break;
            }
            default: {
                throw DbException.getInternalError("type=" + this.type);
            }
        }
        return rows;
    }

    private void informationSchemaCatalogName(SessionLocal session, ArrayList<Row> rows, String catalog) {
        this.add(session, rows, catalog);
    }

    private void checkConstraints(SessionLocal session, Value indexFrom, Value indexTo, ArrayList<Row> rows, String catalog) {
        for (Schema schema : this.database.getAllSchemas()) {
            for (Constraint constraint : schema.getAllConstraints()) {
                String constraintName;
                ConstraintCheck check;
                Table table;
                Constraint.Type constraintType = constraint.getConstraintType();
                if ((constraintType != Constraint.Type.CHECK ? constraintType != Constraint.Type.DOMAIN : this.hideTable(table = (check = (ConstraintCheck)constraint).getTable(), session)) || !this.checkIndex(session, constraintName = constraint.getName(), indexFrom, indexTo)) continue;
                this.checkConstraints(session, rows, catalog, constraint, constraintName);
            }
        }
    }

    private void checkConstraints(SessionLocal session, ArrayList<Row> rows, String catalog, Constraint constraint, String constraintName) {
        this.add(session, rows, catalog, constraint.getSchema().getName(), constraintName, constraint.getExpression().getSQL(0, 2));
    }

    private void collations(SessionLocal session, ArrayList<Row> rows, String catalog) {
        String mainSchemaName = this.database.getMainSchema().getName();
        this.collations(session, rows, catalog, mainSchemaName, "OFF", null);
        for (Locale l : CompareMode.getCollationLocales(false)) {
            this.collations(session, rows, catalog, mainSchemaName, CompareMode.getName(l), l.toLanguageTag());
        }
    }

    private void collations(SessionLocal session, ArrayList<Row> rows, String catalog, String mainSchemaName, String name, String languageTag) {
        if ("und".equals(languageTag)) {
            languageTag = null;
        }
        this.add(session, rows, catalog, mainSchemaName, name, "NO PAD", languageTag);
    }

    private void columns(SessionLocal session, Value indexFrom, Value indexTo, ArrayList<Row> rows, String catalog) {
        String mainSchemaName = this.database.getMainSchema().getName();
        String collation = this.database.getCompareMode().getName();
        if (indexFrom != null && indexFrom.equals(indexTo)) {
            String tableName = indexFrom.getString();
            if (tableName == null) {
                return;
            }
            for (Schema schema : this.database.getAllSchemas()) {
                Table table = schema.getTableOrViewByName(session, tableName);
                if (table == null) continue;
                this.columns(session, rows, catalog, mainSchemaName, collation, table, table.getName());
            }
            Table table = session.findLocalTempTable(tableName);
            if (table != null) {
                this.columns(session, rows, catalog, mainSchemaName, collation, table, table.getName());
            }
        } else {
            for (Schema schema : this.database.getAllSchemas()) {
                for (Table table : schema.getAllTablesAndViews(session)) {
                    String tableName = table.getName();
                    if (!this.checkIndex(session, tableName, indexFrom, indexTo)) continue;
                    this.columns(session, rows, catalog, mainSchemaName, collation, table, tableName);
                }
            }
            for (Table table : session.getLocalTempTables()) {
                String tableName = table.getName();
                if (!this.checkIndex(session, tableName, indexFrom, indexTo)) continue;
                this.columns(session, rows, catalog, mainSchemaName, collation, table, tableName);
            }
        }
    }

    private void columns(SessionLocal session, ArrayList<Row> rows, String catalog, String mainSchemaName, String collation, Table table, String tableName) {
        if (this.hideTable(table, session)) {
            return;
        }
        Column[] cols = table.getColumns();
        int i = 0;
        int l = cols.length;
        while (i < l) {
            this.columns(session, rows, catalog, mainSchemaName, collation, table, tableName, cols[i], ++i);
        }
    }

    private void columns(SessionLocal session, ArrayList<Row> rows, String catalog, String mainSchemaName, String collation, Table table, String tableName, Column c, int ordinalPosition) {
        ValueBigint identityCache;
        ValueBigint identityBase;
        String identityCycle;
        ValueBigint identityMinimum;
        ValueBigint identityMaximum;
        ValueBigint identityIncrement;
        ValueBigint identityStart;
        String identityGeneration;
        String isIdentity;
        String generationExpression;
        String isGenerated;
        String columnDefault;
        Sequence sequence;
        String collationName;
        String characterSetName;
        String characterSetSchema;
        String characterSetCatalog;
        TypeInfo typeInfo = c.getType();
        DataTypeInformation dt = DataTypeInformation.valueOf(typeInfo);
        if (dt.hasCharsetAndCollation) {
            characterSetCatalog = catalog;
            characterSetSchema = mainSchemaName;
            characterSetName = CHARACTER_SET_NAME;
            collationName = collation;
        } else {
            collationName = null;
            characterSetName = null;
            characterSetSchema = null;
            characterSetCatalog = null;
        }
        Domain domain = c.getDomain();
        String domainCatalog = null;
        String domainSchema = null;
        String domainName = null;
        if (domain != null) {
            domainCatalog = catalog;
            domainSchema = domain.getSchema().getName();
            domainName = domain.getName();
        }
        if ((sequence = c.getSequence()) != null) {
            columnDefault = null;
            isGenerated = "NEVER";
            generationExpression = null;
            isIdentity = "YES";
            identityGeneration = c.isGeneratedAlways() ? "ALWAYS" : "BY DEFAULT";
            identityStart = ValueBigint.get(sequence.getStartValue());
            identityIncrement = ValueBigint.get(sequence.getIncrement());
            identityMaximum = ValueBigint.get(sequence.getMaxValue());
            identityMinimum = ValueBigint.get(sequence.getMinValue());
            Sequence.Cycle cycle = sequence.getCycle();
            identityCycle = cycle.isCycle() ? "YES" : "NO";
            identityBase = cycle != Sequence.Cycle.EXHAUSTED ? ValueBigint.get(sequence.getBaseValue()) : null;
            identityCache = ValueBigint.get(sequence.getCacheSize());
        } else {
            if (c.isGenerated()) {
                columnDefault = null;
                isGenerated = "ALWAYS";
                generationExpression = c.getDefaultSQL();
            } else {
                columnDefault = c.getDefaultSQL();
                isGenerated = "NEVER";
                generationExpression = null;
            }
            isIdentity = "NO";
            identityCycle = null;
            identityGeneration = null;
            identityCache = null;
            identityBase = null;
            identityMinimum = null;
            identityMaximum = null;
            identityIncrement = null;
            identityStart = null;
        }
        this.add(session, rows, catalog, table.getSchema().getName(), tableName, c.getName(), ValueInteger.get(ordinalPosition), columnDefault, c.isNullable() ? "YES" : "NO", this.identifier(dt.dataType), dt.characterPrecision, dt.characterPrecision, dt.numericPrecision, dt.numericPrecisionRadix, dt.numericScale, dt.datetimePrecision, dt.intervalType, dt.intervalPrecision, characterSetCatalog, characterSetSchema, characterSetName, characterSetCatalog, characterSetSchema, collationName, domainCatalog, domainSchema, domainName, dt.maximumCardinality, Integer.toString(ordinalPosition), isIdentity, identityGeneration, identityStart, identityIncrement, identityMaximum, identityMinimum, identityCycle, isGenerated, generationExpression, dt.declaredDataType, dt.declaredNumericPrecision, dt.declaredNumericScale, dt.geometryType, dt.geometrySrid, identityBase, identityCache, c.getOnUpdateSQL(), ValueBoolean.get(c.getVisible()), ValueBoolean.get(c.isDefaultOnNull()), ValueInteger.get(c.getSelectivity()), c.getComment());
    }

    private void columnPrivileges(SessionLocal session, Value indexFrom, Value indexTo, ArrayList<Row> rows, String catalog) {
        for (Right r : this.database.getAllRights()) {
            String tableName;
            Table table;
            DbObject object = r.getGrantedObject();
            if (!(object instanceof Table) || this.hideTable(table = (Table)object, session) || !this.checkIndex(session, tableName = table.getName(), indexFrom, indexTo)) continue;
            DbObject grantee = r.getGrantee();
            int mask = r.getRightMask();
            for (Column column : table.getColumns()) {
                this.addPrivileges(session, rows, grantee, catalog, table, column.getName(), mask);
            }
        }
    }

    private void constraintColumnUsage(SessionLocal session, Value indexFrom, Value indexTo, ArrayList<Row> rows, String catalog) {
        for (Schema schema : this.database.getAllSchemas()) {
            for (Constraint constraint : schema.getAllConstraints()) {
                this.constraintColumnUsage(session, indexFrom, indexTo, rows, catalog, constraint);
            }
        }
    }

    private void constraintColumnUsage(SessionLocal session, Value indexFrom, Value indexTo, ArrayList<Row> rows, String catalog, Constraint constraint) {
        switch (constraint.getConstraintType()) {
            case CHECK: 
            case DOMAIN: {
                HashSet<Column> columns = new HashSet<Column>();
                constraint.getExpression().isEverything(ExpressionVisitor.getColumnsVisitor(columns, null));
                for (Column column : columns) {
                    Table table = column.getTable();
                    if (!this.checkIndex(session, table.getName(), indexFrom, indexTo) || this.hideTable(table, session)) continue;
                    this.addConstraintColumnUsage(session, rows, catalog, constraint, column);
                }
                break;
            }
            case REFERENTIAL: {
                Table table = constraint.getRefTable();
                if (this.checkIndex(session, table.getName(), indexFrom, indexTo) && !this.hideTable(table, session)) {
                    for (Column column : constraint.getReferencedColumns(table)) {
                        this.addConstraintColumnUsage(session, rows, catalog, constraint, column);
                    }
                }
            }
            case PRIMARY_KEY: 
            case UNIQUE: {
                Table table = constraint.getTable();
                if (!this.checkIndex(session, table.getName(), indexFrom, indexTo) || this.hideTable(table, session)) break;
                for (Column column : constraint.getReferencedColumns(table)) {
                    this.addConstraintColumnUsage(session, rows, catalog, constraint, column);
                }
                break;
            }
        }
    }

    private void domains(SessionLocal session, Value indexFrom, Value indexTo, ArrayList<Row> rows, String catalog) {
        String mainSchemaName = this.database.getMainSchema().getName();
        String collation = this.database.getCompareMode().getName();
        for (Schema schema : this.database.getAllSchemas()) {
            for (Domain domain : schema.getAllDomains()) {
                String domainName = domain.getName();
                if (!this.checkIndex(session, domainName, indexFrom, indexTo)) continue;
                this.domains(session, rows, catalog, mainSchemaName, collation, domain, domainName);
            }
        }
    }

    private void domains(SessionLocal session, ArrayList<Row> rows, String catalog, String mainSchemaName, String collation, Domain domain, String domainName) {
        String collationName;
        String characterSetName;
        String characterSetSchema;
        String characterSetCatalog;
        Domain parentDomain = domain.getDomain();
        TypeInfo typeInfo = domain.getDataType();
        DataTypeInformation dt = DataTypeInformation.valueOf(typeInfo);
        if (dt.hasCharsetAndCollation) {
            characterSetCatalog = catalog;
            characterSetSchema = mainSchemaName;
            characterSetName = CHARACTER_SET_NAME;
            collationName = collation;
        } else {
            collationName = null;
            characterSetName = null;
            characterSetSchema = null;
            characterSetCatalog = null;
        }
        this.add(session, rows, catalog, domain.getSchema().getName(), domainName, dt.dataType, dt.characterPrecision, dt.characterPrecision, characterSetCatalog, characterSetSchema, characterSetName, characterSetCatalog, characterSetSchema, collationName, dt.numericPrecision, dt.numericPrecisionRadix, dt.numericScale, dt.datetimePrecision, dt.intervalType, dt.intervalPrecision, domain.getDefaultSQL(), dt.maximumCardinality, "TYPE", dt.declaredDataType, dt.declaredNumericPrecision, dt.declaredNumericScale, dt.geometryType, dt.geometrySrid, domain.getOnUpdateSQL(), parentDomain != null ? catalog : null, parentDomain != null ? parentDomain.getSchema().getName() : null, parentDomain != null ? parentDomain.getName() : null, domain.getComment());
    }

    private void domainConstraints(SessionLocal session, Value indexFrom, Value indexTo, ArrayList<Row> rows, String catalog) {
        for (Schema schema : this.database.getAllSchemas()) {
            for (Constraint constraint : schema.getAllConstraints()) {
                ConstraintDomain domainConstraint;
                Domain domain;
                String domainName;
                if (constraint.getConstraintType() != Constraint.Type.DOMAIN || !this.checkIndex(session, domainName = (domain = (domainConstraint = (ConstraintDomain)constraint).getDomain()).getName(), indexFrom, indexTo)) continue;
                this.domainConstraints(session, rows, catalog, domainConstraint, domain, domainName);
            }
        }
    }

    private void domainConstraints(SessionLocal session, ArrayList<Row> rows, String catalog, ConstraintDomain constraint, Domain domain, String domainName) {
        this.add(session, rows, catalog, constraint.getSchema().getName(), constraint.getName(), catalog, domain.getSchema().getName(), domainName, "NO", "NO", constraint.getComment());
    }

    private void elementTypesFields(SessionLocal session, ArrayList<Row> rows, String catalog, int type) {
        String mainSchemaName = this.database.getMainSchema().getName();
        String collation = this.database.getCompareMode().getName();
        for (Schema schema : this.database.getAllSchemas()) {
            String schemaName = schema.getName();
            for (Table table : schema.getAllTablesAndViews(session)) {
                this.elementTypesFieldsForTable(session, rows, catalog, type, mainSchemaName, collation, schemaName, table);
            }
            for (Domain domain : schema.getAllDomains()) {
                this.elementTypesFieldsRow(session, rows, catalog, type, mainSchemaName, collation, schemaName, domain.getName(), "DOMAIN", "TYPE", domain.getDataType());
            }
            for (UserDefinedFunction userDefinedFunction : schema.getAllFunctionsAndAggregates()) {
                FunctionAlias.JavaMethod[] methods;
                if (!(userDefinedFunction instanceof FunctionAlias)) continue;
                String name = userDefinedFunction.getName();
                try {
                    methods = ((FunctionAlias)userDefinedFunction).getJavaMethods();
                }
                catch (DbException e) {
                    continue;
                }
                for (int i = 0; i < methods.length; ++i) {
                    FunctionAlias.JavaMethod method = methods[i];
                    TypeInfo typeInfo = method.getDataType();
                    String specificName = name + '_' + (i + 1);
                    if (typeInfo != null && typeInfo.getValueType() != 0) {
                        this.elementTypesFieldsRow(session, rows, catalog, type, mainSchemaName, collation, schemaName, specificName, "ROUTINE", "RESULT", typeInfo);
                    }
                    Class<?>[] columnList = method.getColumnClasses();
                    int o = 1;
                    int n = columnList.length;
                    for (int p = method.hasConnectionParam() ? 1 : 0; p < n; ++p) {
                        this.elementTypesFieldsRow(session, rows, catalog, type, mainSchemaName, collation, schemaName, specificName, "ROUTINE", Integer.toString(o), ValueToObjectConverter2.classToType(columnList[p]));
                        ++o;
                    }
                }
            }
            for (Constant constant : schema.getAllConstants()) {
                this.elementTypesFieldsRow(session, rows, catalog, type, mainSchemaName, collation, schemaName, constant.getName(), "CONSTANT", "TYPE", constant.getValue().getType());
            }
        }
        for (Table table : session.getLocalTempTables()) {
            this.elementTypesFieldsForTable(session, rows, catalog, type, mainSchemaName, collation, table.getSchema().getName(), table);
        }
    }

    private void elementTypesFieldsForTable(SessionLocal session, ArrayList<Row> rows, String catalog, int type, String mainSchemaName, String collation, String schemaName, Table table) {
        if (this.hideTable(table, session)) {
            return;
        }
        String tableName = table.getName();
        Column[] cols = table.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            this.elementTypesFieldsRow(session, rows, catalog, type, mainSchemaName, collation, schemaName, tableName, "TABLE", Integer.toString(i + 1), cols[i].getType());
        }
    }

    private void elementTypesFieldsRow(SessionLocal session, ArrayList<Row> rows, String catalog, int type, String mainSchemaName, String collation, String objectSchema, String objectName, String objectType, String identifier, TypeInfo typeInfo) {
        switch (typeInfo.getValueType()) {
            case 36: {
                if (type != 22) break;
                this.enumValues(session, rows, catalog, objectSchema, objectName, objectType, identifier, typeInfo);
                break;
            }
            case 40: {
                typeInfo = (TypeInfo)typeInfo.getExtTypeInfo();
                String dtdIdentifier = identifier + '_';
                if (type == 8) {
                    this.elementTypes(session, rows, catalog, mainSchemaName, collation, objectSchema, objectName, objectType, identifier, dtdIdentifier, typeInfo);
                }
                this.elementTypesFieldsRow(session, rows, catalog, type, mainSchemaName, collation, objectSchema, objectName, objectType, dtdIdentifier, typeInfo);
                break;
            }
            case 41: {
                ExtTypeInfoRow ext = (ExtTypeInfoRow)typeInfo.getExtTypeInfo();
                int ordinalPosition = 0;
                for (Map.Entry<String, TypeInfo> entry : ext.getFields()) {
                    typeInfo = entry.getValue();
                    String fieldName = entry.getKey();
                    String dtdIdentifier = identifier + '_' + ++ordinalPosition;
                    if (type == 9) {
                        this.fields(session, rows, catalog, mainSchemaName, collation, objectSchema, objectName, objectType, identifier, fieldName, ordinalPosition, dtdIdentifier, typeInfo);
                    }
                    this.elementTypesFieldsRow(session, rows, catalog, type, mainSchemaName, collation, objectSchema, objectName, objectType, dtdIdentifier, typeInfo);
                }
                break;
            }
        }
    }

    private void elementTypes(SessionLocal session, ArrayList<Row> rows, String catalog, String mainSchemaName, String collation, String objectSchema, String objectName, String objectType, String collectionIdentifier, String dtdIdentifier, TypeInfo typeInfo) {
        String collationName;
        String characterSetName;
        String characterSetSchema;
        String characterSetCatalog;
        DataTypeInformation dt = DataTypeInformation.valueOf(typeInfo);
        if (dt.hasCharsetAndCollation) {
            characterSetCatalog = catalog;
            characterSetSchema = mainSchemaName;
            characterSetName = CHARACTER_SET_NAME;
            collationName = collation;
        } else {
            collationName = null;
            characterSetName = null;
            characterSetSchema = null;
            characterSetCatalog = null;
        }
        this.add(session, rows, catalog, objectSchema, objectName, objectType, collectionIdentifier, dt.dataType, dt.characterPrecision, dt.characterPrecision, characterSetCatalog, characterSetSchema, characterSetName, characterSetCatalog, characterSetSchema, collationName, dt.numericPrecision, dt.numericPrecisionRadix, dt.numericScale, dt.datetimePrecision, dt.intervalType, dt.intervalPrecision, dt.maximumCardinality, dtdIdentifier, dt.declaredDataType, dt.declaredNumericPrecision, dt.declaredNumericScale, dt.geometryType, dt.geometrySrid);
    }

    private void fields(SessionLocal session, ArrayList<Row> rows, String catalog, String mainSchemaName, String collation, String objectSchema, String objectName, String objectType, String rowIdentifier, String fieldName, int ordinalPosition, String dtdIdentifier, TypeInfo typeInfo) {
        String collationName;
        String characterSetName;
        String characterSetSchema;
        String characterSetCatalog;
        DataTypeInformation dt = DataTypeInformation.valueOf(typeInfo);
        if (dt.hasCharsetAndCollation) {
            characterSetCatalog = catalog;
            characterSetSchema = mainSchemaName;
            characterSetName = CHARACTER_SET_NAME;
            collationName = collation;
        } else {
            collationName = null;
            characterSetName = null;
            characterSetSchema = null;
            characterSetCatalog = null;
        }
        this.add(session, rows, catalog, objectSchema, objectName, objectType, rowIdentifier, fieldName, ValueInteger.get(ordinalPosition), dt.dataType, dt.characterPrecision, dt.characterPrecision, characterSetCatalog, characterSetSchema, characterSetName, characterSetCatalog, characterSetSchema, collationName, dt.numericPrecision, dt.numericPrecisionRadix, dt.numericScale, dt.datetimePrecision, dt.intervalType, dt.intervalPrecision, dt.maximumCardinality, dtdIdentifier, dt.declaredDataType, dt.declaredNumericPrecision, dt.declaredNumericScale, dt.geometryType, dt.geometrySrid);
    }

    private void keyColumnUsage(SessionLocal session, Value indexFrom, Value indexTo, ArrayList<Row> rows, String catalog) {
        for (Schema schema : this.database.getAllSchemas()) {
            for (Constraint constraint : schema.getAllConstraints()) {
                String tableName;
                Table table;
                Constraint.Type constraintType = constraint.getConstraintType();
                IndexColumn[] indexColumns = null;
                if (constraintType == Constraint.Type.UNIQUE || constraintType == Constraint.Type.PRIMARY_KEY) {
                    indexColumns = ((ConstraintUnique)constraint).getColumns();
                } else if (constraintType == Constraint.Type.REFERENTIAL) {
                    indexColumns = ((ConstraintReferential)constraint).getColumns();
                }
                if (indexColumns == null || this.hideTable(table = constraint.getTable(), session) || !this.checkIndex(session, tableName = table.getName(), indexFrom, indexTo)) continue;
                this.keyColumnUsage(session, rows, catalog, constraint, constraintType, indexColumns, table, tableName);
            }
        }
    }

    private void keyColumnUsage(SessionLocal session, ArrayList<Row> rows, String catalog, Constraint constraint, Constraint.Type constraintType, IndexColumn[] indexColumns, Table table, String tableName) {
        ConstraintUnique referenced = constraintType == Constraint.Type.REFERENTIAL ? ((ConstraintReferential)constraint).getReferencedConstraint() : null;
        for (int i = 0; i < indexColumns.length; ++i) {
            IndexColumn indexColumn = indexColumns[i];
            ValueInteger ordinalPosition = ValueInteger.get(i + 1);
            ValueInteger positionInUniqueConstraint = null;
            if (referenced != null) {
                Column c = ((ConstraintReferential)constraint).getRefColumns()[i].column;
                IndexColumn[] refColumns = referenced.getColumns();
                for (int j = 0; j < refColumns.length; ++j) {
                    if (!refColumns[j].column.equals(c)) continue;
                    positionInUniqueConstraint = ValueInteger.get(j + 1);
                    break;
                }
            }
            this.add(session, rows, catalog, constraint.getSchema().getName(), constraint.getName(), catalog, table.getSchema().getName(), tableName, indexColumn.columnName, ordinalPosition, positionInUniqueConstraint);
        }
    }

    private void parameters(SessionLocal session, ArrayList<Row> rows, String catalog) {
        String mainSchemaName = this.database.getMainSchema().getName();
        String collation = this.database.getCompareMode().getName();
        for (Schema schema : this.database.getAllSchemas()) {
            for (UserDefinedFunction userDefinedFunction : schema.getAllFunctionsAndAggregates()) {
                FunctionAlias.JavaMethod[] methods;
                if (!(userDefinedFunction instanceof FunctionAlias)) continue;
                try {
                    methods = ((FunctionAlias)userDefinedFunction).getJavaMethods();
                }
                catch (DbException e) {
                    continue;
                }
                for (int i = 0; i < methods.length; ++i) {
                    FunctionAlias.JavaMethod method = methods[i];
                    Class<?>[] columnList = method.getColumnClasses();
                    int o = 1;
                    int n = columnList.length;
                    for (int p = method.hasConnectionParam() ? 1 : 0; p < n; ++p) {
                        this.parameters(session, rows, catalog, mainSchemaName, collation, schema.getName(), userDefinedFunction.getName() + '_' + (i + 1), ValueToObjectConverter2.classToType(columnList[p]), o);
                        ++o;
                    }
                }
            }
        }
    }

    private void parameters(SessionLocal session, ArrayList<Row> rows, String catalog, String mainSchemaName, String collation, String schema, String specificName, TypeInfo typeInfo, int pos) {
        String collationName;
        String characterSetName;
        String characterSetSchema;
        String characterSetCatalog;
        DataTypeInformation dt = DataTypeInformation.valueOf(typeInfo);
        if (dt.hasCharsetAndCollation) {
            characterSetCatalog = catalog;
            characterSetSchema = mainSchemaName;
            characterSetName = CHARACTER_SET_NAME;
            collationName = collation;
        } else {
            collationName = null;
            characterSetName = null;
            characterSetSchema = null;
            characterSetCatalog = null;
        }
        this.add(session, rows, catalog, schema, specificName, ValueInteger.get(pos), "IN", "NO", DataType.isLargeObject(typeInfo.getValueType()) ? "YES" : "NO", "P" + pos, this.identifier(dt.dataType), dt.characterPrecision, dt.characterPrecision, characterSetCatalog, characterSetSchema, characterSetName, characterSetCatalog, characterSetSchema, collationName, dt.numericPrecision, dt.numericPrecisionRadix, dt.numericScale, dt.datetimePrecision, dt.intervalType, dt.intervalPrecision, dt.maximumCardinality, Integer.toString(pos), dt.declaredDataType, dt.declaredNumericPrecision, dt.declaredNumericScale, null, dt.geometryType, dt.geometrySrid);
    }

    private void referentialConstraints(SessionLocal session, Value indexFrom, Value indexTo, ArrayList<Row> rows, String catalog) {
        for (Schema schema : this.database.getAllSchemas()) {
            for (Constraint constraint : schema.getAllConstraints()) {
                String constraintName;
                if (constraint.getConstraintType() != Constraint.Type.REFERENTIAL || this.hideTable(constraint.getTable(), session) || !this.checkIndex(session, constraintName = constraint.getName(), indexFrom, indexTo)) continue;
                this.referentialConstraints(session, rows, catalog, (ConstraintReferential)constraint, constraintName);
            }
        }
    }

    private void referentialConstraints(SessionLocal session, ArrayList<Row> rows, String catalog, ConstraintReferential constraint, String constraintName) {
        ConstraintUnique unique = constraint.getReferencedConstraint();
        this.add(session, rows, catalog, constraint.getSchema().getName(), constraintName, catalog, unique.getSchema().getName(), unique.getName(), "NONE", constraint.getUpdateAction().getSqlName(), constraint.getDeleteAction().getSqlName());
    }

    private void routines(SessionLocal session, ArrayList<Row> rows, String catalog) {
        boolean admin = session.getUser().isAdmin();
        String mainSchemaName = this.database.getMainSchema().getName();
        String collation = this.database.getCompareMode().getName();
        for (Schema schema : this.database.getAllSchemas()) {
            String schemaName = schema.getName();
            for (UserDefinedFunction userDefinedFunction : schema.getAllFunctionsAndAggregates()) {
                String name = userDefinedFunction.getName();
                if (userDefinedFunction instanceof FunctionAlias) {
                    FunctionAlias.JavaMethod[] methods;
                    FunctionAlias alias = (FunctionAlias)userDefinedFunction;
                    try {
                        methods = alias.getJavaMethods();
                    }
                    catch (DbException e) {
                        continue;
                    }
                    for (int i = 0; i < methods.length; ++i) {
                        String routineType;
                        FunctionAlias.JavaMethod method = methods[i];
                        TypeInfo typeInfo = method.getDataType();
                        if (typeInfo != null && typeInfo.getValueType() == 0) {
                            routineType = "PROCEDURE";
                            typeInfo = null;
                        } else {
                            routineType = "FUNCTION";
                        }
                        String javaClassName = alias.getJavaClassName();
                        this.routines(session, rows, catalog, mainSchemaName, collation, schemaName, name, name + '_' + (i + 1), routineType, admin ? alias.getSource() : null, javaClassName != null ? javaClassName + '.' + alias.getJavaMethodName() : null, typeInfo, alias.isDeterministic(), alias.getComment());
                    }
                    continue;
                }
                this.routines(session, rows, catalog, mainSchemaName, collation, schemaName, name, name, "AGGREGATE", null, userDefinedFunction.getJavaClassName(), TypeInfo.TYPE_NULL, false, userDefinedFunction.getComment());
            }
        }
    }

    private void routines(SessionLocal session, ArrayList<Row> rows, String catalog, String mainSchemaName, String collation, String schema, String name, String specificName, String routineType, String definition, String externalName, TypeInfo typeInfo, boolean deterministic, String remarks) {
        String collationName;
        String characterSetName;
        String characterSetSchema;
        String characterSetCatalog;
        DataTypeInformation dt;
        DataTypeInformation dataTypeInformation = dt = typeInfo != null ? DataTypeInformation.valueOf(typeInfo) : DataTypeInformation.NULL;
        if (dt.hasCharsetAndCollation) {
            characterSetCatalog = catalog;
            characterSetSchema = mainSchemaName;
            characterSetName = CHARACTER_SET_NAME;
            collationName = collation;
        } else {
            collationName = null;
            characterSetName = null;
            characterSetSchema = null;
            characterSetCatalog = null;
        }
        this.add(session, rows, catalog, schema, specificName, catalog, schema, name, routineType, this.identifier(dt.dataType), dt.characterPrecision, dt.characterPrecision, characterSetCatalog, characterSetSchema, characterSetName, characterSetCatalog, characterSetSchema, collationName, dt.numericPrecision, dt.numericPrecisionRadix, dt.numericScale, dt.datetimePrecision, dt.intervalType, dt.intervalPrecision, dt.maximumCardinality, "RESULT", "EXTERNAL", definition, externalName, "JAVA", "GENERAL", deterministic ? "YES" : "NO", dt.declaredDataType, dt.declaredNumericPrecision, dt.declaredNumericScale, dt.geometryType, dt.geometrySrid, remarks);
    }

    private void schemata(SessionLocal session, ArrayList<Row> rows, String catalog) {
        String mainSchemaName = this.database.getMainSchema().getName();
        String collation = this.database.getCompareMode().getName();
        for (Schema schema : this.database.getAllSchemas()) {
            this.add(session, rows, catalog, schema.getName(), this.identifier(schema.getOwner().getName()), catalog, mainSchemaName, CHARACTER_SET_NAME, null, collation, schema.getComment());
        }
    }

    private void sequences(SessionLocal session, Value indexFrom, Value indexTo, ArrayList<Row> rows, String catalog) {
        for (Schema schema : this.database.getAllSchemas()) {
            for (Sequence sequence : schema.getAllSequences()) {
                String sequenceName;
                if (sequence.getBelongsToTable() || !this.checkIndex(session, sequenceName = sequence.getName(), indexFrom, indexTo)) continue;
                this.sequences(session, rows, catalog, sequence, sequenceName);
            }
        }
    }

    private void sequences(SessionLocal session, ArrayList<Row> rows, String catalog, Sequence sequence, String sequenceName) {
        DataTypeInformation dt = DataTypeInformation.valueOf(sequence.getDataType());
        Sequence.Cycle cycle = sequence.getCycle();
        this.add(session, rows, catalog, sequence.getSchema().getName(), sequenceName, dt.dataType, ValueInteger.get(sequence.getEffectivePrecision()), dt.numericPrecisionRadix, dt.numericScale, ValueBigint.get(sequence.getStartValue()), ValueBigint.get(sequence.getMinValue()), ValueBigint.get(sequence.getMaxValue()), ValueBigint.get(sequence.getIncrement()), cycle.isCycle() ? "YES" : "NO", dt.declaredDataType, dt.declaredNumericPrecision, dt.declaredNumericScale, cycle != Sequence.Cycle.EXHAUSTED ? ValueBigint.get(sequence.getBaseValue()) : null, ValueBigint.get(sequence.getCacheSize()), sequence.getComment());
    }

    private void tables(SessionLocal session, Value indexFrom, Value indexTo, ArrayList<Row> rows, String catalog) {
        for (Schema schema : this.database.getAllSchemas()) {
            for (Table table : schema.getAllTablesAndViews(session)) {
                String tableName = table.getName();
                if (!this.checkIndex(session, tableName, indexFrom, indexTo)) continue;
                this.tables(session, rows, catalog, table, tableName);
            }
        }
        for (Table table : session.getLocalTempTables()) {
            String tableName = table.getName();
            if (!this.checkIndex(session, tableName, indexFrom, indexTo)) continue;
            this.tables(session, rows, catalog, table, tableName);
        }
    }

    private void tables(SessionLocal session, ArrayList<Row> rows, String catalog, Table table, String tableName) {
        String storageType;
        String commitAction;
        if (this.hideTable(table, session)) {
            return;
        }
        if (table.isTemporary()) {
            commitAction = table.getOnCommitTruncate() ? "DELETE" : (table.getOnCommitDrop() ? "DROP" : "PRESERVE");
            storageType = table.isGlobalTemporary() ? "GLOBAL TEMPORARY" : "LOCAL TEMPORARY";
        } else {
            commitAction = null;
            switch (table.getTableType()) {
                case TABLE_LINK: {
                    storageType = "TABLE LINK";
                    break;
                }
                case EXTERNAL_TABLE_ENGINE: {
                    storageType = "EXTERNAL";
                    break;
                }
                default: {
                    storageType = table.isPersistIndexes() ? "CACHED" : "MEMORY";
                }
            }
        }
        long lastModification = table.getMaxDataModificationId();
        this.add(session, rows, catalog, table.getSchema().getName(), tableName, table.getSQLTableType(), table.isInsertable() ? "YES" : "NO", commitAction, storageType, table.getComment(), lastModification != Long.MAX_VALUE ? ValueBigint.get(lastModification) : null, table.getClass().getName(), ValueBigint.get(table.getRowCountApproximation(session)));
    }

    private void tableConstraints(SessionLocal session, Value indexFrom, Value indexTo, ArrayList<Row> rows, String catalog) {
        for (Schema schema : this.database.getAllSchemas()) {
            for (Constraint constraint : schema.getAllConstraints()) {
                String tableName;
                Table table;
                Constraint.Type constraintType = constraint.getConstraintType();
                if (constraintType == Constraint.Type.DOMAIN || this.hideTable(table = constraint.getTable(), session) || !this.checkIndex(session, tableName = table.getName(), indexFrom, indexTo)) continue;
                this.tableConstraints(session, rows, catalog, constraint, constraintType, table, tableName);
            }
        }
    }

    private void tableConstraints(SessionLocal session, ArrayList<Row> rows, String catalog, Constraint constraint, Constraint.Type constraintType, Table table, String tableName) {
        Index index = constraint.getIndex();
        boolean enforced = constraintType != Constraint.Type.REFERENTIAL ? true : this.database.getReferentialIntegrity() && table.getCheckForeignKeyConstraints() && ((ConstraintReferential)constraint).getRefTable().getCheckForeignKeyConstraints();
        this.add(session, rows, catalog, constraint.getSchema().getName(), constraint.getName(), constraintType.getSqlName(), catalog, table.getSchema().getName(), tableName, "NO", "NO", enforced ? "YES" : "NO", index != null ? catalog : null, index != null ? index.getSchema().getName() : null, index != null ? index.getName() : null, constraint.getComment());
    }

    private void tablePrivileges(SessionLocal session, Value indexFrom, Value indexTo, ArrayList<Row> rows, String catalog) {
        for (Right r : this.database.getAllRights()) {
            String tableName;
            Table table;
            DbObject object = r.getGrantedObject();
            if (!(object instanceof Table) || this.hideTable(table = (Table)object, session) || !this.checkIndex(session, tableName = table.getName(), indexFrom, indexTo)) continue;
            this.addPrivileges(session, rows, r.getGrantee(), catalog, table, null, r.getRightMask());
        }
    }

    private void triggers(SessionLocal session, Value indexFrom, Value indexTo, ArrayList<Row> rows, String catalog) {
        for (Schema schema : this.database.getAllSchemas()) {
            for (TriggerObject trigger : schema.getAllTriggers()) {
                Table table = trigger.getTable();
                String tableName = table.getName();
                if (!this.checkIndex(session, tableName, indexFrom, indexTo)) continue;
                int typeMask = trigger.getTypeMask();
                if ((typeMask & 1) != 0) {
                    this.triggers(session, rows, catalog, trigger, "INSERT", table, tableName);
                }
                if ((typeMask & 2) != 0) {
                    this.triggers(session, rows, catalog, trigger, "UPDATE", table, tableName);
                }
                if ((typeMask & 4) != 0) {
                    this.triggers(session, rows, catalog, trigger, "DELETE", table, tableName);
                }
                if ((typeMask & 8) == 0) continue;
                this.triggers(session, rows, catalog, trigger, "SELECT", table, tableName);
            }
        }
    }

    private void triggers(SessionLocal session, ArrayList<Row> rows, String catalog, TriggerObject trigger, String eventManipulation, Table table, String tableName) {
        Object[] objectArray = new Object[14];
        objectArray[0] = catalog;
        objectArray[1] = trigger.getSchema().getName();
        objectArray[2] = trigger.getName();
        objectArray[3] = eventManipulation;
        objectArray[4] = catalog;
        objectArray[5] = table.getSchema().getName();
        objectArray[6] = tableName;
        Object object = objectArray[7] = trigger.isRowBased() ? "ROW" : "STATEMENT";
        objectArray[8] = trigger.isInsteadOf() ? "INSTEAD OF" : (trigger.isBefore() ? "BEFORE" : "AFTER");
        objectArray[9] = ValueBoolean.get(trigger.isOnRollback());
        objectArray[10] = trigger.getTriggerClassName();
        objectArray[11] = ValueInteger.get(trigger.getQueueSize());
        objectArray[12] = ValueBoolean.get(trigger.isNoWait());
        objectArray[13] = trigger.getComment();
        this.add(session, rows, objectArray);
    }

    private void views(SessionLocal session, Value indexFrom, Value indexTo, ArrayList<Row> rows, String catalog) {
        for (Schema schema : this.database.getAllSchemas()) {
            for (Table table : schema.getAllTablesAndViews(session)) {
                String tableName;
                if (!table.isView() || !this.checkIndex(session, tableName = table.getName(), indexFrom, indexTo)) continue;
                this.views(session, rows, catalog, table, tableName);
            }
        }
        for (Table table : session.getLocalTempTables()) {
            String tableName;
            if (!table.isView() || !this.checkIndex(session, tableName = table.getName(), indexFrom, indexTo)) continue;
            this.views(session, rows, catalog, table, tableName);
        }
    }

    private void views(SessionLocal session, ArrayList<Row> rows, String catalog, Table table, String tableName) {
        String viewDefinition;
        String status = "VALID";
        if (table instanceof TableView) {
            TableView view = (TableView)table;
            viewDefinition = view.getQuerySQL();
            if (view.isInvalid()) {
                status = "INVALID";
            }
        } else {
            viewDefinition = null;
        }
        int mask = 0;
        ArrayList<TriggerObject> triggers = table.getTriggers();
        if (triggers != null) {
            for (TriggerObject trigger : triggers) {
                if (!trigger.isInsteadOf()) continue;
                mask |= trigger.getTypeMask();
            }
        }
        this.add(session, rows, catalog, table.getSchema().getName(), tableName, viewDefinition, "NONE", "NO", "NO", (mask & 2) != 0 ? "YES" : "NO", (mask & 4) != 0 ? "YES" : "NO", (mask & 1) != 0 ? "YES" : "NO", status, table.getComment());
    }

    private void constants(SessionLocal session, Value indexFrom, Value indexTo, ArrayList<Row> rows, String catalog) {
        String mainSchemaName = this.database.getMainSchema().getName();
        String collation = this.database.getCompareMode().getName();
        for (Schema schema : this.database.getAllSchemas()) {
            for (Constant constant : schema.getAllConstants()) {
                String constantName = constant.getName();
                if (!this.checkIndex(session, constantName, indexFrom, indexTo)) continue;
                this.constants(session, rows, catalog, mainSchemaName, collation, constant, constantName);
            }
        }
    }

    private void constants(SessionLocal session, ArrayList<Row> rows, String catalog, String mainSchemaName, String collation, Constant constant, String constantName) {
        String collationName;
        String characterSetName;
        String characterSetSchema;
        String characterSetCatalog;
        ValueExpression expr = constant.getValue();
        TypeInfo typeInfo = expr.getType();
        DataTypeInformation dt = DataTypeInformation.valueOf(typeInfo);
        if (dt.hasCharsetAndCollation) {
            characterSetCatalog = catalog;
            characterSetSchema = mainSchemaName;
            characterSetName = CHARACTER_SET_NAME;
            collationName = collation;
        } else {
            collationName = null;
            characterSetName = null;
            characterSetSchema = null;
            characterSetCatalog = null;
        }
        this.add(session, rows, catalog, constant.getSchema().getName(), constantName, expr.getSQL(0), dt.dataType, dt.characterPrecision, dt.characterPrecision, characterSetCatalog, characterSetSchema, characterSetName, characterSetCatalog, characterSetSchema, collationName, dt.numericPrecision, dt.numericPrecisionRadix, dt.numericScale, dt.datetimePrecision, dt.intervalType, dt.intervalPrecision, dt.maximumCardinality, "TYPE", dt.declaredDataType, dt.declaredNumericPrecision, dt.declaredNumericScale, dt.geometryType, dt.geometrySrid, constant.getComment());
    }

    private void enumValues(SessionLocal session, ArrayList<Row> rows, String catalog, String objectSchema, String objectName, String objectType, String enumIdentifier, TypeInfo typeInfo) {
        ExtTypeInfoEnum ext = (ExtTypeInfoEnum)typeInfo.getExtTypeInfo();
        if (ext == null) {
            return;
        }
        int i = 0;
        int ordinal = session.zeroBasedEnums() ? 0 : 1;
        int l = ext.getCount();
        while (i < l) {
            this.add(session, rows, catalog, objectSchema, objectName, objectType, enumIdentifier, ext.getEnumerator(i), ValueInteger.get(ordinal));
            ++i;
            ++ordinal;
        }
    }

    private void indexes(SessionLocal session, Value indexFrom, Value indexTo, ArrayList<Row> rows, String catalog, boolean columns) {
        if (indexFrom != null && indexFrom.equals(indexTo)) {
            String tableName = indexFrom.getString();
            if (tableName == null) {
                return;
            }
            for (Schema schema : this.database.getAllSchemas()) {
                Table table = schema.getTableOrViewByName(session, tableName);
                if (table == null) continue;
                this.indexes(session, rows, catalog, columns, table, table.getName());
            }
            Table table = session.findLocalTempTable(tableName);
            if (table != null) {
                this.indexes(session, rows, catalog, columns, table, table.getName());
            }
        } else {
            for (Schema schema : this.database.getAllSchemas()) {
                for (Table table : schema.getAllTablesAndViews(session)) {
                    String tableName = table.getName();
                    if (!this.checkIndex(session, tableName, indexFrom, indexTo)) continue;
                    this.indexes(session, rows, catalog, columns, table, tableName);
                }
            }
            for (Table table : session.getLocalTempTables()) {
                String tableName = table.getName();
                if (!this.checkIndex(session, tableName, indexFrom, indexTo)) continue;
                this.indexes(session, rows, catalog, columns, table, tableName);
            }
        }
    }

    private void indexes(SessionLocal session, ArrayList<Row> rows, String catalog, boolean columns, Table table, String tableName) {
        if (this.hideTable(table, session)) {
            return;
        }
        ArrayList<Index> indexes = table.getIndexes();
        if (indexes == null) {
            return;
        }
        for (Index index : indexes) {
            if (index.getCreateSQL() == null) continue;
            if (columns) {
                this.indexColumns(session, rows, catalog, table, tableName, index);
                continue;
            }
            this.indexes(session, rows, catalog, table, tableName, index);
        }
    }

    private void indexes(SessionLocal session, ArrayList<Row> rows, String catalog, Table table, String tableName, Index index) {
        this.add(session, rows, catalog, index.getSchema().getName(), index.getName(), catalog, table.getSchema().getName(), tableName, index.getIndexType().getSQL(), ValueBoolean.get(index.getIndexType().getBelongsToConstraint()), index.getComment(), index.getClass().getName());
    }

    private void indexColumns(SessionLocal session, ArrayList<Row> rows, String catalog, Table table, String tableName, Index index) {
        IndexColumn[] cols = index.getIndexColumns();
        int uniqueColumnCount = index.getUniqueColumnCount();
        int i = 0;
        int l = cols.length;
        while (i < l) {
            IndexColumn idxCol = cols[i];
            int sortType = idxCol.sortType;
            Object[] objectArray = new Object[11];
            objectArray[0] = catalog;
            objectArray[1] = index.getSchema().getName();
            objectArray[2] = index.getName();
            objectArray[3] = catalog;
            objectArray[4] = table.getSchema().getName();
            objectArray[5] = tableName;
            objectArray[6] = idxCol.column.getName();
            objectArray[7] = ValueInteger.get(++i);
            Object object = objectArray[8] = (sortType & 1) == 0 ? "ASC" : "DESC";
            objectArray[9] = (sortType & 2) != 0 ? "FIRST" : ((sortType & 4) != 0 ? "LAST" : null);
            objectArray[10] = ValueBoolean.get(i <= uniqueColumnCount);
            this.add(session, rows, objectArray);
        }
    }

    private void inDoubt(SessionLocal session, ArrayList<Row> rows) {
        ArrayList<InDoubtTransaction> prepared;
        if (session.getUser().isAdmin() && (prepared = this.database.getInDoubtTransactions()) != null) {
            for (InDoubtTransaction prep : prepared) {
                this.add(session, rows, prep.getTransactionName(), prep.getStateDescription());
            }
        }
    }

    private void locks(SessionLocal session, ArrayList<Row> rows) {
        if (session.getUser().isAdmin()) {
            for (SessionLocal s : this.database.getSessions(false)) {
                this.locks(session, rows, s);
            }
        } else {
            this.locks(session, rows, session);
        }
    }

    private void locks(SessionLocal session, ArrayList<Row> rows, SessionLocal sessionWithLocks) {
        for (Table table : sessionWithLocks.getLocks()) {
            this.add(session, rows, table.getSchema().getName(), table.getName(), ValueInteger.get(sessionWithLocks.getId()), table.isLockedExclusivelyBy(sessionWithLocks) ? "WRITE" : "READ");
        }
    }

    private void queryStatistics(SessionLocal session, ArrayList<Row> rows) {
        QueryStatisticsData control = this.database.getQueryStatisticsData();
        if (control != null) {
            for (QueryStatisticsData.QueryEntry entry : control.getQueries()) {
                this.add(session, rows, entry.sqlStatement, ValueInteger.get(entry.count), ValueDouble.get((double)entry.executionTimeMinNanos / 1000000.0), ValueDouble.get((double)entry.executionTimeMaxNanos / 1000000.0), ValueDouble.get((double)entry.executionTimeCumulativeNanos / 1000000.0), ValueDouble.get(entry.executionTimeMeanNanos / 1000000.0), ValueDouble.get(entry.getExecutionTimeStandardDeviation() / 1000000.0), ValueBigint.get(entry.rowCountMin), ValueBigint.get(entry.rowCountMax), ValueBigint.get(entry.rowCountCumulative), ValueDouble.get(entry.rowCountMean), ValueDouble.get(entry.getRowCountStandardDeviation()));
            }
        }
    }

    private void rights(SessionLocal session, Value indexFrom, Value indexTo, ArrayList<Row> rows) {
        if (!session.getUser().isAdmin()) {
            return;
        }
        for (Right r : this.database.getAllRights()) {
            String rightType;
            Role role = r.getGrantedRole();
            DbObject grantee = r.getGrantee();
            String string = rightType = grantee.getType() == 2 ? "USER" : "ROLE";
            if (role == null) {
                String schemaName;
                DbObject object = r.getGrantedObject();
                Schema schema = null;
                DbObject table = null;
                if (object != null) {
                    if (object instanceof Schema) {
                        schema = (Schema)object;
                    } else if (object instanceof Table) {
                        table = (Table)object;
                        schema = ((SchemaObject)table).getSchema();
                    }
                }
                String tableName = table != null ? table.getName() : "";
                String string2 = schemaName = schema != null ? schema.getName() : "";
                if (!this.checkIndex(session, tableName, indexFrom, indexTo)) continue;
                this.add(session, rows, this.identifier(grantee.getName()), rightType, null, r.getRights(), schemaName, tableName);
                continue;
            }
            this.add(session, rows, this.identifier(grantee.getName()), rightType, this.identifier(role.getName()), null, null, null);
        }
    }

    private void roles(SessionLocal session, ArrayList<Row> rows) {
        boolean admin = session.getUser().isAdmin();
        for (RightOwner rightOwner : this.database.getAllUsersAndRoles()) {
            if (!(rightOwner instanceof Role)) continue;
            Role r = (Role)rightOwner;
            if (!admin && !session.getUser().isRoleGranted(r)) continue;
            this.add(session, rows, this.identifier(r.getName()), r.getComment());
        }
    }

    private void sessions(SessionLocal session, ArrayList<Row> rows) {
        if (session.getUser().isAdmin()) {
            for (SessionLocal s : this.database.getSessions(false)) {
                this.sessions(session, rows, s);
            }
        } else {
            this.sessions(session, rows, session);
        }
    }

    private void sessions(SessionLocal session, ArrayList<Row> rows, SessionLocal s) {
        NetworkConnectionInfo networkConnectionInfo = s.getNetworkConnectionInfo();
        Command command = s.getCurrentCommand();
        int blockingSessionId = s.getBlockingSessionId();
        this.add(session, rows, ValueInteger.get(s.getId()), s.getUser().getName(), networkConnectionInfo == null ? null : networkConnectionInfo.getServer(), networkConnectionInfo == null ? null : networkConnectionInfo.getClient(), networkConnectionInfo == null ? null : networkConnectionInfo.getClientInfo(), s.getSessionStart(), session.getIsolationLevel().getSQL(), command == null ? null : command.toString(), command == null ? null : s.getCommandStartOrEnd(), ValueBoolean.get(s.hasPendingTransaction()), String.valueOf((Object)s.getState()), blockingSessionId == 0 ? null : ValueInteger.get(blockingSessionId), s.getState() == SessionLocal.State.SLEEP ? s.getCommandStartOrEnd() : null);
    }

    private void sessionState(SessionLocal session, ArrayList<Row> rows) {
        TimeZoneProvider currentTimeZone;
        String schema;
        for (String name : session.getVariableNames()) {
            Value v = session.getVariable(name);
            StringBuilder builder = new StringBuilder().append("SET @").append(name).append(' ');
            v.getSQL(builder, 0);
            this.add(session, rows, "@" + name, builder.toString());
        }
        for (Table table : session.getLocalTempTables()) {
            this.add(session, rows, "TABLE " + table.getName(), table.getCreateSQL());
        }
        String[] path = session.getSchemaSearchPath();
        if (path != null && path.length > 0) {
            StringBuilder builder = new StringBuilder("SET SCHEMA_SEARCH_PATH ");
            int l = path.length;
            for (int i = 0; i < l; ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                StringUtils.quoteIdentifier(builder, path[i]);
            }
            this.add(session, rows, "SCHEMA_SEARCH_PATH", builder.toString());
        }
        if ((schema = session.getCurrentSchemaName()) != null) {
            this.add(session, rows, "SCHEMA", StringUtils.quoteIdentifier(new StringBuilder("SET SCHEMA "), schema).toString());
        }
        if (!(currentTimeZone = session.currentTimeZone()).equals(DateTimeUtils.getTimeZone())) {
            this.add(session, rows, "TIME ZONE", StringUtils.quoteStringSQL(new StringBuilder("SET TIME ZONE "), currentTimeZone.getId()).toString());
        }
    }

    private void settings(SessionLocal session, ArrayList<Row> rows) {
        for (Setting setting : this.database.getAllSettings()) {
            String value = setting.getStringValue();
            if (value == null) {
                value = Integer.toString(setting.getIntValue());
            }
            this.add(session, rows, this.identifier(setting.getName()), value);
        }
        this.add(session, rows, "info.BUILD_ID", "219");
        this.add(session, rows, "info.VERSION_MAJOR", "2");
        this.add(session, rows, "info.VERSION_MINOR", "2");
        this.add(session, rows, "info.VERSION", Constants.FULL_VERSION);
        if (session.getUser().isAdmin()) {
            String[] settings;
            String[] stringArray = settings = new String[]{"java.runtime.version", "java.vm.name", "java.vendor", "os.name", "os.arch", "os.version", "sun.os.patch.level", "file.separator", "path.separator", "line.separator", "user.country", "user.language", "user.variant", "file.encoding"};
            int value = stringArray.length;
            for (int i = 0; i < value; ++i) {
                String s = stringArray[i];
                this.add(session, rows, "property." + s, Utils.getProperty(s, ""));
            }
        }
        this.add(session, rows, "DEFAULT_NULL_ORDERING", this.database.getDefaultNullOrdering().name());
        this.add(session, rows, "EXCLUSIVE", this.database.getExclusiveSession() == null ? "FALSE" : "TRUE");
        this.add(session, rows, "MODE", this.database.getMode().getName());
        this.add(session, rows, "QUERY_TIMEOUT", Integer.toString(session.getQueryTimeout()));
        this.add(session, rows, "TIME ZONE", session.currentTimeZone().getId());
        this.add(session, rows, "TRUNCATE_LARGE_LENGTH", session.isTruncateLargeLength() ? "TRUE" : "FALSE");
        this.add(session, rows, "VARIABLE_BINARY", session.isVariableBinary() ? "TRUE" : "FALSE");
        this.add(session, rows, "OLD_INFORMATION_SCHEMA", session.isOldInformationSchema() ? "TRUE" : "FALSE");
        BitSet nonKeywords = session.getNonKeywords();
        if (nonKeywords != null) {
            this.add(session, rows, "NON_KEYWORDS", Parser.formatNonKeywords(nonKeywords));
        }
        this.add(session, rows, "RETENTION_TIME", Integer.toString(this.database.getRetentionTime()));
        for (Map.Entry<String, String> entry : this.database.getSettings().getSortedSettings()) {
            this.add(session, rows, entry.getKey(), entry.getValue());
        }
        Store store = this.database.getStore();
        MVStore mvStore = store.getMvStore();
        FileStore fs = mvStore.getFileStore();
        if (fs != null) {
            this.add(session, rows, "info.FILE_WRITE", Long.toString(fs.getWriteCount()));
            this.add(session, rows, "info.FILE_WRITE_BYTES", Long.toString(fs.getWriteBytes()));
            this.add(session, rows, "info.FILE_READ", Long.toString(fs.getReadCount()));
            this.add(session, rows, "info.FILE_READ_BYTES", Long.toString(fs.getReadBytes()));
            this.add(session, rows, "info.UPDATE_FAILURE_PERCENT", String.format(Locale.ENGLISH, "%.2f%%", 100.0 * mvStore.getUpdateFailureRatio()));
            this.add(session, rows, "info.FILL_RATE", Integer.toString(mvStore.getFillRate()));
            this.add(session, rows, "info.CHUNKS_FILL_RATE", Integer.toString(mvStore.getChunksFillRate()));
            this.add(session, rows, "info.CHUNKS_FILL_RATE_RW", Integer.toString(mvStore.getRewritableChunksFillRate()));
            try {
                this.add(session, rows, "info.FILE_SIZE", Long.toString(fs.getFile().size()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.add(session, rows, "info.CHUNK_COUNT", Long.toString(mvStore.getChunkCount()));
            this.add(session, rows, "info.PAGE_COUNT", Long.toString(mvStore.getPageCount()));
            this.add(session, rows, "info.PAGE_COUNT_LIVE", Long.toString(mvStore.getLivePageCount()));
            this.add(session, rows, "info.PAGE_SIZE", Integer.toString(mvStore.getPageSplitSize()));
            this.add(session, rows, "info.CACHE_MAX_SIZE", Integer.toString(mvStore.getCacheSize()));
            this.add(session, rows, "info.CACHE_SIZE", Integer.toString(mvStore.getCacheSizeUsed()));
            this.add(session, rows, "info.CACHE_HIT_RATIO", Integer.toString(mvStore.getCacheHitRatio()));
            this.add(session, rows, "info.TOC_CACHE_HIT_RATIO", Integer.toString(mvStore.getTocCacheHitRatio()));
            this.add(session, rows, "info.LEAF_RATIO", Integer.toString(mvStore.getLeafRatio()));
        }
    }

    private void synonyms(SessionLocal session, ArrayList<Row> rows, String catalog) {
        for (TableSynonym synonym : this.database.getAllSynonyms()) {
            this.add(session, rows, catalog, synonym.getSchema().getName(), synonym.getName(), synonym.getSynonymForName(), synonym.getSynonymForSchema().getName(), "SYNONYM", "VALID", synonym.getComment());
        }
    }

    private void users(SessionLocal session, ArrayList<Row> rows) {
        User currentUser = session.getUser();
        if (currentUser.isAdmin()) {
            for (RightOwner rightOwner : this.database.getAllUsersAndRoles()) {
                if (!(rightOwner instanceof User)) continue;
                this.users(session, rows, (User)rightOwner);
            }
        } else {
            this.users(session, rows, currentUser);
        }
    }

    private void users(SessionLocal session, ArrayList<Row> rows, User user) {
        this.add(session, rows, this.identifier(user.getName()), ValueBoolean.get(user.isAdmin()), user.getComment());
    }

    private void addConstraintColumnUsage(SessionLocal session, ArrayList<Row> rows, String catalog, Constraint constraint, Column column) {
        Table table = column.getTable();
        this.add(session, rows, catalog, table.getSchema().getName(), table.getName(), column.getName(), catalog, constraint.getSchema().getName(), constraint.getName());
    }

    private void addPrivileges(SessionLocal session, ArrayList<Row> rows, DbObject grantee, String catalog, Table table, String column, int rightMask) {
        if ((rightMask & 1) != 0) {
            this.addPrivilege(session, rows, grantee, catalog, table, column, "SELECT");
        }
        if ((rightMask & 4) != 0) {
            this.addPrivilege(session, rows, grantee, catalog, table, column, "INSERT");
        }
        if ((rightMask & 8) != 0) {
            this.addPrivilege(session, rows, grantee, catalog, table, column, "UPDATE");
        }
        if ((rightMask & 2) != 0) {
            this.addPrivilege(session, rows, grantee, catalog, table, column, "DELETE");
        }
    }

    private void addPrivilege(SessionLocal session, ArrayList<Row> rows, DbObject grantee, String catalog, Table table, String column, String right) {
        User user;
        String isGrantable = "NO";
        if (grantee.getType() == 2 && (user = (User)grantee).isAdmin()) {
            isGrantable = "YES";
        }
        if (column == null) {
            this.add(session, rows, null, this.identifier(grantee.getName()), catalog, table.getSchema().getName(), table.getName(), right, isGrantable, "NO");
        } else {
            this.add(session, rows, null, this.identifier(grantee.getName()), catalog, table.getSchema().getName(), table.getName(), column, right, isGrantable);
        }
    }

    @Override
    public long getMaxDataModificationId() {
        switch (this.type) {
            case 15: 
            case 25: 
            case 26: 
            case 30: 
            case 31: 
            case 32: {
                return Long.MAX_VALUE;
            }
        }
        return this.database.getModificationDataId();
    }

    @Override
    public boolean isView() {
        return this.isView;
    }

    @Override
    public long getRowCount(SessionLocal session) {
        return this.getRowCount(session, false);
    }

    @Override
    public long getRowCountApproximation(SessionLocal session) {
        return this.getRowCount(session, true);
    }

    private long getRowCount(SessionLocal session, boolean approximation) {
        switch (this.type) {
            case 0: {
                return 1L;
            }
            case 2: {
                Locale[] locales = CompareMode.getCollationLocales(approximation);
                if (locales == null) break;
                return locales.length + 1;
            }
            case 14: {
                return session.getDatabase().getAllSchemas().size();
            }
            case 25: {
                ArrayList<InDoubtTransaction> inDoubt;
                if (session.getUser().isAdmin() && (inDoubt = session.getDatabase().getInDoubtTransactions()) != null) {
                    return inDoubt.size();
                }
                return 0L;
            }
            case 29: {
                if (!session.getUser().isAdmin()) break;
                long count = 0L;
                for (RightOwner rightOwner : session.getDatabase().getAllUsersAndRoles()) {
                    if (!(rightOwner instanceof Role)) continue;
                    ++count;
                }
                return count;
            }
            case 30: {
                if (session.getUser().isAdmin()) {
                    return session.getDatabase().getSessionCount();
                }
                return 1L;
            }
            case 34: {
                if (session.getUser().isAdmin()) {
                    long count = 0L;
                    for (RightOwner rightOwner : session.getDatabase().getAllUsersAndRoles()) {
                        if (!(rightOwner instanceof User)) continue;
                        ++count;
                    }
                    return count;
                }
                return 1L;
            }
        }
        if (approximation) {
            return 1000L;
        }
        throw DbException.getInternalError(this.toString());
    }

    @Override
    public boolean canGetRowCount(SessionLocal session) {
        switch (this.type) {
            case 0: 
            case 2: 
            case 14: 
            case 25: 
            case 30: 
            case 34: {
                return true;
            }
            case 29: {
                if (!session.getUser().isAdmin()) break;
                return true;
            }
        }
        return false;
    }

    static final class DataTypeInformation {
        static final DataTypeInformation NULL = new DataTypeInformation(null, null, null, null, null, null, null, null, null, false, null, null, null, null, null);
        final String dataType;
        final Value characterPrecision;
        final Value numericPrecision;
        final Value numericPrecisionRadix;
        final Value numericScale;
        final Value datetimePrecision;
        final Value intervalPrecision;
        final Value intervalType;
        final Value maximumCardinality;
        final boolean hasCharsetAndCollation;
        final String declaredDataType;
        final Value declaredNumericPrecision;
        final Value declaredNumericScale;
        final String geometryType;
        final Value geometrySrid;

        static DataTypeInformation valueOf(TypeInfo typeInfo) {
            int type = typeInfo.getValueType();
            String dataType = Value.getTypeName(type);
            ValueBigint characterPrecision = null;
            ValueInteger numericPrecision = null;
            ValueInteger numericScale = null;
            ValueInteger numericPrecisionRadix = null;
            ValueInteger datetimePrecision = null;
            ValueInteger intervalPrecision = null;
            ValueInteger maximumCardinality = null;
            String intervalType = null;
            boolean hasCharsetAndCollation = false;
            String declaredDataType = null;
            ValueInteger declaredNumericPrecision = null;
            ValueInteger declaredNumericScale = null;
            String geometryType = null;
            ValueInteger geometrySrid = null;
            switch (type) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    hasCharsetAndCollation = true;
                }
                case 5: 
                case 6: 
                case 7: 
                case 35: 
                case 38: {
                    characterPrecision = ValueBigint.get(typeInfo.getPrecision());
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    numericPrecision = ValueInteger.get(MathUtils.convertLongToInt(typeInfo.getPrecision()));
                    numericScale = ValueInteger.get(0);
                    numericPrecisionRadix = ValueInteger.get(2);
                    declaredDataType = dataType;
                    break;
                }
                case 13: {
                    numericPrecision = ValueInteger.get(MathUtils.convertLongToInt(typeInfo.getPrecision()));
                    numericScale = ValueInteger.get(typeInfo.getScale());
                    numericPrecisionRadix = ValueInteger.get(10);
                    String string = declaredDataType = typeInfo.getExtTypeInfo() != null ? "DECIMAL" : "NUMERIC";
                    if (typeInfo.getDeclaredPrecision() >= 0L) {
                        declaredNumericPrecision = numericPrecision;
                    }
                    if (typeInfo.getDeclaredScale() < 0) break;
                    declaredNumericScale = numericScale;
                    break;
                }
                case 14: 
                case 15: {
                    numericPrecision = ValueInteger.get(MathUtils.convertLongToInt(typeInfo.getPrecision()));
                    numericPrecisionRadix = ValueInteger.get(2);
                    long declaredPrecision = typeInfo.getDeclaredPrecision();
                    if (declaredPrecision >= 0L) {
                        declaredDataType = "FLOAT";
                        if (declaredPrecision <= 0L) break;
                        declaredNumericPrecision = ValueInteger.get((int)declaredPrecision);
                        break;
                    }
                    declaredDataType = dataType;
                    break;
                }
                case 16: {
                    numericPrecision = ValueInteger.get(MathUtils.convertLongToInt(typeInfo.getPrecision()));
                    numericPrecisionRadix = ValueInteger.get(10);
                    declaredDataType = dataType;
                    if (typeInfo.getDeclaredPrecision() < 0L) break;
                    declaredNumericPrecision = numericPrecision;
                    break;
                }
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: {
                    intervalType = IntervalQualifier.valueOf(type - 22).toString();
                    dataType = "INTERVAL";
                    intervalPrecision = ValueInteger.get(MathUtils.convertLongToInt(typeInfo.getPrecision()));
                }
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    datetimePrecision = ValueInteger.get(typeInfo.getScale());
                    break;
                }
                case 37: {
                    Integer srid;
                    ExtTypeInfoGeometry extTypeInfo = (ExtTypeInfoGeometry)typeInfo.getExtTypeInfo();
                    if (extTypeInfo == null) break;
                    int typeCode = extTypeInfo.getType();
                    if (typeCode != 0) {
                        geometryType = EWKTUtils.formatGeometryTypeAndDimensionSystem(new StringBuilder(), typeCode).toString();
                    }
                    if ((srid = extTypeInfo.getSrid()) == null) break;
                    geometrySrid = ValueInteger.get(srid);
                    break;
                }
                case 40: {
                    maximumCardinality = ValueInteger.get(MathUtils.convertLongToInt(typeInfo.getPrecision()));
                }
            }
            return new DataTypeInformation(dataType, characterPrecision, numericPrecision, numericPrecisionRadix, numericScale, datetimePrecision, intervalPrecision, intervalType != null ? ValueVarchar.get(intervalType) : ValueNull.INSTANCE, maximumCardinality, hasCharsetAndCollation, declaredDataType, declaredNumericPrecision, declaredNumericScale, geometryType, geometrySrid);
        }

        private DataTypeInformation(String dataType, Value characterPrecision, Value numericPrecision, Value numericPrecisionRadix, Value numericScale, Value datetimePrecision, Value intervalPrecision, Value intervalType, Value maximumCardinality, boolean hasCharsetAndCollation, String declaredDataType, Value declaredNumericPrecision, Value declaredNumericScale, String geometryType, Value geometrySrid) {
            this.dataType = dataType;
            this.characterPrecision = characterPrecision;
            this.numericPrecision = numericPrecision;
            this.numericPrecisionRadix = numericPrecisionRadix;
            this.numericScale = numericScale;
            this.datetimePrecision = datetimePrecision;
            this.intervalPrecision = intervalPrecision;
            this.intervalType = intervalType;
            this.maximumCardinality = maximumCardinality;
            this.hasCharsetAndCollation = hasCharsetAndCollation;
            this.declaredDataType = declaredDataType;
            this.declaredNumericPrecision = declaredNumericPrecision;
            this.declaredNumericScale = declaredNumericScale;
            this.geometryType = geometryType;
            this.geometrySrid = geometrySrid;
        }
    }
}

