/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.util.ArrayList;
import org.h2.engine.SessionLocal;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.MetaIndex;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableType;
import org.h2.util.StringUtils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import org.h2.value.ValueVarchar;
import org.h2.value.ValueVarcharIgnoreCase;

public abstract class MetaTable
extends Table {
    public static final long ROW_COUNT_APPROXIMATION = 1000L;
    protected final int type;
    protected int indexColumn;
    protected MetaIndex metaIndex;

    protected MetaTable(Schema schema, int id, int type) {
        super(schema, id, null, true, true);
        this.type = type;
    }

    protected final void setMetaTableName(String upperName) {
        this.setObjectName(this.database.sysIdentifier(upperName));
    }

    final Column column(String name) {
        return new Column(this.database.sysIdentifier(name), this.database.getSettings().caseInsensitiveIdentifiers ? TypeInfo.TYPE_VARCHAR_IGNORECASE : TypeInfo.TYPE_VARCHAR);
    }

    protected final Column column(String name, TypeInfo type) {
        return new Column(this.database.sysIdentifier(name), type);
    }

    @Override
    public final String getCreateSQL() {
        return null;
    }

    @Override
    public final Index addIndex(SessionLocal session, String indexName, int indexId, IndexColumn[] cols, int uniqueColumnCount, IndexType indexType, boolean create, String indexComment) {
        throw DbException.getUnsupportedException("META");
    }

    protected final String identifier(String s) {
        if (this.database.getSettings().databaseToLower) {
            s = s == null ? null : StringUtils.toLowerEnglish(s);
        }
        return s;
    }

    protected final boolean checkIndex(SessionLocal session, String value, Value indexFrom, Value indexTo) {
        if (value == null || indexFrom == null && indexTo == null) {
            return true;
        }
        Value v = this.database.getSettings().caseInsensitiveIdentifiers ? ValueVarcharIgnoreCase.get(value) : ValueVarchar.get(value);
        if (indexFrom != null && session.compare(v, indexFrom) < 0) {
            return false;
        }
        return indexTo == null || session.compare(v, indexTo) <= 0;
    }

    protected final boolean hideTable(Table table, SessionLocal session) {
        return table.isHidden() && session != this.database.getSystemSession();
    }

    public abstract ArrayList<Row> generateRows(SessionLocal var1, SearchRow var2, SearchRow var3);

    @Override
    public boolean isInsertable() {
        return false;
    }

    @Override
    public final void removeRow(SessionLocal session, Row row) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public final void addRow(SessionLocal session, Row row) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public final void removeChildrenAndResources(SessionLocal session) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public final void close(SessionLocal session) {
    }

    protected final void add(SessionLocal session, ArrayList<Row> rows, Object ... stringsOrValues) {
        Value[] values = new Value[stringsOrValues.length];
        for (int i = 0; i < stringsOrValues.length; ++i) {
            Object s = stringsOrValues[i];
            ValueNull v = s == null ? ValueNull.INSTANCE : (s instanceof String ? ValueVarchar.get((String)s) : (Value)s);
            values[i] = this.columns[i].convert(session, v);
        }
        rows.add(Row.get(values, 1, rows.size()));
    }

    @Override
    public final void checkRename() {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public final void checkSupportAlter() {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public final long truncate(SessionLocal session) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public long getRowCount(SessionLocal session) {
        throw DbException.getInternalError(this.toString());
    }

    @Override
    public boolean canGetRowCount(SessionLocal session) {
        return false;
    }

    @Override
    public final boolean canDrop() {
        return false;
    }

    @Override
    public final TableType getTableType() {
        return TableType.SYSTEM_TABLE;
    }

    @Override
    public final Index getScanIndex(SessionLocal session) {
        return new MetaIndex(this, IndexColumn.wrap(this.columns), true);
    }

    @Override
    public final ArrayList<Index> getIndexes() {
        ArrayList<Index> list = new ArrayList<Index>(2);
        if (this.metaIndex == null) {
            return list;
        }
        list.add(new MetaIndex(this, IndexColumn.wrap(this.columns), true));
        list.add(this.metaIndex);
        return list;
    }

    @Override
    public long getRowCountApproximation(SessionLocal session) {
        return 1000L;
    }

    @Override
    public final boolean isDeterministic() {
        return true;
    }

    @Override
    public final boolean canReference() {
        return false;
    }
}

