/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.h2.command.query.AllColumnsForPlan;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.message.Trace;
import org.h2.table.PlanItem;
import org.h2.table.TableFilter;

public class Plan {
    private final TableFilter[] filters;
    private final HashMap<TableFilter, PlanItem> planItems = new HashMap();
    private final Expression[] allConditions;
    private final TableFilter[] allFilters;

    public Plan(TableFilter[] filters, int count, Expression condition) {
        this.filters = new TableFilter[count];
        System.arraycopy(filters, 0, this.filters, 0, count);
        ArrayList<Expression> allCond = new ArrayList<Expression>();
        ArrayList all = new ArrayList();
        if (condition != null) {
            allCond.add(condition);
        }
        for (int i = 0; i < count; ++i) {
            TableFilter f = filters[i];
            f.visit(f1 -> {
                all.add(f1);
                if (f1.getJoinCondition() != null) {
                    allCond.add(f1.getJoinCondition());
                }
            });
        }
        this.allConditions = allCond.toArray(new Expression[0]);
        this.allFilters = all.toArray(new TableFilter[0]);
    }

    public PlanItem getItem(TableFilter filter) {
        return this.planItems.get(filter);
    }

    public TableFilter[] getFilters() {
        return this.filters;
    }

    public void removeUnusableIndexConditions() {
        for (int i = 0; i < this.allFilters.length; ++i) {
            TableFilter f = this.allFilters[i];
            this.setEvaluatable(f, true);
            if (i < this.allFilters.length - 1) {
                f.optimizeFullCondition();
            }
            f.removeUnusableIndexConditions();
        }
        for (TableFilter f : this.allFilters) {
            this.setEvaluatable(f, false);
        }
    }

    public double calculateCost(SessionLocal session, AllColumnsForPlan allColumnsSet) {
        Trace t = session.getTrace();
        if (t.isDebugEnabled()) {
            t.debug("Plan       : calculate cost for plan {0}", Arrays.toString(this.allFilters));
        }
        double cost = 1.0;
        boolean invalidPlan = false;
        for (int i = 0; i < this.allFilters.length; ++i) {
            TableFilter tableFilter = this.allFilters[i];
            if (t.isDebugEnabled()) {
                t.debug("Plan       :   for table filter {0}", tableFilter);
            }
            PlanItem item = tableFilter.getBestPlanItem(session, this.allFilters, i, allColumnsSet);
            this.planItems.put(tableFilter, item);
            if (t.isDebugEnabled()) {
                t.debug("Plan       :   best plan item cost {0} index {1}", item.cost, item.getIndex().getPlanSQL());
            }
            cost += cost * item.cost;
            this.setEvaluatable(tableFilter, true);
            Expression on = tableFilter.getJoinCondition();
            if (on == null || on.isEverything(ExpressionVisitor.EVALUATABLE_VISITOR)) continue;
            invalidPlan = true;
            break;
        }
        if (invalidPlan) {
            cost = Double.POSITIVE_INFINITY;
        }
        if (t.isDebugEnabled()) {
            session.getTrace().debug("Plan       : plan cost {0}", cost);
        }
        for (TableFilter f : this.allFilters) {
            this.setEvaluatable(f, false);
        }
        return cost;
    }

    private void setEvaluatable(TableFilter filter, boolean b) {
        filter.setEvaluatable(filter, b);
        for (Expression e : this.allConditions) {
            e.setEvaluatable(filter, b);
        }
    }
}

