/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.util.ArrayList;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.index.Index;
import org.h2.index.RangeIndex;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableType;
import org.h2.table.VirtualTable;
import org.h2.value.TypeInfo;

public class RangeTable
extends VirtualTable {
    public static final String NAME = "SYSTEM_RANGE";
    public static final String ALIAS = "GENERATE_SERIES";
    private Expression min;
    private Expression max;
    private Expression step;
    private boolean optimized;
    private final RangeIndex index;

    public RangeTable(Schema schema, Expression min, Expression max) {
        super(schema, 0, NAME);
        this.min = min;
        this.max = max;
        Column[] columns = new Column[]{new Column("X", TypeInfo.TYPE_BIGINT)};
        this.setColumns(columns);
        this.index = new RangeIndex(this, IndexColumn.wrap(columns));
    }

    public RangeTable(Schema schema, Expression min, Expression max, Expression step) {
        this(schema, min, max);
        this.step = step;
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        builder.append(NAME).append('(');
        this.min.getUnenclosedSQL(builder, sqlFlags).append(", ");
        this.max.getUnenclosedSQL(builder, sqlFlags);
        if (this.step != null) {
            this.step.getUnenclosedSQL(builder.append(", "), sqlFlags);
        }
        return builder.append(')');
    }

    @Override
    public boolean canGetRowCount(SessionLocal session) {
        return true;
    }

    @Override
    public long getRowCount(SessionLocal session) {
        long step = this.getStep(session);
        if (step == 0L) {
            throw DbException.get(90142);
        }
        long delta = this.getMax(session) - this.getMin(session);
        if (step > 0L ? delta < 0L : delta > 0L) {
            return 0L;
        }
        return delta / step + 1L;
    }

    @Override
    public TableType getTableType() {
        return TableType.SYSTEM_TABLE;
    }

    @Override
    public Index getScanIndex(SessionLocal session) {
        return this.index;
    }

    @Override
    public ArrayList<Index> getIndexes() {
        ArrayList<Index> list = new ArrayList<Index>(2);
        list.add(this.index);
        list.add(this.index);
        return list;
    }

    public long getMin(SessionLocal session) {
        this.optimize(session);
        return this.min.getValue(session).getLong();
    }

    public long getMax(SessionLocal session) {
        this.optimize(session);
        return this.max.getValue(session).getLong();
    }

    public long getStep(SessionLocal session) {
        this.optimize(session);
        if (this.step == null) {
            return 1L;
        }
        return this.step.getValue(session).getLong();
    }

    private void optimize(SessionLocal s) {
        if (!this.optimized) {
            this.min = this.min.optimize(s);
            this.max = this.max.optimize(s);
            if (this.step != null) {
                this.step = this.step.optimize(s);
            }
            this.optimized = true;
        }
    }

    @Override
    public long getMaxDataModificationId() {
        return 0L;
    }

    @Override
    public long getRowCountApproximation(SessionLocal session) {
        return 100L;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }
}

