/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.h2.command.Prepared;
import org.h2.command.query.AllColumnsForPlan;
import org.h2.constraint.Constraint;
import org.h2.engine.CastDataProvider;
import org.h2.engine.DbObject;
import org.h2.engine.Right;
import org.h2.engine.SessionLocal;
import org.h2.expression.ExpressionVisitor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.result.DefaultRow;
import org.h2.result.LocalResult;
import org.h2.result.Row;
import org.h2.result.RowFactory;
import org.h2.result.SearchRow;
import org.h2.result.SimpleRowValue;
import org.h2.result.SortOrder;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.IndexHints;
import org.h2.table.PlanItem;
import org.h2.table.TableFilter;
import org.h2.table.TableSynonym;
import org.h2.table.TableType;
import org.h2.table.TableView;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public abstract class Table
extends SchemaObject {
    public static final int TYPE_CACHED = 0;
    public static final int TYPE_MEMORY = 1;
    public static final int READ_LOCK = 0;
    public static final int WRITE_LOCK = 1;
    public static final int EXCLUSIVE_LOCK = 2;
    protected Column[] columns;
    protected CompareMode compareMode;
    protected boolean isHidden;
    private final HashMap<String, Column> columnMap;
    private final boolean persistIndexes;
    private final boolean persistData;
    private ArrayList<TriggerObject> triggers;
    private ArrayList<Constraint> constraints;
    private ArrayList<Sequence> sequences;
    private final CopyOnWriteArrayList<TableView> dependentViews = new CopyOnWriteArrayList();
    private ArrayList<TableSynonym> synonyms;
    private boolean checkForeignKeyConstraints = true;
    private boolean onCommitDrop;
    private boolean onCommitTruncate;
    private volatile Row nullRow;
    private RowFactory rowFactory = RowFactory.getRowFactory();
    private boolean tableExpression;

    protected Table(Schema schema, int id, String name, boolean persistIndexes, boolean persistData) {
        super(schema, id, name, 11);
        this.columnMap = schema.getDatabase().newStringMap();
        this.persistIndexes = persistIndexes;
        this.persistData = persistData;
        this.compareMode = schema.getDatabase().getCompareMode();
    }

    @Override
    public void rename(String newName) {
        super.rename(newName);
        if (this.constraints != null) {
            for (Constraint constraint : this.constraints) {
                constraint.rebuild();
            }
        }
    }

    public boolean isView() {
        return false;
    }

    public boolean lock(SessionLocal session, int lockType) {
        return false;
    }

    public abstract void close(SessionLocal var1);

    public void unlock(SessionLocal s) {
    }

    public abstract Index addIndex(SessionLocal var1, String var2, int var3, IndexColumn[] var4, int var5, IndexType var6, boolean var7, String var8);

    public Row getRow(SessionLocal session, long key) {
        return null;
    }

    public boolean isInsertable() {
        return true;
    }

    public abstract void removeRow(SessionLocal var1, Row var2);

    public Row lockRow(SessionLocal session, Row row) {
        throw DbException.getUnsupportedException("lockRow()");
    }

    public abstract long truncate(SessionLocal var1);

    public abstract void addRow(SessionLocal var1, Row var2);

    public void updateRow(SessionLocal session, Row oldRow, Row newRow) {
        newRow.setKey(oldRow.getKey());
        this.removeRow(session, oldRow);
        this.addRow(session, newRow);
    }

    public abstract void checkSupportAlter();

    public abstract TableType getTableType();

    public String getSQLTableType() {
        if (this.isView()) {
            return "VIEW";
        }
        if (this.isTemporary()) {
            return this.isGlobalTemporary() ? "GLOBAL TEMPORARY" : "LOCAL TEMPORARY";
        }
        if (TableType.SYSTEM_TABLE.equals((Object)this.getTableType())) {
            return "SYS TABLE";
        }
        return "BASE TABLE";
    }

    public abstract Index getScanIndex(SessionLocal var1);

    public Index getScanIndex(SessionLocal session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan allColumnsSet) {
        return this.getScanIndex(session);
    }

    public abstract ArrayList<Index> getIndexes();

    public Index getIndex(String indexName) {
        ArrayList<Index> indexes = this.getIndexes();
        if (indexes != null) {
            for (Index index : indexes) {
                if (!index.getName().equals(indexName)) continue;
                return index;
            }
        }
        throw DbException.get(42112, indexName);
    }

    public boolean isLockedExclusively() {
        return false;
    }

    public abstract long getMaxDataModificationId();

    public abstract boolean isDeterministic();

    public abstract boolean canGetRowCount(SessionLocal var1);

    public boolean canReference() {
        return true;
    }

    public abstract boolean canDrop();

    public abstract long getRowCount(SessionLocal var1);

    public abstract long getRowCountApproximation(SessionLocal var1);

    public long getDiskSpaceUsed() {
        return 0L;
    }

    public Column getRowIdColumn() {
        return null;
    }

    public boolean isQueryComparable() {
        return true;
    }

    public void addDependencies(HashSet<DbObject> dependencies) {
        if (dependencies.contains(this)) {
            return;
        }
        if (this.sequences != null) {
            dependencies.addAll(this.sequences);
        }
        ExpressionVisitor visitor = ExpressionVisitor.getDependenciesVisitor(dependencies);
        for (Column col : this.columns) {
            col.isEverything(visitor);
        }
        if (this.constraints != null) {
            for (Constraint c : this.constraints) {
                c.isEverything(visitor);
            }
        }
        dependencies.add(this);
    }

    @Override
    public ArrayList<DbObject> getChildren() {
        ArrayList<DbObject> children = Utils.newSmallArrayList();
        ArrayList<Index> indexes = this.getIndexes();
        if (indexes != null) {
            children.addAll(indexes);
        }
        if (this.constraints != null) {
            children.addAll(this.constraints);
        }
        if (this.triggers != null) {
            children.addAll(this.triggers);
        }
        if (this.sequences != null) {
            children.addAll(this.sequences);
        }
        children.addAll(this.dependentViews);
        if (this.synonyms != null) {
            children.addAll(this.synonyms);
        }
        ArrayList<Right> rights = this.database.getAllRights();
        for (Right right : rights) {
            if (right.getGrantedObject() != this) continue;
            children.add(right);
        }
        return children;
    }

    protected void setColumns(Column[] columns) {
        if (columns.length > 16384) {
            throw DbException.get(54011, "16384");
        }
        this.columns = columns;
        if (this.columnMap.size() > 0) {
            this.columnMap.clear();
        }
        for (int i = 0; i < columns.length; ++i) {
            Column col = columns[i];
            int dataType = col.getType().getValueType();
            if (dataType == -1) {
                throw DbException.get(50004, col.getTraceSQL());
            }
            col.setTable(this, i);
            String columnName = col.getName();
            if (this.columnMap.putIfAbsent(columnName, col) == null) continue;
            throw DbException.get(42121, columnName);
        }
        this.rowFactory = this.database.getRowFactory().createRowFactory(this.database, this.database.getCompareMode(), this.database, columns, null, false);
    }

    public void renameColumn(Column column, String newName) {
        for (Column c : this.columns) {
            if (c == column || !c.getName().equals(newName)) continue;
            throw DbException.get(42121, newName);
        }
        this.columnMap.remove(column.getName());
        column.rename(newName);
        this.columnMap.put(newName, column);
    }

    public boolean isLockedExclusivelyBy(SessionLocal session) {
        return false;
    }

    public void updateRows(Prepared prepared, SessionLocal session, LocalResult rows) {
        SessionLocal.Savepoint rollback = session.setSavepoint();
        int rowScanCount = 0;
        while (rows.next()) {
            if ((++rowScanCount & 0x7F) == 0) {
                prepared.checkCanceled();
            }
            Row o = rows.currentRowForTable();
            rows.next();
            try {
                this.removeRow(session, o);
            }
            catch (DbException e) {
                if (e.getErrorCode() == 90131 || e.getErrorCode() == 90112) {
                    session.rollbackTo(rollback);
                }
                throw e;
            }
        }
        rows.reset();
        while (rows.next()) {
            if ((++rowScanCount & 0x7F) == 0) {
                prepared.checkCanceled();
            }
            rows.next();
            Row n = rows.currentRowForTable();
            try {
                this.addRow(session, n);
            }
            catch (DbException e) {
                if (e.getErrorCode() == 90131) {
                    session.rollbackTo(rollback);
                }
                throw e;
            }
        }
    }

    public CopyOnWriteArrayList<TableView> getDependentViews() {
        return this.dependentViews;
    }

    @Override
    public void removeChildrenAndResources(SessionLocal session) {
        while (!this.dependentViews.isEmpty()) {
            TableView view = this.dependentViews.get(0);
            this.dependentViews.remove(0);
            this.database.removeSchemaObject(session, view);
        }
        while (this.synonyms != null && !this.synonyms.isEmpty()) {
            TableSynonym synonym = this.synonyms.remove(0);
            this.database.removeSchemaObject(session, synonym);
        }
        while (this.triggers != null && !this.triggers.isEmpty()) {
            TriggerObject trigger = this.triggers.remove(0);
            this.database.removeSchemaObject(session, trigger);
        }
        while (this.constraints != null && !this.constraints.isEmpty()) {
            Constraint constraint = this.constraints.remove(0);
            this.database.removeSchemaObject(session, constraint);
        }
        for (Right right : this.database.getAllRights()) {
            if (right.getGrantedObject() != this) continue;
            this.database.removeDatabaseObject(session, right);
        }
        this.database.removeMeta(session, this.getId());
        while (this.sequences != null && !this.sequences.isEmpty()) {
            Sequence sequence = this.sequences.remove(0);
            if (this.database.getDependentTable(sequence, this) != null) continue;
            this.database.removeSchemaObject(session, sequence);
        }
    }

    public void dropMultipleColumnsConstraintsAndIndexes(SessionLocal session, ArrayList<Column> columnsToDrop) {
        HashSet<Constraint> constraintsToDrop = new HashSet<Constraint>();
        if (this.constraints != null) {
            for (Column col : columnsToDrop) {
                for (Constraint constraint : this.constraints) {
                    HashSet<Column> columns = constraint.getReferencedColumns(this);
                    if (!columns.contains(col)) continue;
                    if (columns.size() == 1) {
                        constraintsToDrop.add(constraint);
                        continue;
                    }
                    throw DbException.get(90083, constraint.getTraceSQL());
                }
            }
        }
        HashSet<Index> indexesToDrop = new HashSet<Index>();
        ArrayList<Index> indexes = this.getIndexes();
        if (indexes != null) {
            for (Column col : columnsToDrop) {
                for (Index index : indexes) {
                    if (index.getCreateSQL() == null || index.getColumnIndex(col) < 0) continue;
                    if (index.getColumns().length == 1) {
                        indexesToDrop.add(index);
                        continue;
                    }
                    throw DbException.get(90083, index.getTraceSQL());
                }
            }
        }
        for (Constraint c : constraintsToDrop) {
            if (!c.isValid()) continue;
            session.getDatabase().removeSchemaObject(session, c);
        }
        for (Index i : indexesToDrop) {
            if (!this.getIndexes().contains(i)) continue;
            session.getDatabase().removeSchemaObject(session, i);
        }
    }

    public RowFactory getRowFactory() {
        return this.rowFactory;
    }

    public Row createRow(Value[] data, int memory) {
        return this.rowFactory.createRow(data, memory);
    }

    public Row getTemplateRow() {
        return this.createRow(new Value[this.getColumns().length], -1);
    }

    public SearchRow getTemplateSimpleRow(boolean singleColumn) {
        if (singleColumn) {
            return new SimpleRowValue(this.columns.length);
        }
        return new DefaultRow(new Value[this.columns.length]);
    }

    public Row getNullRow() {
        Row row = this.nullRow;
        if (row == null) {
            Object[] values = new Value[this.columns.length];
            Arrays.fill(values, ValueNull.INSTANCE);
            this.nullRow = row = this.createRow((Value[])values, 1);
        }
        return row;
    }

    public Column[] getColumns() {
        return this.columns;
    }

    @Override
    public int getType() {
        return 0;
    }

    public Column getColumn(int index) {
        return this.columns[index];
    }

    public Column getColumn(String columnName) {
        Column column = this.columnMap.get(columnName);
        if (column == null) {
            throw DbException.get(42122, columnName);
        }
        return column;
    }

    public Column getColumn(String columnName, boolean ifExists) {
        Column column = this.columnMap.get(columnName);
        if (column == null && !ifExists) {
            throw DbException.get(42122, columnName);
        }
        return column;
    }

    public Column findColumn(String columnName) {
        return this.columnMap.get(columnName);
    }

    public boolean doesColumnExist(String columnName) {
        return this.columnMap.containsKey(columnName);
    }

    public Column getIdentityColumn() {
        for (Column column : this.columns) {
            if (!column.isIdentity()) continue;
            return column;
        }
        return null;
    }

    public PlanItem getBestPlanItem(SessionLocal session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan allColumnsSet) {
        PlanItem item = new PlanItem();
        item.setIndex(this.getScanIndex(session));
        item.cost = item.getIndex().getCost(session, null, filters, filter, null, allColumnsSet);
        Trace t = session.getTrace();
        if (t.isDebugEnabled()) {
            t.debug("Table      :     potential plan item cost {0} index {1}", item.cost, item.getIndex().getPlanSQL());
        }
        ArrayList<Index> indexes = this.getIndexes();
        IndexHints indexHints = Table.getIndexHints(filters, filter);
        if (indexes != null && masks != null) {
            int size = indexes.size();
            for (int i = 1; i < size; ++i) {
                Index index = indexes.get(i);
                if (Table.isIndexExcludedByHints(indexHints, index)) continue;
                double cost = index.getCost(session, masks, filters, filter, sortOrder, allColumnsSet);
                if (t.isDebugEnabled()) {
                    t.debug("Table      :     potential plan item cost {0} index {1}", cost, index.getPlanSQL());
                }
                if (!(cost < item.cost)) continue;
                item.cost = cost;
                item.setIndex(index);
            }
        }
        return item;
    }

    private static boolean isIndexExcludedByHints(IndexHints indexHints, Index index) {
        return indexHints != null && !indexHints.allowIndex(index);
    }

    private static IndexHints getIndexHints(TableFilter[] filters, int filter) {
        return filters == null ? null : filters[filter].getIndexHints();
    }

    public Index findPrimaryKey() {
        ArrayList<Index> indexes = this.getIndexes();
        if (indexes != null) {
            for (Index idx : indexes) {
                if (!idx.getIndexType().isPrimaryKey()) continue;
                return idx;
            }
        }
        return null;
    }

    public Index getPrimaryKey() {
        Index index = this.findPrimaryKey();
        if (index != null) {
            return index;
        }
        throw DbException.get(42112, "PRIMARY_KEY_");
    }

    public void convertInsertRow(SessionLocal session, Row row, Boolean overridingSystem) {
        Value value;
        int i;
        int length = this.columns.length;
        int generated = 0;
        for (i = 0; i < length; ++i) {
            Value v2;
            value = row.getValue(i);
            Column column = this.columns[i];
            if (value == ValueNull.INSTANCE && column.isDefaultOnNull()) {
                value = null;
            }
            if (column.isIdentity()) {
                if (overridingSystem != null) {
                    if (!overridingSystem.booleanValue()) {
                        value = null;
                    }
                } else if (value != null && column.isGeneratedAlways()) {
                    throw DbException.get(90154, column.getSQLWithTable(new StringBuilder(), 3).toString());
                }
            } else if (column.isGeneratedAlways()) {
                if (value != null) {
                    throw DbException.get(90154, column.getSQLWithTable(new StringBuilder(), 3).toString());
                }
                ++generated;
                continue;
            }
            if ((v2 = column.validateConvertUpdateSequence(session, value, row)) == value) continue;
            row.setValue(i, v2);
        }
        if (generated > 0) {
            for (i = 0; i < length; ++i) {
                value = row.getValue(i);
                if (value != null) continue;
                row.setValue(i, this.columns[i].validateConvertUpdateSequence(session, null, row));
            }
        }
    }

    public void convertUpdateRow(SessionLocal session, Row row, boolean fromTrigger) {
        Value value;
        int i;
        int length = this.columns.length;
        int generated = 0;
        for (i = 0; i < length; ++i) {
            value = row.getValue(i);
            Column column = this.columns[i];
            if (column.isGenerated()) {
                if (value != null) {
                    if (!fromTrigger) {
                        throw DbException.get(90154, column.getSQLWithTable(new StringBuilder(), 3).toString());
                    }
                    row.setValue(i, null);
                }
                ++generated;
                continue;
            }
            Value v2 = column.validateConvertUpdateSequence(session, value, row);
            if (v2 == value) continue;
            row.setValue(i, v2);
        }
        if (generated > 0) {
            for (i = 0; i < length; ++i) {
                value = row.getValue(i);
                if (value != null) continue;
                row.setValue(i, this.columns[i].validateConvertUpdateSequence(session, null, row));
            }
        }
    }

    private static void remove(ArrayList<? extends DbObject> list, DbObject obj) {
        if (list != null) {
            list.remove(obj);
        }
    }

    public void removeIndex(Index index) {
        ArrayList<Index> indexes = this.getIndexes();
        if (indexes != null) {
            Table.remove(indexes, index);
            if (index.getIndexType().isPrimaryKey()) {
                for (Column col : index.getColumns()) {
                    col.setPrimaryKey(false);
                }
            }
        }
    }

    public void removeDependentView(TableView view) {
        this.dependentViews.remove(view);
    }

    public void removeSynonym(TableSynonym synonym) {
        Table.remove(this.synonyms, synonym);
    }

    public void removeConstraint(Constraint constraint) {
        Table.remove(this.constraints, constraint);
    }

    public final void removeSequence(Sequence sequence) {
        Table.remove(this.sequences, sequence);
    }

    public void removeTrigger(TriggerObject trigger) {
        Table.remove(this.triggers, trigger);
    }

    public void addDependentView(TableView view) {
        this.dependentViews.add(view);
    }

    public void addSynonym(TableSynonym synonym) {
        this.synonyms = Table.add(this.synonyms, synonym);
    }

    public void addConstraint(Constraint constraint) {
        if (this.constraints == null || !this.constraints.contains(constraint)) {
            this.constraints = Table.add(this.constraints, constraint);
        }
    }

    public ArrayList<Constraint> getConstraints() {
        return this.constraints;
    }

    public void addSequence(Sequence sequence) {
        this.sequences = Table.add(this.sequences, sequence);
    }

    public void addTrigger(TriggerObject trigger) {
        this.triggers = Table.add(this.triggers, trigger);
    }

    private static <T> ArrayList<T> add(ArrayList<T> list, T obj) {
        if (list == null) {
            list = Utils.newSmallArrayList();
        }
        list.add(obj);
        return list;
    }

    public void fire(SessionLocal session, int type, boolean beforeAction) {
        if (this.triggers != null) {
            for (TriggerObject trigger : this.triggers) {
                trigger.fire(session, type, beforeAction);
            }
        }
    }

    public boolean hasSelectTrigger() {
        if (this.triggers != null) {
            for (TriggerObject trigger : this.triggers) {
                if (!trigger.isSelectTrigger()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean fireRow() {
        return this.constraints != null && !this.constraints.isEmpty() || this.triggers != null && !this.triggers.isEmpty();
    }

    public boolean fireBeforeRow(SessionLocal session, Row oldRow, Row newRow) {
        boolean done = this.fireRow(session, oldRow, newRow, true, false);
        this.fireConstraints(session, oldRow, newRow, true);
        return done;
    }

    private void fireConstraints(SessionLocal session, Row oldRow, Row newRow, boolean before) {
        if (this.constraints != null) {
            for (Constraint constraint : this.constraints) {
                if (constraint.isBefore() != before) continue;
                constraint.checkRow(session, this, oldRow, newRow);
            }
        }
    }

    public void fireAfterRow(SessionLocal session, Row oldRow, Row newRow, boolean rollback) {
        this.fireRow(session, oldRow, newRow, false, rollback);
        if (!rollback) {
            this.fireConstraints(session, oldRow, newRow, false);
        }
    }

    private boolean fireRow(SessionLocal session, Row oldRow, Row newRow, boolean beforeAction, boolean rollback) {
        if (this.triggers != null) {
            for (TriggerObject trigger : this.triggers) {
                boolean done = trigger.fireRow(session, this, oldRow, newRow, beforeAction, rollback);
                if (!done) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isGlobalTemporary() {
        return false;
    }

    public boolean canTruncate() {
        return false;
    }

    public void setCheckForeignKeyConstraints(SessionLocal session, boolean enabled, boolean checkExisting) {
        if (enabled && checkExisting && this.constraints != null) {
            for (Constraint c : this.constraints) {
                if (c.getConstraintType() != Constraint.Type.REFERENTIAL) continue;
                c.checkExistingData(session);
            }
        }
        this.checkForeignKeyConstraints = enabled;
    }

    public boolean getCheckForeignKeyConstraints() {
        return this.checkForeignKeyConstraints;
    }

    public Index getIndexForColumn(Column column, boolean needGetFirstOrLast, boolean needFindNext) {
        ArrayList<Index> indexes = this.getIndexes();
        Index result = null;
        if (indexes != null) {
            int size = indexes.size();
            for (int i = 1; i < size; ++i) {
                Index index = indexes.get(i);
                if (needGetFirstOrLast && !index.canGetFirstOrLast() || needFindNext && !index.canFindNext() || !index.isFirstColumn(column) || result != null && result.getColumns().length <= index.getColumns().length) continue;
                result = index;
            }
        }
        return result;
    }

    public boolean getOnCommitDrop() {
        return this.onCommitDrop;
    }

    public void setOnCommitDrop(boolean onCommitDrop) {
        this.onCommitDrop = onCommitDrop;
    }

    public boolean getOnCommitTruncate() {
        return this.onCommitTruncate;
    }

    public void setOnCommitTruncate(boolean onCommitTruncate) {
        this.onCommitTruncate = onCommitTruncate;
    }

    public void removeIndexOrTransferOwnership(SessionLocal session, Index index) {
        boolean stillNeeded = false;
        if (this.constraints != null) {
            for (Constraint cons : this.constraints) {
                if (!cons.usesIndex(index)) continue;
                cons.setIndexOwner(index);
                this.database.updateMeta(session, cons);
                stillNeeded = true;
            }
        }
        if (!stillNeeded) {
            this.database.removeSchemaObject(session, index);
        }
    }

    public void removeColumnExpressionsDependencies(SessionLocal session) {
        for (Column column : this.columns) {
            column.setDefaultExpression(session, null);
            column.setOnUpdateExpression(session, null);
        }
    }

    public ArrayList<SessionLocal> checkDeadlock(SessionLocal session, SessionLocal clash, Set<SessionLocal> visited) {
        return null;
    }

    public boolean isPersistIndexes() {
        return this.persistIndexes;
    }

    public boolean isPersistData() {
        return this.persistData;
    }

    public int compareValues(CastDataProvider provider, Value a, Value b) {
        return a.compareTo(b, provider, this.compareMode);
    }

    public CompareMode getCompareMode() {
        return this.compareMode;
    }

    public void checkWritingAllowed() {
        this.database.checkWritingAllowed();
    }

    @Override
    public boolean isHidden() {
        return this.isHidden;
    }

    public void setHidden(boolean hidden) {
        this.isHidden = hidden;
    }

    public boolean isRowLockable() {
        return false;
    }

    public void setTableExpression(boolean tableExpression) {
        this.tableExpression = tableExpression;
    }

    public boolean isTableExpression() {
        return this.tableExpression;
    }

    public ArrayList<TriggerObject> getTriggers() {
        return this.triggers;
    }

    public int getMainIndexColumn() {
        return -1;
    }
}

