/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.h2.command.Prepared;
import org.h2.engine.SessionLocal;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.LinkedIndex;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbc.JdbcResultSet;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.result.Row;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableLinkConnection;
import org.h2.table.TableType;
import org.h2.util.JdbcUtils;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.DataType;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

public class TableLink
extends Table {
    private static final int MAX_RETRY = 2;
    private static final long ROW_COUNT_APPROXIMATION = 100000L;
    private final String originalSchema;
    private String driver;
    private String url;
    private String user;
    private String password;
    private String originalTable;
    private String qualifiedTableName;
    private TableLinkConnection conn;
    private HashMap<String, PreparedStatement> preparedMap = new HashMap();
    private final ArrayList<Index> indexes = Utils.newSmallArrayList();
    private final boolean emitUpdates;
    private LinkedIndex linkedIndex;
    private DbException connectException;
    private boolean storesLowerCase;
    private boolean storesMixedCase;
    private boolean storesMixedCaseQuoted;
    private boolean supportsMixedCaseIdentifiers;
    private String identifierQuoteString;
    private boolean globalTemporary;
    private boolean readOnly;
    private final boolean targetsMySql;
    private int fetchSize = 0;
    private boolean autocommit = true;

    public TableLink(Schema schema, int id, String name, String driver, String url, String user, String password, String originalSchema, String originalTable, boolean emitUpdates, boolean force) {
        super(schema, id, name, false, true);
        this.driver = driver;
        this.url = url;
        this.user = user;
        this.password = password;
        this.originalSchema = originalSchema;
        this.originalTable = originalTable;
        this.emitUpdates = emitUpdates;
        this.targetsMySql = TableLink.isMySqlUrl(this.url);
        try {
            this.connect();
        }
        catch (DbException e) {
            if (!force) {
                throw e;
            }
            Column[] cols = new Column[]{};
            this.setColumns(cols);
            this.linkedIndex = new LinkedIndex(this, id, IndexColumn.wrap(cols), 0, IndexType.createNonUnique(false));
            this.indexes.add(this.linkedIndex);
        }
    }

    private void connect() {
        this.connectException = null;
        int retry = 0;
        while (true) {
            try {
                this.conn = this.database.getLinkConnection(this.driver, this.url, this.user, this.password);
                this.conn.setAutoCommit(this.autocommit);
                TableLinkConnection tableLinkConnection = this.conn;
                synchronized (tableLinkConnection) {
                    try {
                        this.readMetaData();
                        return;
                    }
                    catch (Exception e) {
                        this.conn.close(true);
                        this.conn = null;
                        throw DbException.convert(e);
                    }
                }
            }
            catch (DbException e) {
                if (retry >= 2) {
                    this.connectException = e;
                    throw e;
                }
                ++retry;
                continue;
            }
            break;
        }
    }

    private void readMetaData() throws SQLException {
        Column col;
        int type;
        int scale;
        long precision;
        Throwable throwable;
        DatabaseMetaData meta = this.conn.getConnection().getMetaData();
        this.storesLowerCase = meta.storesLowerCaseIdentifiers();
        this.storesMixedCase = meta.storesMixedCaseIdentifiers();
        this.storesMixedCaseQuoted = meta.storesMixedCaseQuotedIdentifiers();
        this.supportsMixedCaseIdentifiers = meta.supportsMixedCaseIdentifiers();
        this.identifierQuoteString = meta.getIdentifierQuoteString();
        ArrayList<Column> columnList = Utils.newSmallArrayList();
        HashMap<String, Column> columnMap = new HashMap<String, Column>();
        String schema = null;
        boolean isQuery = this.originalTable.startsWith("(");
        if (!isQuery) {
            throwable = null;
            try (ResultSet rs = meta.getTables(null, this.originalSchema, this.originalTable, null);){
                if (rs.next() && rs.next()) {
                    throw DbException.get(90080, this.originalTable);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            rs = meta.getColumns(null, this.originalSchema, this.originalTable, null);
            throwable = null;
            try {
                int i = 0;
                String catalog = null;
                while (rs.next()) {
                    String thisCatalog = rs.getString("TABLE_CAT");
                    if (catalog == null) {
                        catalog = thisCatalog;
                    }
                    String thisSchema = rs.getString("TABLE_SCHEM");
                    if (schema == null) {
                        schema = thisSchema;
                    }
                    if (!Objects.equals(catalog, thisCatalog) || !Objects.equals(schema, thisSchema)) {
                        columnMap.clear();
                        columnList.clear();
                        break;
                    }
                    String n = rs.getString("COLUMN_NAME");
                    n = this.convertColumnName(n);
                    int sqlType = rs.getInt("DATA_TYPE");
                    String sqlTypeName = rs.getString("TYPE_NAME");
                    precision = rs.getInt("COLUMN_SIZE");
                    precision = TableLink.convertPrecision(sqlType, precision);
                    scale = rs.getInt("DECIMAL_DIGITS");
                    scale = TableLink.convertScale(sqlType, scale);
                    type = DataType.convertSQLTypeToValueType(sqlType, sqlTypeName);
                    col = new Column(n, TypeInfo.getTypeInfo(type, precision, scale, null), this, i++);
                    columnList.add(col);
                    columnMap.put(n, col);
                }
            }
            catch (Throwable i) {
                throwable = i;
                throw i;
            }
            finally {
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable i) {
                            throwable.addSuppressed(i);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        this.qualifiedTableName = this.originalTable.indexOf(46) < 0 && !StringUtils.isNullOrEmpty(schema) ? schema + '.' + this.originalTable : this.originalTable;
        try {
            throwable = null;
            try (Statement stat = this.conn.getConnection().createStatement();
                 ResultSet rs = stat.executeQuery("SELECT * FROM " + this.qualifiedTableName + " T WHERE 1=0");){
                if (rs instanceof JdbcResultSet) {
                    ResultInterface result = ((JdbcResultSet)rs).getResult();
                    columnList.clear();
                    columnMap.clear();
                    int i = 0;
                    int l = result.getVisibleColumnCount();
                    while (i < l) {
                        String n = result.getColumnName(i);
                        Column col2 = new Column(n, result.getColumnType(i), this, ++i);
                        columnList.add(col2);
                        columnMap.put(n, col2);
                    }
                } else if (columnList.isEmpty()) {
                    ResultSetMetaData rsMeta = rs.getMetaData();
                    int i = 0;
                    int l = rsMeta.getColumnCount();
                    while (i < l) {
                        String n = rsMeta.getColumnName(i + 1);
                        n = this.convertColumnName(n);
                        int sqlType = rsMeta.getColumnType(i + 1);
                        precision = rsMeta.getPrecision(i + 1);
                        precision = TableLink.convertPrecision(sqlType, precision);
                        scale = rsMeta.getScale(i + 1);
                        scale = TableLink.convertScale(sqlType, scale);
                        type = DataType.getValueTypeFromResultSet(rsMeta, i + 1);
                        col = new Column(n, TypeInfo.getTypeInfo(type, precision, scale, null), this, i++);
                        columnList.add(col);
                        columnMap.put(n, col);
                    }
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (Exception e) {
            throw DbException.get(42102, e, this.originalTable + '(' + e + ')');
        }
        Column[] cols = columnList.toArray(new Column[0]);
        this.setColumns(cols);
        int id = this.getId();
        this.linkedIndex = new LinkedIndex(this, id, IndexColumn.wrap(cols), 0, IndexType.createNonUnique(false));
        this.indexes.add(this.linkedIndex);
        if (!isQuery) {
            this.readIndexes(meta, columnMap);
        }
    }

    private void readIndexes(DatabaseMetaData meta, HashMap<String, Column> columnMap) {
        Throwable throwable;
        ResultSet rs2;
        String pkName = null;
        try {
            rs2 = meta.getPrimaryKeys(null, this.originalSchema, this.originalTable);
            throwable = null;
            try {
                if (rs2.next()) {
                    pkName = this.readPrimaryKey(rs2, columnMap);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (rs2 != null) {
                    if (throwable != null) {
                        try {
                            rs2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        rs2.close();
                    }
                }
            }
        }
        catch (Exception rs2) {
            // empty catch block
        }
        try {
            rs2 = meta.getIndexInfo(null, this.originalSchema, this.originalTable, false, true);
            throwable = null;
            try {
                this.readIndexes(rs2, columnMap, pkName);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (rs2 != null) {
                    if (throwable != null) {
                        try {
                            rs2.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        rs2.close();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String readPrimaryKey(ResultSet rs, HashMap<String, Column> columnMap) throws SQLException {
        String pkName = null;
        ArrayList<Column> list = Utils.newSmallArrayList();
        do {
            int idx = rs.getInt("KEY_SEQ");
            if (StringUtils.isNullOrEmpty(pkName)) {
                pkName = rs.getString("PK_NAME");
            }
            while (list.size() < idx) {
                list.add(null);
            }
            String col = rs.getString("COLUMN_NAME");
            col = this.convertColumnName(col);
            Column column = columnMap.get(col);
            if (idx == 0) {
                list.add(column);
                continue;
            }
            list.set(idx - 1, column);
        } while (rs.next());
        this.addIndex(list, list.size(), IndexType.createPrimaryKey(false, false));
        return pkName;
    }

    private void readIndexes(ResultSet rs, HashMap<String, Column> columnMap, String pkName) throws SQLException {
        String indexName = null;
        ArrayList<Column> list = Utils.newSmallArrayList();
        int uniqueColumnCount = 0;
        IndexType indexType = null;
        while (rs.next()) {
            if (rs.getShort("TYPE") == 0) continue;
            String newIndex = rs.getString("INDEX_NAME");
            if (pkName != null && pkName.equals(newIndex)) continue;
            if (indexName != null && !indexName.equals(newIndex)) {
                this.addIndex(list, uniqueColumnCount, indexType);
                uniqueColumnCount = 0;
                indexName = null;
            }
            if (indexName == null) {
                indexName = newIndex;
                list.clear();
            }
            if (!rs.getBoolean("NON_UNIQUE")) {
                ++uniqueColumnCount;
            }
            indexType = uniqueColumnCount > 0 ? IndexType.createUnique(false, false) : IndexType.createNonUnique(false);
            String col = rs.getString("COLUMN_NAME");
            col = this.convertColumnName(col);
            Column column = columnMap.get(col);
            list.add(column);
        }
        if (indexName != null) {
            this.addIndex(list, uniqueColumnCount, indexType);
        }
    }

    private static long convertPrecision(int sqlType, long precision) {
        switch (sqlType) {
            case 2: 
            case 3: {
                if (precision != 0L) break;
                precision = 65535L;
                break;
            }
            case 91: {
                precision = Math.max(10L, precision);
                break;
            }
            case 93: {
                precision = Math.max(29L, precision);
                break;
            }
            case 92: {
                precision = Math.max(18L, precision);
            }
        }
        return precision;
    }

    private static int convertScale(int sqlType, int scale) {
        switch (sqlType) {
            case 2: 
            case 3: {
                if (scale >= 0) break;
                scale = Short.MAX_VALUE;
            }
        }
        return scale;
    }

    private String convertColumnName(String columnName) {
        if (this.targetsMySql) {
            columnName = StringUtils.toUpperEnglish(columnName);
        } else if ((this.storesMixedCase || this.storesLowerCase) && columnName.equals(StringUtils.toLowerEnglish(columnName))) {
            columnName = StringUtils.toUpperEnglish(columnName);
        } else if (this.storesMixedCase && !this.supportsMixedCaseIdentifiers) {
            columnName = StringUtils.toUpperEnglish(columnName);
        } else if (this.storesMixedCase && this.storesMixedCaseQuoted) {
            columnName = StringUtils.toUpperEnglish(columnName);
        }
        return columnName;
    }

    private void addIndex(List<Column> list, int uniqueColumnCount, IndexType indexType) {
        int firstNull = list.indexOf(null);
        if (firstNull == 0) {
            this.trace.info("Omitting linked index - no recognized columns.");
            return;
        }
        if (firstNull > 0) {
            this.trace.info("Unrecognized columns in linked index. Registering the index against the leading {0} recognized columns of {1} total columns.", firstNull, list.size());
            list = list.subList(0, firstNull);
        }
        Column[] cols = list.toArray(new Column[0]);
        LinkedIndex index = new LinkedIndex(this, 0, IndexColumn.wrap(cols), uniqueColumnCount, indexType);
        this.indexes.add(index);
    }

    @Override
    public String getDropSQL() {
        StringBuilder builder = new StringBuilder("DROP TABLE IF EXISTS ");
        return this.getSQL(builder, 0).toString();
    }

    @Override
    public String getCreateSQL() {
        StringBuilder buff = new StringBuilder("CREATE FORCE ");
        if (this.isTemporary()) {
            if (this.globalTemporary) {
                buff.append("GLOBAL ");
            } else {
                buff.append("LOCAL ");
            }
            buff.append("TEMPORARY ");
        }
        buff.append("LINKED TABLE ");
        this.getSQL(buff, 0);
        if (this.comment != null) {
            buff.append(" COMMENT ");
            StringUtils.quoteStringSQL(buff, this.comment);
        }
        buff.append('(');
        StringUtils.quoteStringSQL(buff, this.driver).append(", ");
        StringUtils.quoteStringSQL(buff, this.url).append(", ");
        StringUtils.quoteStringSQL(buff, this.user).append(", ");
        StringUtils.quoteStringSQL(buff, this.password).append(", ");
        StringUtils.quoteStringSQL(buff, this.originalTable).append(')');
        if (this.emitUpdates) {
            buff.append(" EMIT UPDATES");
        }
        if (this.readOnly) {
            buff.append(" READONLY");
        }
        if (this.fetchSize != 0) {
            buff.append(" FETCH_SIZE ").append(this.fetchSize);
        }
        if (!this.autocommit) {
            buff.append(" AUTOCOMMIT OFF");
        }
        buff.append(" /*").append("--hide--").append("*/");
        return buff.toString();
    }

    @Override
    public Index addIndex(SessionLocal session, String indexName, int indexId, IndexColumn[] cols, int uniqueColumnCount, IndexType indexType, boolean create, String indexComment) {
        throw DbException.getUnsupportedException("LINK");
    }

    @Override
    public Index getScanIndex(SessionLocal session) {
        return this.linkedIndex;
    }

    @Override
    public boolean isInsertable() {
        return !this.readOnly;
    }

    private void checkReadOnly() {
        if (this.readOnly) {
            throw DbException.get(90097);
        }
    }

    @Override
    public void removeRow(SessionLocal session, Row row) {
        this.checkReadOnly();
        this.getScanIndex(session).remove(session, row);
    }

    @Override
    public void addRow(SessionLocal session, Row row) {
        this.checkReadOnly();
        this.getScanIndex(session).add(session, row);
    }

    @Override
    public void close(SessionLocal session) {
        if (this.conn != null) {
            try {
                this.conn.close(false);
            }
            finally {
                this.conn = null;
            }
        }
    }

    @Override
    public synchronized long getRowCount(SessionLocal session) {
        String sql = "SELECT COUNT(*) FROM " + this.qualifiedTableName + " as foo";
        try {
            PreparedStatement prep = this.execute(sql, null, false, session);
            ResultSet rs = prep.getResultSet();
            rs.next();
            long count = rs.getLong(1);
            rs.close();
            this.reusePreparedStatement(prep, sql);
            return count;
        }
        catch (Exception e) {
            throw TableLink.wrapException(sql, e);
        }
    }

    public static DbException wrapException(String sql, Exception ex) {
        SQLException e = DbException.toSQLException(ex);
        return DbException.get(90111, e, sql, e.toString());
    }

    public String getQualifiedTable() {
        return this.qualifiedTableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement execute(String sql, ArrayList<Value> params, boolean reusePrepared, SessionLocal session) {
        if (this.conn == null) {
            throw this.connectException;
        }
        int retry = 0;
        while (true) {
            try {
                TableLinkConnection tableLinkConnection = this.conn;
                synchronized (tableLinkConnection) {
                    Value v;
                    int i;
                    PreparedStatement prep = this.preparedMap.remove(sql);
                    if (prep == null) {
                        prep = this.conn.getConnection().prepareStatement(sql);
                        if (this.fetchSize != 0) {
                            prep.setFetchSize(this.fetchSize);
                        }
                    }
                    if (this.trace.isDebugEnabled()) {
                        StringBuilder builder = new StringBuilder(this.getName()).append(":\n").append(sql);
                        if (params != null && !params.isEmpty()) {
                            builder.append(" {");
                            i = 0;
                            int l = params.size();
                            while (i < l) {
                                v = params.get(i);
                                if (i > 0) {
                                    builder.append(", ");
                                }
                                builder.append(++i).append(": ");
                                v.getSQL(builder, 0);
                            }
                            builder.append('}');
                        }
                        builder.append(';');
                        this.trace.debug(builder.toString());
                    }
                    if (params != null) {
                        JdbcConnection ownConnection = session.createConnection(false);
                        int size = params.size();
                        for (i = 0; i < size; ++i) {
                            v = params.get(i);
                            JdbcUtils.set(prep, i + 1, v, ownConnection);
                        }
                    }
                    prep.execute();
                    if (reusePrepared) {
                        this.reusePreparedStatement(prep, sql);
                        return null;
                    }
                    return prep;
                }
            }
            catch (SQLException e) {
                if (retry >= 2) {
                    throw DbException.convert(e);
                }
                this.conn.close(true);
                this.connect();
                ++retry;
                continue;
            }
            break;
        }
    }

    @Override
    public void checkSupportAlter() {
        throw DbException.getUnsupportedException("LINK");
    }

    @Override
    public long truncate(SessionLocal session) {
        throw DbException.getUnsupportedException("LINK");
    }

    @Override
    public boolean canGetRowCount(SessionLocal session) {
        return true;
    }

    @Override
    public boolean canDrop() {
        return true;
    }

    @Override
    public TableType getTableType() {
        return TableType.TABLE_LINK;
    }

    @Override
    public void removeChildrenAndResources(SessionLocal session) {
        super.removeChildrenAndResources(session);
        this.close(session);
        this.database.removeMeta(session, this.getId());
        this.driver = null;
        this.originalTable = null;
        this.password = null;
        this.user = null;
        this.url = null;
        this.preparedMap = null;
        this.invalidate();
    }

    public boolean isOracle() {
        return this.url.startsWith("jdbc:oracle:");
    }

    private static boolean isMySqlUrl(String url) {
        return url.startsWith("jdbc:mysql:") || url.startsWith("jdbc:mariadb:");
    }

    @Override
    public ArrayList<Index> getIndexes() {
        return this.indexes;
    }

    @Override
    public long getMaxDataModificationId() {
        return Long.MAX_VALUE;
    }

    @Override
    public void updateRows(Prepared prepared, SessionLocal session, LocalResult rows) {
        this.checkReadOnly();
        if (this.emitUpdates) {
            while (rows.next()) {
                prepared.checkCanceled();
                Row oldRow = rows.currentRowForTable();
                rows.next();
                Row newRow = rows.currentRowForTable();
                this.linkedIndex.update(oldRow, newRow, session);
            }
        } else {
            super.updateRows(prepared, session, rows);
        }
    }

    public void setGlobalTemporary(boolean globalTemporary) {
        this.globalTemporary = globalTemporary;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public long getRowCountApproximation(SessionLocal session) {
        return 100000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reusePreparedStatement(PreparedStatement prep, String sql) {
        TableLinkConnection tableLinkConnection = this.conn;
        synchronized (tableLinkConnection) {
            this.preparedMap.put(sql, prep);
        }
    }

    @Override
    public boolean isDeterministic() {
        return false;
    }

    @Override
    public void checkWritingAllowed() {
    }

    @Override
    public void convertInsertRow(SessionLocal session, Row row, Boolean overridingSystem) {
        this.convertRow(session, row);
    }

    @Override
    public void convertUpdateRow(SessionLocal session, Row row, boolean fromTrigger) {
        this.convertRow(session, row);
    }

    private void convertRow(SessionLocal session, Row row) {
        for (int i = 0; i < this.columns.length; ++i) {
            Column column;
            Value v2;
            Value value = row.getValue(i);
            if (value == null || (v2 = (column = this.columns[i]).validateConvertUpdateSequence(session, value, row)) == value) continue;
            row.setValue(i, v2);
        }
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setAutoCommit(boolean mode) {
        this.autocommit = mode;
    }

    public boolean getAutocommit() {
        return this.autocommit;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public String getIdentifierQuoteString() {
        return this.identifierQuoteString;
    }
}

