/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.h2.command.Prepared;
import org.h2.command.ddl.CreateTableData;
import org.h2.command.query.AllColumnsForPlan;
import org.h2.command.query.Query;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.expression.Parameter;
import org.h2.index.Index;
import org.h2.index.QueryExpressionIndex;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.result.SortOrder;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.QueryExpressionTable;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.table.TableType;
import org.h2.util.StringUtils;
import org.h2.util.Utils;

public final class TableView
extends QueryExpressionTable {
    private String querySQL;
    private Column[] columnTemplates;
    private boolean allowRecursive;
    private DbException createException;
    private ResultInterface recursiveResult;
    private boolean isRecursiveQueryDetected;
    private boolean isTableExpression;

    public TableView(Schema schema, int id, String name, String querySQL, ArrayList<Parameter> params, Column[] columnTemplates, SessionLocal session, boolean allowRecursive, boolean literalsChecked, boolean isTableExpression, boolean isTemporary) {
        super(schema, id, name);
        this.setTemporary(isTemporary);
        this.init(querySQL, params, columnTemplates, session, allowRecursive, literalsChecked, isTableExpression);
    }

    public void replace(String querySQL, Column[] newColumnTemplates, SessionLocal session, boolean recursive, boolean force, boolean literalsChecked) {
        String oldQuerySQL = this.querySQL;
        Column[] oldColumnTemplates = this.columnTemplates;
        boolean oldRecursive = this.allowRecursive;
        this.init(querySQL, null, newColumnTemplates, session, recursive, literalsChecked, this.isTableExpression);
        DbException e = this.recompile(session, force, true);
        if (e != null) {
            this.init(oldQuerySQL, null, oldColumnTemplates, session, oldRecursive, literalsChecked, this.isTableExpression);
            this.recompile(session, true, false);
            throw e;
        }
    }

    private synchronized void init(String querySQL, ArrayList<Parameter> params, Column[] columnTemplates, SessionLocal session, boolean allowRecursive, boolean literalsChecked, boolean isTableExpression) {
        this.querySQL = querySQL;
        this.columnTemplates = columnTemplates;
        this.allowRecursive = allowRecursive;
        this.isRecursiveQueryDetected = false;
        this.isTableExpression = isTableExpression;
        this.index = new QueryExpressionIndex(this, querySQL, params, allowRecursive);
        this.initColumnsAndTables(session, literalsChecked);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Query compileViewQuery(SessionLocal session, String sql, boolean literalsChecked) {
        Prepared p;
        session.setParsingCreateView(true);
        try {
            p = session.prepare(sql, false, literalsChecked);
        }
        finally {
            session.setParsingCreateView(false);
        }
        if (!(p instanceof Query)) {
            throw DbException.getSyntaxError(sql, 0);
        }
        Query q = (Query)p;
        if (this.isTableExpression && this.allowRecursive) {
            q.setNeverLazy(true);
        }
        return q;
    }

    public synchronized DbException recompile(SessionLocal session, boolean force, boolean clearIndexCache) {
        block4: {
            try {
                this.compileViewQuery(session, this.querySQL, false);
            }
            catch (DbException e) {
                if (force) break block4;
                return e;
            }
        }
        ArrayList<TableView> dependentViews = new ArrayList<TableView>(this.getDependentViews());
        this.initColumnsAndTables(session, false);
        for (TableView v : dependentViews) {
            DbException e = v.recompile(session, force, false);
            if (e == null || force) continue;
            return e;
        }
        if (clearIndexCache) {
            TableView.clearIndexCaches(this.database);
        }
        return force ? null : this.createException;
    }

    private void initColumnsAndTables(SessionLocal session, boolean literalsChecked) {
        Column[] cols;
        block6: {
            this.removeCurrentViewFromOtherTables();
            this.setTableExpression(this.isTableExpression);
            try {
                Query compiledQuery = this.compileViewQuery(session, this.querySQL, literalsChecked);
                this.querySQL = compiledQuery.getPlanSQL(0);
                this.tables = new ArrayList<Table>(compiledQuery.getTables());
                cols = this.initColumns(session, this.columnTemplates, compiledQuery, false);
                this.createException = null;
                this.viewQuery = compiledQuery;
            }
            catch (DbException e) {
                if (e.getErrorCode() == 90156) {
                    throw e;
                }
                e.addSQL(this.getCreateSQL());
                this.createException = e;
                if (this.isRecursiveQueryExceptionDetected(this.createException)) {
                    this.isRecursiveQueryDetected = true;
                }
                this.tables = Utils.newSmallArrayList();
                cols = new Column[]{};
                if (!this.allowRecursive || this.columnTemplates == null) break block6;
                cols = new Column[this.columnTemplates.length];
                for (int i = 0; i < this.columnTemplates.length; ++i) {
                    cols[i] = this.columnTemplates[i].getClone();
                }
                this.index.setRecursive(true);
                this.createException = null;
            }
        }
        this.setColumns(cols);
        if (this.getId() != 0) {
            this.addDependentViewToTables();
        }
    }

    public boolean isInvalid() {
        return this.createException != null;
    }

    @Override
    public Query getTopQuery() {
        return null;
    }

    @Override
    public String getDropSQL() {
        return this.getSQL(new StringBuilder("DROP VIEW IF EXISTS "), 0).append(" CASCADE").toString();
    }

    @Override
    public String getCreateSQLForCopy(Table table, String quotedName) {
        return this.getCreateSQL(false, true, quotedName);
    }

    @Override
    public String getCreateSQL() {
        return this.getCreateSQL(false, true);
    }

    public String getCreateSQL(boolean orReplace, boolean force) {
        return this.getCreateSQL(orReplace, force, this.getSQL(0));
    }

    private String getCreateSQL(boolean orReplace, boolean force, String quotedName) {
        StringBuilder builder = new StringBuilder("CREATE ");
        if (orReplace) {
            builder.append("OR REPLACE ");
        }
        if (force) {
            builder.append("FORCE ");
        }
        builder.append("VIEW ");
        if (this.isTableExpression) {
            builder.append("TABLE_EXPRESSION ");
        }
        builder.append(quotedName);
        if (this.comment != null) {
            builder.append(" COMMENT ");
            StringUtils.quoteStringSQL(builder, this.comment);
        }
        if (this.columns != null && this.columns.length > 0) {
            builder.append('(');
            Column.writeColumns(builder, this.columns, 0);
            builder.append(')');
        } else if (this.columnTemplates != null) {
            builder.append('(');
            Column.writeColumns(builder, this.columnTemplates, 0);
            builder.append(')');
        }
        return builder.append(" AS\n").append(this.querySQL).toString();
    }

    @Override
    public boolean canDrop() {
        return true;
    }

    @Override
    public TableType getTableType() {
        return TableType.VIEW;
    }

    @Override
    public void removeChildrenAndResources(SessionLocal session) {
        this.removeCurrentViewFromOtherTables();
        super.removeChildrenAndResources(session);
        this.database.removeMeta(session, this.getId());
        this.querySQL = null;
        this.index = null;
        TableView.clearIndexCaches(this.database);
        this.invalidate();
    }

    public static void clearIndexCaches(Database database) {
        for (SessionLocal s : database.getSessions(true)) {
            s.clearViewIndexCache();
        }
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        if (this.isTemporary() && this.querySQL != null) {
            builder.append("(\n");
            return StringUtils.indent(builder, this.querySQL, 4, true).append(')');
        }
        return super.getSQL(builder, sqlFlags);
    }

    public String getQuerySQL() {
        return this.querySQL;
    }

    @Override
    public Index getScanIndex(SessionLocal session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan allColumnsSet) {
        if (this.createException != null) {
            String msg = this.createException.getMessage();
            throw DbException.get(90109, this.createException, this.getTraceSQL(), msg);
        }
        return super.getScanIndex(session, masks, filters, filter, sortOrder, allColumnsSet);
    }

    @Override
    public long getMaxDataModificationId() {
        if (this.createException != null || this.viewQuery == null) {
            return Long.MAX_VALUE;
        }
        return super.getMaxDataModificationId();
    }

    private void removeCurrentViewFromOtherTables() {
        if (this.tables != null) {
            for (Table t : this.tables) {
                t.removeDependentView(this);
            }
            this.tables.clear();
        }
    }

    private void addDependentViewToTables() {
        for (Table t : this.tables) {
            t.addDependentView(this);
        }
    }

    public boolean isRecursive() {
        return this.allowRecursive;
    }

    @Override
    public boolean isDeterministic() {
        if (this.allowRecursive || this.viewQuery == null) {
            return false;
        }
        return super.isDeterministic();
    }

    public void setRecursiveResult(ResultInterface value) {
        if (this.recursiveResult != null) {
            this.recursiveResult.close();
        }
        this.recursiveResult = value;
    }

    public ResultInterface getRecursiveResult() {
        return this.recursiveResult;
    }

    public boolean isRecursiveQueryDetected() {
        return this.isRecursiveQueryDetected;
    }

    private boolean isRecursiveQueryExceptionDetected(DbException exception) {
        if (exception == null) {
            return false;
        }
        int errorCode = exception.getErrorCode();
        if (errorCode != 42102 && errorCode != 42104 && errorCode != 42103) {
            return false;
        }
        return exception.getMessage().contains("\"" + this.getName() + "\"");
    }

    public List<Table> getTables() {
        return this.tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableView createTableViewMaybeRecursive(Schema schema, int id, String name, String querySQL, ArrayList<Parameter> parameters, Column[] columnTemplates, SessionLocal session, boolean literalsChecked, boolean isTableExpression, boolean isTemporary, Database db) {
        List<Column> columnTemplateList;
        Table recursiveTable = TableView.createShadowTableForRecursiveTableExpression(isTemporary, session, name, schema, Arrays.asList(columnTemplates), db);
        String[] querySQLOutput = new String[1];
        ArrayList<String> columnNames = new ArrayList<String>();
        for (Column columnTemplate : columnTemplates) {
            columnNames.add(columnTemplate.getName());
        }
        try {
            Prepared withQuery = session.prepare(querySQL, false, false);
            if (!isTemporary) {
                withQuery.setSession(session);
            }
            columnTemplateList = TableView.createQueryColumnTemplateList(columnNames.toArray(new String[1]), (Query)withQuery, querySQLOutput);
        }
        finally {
            TableView.destroyShadowTableForRecursiveExpression(isTemporary, session, recursiveTable);
        }
        TableView view = new TableView(schema, id, name, querySQL, parameters, columnTemplateList.toArray(columnTemplates), session, true, literalsChecked, isTableExpression, isTemporary);
        if (!view.isRecursiveQueryDetected()) {
            if (!isTemporary) {
                db.addSchemaObject(session, view);
                view.lock(session, 2);
                session.getDatabase().removeSchemaObject(session, view);
                view.removeChildrenAndResources(session);
            } else {
                session.removeLocalTempTable(view);
            }
            view = new TableView(schema, id, name, querySQL, parameters, columnTemplates, session, false, literalsChecked, isTableExpression, isTemporary);
        }
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Table createShadowTableForRecursiveTableExpression(boolean isTemporary, SessionLocal targetSession, String cteViewName, Schema schema, List<Column> columns, Database db) {
        CreateTableData recursiveTableData = new CreateTableData();
        recursiveTableData.id = db.allocateObjectId();
        recursiveTableData.columns = new ArrayList<Column>(columns);
        recursiveTableData.tableName = cteViewName;
        recursiveTableData.temporary = isTemporary;
        recursiveTableData.persistData = true;
        recursiveTableData.persistIndexes = !isTemporary;
        recursiveTableData.session = targetSession;
        Table recursiveTable = schema.createTable(recursiveTableData);
        if (!isTemporary) {
            db.unlockMeta(targetSession);
            SessionLocal sessionLocal = targetSession;
            synchronized (sessionLocal) {
                db.addSchemaObject(targetSession, recursiveTable);
            }
        } else {
            targetSession.addLocalTempTable(recursiveTable);
        }
        return recursiveTable;
    }

    public static void destroyShadowTableForRecursiveExpression(boolean isTemporary, SessionLocal targetSession, Table recursiveTable) {
        if (recursiveTable != null) {
            if (!isTemporary) {
                recursiveTable.lock(targetSession, 2);
                targetSession.getDatabase().removeSchemaObject(targetSession, recursiveTable);
            } else {
                targetSession.removeLocalTempTable(recursiveTable);
            }
            targetSession.getDatabase().unlockMeta(targetSession);
        }
    }
}

