/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.sql.Connection;
import java.sql.SQLException;
import org.h2.server.ShutdownHandler;
import org.h2.tools.Server;
import org.h2.util.JdbcUtils;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.util.Tool;
import org.h2.util.Utils;

public class Console
extends Tool
implements ShutdownHandler {
    Server web;
    private Server tcp;
    private Server pg;
    boolean isWindows;

    public static void main(String ... args) throws SQLException {
        Console console;
        try {
            console = (Console)Utils.newInstance("org.h2.tools.GUIConsole", new Object[0]);
        }
        catch (Exception | NoClassDefFoundError e) {
            console = new Console();
        }
        console.runTool(args);
    }

    @Override
    public void runTool(String ... args) throws SQLException {
        SQLException startException;
        block44: {
            boolean printStatus;
            boolean pgStart;
            block43: {
                this.isWindows = Utils.getProperty("os.name", "").startsWith("Windows");
                boolean tcpStart = false;
                pgStart = false;
                boolean webStart = false;
                boolean toolStart = false;
                boolean browserStart = false;
                boolean startDefaultServers = true;
                printStatus = args != null && args.length > 0;
                String driver = null;
                String url = null;
                String user = null;
                String password = null;
                boolean tcpShutdown = false;
                boolean tcpShutdownForce = false;
                String tcpPassword = "";
                String tcpShutdownServer = "";
                boolean ifExists = false;
                boolean webAllowOthers = false;
                for (int i = 0; args != null && i < args.length; ++i) {
                    String arg = args[i];
                    if (arg == null) continue;
                    if ("-?".equals(arg) || "-help".equals(arg)) {
                        this.showUsage();
                        return;
                    }
                    if ("-url".equals(arg)) {
                        startDefaultServers = false;
                        url = args[++i];
                        continue;
                    }
                    if ("-driver".equals(arg)) {
                        driver = args[++i];
                        continue;
                    }
                    if ("-user".equals(arg)) {
                        user = args[++i];
                        continue;
                    }
                    if ("-password".equals(arg)) {
                        password = args[++i];
                        continue;
                    }
                    if (arg.startsWith("-web")) {
                        if ("-web".equals(arg)) {
                            startDefaultServers = false;
                            webStart = true;
                            continue;
                        }
                        if ("-webAllowOthers".equals(arg)) {
                            webAllowOthers = true;
                            continue;
                        }
                        if ("-webExternalNames".equals(arg)) {
                            ++i;
                            continue;
                        }
                        if ("-webDaemon".equals(arg) || "-webSSL".equals(arg)) continue;
                        if ("-webPort".equals(arg)) {
                            ++i;
                            continue;
                        }
                        this.showUsageAndThrowUnsupportedOption(arg);
                        continue;
                    }
                    if ("-tool".equals(arg)) {
                        startDefaultServers = false;
                        webStart = true;
                        toolStart = true;
                        continue;
                    }
                    if ("-browser".equals(arg)) {
                        startDefaultServers = false;
                        webStart = true;
                        browserStart = true;
                        continue;
                    }
                    if (arg.startsWith("-tcp")) {
                        if ("-tcp".equals(arg)) {
                            startDefaultServers = false;
                            tcpStart = true;
                            continue;
                        }
                        if ("-tcpAllowOthers".equals(arg) || "-tcpDaemon".equals(arg) || "-tcpSSL".equals(arg)) continue;
                        if ("-tcpPort".equals(arg)) {
                            ++i;
                            continue;
                        }
                        if ("-tcpPassword".equals(arg)) {
                            tcpPassword = args[++i];
                            continue;
                        }
                        if ("-tcpShutdown".equals(arg)) {
                            startDefaultServers = false;
                            tcpShutdown = true;
                            tcpShutdownServer = args[++i];
                            continue;
                        }
                        if ("-tcpShutdownForce".equals(arg)) {
                            tcpShutdownForce = true;
                            continue;
                        }
                        this.showUsageAndThrowUnsupportedOption(arg);
                        continue;
                    }
                    if (arg.startsWith("-pg")) {
                        if ("-pg".equals(arg)) {
                            startDefaultServers = false;
                            pgStart = true;
                            continue;
                        }
                        if ("-pgAllowOthers".equals(arg) || "-pgDaemon".equals(arg)) continue;
                        if ("-pgPort".equals(arg)) {
                            ++i;
                            continue;
                        }
                        this.showUsageAndThrowUnsupportedOption(arg);
                        continue;
                    }
                    if ("-properties".equals(arg)) {
                        ++i;
                        continue;
                    }
                    if ("-trace".equals(arg)) continue;
                    if ("-ifExists".equals(arg)) {
                        ifExists = true;
                        continue;
                    }
                    if ("-baseDir".equals(arg)) {
                        ++i;
                        continue;
                    }
                    this.showUsageAndThrowUnsupportedOption(arg);
                }
                if (startDefaultServers) {
                    webStart = true;
                    toolStart = true;
                    browserStart = true;
                    tcpStart = true;
                    pgStart = true;
                }
                if (tcpShutdown) {
                    this.out.println("Shutting down TCP Server at " + tcpShutdownServer);
                    Server.shutdownTcpServer(tcpShutdownServer, tcpPassword, tcpShutdownForce, false);
                }
                startException = null;
                boolean webRunning = false;
                if (url != null) {
                    Connection conn = JdbcUtils.getConnection(driver, url, user, password);
                    Server.startWebServer(conn);
                }
                if (webStart) {
                    try {
                        String webKey = webAllowOthers ? null : StringUtils.convertBytesToHex(MathUtils.secureRandomBytes(32));
                        this.web = Server.createWebServer(args, webKey, !ifExists);
                        this.web.setShutdownHandler(this);
                        this.web.start();
                        if (printStatus) {
                            this.out.println(this.web.getStatus());
                        }
                        webRunning = true;
                    }
                    catch (SQLException e) {
                        this.printProblem(e, this.web);
                        startException = e;
                    }
                }
                if (toolStart && webRunning) {
                    this.show();
                }
                if (browserStart && this.web != null) {
                    this.openBrowser(this.web.getURL());
                }
                if (tcpStart) {
                    try {
                        this.tcp = Server.createTcpServer(args);
                        this.tcp.start();
                        if (printStatus) {
                            this.out.println(this.tcp.getStatus());
                        }
                        this.tcp.setShutdownHandler(this);
                    }
                    catch (SQLException e) {
                        this.printProblem(e, this.tcp);
                        if (startException != null) break block43;
                        startException = e;
                    }
                }
            }
            if (pgStart) {
                try {
                    this.pg = Server.createPgServer(args);
                    this.pg.start();
                    if (printStatus) {
                        this.out.println(this.pg.getStatus());
                    }
                }
                catch (SQLException e) {
                    this.printProblem(e, this.pg);
                    if (startException != null) break block44;
                    startException = e;
                }
            }
        }
        if (startException != null) {
            this.shutdown();
            throw startException;
        }
    }

    void show() {
    }

    private void printProblem(Exception e, Server server) {
        if (server == null) {
            e.printStackTrace();
        } else {
            this.out.println(server.getStatus());
            this.out.println("Root cause: " + e.getMessage());
        }
    }

    @Override
    public void shutdown() {
        if (this.web != null && this.web.isRunning(false)) {
            this.web.stop();
            this.web = null;
        }
        if (this.tcp != null && this.tcp.isRunning(false)) {
            this.tcp.stop();
            this.tcp = null;
        }
        if (this.pg != null && this.pg.isRunning(false)) {
            this.pg.stop();
            this.pg = null;
        }
    }

    void openBrowser(String url) {
        try {
            Server.openBrowser(url);
        }
        catch (Exception e) {
            this.out.println(e.getMessage());
        }
    }
}

