/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Properties;
import javax.naming.Context;
import javax.sql.DataSource;
import org.h2.api.JavaObjectSerializer;
import org.h2.engine.SysProperties;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbc.JdbcPreparedStatement;
import org.h2.message.DbException;
import org.h2.tools.SimpleResultSet;
import org.h2.util.Bits;
import org.h2.util.JSR310Utils;
import org.h2.util.LegacyDateTimeUtils;
import org.h2.util.NetworkConnectionInfo;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.Value;
import org.h2.value.ValueLob;
import org.h2.value.ValueToObjectConverter;
import org.h2.value.ValueUuid;

public class JdbcUtils {
    public static JavaObjectSerializer serializer;
    private static final String[] DRIVERS;
    private static final byte[] UUID_PREFIX;
    private static boolean allowAllClasses;
    private static HashSet<String> allowedClassNames;
    private static final ArrayList<Utils.ClassFactory> userClassFactories;
    private static String[] allowedClassNamePrefixes;

    private JdbcUtils() {
    }

    public static void addClassFactory(Utils.ClassFactory classFactory) {
        userClassFactories.add(classFactory);
    }

    public static void removeClassFactory(Utils.ClassFactory classFactory) {
        userClassFactories.remove(classFactory);
    }

    public static <Z> Class<Z> loadUserClass(String className) {
        if (allowedClassNames == null) {
            String s = SysProperties.ALLOWED_CLASSES;
            String[] prefixes = new ArrayList();
            int allowAll = 0;
            HashSet<String> classNames = new HashSet<String>();
            for (String p : StringUtils.arraySplit(s, ',', true)) {
                if (p.equals("*")) {
                    allowAll = 1;
                    continue;
                }
                if (p.endsWith("*")) {
                    prefixes.add(p.substring(0, p.length() - 1));
                    continue;
                }
                classNames.add(p);
            }
            allowedClassNamePrefixes = prefixes.toArray(new String[0]);
            allowAllClasses = allowAll;
            allowedClassNames = classNames;
        }
        if (!allowAllClasses && !allowedClassNames.contains(className)) {
            boolean allowed = false;
            for (String s : allowedClassNamePrefixes) {
                if (!className.startsWith(s)) continue;
                allowed = true;
                break;
            }
            if (!allowed) {
                throw DbException.get(90134, className);
            }
        }
        for (Utils.ClassFactory classFactory : userClassFactories) {
            if (!classFactory.match(className)) continue;
            try {
                Class<?> userClass = classFactory.loadClass(className);
                if (userClass == null) continue;
                return userClass;
            }
            catch (Exception e) {
                throw DbException.get(90086, e, className);
            }
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            }
            catch (Exception e2) {
                throw DbException.get(90086, e, className);
            }
        }
        catch (NoClassDefFoundError e) {
            throw DbException.get(90086, e, className);
        }
        catch (Error e) {
            throw DbException.get(50000, e, className);
        }
    }

    public static void closeSilently(Statement stat) {
        if (stat != null) {
            try {
                stat.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void closeSilently(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void closeSilently(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static Connection getConnection(String driver, String url, String user, String password) throws SQLException {
        return JdbcUtils.getConnection(driver, url, user, password, null, false);
    }

    public static Connection getConnection(String driver, String url, String user, String password, NetworkConnectionInfo networkConnectionInfo, boolean forbidCreation) throws SQLException {
        if (url.startsWith("jdbc:h2:")) {
            JdbcConnection connection = new JdbcConnection(url, null, user, password, forbidCreation);
            if (networkConnectionInfo != null) {
                connection.getSession().setNetworkConnectionInfo(networkConnectionInfo);
            }
            return connection;
        }
        if (StringUtils.isNullOrEmpty(driver)) {
            JdbcUtils.load(url);
        } else {
            Class d = JdbcUtils.loadUserClass(driver);
            try {
                if (Driver.class.isAssignableFrom(d)) {
                    Connection connection;
                    Driver driverInstance = (Driver)d.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    Properties prop = new Properties();
                    if (user != null) {
                        prop.setProperty("user", user);
                    }
                    if (password != null) {
                        prop.setProperty("password", password);
                    }
                    if ((connection = driverInstance.connect(url, prop)) != null) {
                        return connection;
                    }
                    throw new SQLException("Driver " + driver + " is not suitable for " + url, "08001");
                }
                if (Context.class.isAssignableFrom(d)) {
                    if (!url.startsWith("java:")) {
                        throw new SQLException("Only java scheme is supported for JNDI lookups", "08001");
                    }
                    Context context = (Context)d.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    DataSource ds = (DataSource)context.lookup(url);
                    if (StringUtils.isNullOrEmpty(user) && StringUtils.isNullOrEmpty(password)) {
                        return ds.getConnection();
                    }
                    return ds.getConnection(user, password);
                }
            }
            catch (Exception e) {
                throw DbException.toSQLException(e);
            }
        }
        return DriverManager.getConnection(url, user, password);
    }

    public static String getDriver(String url) {
        if (url.startsWith("jdbc:")) {
            url = url.substring("jdbc:".length());
            for (int i = 0; i < DRIVERS.length; i += 2) {
                String prefix = DRIVERS[i];
                if (!url.startsWith(prefix)) continue;
                return DRIVERS[i + 1];
            }
        }
        return null;
    }

    public static void load(String url) {
        String driver = JdbcUtils.getDriver(url);
        if (driver != null) {
            JdbcUtils.loadUserClass(driver);
        }
    }

    public static byte[] serialize(Object obj, JavaObjectSerializer javaObjectSerializer) {
        try {
            if (javaObjectSerializer != null) {
                return javaObjectSerializer.serialize(obj);
            }
            if (serializer != null) {
                return serializer.serialize(obj);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(out);
            os.writeObject(obj);
            return out.toByteArray();
        }
        catch (Throwable e) {
            throw DbException.get(90026, e, e.toString());
        }
    }

    public static Object deserialize(byte[] data, JavaObjectSerializer javaObjectSerializer) {
        try {
            ObjectInputStream is;
            if (javaObjectSerializer != null) {
                return javaObjectSerializer.deserialize(data);
            }
            if (serializer != null) {
                return serializer.deserialize(data);
            }
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            if (SysProperties.USE_THREAD_CONTEXT_CLASS_LOADER) {
                final ClassLoader loader = Thread.currentThread().getContextClassLoader();
                is = new ObjectInputStream(in){

                    @Override
                    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                        try {
                            return Class.forName(desc.getName(), true, loader);
                        }
                        catch (ClassNotFoundException e) {
                            return super.resolveClass(desc);
                        }
                    }
                };
            } else {
                is = new ObjectInputStream(in);
            }
            return is.readObject();
        }
        catch (Throwable e) {
            throw DbException.get(90027, e, e.toString());
        }
    }

    public static ValueUuid deserializeUuid(byte[] data) {
        block3: {
            if (data.length == 80) {
                for (int i = 0; i < 64; ++i) {
                    if (data[i] == UUID_PREFIX[i]) {
                        continue;
                    }
                    break block3;
                }
                return ValueUuid.get(Bits.readLong(data, 72), Bits.readLong(data, 64));
            }
        }
        throw DbException.get(90027, "Is not a UUID");
    }

    public static void set(PreparedStatement prep, int parameterIndex, Value value, JdbcConnection conn) throws SQLException {
        if (prep instanceof JdbcPreparedStatement) {
            if (value instanceof ValueLob) {
                JdbcUtils.setLob(prep, parameterIndex, (ValueLob)value);
            } else {
                prep.setObject(parameterIndex, value);
            }
        } else {
            JdbcUtils.setOther(prep, parameterIndex, value, conn);
        }
    }

    private static void setOther(PreparedStatement prep, int parameterIndex, Value value, JdbcConnection conn) throws SQLException {
        int valueType = value.getValueType();
        switch (valueType) {
            case 0: {
                prep.setNull(parameterIndex, 0);
                break;
            }
            case 8: {
                prep.setBoolean(parameterIndex, value.getBoolean());
                break;
            }
            case 9: {
                prep.setByte(parameterIndex, value.getByte());
                break;
            }
            case 10: {
                prep.setShort(parameterIndex, value.getShort());
                break;
            }
            case 11: {
                prep.setInt(parameterIndex, value.getInt());
                break;
            }
            case 12: {
                prep.setLong(parameterIndex, value.getLong());
                break;
            }
            case 13: 
            case 16: {
                prep.setBigDecimal(parameterIndex, value.getBigDecimal());
                break;
            }
            case 15: {
                prep.setDouble(parameterIndex, value.getDouble());
                break;
            }
            case 14: {
                prep.setFloat(parameterIndex, value.getFloat());
                break;
            }
            case 18: {
                try {
                    prep.setObject(parameterIndex, (Object)JSR310Utils.valueToLocalTime(value, null), 92);
                }
                catch (SQLException ignore) {
                    prep.setTime(parameterIndex, LegacyDateTimeUtils.toTime(null, null, value));
                }
                break;
            }
            case 17: {
                try {
                    prep.setObject(parameterIndex, (Object)JSR310Utils.valueToLocalDate(value, null), 91);
                }
                catch (SQLException ignore) {
                    prep.setDate(parameterIndex, LegacyDateTimeUtils.toDate(null, null, value));
                }
                break;
            }
            case 20: {
                try {
                    prep.setObject(parameterIndex, (Object)JSR310Utils.valueToLocalDateTime(value, null), 93);
                }
                catch (SQLException ignore) {
                    prep.setTimestamp(parameterIndex, LegacyDateTimeUtils.toTimestamp(null, null, value));
                }
                break;
            }
            case 5: 
            case 6: 
            case 37: 
            case 38: {
                prep.setBytes(parameterIndex, value.getBytesNoCopy());
                break;
            }
            case 2: 
            case 4: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: {
                prep.setString(parameterIndex, value.getString());
                break;
            }
            case 3: 
            case 7: {
                JdbcUtils.setLob(prep, parameterIndex, (ValueLob)value);
                break;
            }
            case 40: {
                prep.setArray(parameterIndex, prep.getConnection().createArrayOf("NULL", (Object[])ValueToObjectConverter.valueToDefaultObject(value, conn, true)));
                break;
            }
            case 35: {
                prep.setObject(parameterIndex, JdbcUtils.deserialize(value.getBytesNoCopy(), conn.getJavaObjectSerializer()), 2000);
                break;
            }
            case 39: {
                prep.setBytes(parameterIndex, value.getBytes());
                break;
            }
            case 1: {
                try {
                    prep.setObject(parameterIndex, (Object)value.getString(), 1);
                }
                catch (SQLException ignore) {
                    prep.setString(parameterIndex, value.getString());
                }
                break;
            }
            case 21: {
                try {
                    prep.setObject(parameterIndex, (Object)JSR310Utils.valueToOffsetDateTime(value, null), 2014);
                    return;
                }
                catch (SQLException ignore) {
                    prep.setString(parameterIndex, value.getString());
                    break;
                }
            }
            case 19: {
                try {
                    prep.setObject(parameterIndex, (Object)JSR310Utils.valueToOffsetTime(value, null), 2013);
                    return;
                }
                catch (SQLException ignore) {
                    prep.setString(parameterIndex, value.getString());
                    break;
                }
            }
            default: {
                throw DbException.getUnsupportedException(Value.getTypeName(valueType));
            }
        }
    }

    private static void setLob(PreparedStatement prep, int parameterIndex, ValueLob value) throws SQLException {
        if (value.getValueType() == 7) {
            long p = value.octetLength();
            prep.setBinaryStream(parameterIndex, value.getInputStream(), p > Integer.MAX_VALUE ? -1 : (int)p);
        } else {
            long p = value.charLength();
            prep.setCharacterStream(parameterIndex, value.getReader(), p > Integer.MAX_VALUE ? -1 : (int)p);
        }
    }

    public static ResultSet getMetaResultSet(Connection conn, String sql) throws SQLException {
        DatabaseMetaData meta = conn.getMetaData();
        if (JdbcUtils.isBuiltIn(sql, "@best_row_identifier")) {
            String[] p = JdbcUtils.split(sql);
            int scale = p[4] == null ? 0 : Integer.parseInt(p[4]);
            boolean nullable = Boolean.parseBoolean(p[5]);
            return meta.getBestRowIdentifier(p[1], p[2], p[3], scale, nullable);
        }
        if (JdbcUtils.isBuiltIn(sql, "@catalogs")) {
            return meta.getCatalogs();
        }
        if (JdbcUtils.isBuiltIn(sql, "@columns")) {
            String[] p = JdbcUtils.split(sql);
            return meta.getColumns(p[1], p[2], p[3], p[4]);
        }
        if (JdbcUtils.isBuiltIn(sql, "@column_privileges")) {
            String[] p = JdbcUtils.split(sql);
            return meta.getColumnPrivileges(p[1], p[2], p[3], p[4]);
        }
        if (JdbcUtils.isBuiltIn(sql, "@cross_references")) {
            String[] p = JdbcUtils.split(sql);
            return meta.getCrossReference(p[1], p[2], p[3], p[4], p[5], p[6]);
        }
        if (JdbcUtils.isBuiltIn(sql, "@exported_keys")) {
            String[] p = JdbcUtils.split(sql);
            return meta.getExportedKeys(p[1], p[2], p[3]);
        }
        if (JdbcUtils.isBuiltIn(sql, "@imported_keys")) {
            String[] p = JdbcUtils.split(sql);
            return meta.getImportedKeys(p[1], p[2], p[3]);
        }
        if (JdbcUtils.isBuiltIn(sql, "@index_info")) {
            String[] p = JdbcUtils.split(sql);
            boolean unique = Boolean.parseBoolean(p[4]);
            boolean approx = Boolean.parseBoolean(p[5]);
            return meta.getIndexInfo(p[1], p[2], p[3], unique, approx);
        }
        if (JdbcUtils.isBuiltIn(sql, "@primary_keys")) {
            String[] p = JdbcUtils.split(sql);
            return meta.getPrimaryKeys(p[1], p[2], p[3]);
        }
        if (JdbcUtils.isBuiltIn(sql, "@procedures")) {
            String[] p = JdbcUtils.split(sql);
            return meta.getProcedures(p[1], p[2], p[3]);
        }
        if (JdbcUtils.isBuiltIn(sql, "@procedure_columns")) {
            String[] p = JdbcUtils.split(sql);
            return meta.getProcedureColumns(p[1], p[2], p[3], p[4]);
        }
        if (JdbcUtils.isBuiltIn(sql, "@schemas")) {
            return meta.getSchemas();
        }
        if (JdbcUtils.isBuiltIn(sql, "@tables")) {
            String[] p = JdbcUtils.split(sql);
            String[] types = p[4] == null ? null : StringUtils.arraySplit(p[4], ',', false);
            return meta.getTables(p[1], p[2], p[3], types);
        }
        if (JdbcUtils.isBuiltIn(sql, "@table_privileges")) {
            String[] p = JdbcUtils.split(sql);
            return meta.getTablePrivileges(p[1], p[2], p[3]);
        }
        if (JdbcUtils.isBuiltIn(sql, "@table_types")) {
            return meta.getTableTypes();
        }
        if (JdbcUtils.isBuiltIn(sql, "@type_info")) {
            return meta.getTypeInfo();
        }
        if (JdbcUtils.isBuiltIn(sql, "@udts")) {
            int[] types;
            String[] p = JdbcUtils.split(sql);
            if (p[4] == null) {
                types = null;
            } else {
                String[] t = StringUtils.arraySplit(p[4], ',', false);
                types = new int[t.length];
                for (int i = 0; i < t.length; ++i) {
                    types[i] = Integer.parseInt(t[i]);
                }
            }
            return meta.getUDTs(p[1], p[2], p[3], types);
        }
        if (JdbcUtils.isBuiltIn(sql, "@version_columns")) {
            String[] p = JdbcUtils.split(sql);
            return meta.getVersionColumns(p[1], p[2], p[3]);
        }
        if (JdbcUtils.isBuiltIn(sql, "@memory")) {
            SimpleResultSet rs = new SimpleResultSet();
            rs.addColumn("Type", 12, 0, 0);
            rs.addColumn("KB", 12, 0, 0);
            rs.addRow("Used Memory", Long.toString(Utils.getMemoryUsed()));
            rs.addRow("Free Memory", Long.toString(Utils.getMemoryFree()));
            return rs;
        }
        if (JdbcUtils.isBuiltIn(sql, "@info")) {
            String map;
            SimpleResultSet rs = new SimpleResultSet();
            rs.addColumn("KEY", 12, 0, 0);
            rs.addColumn("VALUE", 12, 0, 0);
            rs.addRow("conn.getCatalog", conn.getCatalog());
            rs.addRow("conn.getAutoCommit", Boolean.toString(conn.getAutoCommit()));
            rs.addRow("conn.getTransactionIsolation", Integer.toString(conn.getTransactionIsolation()));
            rs.addRow("conn.getWarnings", String.valueOf(conn.getWarnings()));
            try {
                map = String.valueOf(conn.getTypeMap());
            }
            catch (SQLException e) {
                map = e.toString();
            }
            rs.addRow("conn.getTypeMap", map);
            rs.addRow("conn.isReadOnly", Boolean.toString(conn.isReadOnly()));
            rs.addRow("conn.getHoldability", Integer.toString(conn.getHoldability()));
            JdbcUtils.addDatabaseMetaData(rs, meta);
            return rs;
        }
        if (JdbcUtils.isBuiltIn(sql, "@attributes")) {
            String[] p = JdbcUtils.split(sql);
            return meta.getAttributes(p[1], p[2], p[3], p[4]);
        }
        if (JdbcUtils.isBuiltIn(sql, "@super_tables")) {
            String[] p = JdbcUtils.split(sql);
            return meta.getSuperTables(p[1], p[2], p[3]);
        }
        if (JdbcUtils.isBuiltIn(sql, "@super_types")) {
            String[] p = JdbcUtils.split(sql);
            return meta.getSuperTypes(p[1], p[2], p[3]);
        }
        if (JdbcUtils.isBuiltIn(sql, "@pseudo_columns")) {
            String[] p = JdbcUtils.split(sql);
            return meta.getPseudoColumns(p[1], p[2], p[3], p[4]);
        }
        return null;
    }

    private static void addDatabaseMetaData(SimpleResultSet rs, DatabaseMetaData meta) {
        Method[] methods = DatabaseMetaData.class.getDeclaredMethods();
        Arrays.sort(methods, Comparator.comparing(Method::toString));
        for (Method m : methods) {
            if (m.getParameterTypes().length != 0) continue;
            try {
                Object o = m.invoke((Object)meta, new Object[0]);
                rs.addRow("meta." + m.getName(), String.valueOf(o));
            }
            catch (InvocationTargetException e) {
                rs.addRow("meta." + m.getName(), e.getTargetException().toString());
            }
            catch (Exception e) {
                rs.addRow("meta." + m.getName(), e.toString());
            }
        }
    }

    public static boolean isBuiltIn(String sql, String builtIn) {
        return sql.regionMatches(true, 0, builtIn, 0, builtIn.length());
    }

    public static String[] split(String s) {
        String[] t = StringUtils.arraySplit(s, ' ', true);
        String[] list = new String[Math.max(10, t.length)];
        System.arraycopy(t, 0, list, 0, t.length);
        for (int i = 0; i < list.length; ++i) {
            if (!"null".equals(list[i])) continue;
            list[i] = null;
        }
        return list;
    }

    static {
        DRIVERS = new String[]{"h2:", "org.h2.Driver", "Cache:", "com.intersys.jdbc.CacheDriver", "daffodilDB://", "in.co.daffodil.db.rmi.RmiDaffodilDBDriver", "daffodil", "in.co.daffodil.db.jdbc.DaffodilDBDriver", "db2:", "com.ibm.db2.jcc.DB2Driver", "derby:net:", "org.apache.derby.client.ClientAutoloadedDriver", "derby://", "org.apache.derby.client.ClientAutoloadedDriver", "derby:", "org.apache.derby.iapi.jdbc.AutoloadedDriver", "FrontBase:", "com.frontbase.jdbc.FBJDriver", "firebirdsql:", "org.firebirdsql.jdbc.FBDriver", "hsqldb:", "org.hsqldb.jdbcDriver", "informix-sqli:", "com.informix.jdbc.IfxDriver", "jtds:", "net.sourceforge.jtds.jdbc.Driver", "microsoft:", "com.microsoft.jdbc.sqlserver.SQLServerDriver", "mimer:", "com.mimer.jdbc.Driver", "mysql:", "com.mysql.cj.jdbc.Driver", "mariadb:", "org.mariadb.jdbc.Driver", "odbc:", "sun.jdbc.odbc.JdbcOdbcDriver", "oracle:", "oracle.jdbc.driver.OracleDriver", "pervasive:", "com.pervasive.jdbc.v2.Driver", "pointbase:micro:", "com.pointbase.me.jdbc.jdbcDriver", "pointbase:", "com.pointbase.jdbc.jdbcUniversalDriver", "postgresql:", "org.postgresql.Driver", "sybase:", "com.sybase.jdbc3.jdbc.SybDriver", "sqlserver:", "com.microsoft.sqlserver.jdbc.SQLServerDriver", "teradata:", "com.ncr.teradata.TeraDriver"};
        UUID_PREFIX = "\u00ac\u00ed\u0000\u0005sr\u0000\u000ejava.util.UUID\u00bc\u0099\u0003\u00f7\u0098m\u0085/\u0002\u0000\u0002J\u0000\fleastSigBitsJ\u0000\u000bmostSigBitsxp".getBytes(StandardCharsets.ISO_8859_1);
        userClassFactories = new ArrayList();
        String clazz = SysProperties.JAVA_OBJECT_SERIALIZER;
        if (clazz != null) {
            try {
                serializer = (JavaObjectSerializer)JdbcUtils.loadUserClass(clazz).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw DbException.convert(e);
            }
        }
    }
}

