/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.util.HashMap;
import org.h2.util.StringUtils;

public class ParserUtil {
    public static final int KEYWORD = 1;
    public static final int IDENTIFIER = 2;
    public static final int ALL = 3;
    public static final int AND = 4;
    public static final int ANY = 5;
    public static final int ARRAY = 6;
    public static final int AS = 7;
    public static final int ASYMMETRIC = 8;
    public static final int AUTHORIZATION = 9;
    public static final int BETWEEN = 10;
    public static final int CASE = 11;
    public static final int CAST = 12;
    public static final int CHECK = 13;
    public static final int CONSTRAINT = 14;
    public static final int CROSS = 15;
    public static final int CURRENT_CATALOG = 16;
    public static final int CURRENT_DATE = 17;
    public static final int CURRENT_PATH = 18;
    public static final int CURRENT_ROLE = 19;
    public static final int CURRENT_SCHEMA = 20;
    public static final int CURRENT_TIME = 21;
    public static final int CURRENT_TIMESTAMP = 22;
    public static final int CURRENT_USER = 23;
    public static final int DAY = 24;
    public static final int DEFAULT = 25;
    public static final int DISTINCT = 26;
    public static final int ELSE = 27;
    public static final int END = 28;
    public static final int EXCEPT = 29;
    public static final int EXISTS = 30;
    public static final int FALSE = 31;
    public static final int FETCH = 32;
    public static final int FOR = 33;
    public static final int FOREIGN = 34;
    public static final int FROM = 35;
    public static final int FULL = 36;
    public static final int GROUP = 37;
    public static final int HAVING = 38;
    public static final int HOUR = 39;
    public static final int IF = 40;
    public static final int IN = 41;
    public static final int INNER = 42;
    public static final int INTERSECT = 43;
    public static final int INTERVAL = 44;
    public static final int IS = 45;
    public static final int JOIN = 46;
    public static final int KEY = 47;
    public static final int LEFT = 48;
    public static final int LIKE = 49;
    public static final int LIMIT = 50;
    public static final int LOCALTIME = 51;
    public static final int LOCALTIMESTAMP = 52;
    public static final int MINUS = 53;
    public static final int MINUTE = 54;
    public static final int MONTH = 55;
    public static final int NATURAL = 56;
    public static final int NOT = 57;
    public static final int NULL = 58;
    public static final int OFFSET = 59;
    public static final int ON = 60;
    public static final int OR = 61;
    public static final int ORDER = 62;
    public static final int PRIMARY = 63;
    public static final int QUALIFY = 64;
    public static final int RIGHT = 65;
    public static final int ROW = 66;
    public static final int ROWNUM = 67;
    public static final int SECOND = 68;
    public static final int SELECT = 69;
    public static final int SESSION_USER = 70;
    public static final int SET = 71;
    public static final int SOME = 72;
    public static final int SYMMETRIC = 73;
    public static final int SYSTEM_USER = 74;
    public static final int TABLE = 75;
    public static final int TO = 76;
    public static final int TRUE = 77;
    public static final int UESCAPE = 78;
    public static final int UNION = 79;
    public static final int UNIQUE = 80;
    public static final int UNKNOWN = 81;
    public static final int USER = 82;
    public static final int USING = 83;
    public static final int VALUE = 84;
    public static final int VALUES = 85;
    public static final int WHEN = 86;
    public static final int WHERE = 87;
    public static final int WINDOW = 88;
    public static final int WITH = 89;
    public static final int YEAR = 90;
    public static final int _ROWID_ = 91;
    public static final int FIRST_KEYWORD = 3;
    public static final int LAST_KEYWORD = 91;
    private static final HashMap<String, Integer> KEYWORDS;

    private ParserUtil() {
    }

    public static StringBuilder quoteIdentifier(StringBuilder builder, String s, int sqlFlags) {
        if (s == null) {
            return builder.append("\"\"");
        }
        if ((sqlFlags & 1) != 0 && ParserUtil.isSimpleIdentifier(s, false, false)) {
            return builder.append(s);
        }
        return StringUtils.quoteIdentifier(builder, s);
    }

    public static boolean isKeyword(String s, boolean ignoreCase) {
        return ParserUtil.getTokenType(s, ignoreCase, false) != 2;
    }

    public static boolean isSimpleIdentifier(String s, boolean databaseToUpper, boolean databaseToLower) {
        if (databaseToUpper && databaseToLower) {
            throw new IllegalArgumentException("databaseToUpper && databaseToLower");
        }
        int length = s.length();
        if (length == 0 || !ParserUtil.checkLetter(databaseToUpper, databaseToLower, s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < length; ++i) {
            char c = s.charAt(i);
            if (c == '_' || c >= '0' && c <= '9' || ParserUtil.checkLetter(databaseToUpper, databaseToLower, c)) continue;
            return false;
        }
        return ParserUtil.getTokenType(s, !databaseToUpper, true) == 2;
    }

    private static boolean checkLetter(boolean databaseToUpper, boolean databaseToLower, char c) {
        return !(databaseToUpper ? c < 'A' || c > 'Z' : (databaseToLower ? c < 'a' || c > 'z' : !(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')));
    }

    public static int getTokenType(String s, boolean ignoreCase, boolean additionalKeywords) {
        Integer type;
        int length = s.length();
        if (length <= 1 || length > 17) {
            return 2;
        }
        if (ignoreCase) {
            s = StringUtils.toUpperEnglish(s);
        }
        if ((type = KEYWORDS.get(s)) == null) {
            return 2;
        }
        int t = type;
        return t == 1 && !additionalKeywords ? 2 : t;
    }

    static {
        HashMap<String, Integer> map = new HashMap<String, Integer>(256);
        map.put("ALL", 3);
        map.put("AND", 4);
        map.put("ANY", 5);
        map.put("ARRAY", 6);
        map.put("AS", 7);
        map.put("ASYMMETRIC", 8);
        map.put("AUTHORIZATION", 9);
        map.put("BETWEEN", 10);
        map.put("CASE", 11);
        map.put("CAST", 12);
        map.put("CHECK", 13);
        map.put("CONSTRAINT", 14);
        map.put("CROSS", 15);
        map.put("CURRENT_CATALOG", 16);
        map.put("CURRENT_DATE", 17);
        map.put("CURRENT_PATH", 18);
        map.put("CURRENT_ROLE", 19);
        map.put("CURRENT_SCHEMA", 20);
        map.put("CURRENT_TIME", 21);
        map.put("CURRENT_TIMESTAMP", 22);
        map.put("CURRENT_USER", 23);
        map.put("DAY", 24);
        map.put("DEFAULT", 25);
        map.put("DISTINCT", 26);
        map.put("ELSE", 27);
        map.put("END", 28);
        map.put("EXCEPT", 29);
        map.put("EXISTS", 30);
        map.put("FALSE", 31);
        map.put("FETCH", 32);
        map.put("FOR", 33);
        map.put("FOREIGN", 34);
        map.put("FROM", 35);
        map.put("FULL", 36);
        map.put("GROUP", 37);
        map.put("HAVING", 38);
        map.put("HOUR", 39);
        map.put("IF", 40);
        map.put("IN", 41);
        map.put("INNER", 42);
        map.put("INTERSECT", 43);
        map.put("INTERVAL", 44);
        map.put("IS", 45);
        map.put("JOIN", 46);
        map.put("KEY", 47);
        map.put("LEFT", 48);
        map.put("LIKE", 49);
        map.put("LIMIT", 50);
        map.put("LOCALTIME", 51);
        map.put("LOCALTIMESTAMP", 52);
        map.put("MINUS", 53);
        map.put("MINUTE", 54);
        map.put("MONTH", 55);
        map.put("NATURAL", 56);
        map.put("NOT", 57);
        map.put("NULL", 58);
        map.put("OFFSET", 59);
        map.put("ON", 60);
        map.put("OR", 61);
        map.put("ORDER", 62);
        map.put("PRIMARY", 63);
        map.put("QUALIFY", 64);
        map.put("RIGHT", 65);
        map.put("ROW", 66);
        map.put("ROWNUM", 67);
        map.put("SECOND", 68);
        map.put("SELECT", 69);
        map.put("SESSION_USER", 70);
        map.put("SET", 71);
        map.put("SOME", 72);
        map.put("SYMMETRIC", 73);
        map.put("SYSTEM_USER", 74);
        map.put("TABLE", 75);
        map.put("TO", 76);
        map.put("TRUE", 77);
        map.put("UESCAPE", 78);
        map.put("UNION", 79);
        map.put("UNIQUE", 80);
        map.put("UNKNOWN", 81);
        map.put("USER", 82);
        map.put("USING", 83);
        map.put("VALUE", 84);
        map.put("VALUES", 85);
        map.put("WHEN", 86);
        map.put("WHERE", 87);
        map.put("WINDOW", 88);
        map.put("WITH", 89);
        map.put("YEAR", 90);
        map.put("_ROWID_", 91);
        map.put("BOTH", 1);
        map.put("GROUPS", 1);
        map.put("ILIKE", 1);
        map.put("LEADING", 1);
        map.put("OVER", 1);
        map.put("PARTITION", 1);
        map.put("RANGE", 1);
        map.put("REGEXP", 1);
        map.put("ROWS", 1);
        map.put("TOP", 1);
        map.put("TRAILING", 1);
        KEYWORDS = map;
    }
}

