/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SoftValuesHashMap<K, V>
extends AbstractMap<K, V> {
    private final Map<K, SoftValue<V>> map;
    private final ReferenceQueue<V> queue = new ReferenceQueue();

    public SoftValuesHashMap() {
        this.map = new HashMap<K, SoftValue<V>>();
    }

    private void processQueue() {
        Reference<V> o;
        while ((o = this.queue.poll()) != null) {
            SoftValue k = (SoftValue)o;
            Object key = k.key;
            this.map.remove(key);
        }
        return;
    }

    @Override
    public V get(Object key) {
        this.processQueue();
        SoftReference o = this.map.get(key);
        if (o == null) {
            return null;
        }
        return (V)o.get();
    }

    @Override
    public V put(K key, V value) {
        this.processQueue();
        SoftValue<V> old = this.map.put(key, new SoftValue<V>(value, this.queue, key));
        return old == null ? null : (V)old.get();
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        SoftReference ref = this.map.remove(key);
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public void clear() {
        this.processQueue();
        this.map.clear();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    private static class SoftValue<T>
    extends SoftReference<T> {
        final Object key;

        public SoftValue(T ref, ReferenceQueue<T> q, Object key) {
            super(ref, q);
            this.key = key;
        }
    }
}

