/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util.geometry;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import org.h2.util.StringUtils;
import org.h2.util.geometry.EWKBUtils;
import org.h2.util.geometry.GeometryUtils;

public final class EWKTUtils {
    static final String[] TYPES = new String[]{"POINT", "LINESTRING", "POLYGON", "MULTIPOINT", "MULTILINESTRING", "MULTIPOLYGON", "GEOMETRYCOLLECTION"};
    private static final String[] DIMENSION_SYSTEMS = new String[]{"XY", "Z", "M", "ZM"};

    public static String ewkb2ewkt(byte[] ewkb) {
        return EWKTUtils.ewkb2ewkt(ewkb, EWKBUtils.getDimensionSystem(ewkb));
    }

    public static String ewkb2ewkt(byte[] ewkb, int dimensionSystem) {
        StringBuilder output = new StringBuilder();
        EWKBUtils.parseEWKB(ewkb, new EWKTTarget(output, dimensionSystem));
        return output.toString();
    }

    public static byte[] ewkt2ewkb(String ewkt) {
        return EWKTUtils.ewkt2ewkb(ewkt, EWKTUtils.getDimensionSystem(ewkt));
    }

    public static byte[] ewkt2ewkb(String ewkt, int dimensionSystem) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        EWKBUtils.EWKBTarget target = new EWKBUtils.EWKBTarget(output, dimensionSystem);
        EWKTUtils.parseEWKT(ewkt, target);
        return output.toByteArray();
    }

    public static void parseEWKT(String ewkt, GeometryUtils.Target target) {
        EWKTUtils.parseEWKT(new EWKTSource(ewkt), target, 0, 0);
    }

    public static int parseGeometryType(String s) {
        EWKTSource source = new EWKTSource(s);
        int type = source.readType();
        int dimensionSystem = 0;
        if (source.hasData()) {
            dimensionSystem = source.readDimensionSystem();
            if (source.hasData()) {
                throw new IllegalArgumentException();
            }
        }
        return dimensionSystem * 1000 + type;
    }

    public static int parseDimensionSystem(String s) {
        EWKTSource source = new EWKTSource(s);
        int dimensionSystem = source.readDimensionSystem();
        if (source.hasData() || dimensionSystem == 0) {
            throw new IllegalArgumentException();
        }
        return dimensionSystem;
    }

    public static StringBuilder formatGeometryTypeAndDimensionSystem(StringBuilder builder, int type) {
        int t = type % 1000;
        int d = type / 1000;
        if (t < 1 || t > 7 || d < 0 || d > 3) {
            throw new IllegalArgumentException();
        }
        builder.append(TYPES[t - 1]);
        if (d != 0) {
            builder.append(' ').append(DIMENSION_SYSTEMS[d]);
        }
        return builder;
    }

    private static void parseEWKT(EWKTSource source, GeometryUtils.Target target, int parentType, int dimensionSystem) {
        int type;
        if (parentType == 0) {
            target.init(source.readSRID());
        }
        switch (parentType) {
            default: {
                type = source.readType();
                dimensionSystem = source.readDimensionSystem();
                break;
            }
            case 4: {
                type = 1;
                break;
            }
            case 5: {
                type = 2;
                break;
            }
            case 6: {
                type = 3;
            }
        }
        target.dimensionSystem(dimensionSystem);
        switch (type) {
            case 1: {
                if (parentType != 0 && parentType != 4 && parentType != 7) {
                    throw new IllegalArgumentException();
                }
                boolean empty = source.readEmpty();
                target.startPoint();
                if (empty) {
                    target.addCoordinate(Double.NaN, Double.NaN, Double.NaN, Double.NaN, 0, 1);
                    break;
                }
                EWKTUtils.addCoordinate(source, target, dimensionSystem, 0, 1);
                source.read(')');
                break;
            }
            case 2: {
                if (parentType != 0 && parentType != 5 && parentType != 7) {
                    throw new IllegalArgumentException();
                }
                boolean empty = source.readEmpty();
                if (empty) {
                    target.startLineString(0);
                    break;
                }
                ArrayList<double[]> coordinates = new ArrayList<double[]>();
                do {
                    coordinates.add(EWKTUtils.readCoordinate(source, dimensionSystem));
                } while (source.hasMoreCoordinates());
                int numPoints = coordinates.size();
                if (numPoints < 0 || numPoints == 1) {
                    throw new IllegalArgumentException();
                }
                target.startLineString(numPoints);
                for (int i = 0; i < numPoints; ++i) {
                    double[] c = (double[])coordinates.get(i);
                    target.addCoordinate(c[0], c[1], c[2], c[3], i, numPoints);
                }
                break;
            }
            case 3: {
                if (parentType != 0 && parentType != 6 && parentType != 7) {
                    throw new IllegalArgumentException();
                }
                boolean empty = source.readEmpty();
                if (empty) {
                    target.startPolygon(0, 0);
                    break;
                }
                ArrayList<double[]> outer = EWKTUtils.readRing(source, dimensionSystem);
                ArrayList<ArrayList<double[]>> inner = new ArrayList<ArrayList<double[]>>();
                while (source.hasMoreCoordinates()) {
                    inner.add(EWKTUtils.readRing(source, dimensionSystem));
                }
                int numInner = inner.size();
                int size = outer.size();
                if (size >= 1 && size <= 3) {
                    throw new IllegalArgumentException();
                }
                if (size == 0 && numInner > 0) {
                    throw new IllegalArgumentException();
                }
                target.startPolygon(numInner, size);
                if (size <= 0) break;
                EWKTUtils.addRing(outer, target);
                for (int i = 0; i < numInner; ++i) {
                    ArrayList ring = (ArrayList)inner.get(i);
                    size = ring.size();
                    if (size >= 1 && size <= 3) {
                        throw new IllegalArgumentException();
                    }
                    target.startPolygonInner(size);
                    EWKTUtils.addRing(ring, target);
                }
                target.endNonEmptyPolygon();
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                EWKTUtils.parseCollection(source, target, type, parentType, dimensionSystem);
                break;
            }
            case 7: {
                EWKTUtils.parseCollection(source, target, 7, parentType, 0);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        target.endObject(type);
        if (parentType == 0 && source.hasData()) {
            throw new IllegalArgumentException();
        }
    }

    private static void parseCollection(EWKTSource source, GeometryUtils.Target target, int type, int parentType, int dimensionSystem) {
        if (parentType != 0 && parentType != 7) {
            throw new IllegalArgumentException();
        }
        if (source.readEmpty()) {
            target.startCollection(type, 0);
        } else if (type == 4 && source.hasCoordinate()) {
            EWKTUtils.parseMultiPointAlternative(source, target, dimensionSystem);
        } else {
            int numItems = source.getItemCount();
            target.startCollection(type, numItems);
            for (int i = 0; i < numItems; ++i) {
                if (i > 0) {
                    source.read(',');
                }
                GeometryUtils.Target innerTarget = target.startCollectionItem(i, numItems);
                EWKTUtils.parseEWKT(source, innerTarget, type, dimensionSystem);
                target.endCollectionItem(innerTarget, type, i, numItems);
            }
            source.read(')');
        }
    }

    private static void parseMultiPointAlternative(EWKTSource source, GeometryUtils.Target target, int dimensionSystem) {
        ArrayList<double[]> points = new ArrayList<double[]>();
        do {
            points.add(EWKTUtils.readCoordinate(source, dimensionSystem));
        } while (source.hasMoreCoordinates());
        int numItems = points.size();
        target.startCollection(4, numItems);
        for (int i = 0; i < points.size(); ++i) {
            GeometryUtils.Target innerTarget = target.startCollectionItem(i, numItems);
            target.startPoint();
            double[] c = (double[])points.get(i);
            target.addCoordinate(c[0], c[1], c[2], c[3], 0, 1);
            target.endCollectionItem(innerTarget, 4, i, numItems);
        }
    }

    private static ArrayList<double[]> readRing(EWKTSource source, int dimensionSystem) {
        if (source.readEmpty()) {
            return new ArrayList<double[]>(0);
        }
        ArrayList<double[]> result = new ArrayList<double[]>();
        double[] c = EWKTUtils.readCoordinate(source, dimensionSystem);
        double startX = c[0];
        double startY = c[1];
        result.add(c);
        while (source.hasMoreCoordinates()) {
            result.add(EWKTUtils.readCoordinate(source, dimensionSystem));
        }
        int size = result.size();
        if (size < 4) {
            throw new IllegalArgumentException();
        }
        c = (double[])result.get(size - 1);
        double endX = c[0];
        double endY = c[1];
        if (startX != endX || startY != endY) {
            throw new IllegalArgumentException();
        }
        return result;
    }

    private static void addRing(ArrayList<double[]> ring, GeometryUtils.Target target) {
        int size = ring.size();
        for (int i = 0; i < size; ++i) {
            double[] coordinates = ring.get(i);
            target.addCoordinate(coordinates[0], coordinates[1], coordinates[2], coordinates[3], i, size);
        }
    }

    private static void addCoordinate(EWKTSource source, GeometryUtils.Target target, int dimensionSystem, int index, int total) {
        double x = source.readCoordinate();
        double y = source.readCoordinate();
        double z = (dimensionSystem & 1) != 0 ? source.readCoordinate() : Double.NaN;
        double m = (dimensionSystem & 2) != 0 ? source.readCoordinate() : Double.NaN;
        target.addCoordinate(x, y, z, m, index, total);
    }

    private static double[] readCoordinate(EWKTSource source, int dimensionSystem) {
        double x = source.readCoordinate();
        double y = source.readCoordinate();
        double z = (dimensionSystem & 1) != 0 ? source.readCoordinate() : Double.NaN;
        double m = (dimensionSystem & 2) != 0 ? source.readCoordinate() : Double.NaN;
        return new double[]{x, y, z, m};
    }

    public static int getDimensionSystem(String ewkt) {
        EWKTSource source = new EWKTSource(ewkt);
        source.readSRID();
        source.readType();
        return source.readDimensionSystem();
    }

    private EWKTUtils() {
    }

    private static final class EWKTSource {
        private final String ewkt;
        private int offset;

        EWKTSource(String ewkt) {
            this.ewkt = ewkt;
        }

        int readSRID() {
            int srid;
            this.skipWS();
            if (this.ewkt.regionMatches(true, this.offset, "SRID=", 0, 5)) {
                this.offset += 5;
                int idx = this.ewkt.indexOf(59, 5);
                if (idx < 0) {
                    throw new IllegalArgumentException();
                }
                int end = idx;
                while (this.ewkt.charAt(end - 1) <= ' ') {
                    --end;
                }
                srid = Integer.parseInt(StringUtils.trimSubstring(this.ewkt, this.offset, end));
                this.offset = idx + 1;
            } else {
                srid = 0;
            }
            return srid;
        }

        void read(char symbol) {
            this.skipWS();
            int len = this.ewkt.length();
            if (this.offset >= len) {
                throw new IllegalArgumentException();
            }
            if (this.ewkt.charAt(this.offset) != symbol) {
                throw new IllegalArgumentException();
            }
            ++this.offset;
        }

        int readType() {
            this.skipWS();
            int len = this.ewkt.length();
            if (this.offset >= len) {
                throw new IllegalArgumentException();
            }
            int result = 0;
            char ch = this.ewkt.charAt(this.offset);
            switch (ch) {
                case 'P': 
                case 'p': {
                    result = this.match("POINT", 1);
                    if (result != 0) break;
                    result = this.match("POLYGON", 3);
                    break;
                }
                case 'L': 
                case 'l': {
                    result = this.match("LINESTRING", 2);
                    break;
                }
                case 'M': 
                case 'm': {
                    if (this.match("MULTI", 1) == 0 || (result = this.match("POINT", 4)) != 0 || (result = this.match("POLYGON", 6)) != 0) break;
                    result = this.match("LINESTRING", 5);
                    break;
                }
                case 'G': 
                case 'g': {
                    result = this.match("GEOMETRYCOLLECTION", 7);
                }
            }
            if (result == 0) {
                throw new IllegalArgumentException();
            }
            return result;
        }

        int readDimensionSystem() {
            int result;
            int o = this.offset;
            this.skipWS();
            int len = this.ewkt.length();
            if (this.offset >= len) {
                throw new IllegalArgumentException();
            }
            char ch = this.ewkt.charAt(this.offset);
            switch (ch) {
                case 'M': 
                case 'm': {
                    result = 2;
                    ++this.offset;
                    break;
                }
                case 'Z': 
                case 'z': {
                    ++this.offset;
                    if (this.offset >= len) {
                        result = 1;
                        break;
                    }
                    ch = this.ewkt.charAt(this.offset);
                    if (ch == 'M' || ch == 'm') {
                        ++this.offset;
                        result = 3;
                        break;
                    }
                    result = 1;
                    break;
                }
                default: {
                    result = 0;
                    if (o == this.offset) break;
                    return result;
                }
            }
            this.checkStringEnd(len);
            return result;
        }

        boolean readEmpty() {
            this.skipWS();
            int len = this.ewkt.length();
            if (this.offset >= len) {
                throw new IllegalArgumentException();
            }
            if (this.ewkt.charAt(this.offset) == '(') {
                ++this.offset;
                return false;
            }
            if (this.match("EMPTY", 1) != 0) {
                this.checkStringEnd(len);
                return true;
            }
            throw new IllegalArgumentException();
        }

        private int match(String token, int code) {
            int l = token.length();
            if (this.offset <= this.ewkt.length() - l && this.ewkt.regionMatches(true, this.offset, token, 0, l)) {
                this.offset += l;
            } else {
                code = 0;
            }
            return code;
        }

        private void checkStringEnd(int len) {
            char ch;
            if (this.offset < len && (ch = this.ewkt.charAt(this.offset)) > ' ' && ch != '(' && ch != ')' && ch != ',') {
                throw new IllegalArgumentException();
            }
        }

        public boolean hasCoordinate() {
            this.skipWS();
            if (this.offset >= this.ewkt.length()) {
                return false;
            }
            return EWKTSource.isNumberStart(this.ewkt.charAt(this.offset));
        }

        public double readCoordinate() {
            this.skipWS();
            int len = this.ewkt.length();
            if (this.offset >= len) {
                throw new IllegalArgumentException();
            }
            char ch = this.ewkt.charAt(this.offset);
            if (!EWKTSource.isNumberStart(ch)) {
                throw new IllegalArgumentException();
            }
            int start = this.offset++;
            while (this.offset < len && EWKTSource.isNumberPart(ch = this.ewkt.charAt(this.offset))) {
                ++this.offset;
            }
            if (this.offset < len && ch > ' ' && ch != ')' && ch != ',') {
                throw new IllegalArgumentException();
            }
            Double d = Double.parseDouble(this.ewkt.substring(start, this.offset));
            return d == 0.0 ? 0.0 : d;
        }

        private static boolean isNumberStart(char ch) {
            if (ch >= '0' && ch <= '9') {
                return true;
            }
            switch (ch) {
                case '+': 
                case '-': 
                case '.': {
                    return true;
                }
            }
            return false;
        }

        private static boolean isNumberPart(char ch) {
            if (ch >= '0' && ch <= '9') {
                return true;
            }
            switch (ch) {
                case '+': 
                case '-': 
                case '.': 
                case 'E': 
                case 'e': {
                    return true;
                }
            }
            return false;
        }

        public boolean hasMoreCoordinates() {
            this.skipWS();
            if (this.offset >= this.ewkt.length()) {
                throw new IllegalArgumentException();
            }
            switch (this.ewkt.charAt(this.offset)) {
                case ',': {
                    ++this.offset;
                    return true;
                }
                case ')': {
                    ++this.offset;
                    return false;
                }
            }
            throw new IllegalArgumentException();
        }

        boolean hasData() {
            this.skipWS();
            return this.offset < this.ewkt.length();
        }

        int getItemCount() {
            int result = 1;
            int offset = this.offset;
            int level = 0;
            int len = this.ewkt.length();
            while (offset < len) {
                switch (this.ewkt.charAt(offset++)) {
                    case ',': {
                        if (level != 0) break;
                        ++result;
                        break;
                    }
                    case '(': {
                        ++level;
                        break;
                    }
                    case ')': {
                        if (--level >= 0) break;
                        return result;
                    }
                }
            }
            throw new IllegalArgumentException();
        }

        private void skipWS() {
            int len = this.ewkt.length();
            while (this.offset < len && this.ewkt.charAt(this.offset) <= ' ') {
                ++this.offset;
            }
        }

        public String toString() {
            return new StringBuilder(this.ewkt.length() + 3).append(this.ewkt, 0, this.offset).append("<*>").append(this.ewkt, this.offset, this.ewkt.length()).toString();
        }
    }

    public static final class EWKTTarget
    extends GeometryUtils.Target {
        private final StringBuilder output;
        private final int dimensionSystem;
        private int type;
        private boolean inMulti;

        public EWKTTarget(StringBuilder output, int dimensionSystem) {
            this.output = output;
            this.dimensionSystem = dimensionSystem;
        }

        @Override
        protected void init(int srid) {
            if (srid != 0) {
                this.output.append("SRID=").append(srid).append(';');
            }
        }

        @Override
        protected void startPoint() {
            this.writeHeader(1);
        }

        @Override
        protected void startLineString(int numPoints) {
            this.writeHeader(2);
            if (numPoints == 0) {
                this.output.append("EMPTY");
            }
        }

        @Override
        protected void startPolygon(int numInner, int numPoints) {
            this.writeHeader(3);
            if (numPoints == 0) {
                this.output.append("EMPTY");
            } else {
                this.output.append('(');
            }
        }

        @Override
        protected void startPolygonInner(int numInner) {
            this.output.append(numInner > 0 ? ", " : ", EMPTY");
        }

        @Override
        protected void endNonEmptyPolygon() {
            this.output.append(')');
        }

        @Override
        protected void startCollection(int type, int numItems) {
            this.writeHeader(type);
            if (numItems == 0) {
                this.output.append("EMPTY");
            }
            if (type != 7) {
                this.inMulti = true;
            }
        }

        private void writeHeader(int type) {
            this.type = type;
            if (this.inMulti) {
                return;
            }
            this.output.append(TYPES[type - 1]);
            switch (this.dimensionSystem) {
                case 1: {
                    this.output.append(" Z");
                    break;
                }
                case 2: {
                    this.output.append(" M");
                    break;
                }
                case 3: {
                    this.output.append(" ZM");
                }
            }
            this.output.append(' ');
        }

        @Override
        protected GeometryUtils.Target startCollectionItem(int index, int total) {
            if (index == 0) {
                this.output.append('(');
            } else {
                this.output.append(", ");
            }
            return this;
        }

        @Override
        protected void endCollectionItem(GeometryUtils.Target target, int type, int index, int total) {
            if (index + 1 == total) {
                this.output.append(')');
            }
        }

        @Override
        protected void endObject(int type) {
            switch (type) {
                case 4: 
                case 5: 
                case 6: {
                    this.inMulti = false;
                }
            }
        }

        @Override
        protected void addCoordinate(double x, double y, double z, double m, int index, int total) {
            if (this.type == 1 && Double.isNaN(x) && Double.isNaN(y) && Double.isNaN(z) && Double.isNaN(m)) {
                this.output.append("EMPTY");
                return;
            }
            if (index == 0) {
                this.output.append('(');
            } else {
                this.output.append(", ");
            }
            this.writeDouble(x);
            this.output.append(' ');
            this.writeDouble(y);
            if ((this.dimensionSystem & 1) != 0) {
                this.output.append(' ');
                this.writeDouble(z);
            }
            if ((this.dimensionSystem & 2) != 0) {
                this.output.append(' ');
                this.writeDouble(m);
            }
            if (index + 1 == total) {
                this.output.append(')');
            }
        }

        private void writeDouble(double v) {
            String s = Double.toString(GeometryUtils.checkFinite(v));
            if (s.endsWith(".0")) {
                this.output.append(s, 0, s.length() - 2);
            } else {
                int idx = s.indexOf(".0E");
                if (idx < 0) {
                    this.output.append(s);
                } else {
                    this.output.append(s, 0, idx).append(s, idx + 2, s.length());
                }
            }
        }
    }
}

