/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util.geometry;

import java.io.ByteArrayOutputStream;
import java.math.BigDecimal;
import org.h2.message.DbException;
import org.h2.util.geometry.EWKBUtils;
import org.h2.util.geometry.GeometryUtils;
import org.h2.util.json.JSONArray;
import org.h2.util.json.JSONByteArrayTarget;
import org.h2.util.json.JSONBytesSource;
import org.h2.util.json.JSONNull;
import org.h2.util.json.JSONNumber;
import org.h2.util.json.JSONObject;
import org.h2.util.json.JSONString;
import org.h2.util.json.JSONValue;
import org.h2.util.json.JSONValueTarget;

public final class GeoJsonUtils {
    static final String[] TYPES = new String[]{"Point", "LineString", "Polygon", "MultiPoint", "MultiLineString", "MultiPolygon", "GeometryCollection"};

    public static byte[] ewkbToGeoJson(byte[] ewkb, int dimensionSystem) {
        JSONByteArrayTarget output = new JSONByteArrayTarget();
        GeoJsonTarget target = new GeoJsonTarget(output, dimensionSystem);
        EWKBUtils.parseEWKB(ewkb, target);
        return output.getResult();
    }

    public static byte[] geoJsonToEwkb(byte[] json, int srid) {
        JSONValue v = JSONBytesSource.parse(json, new JSONValueTarget());
        GeometryUtils.DimensionSystemTarget dst = new GeometryUtils.DimensionSystemTarget();
        GeoJsonUtils.parse(v, dst);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        EWKBUtils.EWKBTarget target = new EWKBUtils.EWKBTarget(baos, dst.getDimensionSystem());
        target.init(srid);
        GeoJsonUtils.parse(v, target);
        return baos.toByteArray();
    }

    private static void parse(JSONValue v, GeometryUtils.Target target) {
        if (v instanceof JSONNull) {
            target.startPoint();
            target.addCoordinate(Double.NaN, Double.NaN, Double.NaN, Double.NaN, 0, 1);
            target.endObject(1);
        } else if (v instanceof JSONObject) {
            JSONObject o = (JSONObject)v;
            JSONValue t = o.getFirst("type");
            if (!(t instanceof JSONString)) {
                throw new IllegalArgumentException();
            }
            switch (((JSONString)t).getString()) {
                case "Point": {
                    GeoJsonUtils.parse(o, target, 1);
                    break;
                }
                case "LineString": {
                    GeoJsonUtils.parse(o, target, 2);
                    break;
                }
                case "Polygon": {
                    GeoJsonUtils.parse(o, target, 3);
                    break;
                }
                case "MultiPoint": {
                    GeoJsonUtils.parse(o, target, 4);
                    break;
                }
                case "MultiLineString": {
                    GeoJsonUtils.parse(o, target, 5);
                    break;
                }
                case "MultiPolygon": {
                    GeoJsonUtils.parse(o, target, 6);
                    break;
                }
                case "GeometryCollection": {
                    GeoJsonUtils.parseGeometryCollection(o, target);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    private static void parse(JSONObject o, GeometryUtils.Target target, int type) {
        JSONValue t = o.getFirst("coordinates");
        if (!(t instanceof JSONArray)) {
            throw new IllegalArgumentException();
        }
        JSONArray a = (JSONArray)t;
        switch (type) {
            case 1: {
                target.startPoint();
                GeoJsonUtils.parseCoordinate(a, target, 0, 1);
                target.endObject(1);
                break;
            }
            case 2: {
                GeoJsonUtils.parseLineString(a, target);
                break;
            }
            case 3: {
                GeoJsonUtils.parsePolygon(a, target);
                break;
            }
            case 4: {
                JSONValue[] points = a.getArray();
                int numPoints = points.length;
                target.startCollection(4, numPoints);
                for (int i = 0; i < numPoints; ++i) {
                    target.startPoint();
                    GeoJsonUtils.parseCoordinate(points[i], target, 0, 1);
                    target.endObject(1);
                    target.endCollectionItem(target, 4, i, numPoints);
                }
                target.endObject(4);
                break;
            }
            case 5: {
                JSONValue[] strings = a.getArray();
                int numStrings = strings.length;
                target.startCollection(5, numStrings);
                for (int i = 0; i < numStrings; ++i) {
                    JSONValue string = strings[i];
                    if (!(string instanceof JSONArray)) {
                        throw new IllegalArgumentException();
                    }
                    GeoJsonUtils.parseLineString((JSONArray)string, target);
                    target.endCollectionItem(target, 5, i, numStrings);
                }
                target.endObject(5);
                break;
            }
            case 6: {
                JSONValue[] polygons = a.getArray();
                int numPolygons = polygons.length;
                target.startCollection(6, numPolygons);
                for (int i = 0; i < numPolygons; ++i) {
                    JSONValue string = polygons[i];
                    if (!(string instanceof JSONArray)) {
                        throw new IllegalArgumentException();
                    }
                    GeoJsonUtils.parsePolygon((JSONArray)string, target);
                    target.endCollectionItem(target, 6, i, numPolygons);
                }
                target.endObject(6);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private static void parseGeometryCollection(JSONObject o, GeometryUtils.Target target) {
        JSONValue t = o.getFirst("geometries");
        if (!(t instanceof JSONArray)) {
            throw new IllegalArgumentException();
        }
        JSONArray a = (JSONArray)t;
        JSONValue[] geometries = a.getArray();
        int numGeometries = geometries.length;
        target.startCollection(7, numGeometries);
        for (int i = 0; i < numGeometries; ++i) {
            JSONValue geometry = geometries[i];
            GeoJsonUtils.parse(geometry, target);
            target.endCollectionItem(target, 7, i, numGeometries);
        }
        target.endObject(7);
    }

    private static void parseLineString(JSONArray a, GeometryUtils.Target target) {
        JSONValue[] points = a.getArray();
        int numPoints = points.length;
        target.startLineString(numPoints);
        for (int i = 0; i < numPoints; ++i) {
            GeoJsonUtils.parseCoordinate(points[i], target, i, numPoints);
        }
        target.endObject(2);
    }

    private static void parsePolygon(JSONArray a, GeometryUtils.Target target) {
        JSONValue[] rings = a.getArray();
        int numRings = rings.length;
        if (numRings == 0) {
            target.startPolygon(0, 0);
        } else {
            JSONValue ring = rings[0];
            if (!(ring instanceof JSONArray)) {
                throw new IllegalArgumentException();
            }
            JSONValue[] points = ((JSONArray)ring).getArray();
            target.startPolygon(numRings - 1, points.length);
            GeoJsonUtils.parseRing(points, target);
            for (int i = 1; i < numRings; ++i) {
                ring = rings[i];
                if (!(ring instanceof JSONArray)) {
                    throw new IllegalArgumentException();
                }
                points = ((JSONArray)ring).getArray();
                target.startPolygonInner(points.length);
                GeoJsonUtils.parseRing(points, target);
            }
            target.endNonEmptyPolygon();
        }
        target.endObject(3);
    }

    private static void parseRing(JSONValue[] points, GeometryUtils.Target target) {
        int numPoints = points.length;
        for (int i = 0; i < numPoints; ++i) {
            GeoJsonUtils.parseCoordinate(points[i], target, i, numPoints);
        }
    }

    private static void parseCoordinate(JSONValue v, GeometryUtils.Target target, int index, int total) {
        if (v instanceof JSONNull) {
            target.addCoordinate(Double.NaN, Double.NaN, Double.NaN, Double.NaN, 0, 1);
            return;
        }
        if (!(v instanceof JSONArray)) {
            throw new IllegalArgumentException();
        }
        JSONValue[] values = ((JSONArray)v).getArray();
        int length = values.length;
        if (length < 2) {
            throw new IllegalArgumentException();
        }
        target.addCoordinate(GeoJsonUtils.readCoordinate(values, 0), GeoJsonUtils.readCoordinate(values, 1), GeoJsonUtils.readCoordinate(values, 2), GeoJsonUtils.readCoordinate(values, 3), index, total);
    }

    private static double readCoordinate(JSONValue[] values, int index) {
        if (index >= values.length) {
            return Double.NaN;
        }
        JSONValue v = values[index];
        if (!(v instanceof JSONNumber)) {
            throw new IllegalArgumentException();
        }
        return ((JSONNumber)v).getBigDecimal().doubleValue();
    }

    private GeoJsonUtils() {
    }

    public static final class GeoJsonTarget
    extends GeometryUtils.Target {
        private final JSONByteArrayTarget output;
        private final int dimensionSystem;
        private int type;
        private boolean inMulti;
        private boolean inMultiLine;
        private boolean wasEmpty;

        public GeoJsonTarget(JSONByteArrayTarget output, int dimensionSystem) {
            if (dimensionSystem == 2) {
                throw DbException.get(22018, "M (XYM) dimension system is not supported in GeoJson");
            }
            this.output = output;
            this.dimensionSystem = dimensionSystem;
        }

        @Override
        protected void startPoint() {
            this.type = 1;
            this.wasEmpty = false;
        }

        @Override
        protected void startLineString(int numPoints) {
            this.writeHeader(2);
            if (numPoints == 0) {
                this.output.endArray();
            }
        }

        @Override
        protected void startPolygon(int numInner, int numPoints) {
            this.writeHeader(3);
            if (numPoints == 0) {
                this.output.endArray();
            } else {
                this.output.startArray();
            }
        }

        @Override
        protected void startPolygonInner(int numInner) {
            this.output.startArray();
            if (numInner == 0) {
                this.output.endArray();
            }
        }

        @Override
        protected void endNonEmptyPolygon() {
            this.output.endArray();
        }

        @Override
        protected void startCollection(int type, int numItems) {
            this.writeHeader(type);
            if (type != 7) {
                this.inMulti = true;
                if (type == 5 || type == 6) {
                    this.inMultiLine = true;
                }
            }
        }

        @Override
        protected GeometryUtils.Target startCollectionItem(int index, int total) {
            if (this.inMultiLine) {
                this.output.startArray();
            }
            return this;
        }

        @Override
        protected void endObject(int type) {
            switch (type) {
                case 4: 
                case 5: 
                case 6: {
                    this.inMulti = false;
                    this.inMultiLine = false;
                }
                case 7: {
                    this.output.endArray();
                }
            }
            if (!this.inMulti && !this.wasEmpty) {
                this.output.endObject();
            }
        }

        private void writeHeader(int type) {
            this.type = type;
            this.wasEmpty = false;
            if (!this.inMulti) {
                this.writeStartObject(type);
            }
        }

        @Override
        protected void addCoordinate(double x, double y, double z, double m, int index, int total) {
            if (this.type == 1) {
                if (Double.isNaN(x) && Double.isNaN(y) && Double.isNaN(z) && Double.isNaN(m)) {
                    this.wasEmpty = true;
                    this.output.valueNull();
                    return;
                }
                if (!this.inMulti) {
                    this.writeStartObject(1);
                }
            }
            this.output.startArray();
            this.writeDouble(x);
            this.writeDouble(y);
            if ((this.dimensionSystem & 1) != 0) {
                this.writeDouble(z);
            }
            if ((this.dimensionSystem & 2) != 0) {
                this.writeDouble(m);
            }
            this.output.endArray();
            if (this.type != 1 && index + 1 == total) {
                this.output.endArray();
            }
        }

        private void writeStartObject(int type) {
            this.output.startObject();
            this.output.member("type");
            this.output.valueString(TYPES[type - 1]);
            this.output.member(type != 7 ? "coordinates" : "geometries");
            if (type != 1) {
                this.output.startArray();
            }
        }

        private void writeDouble(double v) {
            this.output.valueNumber(BigDecimal.valueOf(GeometryUtils.checkFinite(v)).stripTrailingZeros());
        }
    }
}

