/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.nio.charset.Charset;
import java.text.CollationKey;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import org.h2.util.Bits;

public class CharsetCollator
extends Collator {
    static final Comparator<byte[]> COMPARATOR = Bits::compareNotNullSigned;
    private final Charset charset;

    public CharsetCollator(Charset charset) {
        this.charset = charset;
    }

    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public int compare(String source, String target) {
        return COMPARATOR.compare(this.toBytes(source), this.toBytes(target));
    }

    byte[] toBytes(String source) {
        if (this.getStrength() <= 1) {
            source = source.toUpperCase(Locale.ROOT);
        }
        return source.getBytes(this.charset);
    }

    @Override
    public CollationKey getCollationKey(String source) {
        return new CharsetCollationKey(source);
    }

    @Override
    public int hashCode() {
        return 255;
    }

    private class CharsetCollationKey
    extends CollationKey {
        private final byte[] bytes;

        CharsetCollationKey(String source) {
            super(source);
            this.bytes = CharsetCollator.this.toBytes(source);
        }

        @Override
        public int compareTo(CollationKey target) {
            return COMPARATOR.compare(this.bytes, target.toByteArray());
        }

        @Override
        public byte[] toByteArray() {
            return this.bytes;
        }
    }
}

