/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.JDBCType;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLType;
import java.util.HashMap;
import java.util.Map;
import org.h2.api.H2Type;
import org.h2.api.IntervalQualifier;
import org.h2.engine.Mode;
import org.h2.message.DbException;
import org.h2.util.StringUtils;
import org.h2.value.ExtTypeInfoRow;
import org.h2.value.TypeInfo;

public class DataType {
    private static final HashMap<String, DataType> TYPES_BY_NAME = new HashMap(128);
    static final DataType[] TYPES_BY_VALUE_TYPE = new DataType[42];
    public int type;
    public int sqlType;
    public long minPrecision;
    public long maxPrecision;
    public int minScale;
    public int maxScale;
    public String prefix;
    public String suffix;
    public String params;
    public boolean caseSensitive;
    public boolean supportsPrecision;
    public boolean supportsScale;
    public long defaultPrecision;
    public int defaultScale;
    public boolean specialPrecisionScale;

    private static void addInterval(int type) {
        IntervalQualifier qualifier = IntervalQualifier.valueOf(type - 22);
        String name = qualifier.toString();
        DataType dataType = new DataType();
        dataType.prefix = "INTERVAL '";
        dataType.suffix = "' " + name;
        dataType.supportsPrecision = true;
        dataType.defaultPrecision = 2L;
        dataType.minPrecision = 1L;
        dataType.maxPrecision = 18L;
        if (qualifier.hasSeconds()) {
            dataType.supportsScale = true;
            dataType.defaultScale = 6;
            dataType.maxScale = 9;
            dataType.params = "PRECISION,SCALE";
        } else {
            dataType.params = "PRECISION";
        }
        DataType.add(type, 1111, dataType, ("INTERVAL " + name).intern());
    }

    private static void add(int type, int sqlType, DataType dataType, String ... names) {
        dataType.type = type;
        dataType.sqlType = sqlType;
        if (TYPES_BY_VALUE_TYPE[type] == null) {
            DataType.TYPES_BY_VALUE_TYPE[type] = dataType;
        }
        for (String name : names) {
            TYPES_BY_NAME.put(name, dataType);
        }
    }

    public static DataType createNumeric(int precision, int scale) {
        DataType dataType = new DataType();
        dataType.maxPrecision = dataType.minPrecision = (long)precision;
        dataType.defaultPrecision = dataType.minPrecision;
        dataType.maxScale = dataType.minScale = scale;
        dataType.defaultScale = dataType.minScale;
        return dataType;
    }

    public static DataType createDate(int maxPrecision, int precision, String prefix, boolean supportsScale, int scale, int maxScale) {
        DataType dataType = new DataType();
        dataType.prefix = prefix + " '";
        dataType.suffix = "'";
        dataType.maxPrecision = maxPrecision;
        dataType.defaultPrecision = dataType.minPrecision = (long)precision;
        if (supportsScale) {
            dataType.params = "SCALE";
            dataType.supportsScale = true;
            dataType.maxScale = maxScale;
            dataType.defaultScale = scale;
        }
        return dataType;
    }

    private static DataType createString(boolean caseSensitive, boolean fixedLength) {
        return DataType.createString(caseSensitive, fixedLength, "'", "'");
    }

    private static DataType createBinary(boolean fixedLength) {
        return DataType.createString(false, fixedLength, "X'", "'");
    }

    private static DataType createString(boolean caseSensitive, boolean fixedLength, String prefix, String suffix) {
        DataType dataType = new DataType();
        dataType.prefix = prefix;
        dataType.suffix = suffix;
        dataType.params = "LENGTH";
        dataType.caseSensitive = caseSensitive;
        dataType.supportsPrecision = true;
        dataType.minPrecision = 1L;
        dataType.maxPrecision = 1000000000L;
        dataType.defaultPrecision = fixedLength ? 1L : 1000000000L;
        return dataType;
    }

    private static DataType createLob(boolean clob) {
        DataType t = clob ? DataType.createString(true, false) : DataType.createBinary(false);
        t.maxPrecision = Long.MAX_VALUE;
        t.defaultPrecision = Long.MAX_VALUE;
        return t;
    }

    private static DataType createGeometry() {
        DataType dataType = new DataType();
        dataType.prefix = "'";
        dataType.suffix = "'";
        dataType.params = "TYPE,SRID";
        dataType.maxPrecision = Long.MAX_VALUE;
        dataType.defaultPrecision = Long.MAX_VALUE;
        return dataType;
    }

    public static DataType getDataType(int type) {
        if (type == -1) {
            throw DbException.get(50004, "?");
        }
        if (type >= 0 && type < 42) {
            return TYPES_BY_VALUE_TYPE[type];
        }
        return TYPES_BY_VALUE_TYPE[0];
    }

    public static int convertTypeToSQLType(TypeInfo type) {
        int valueType = type.getValueType();
        switch (valueType) {
            case 13: {
                return type.getExtTypeInfo() != null ? 3 : 2;
            }
            case 14: 
            case 15: {
                if (type.getDeclaredPrecision() < 0L) break;
                return 6;
            }
        }
        return DataType.getDataType((int)valueType).sqlType;
    }

    public static int convertSQLTypeToValueType(int sqlType, String sqlTypeName) {
        switch (sqlType) {
            case -2: {
                if (!sqlTypeName.equalsIgnoreCase("UUID")) break;
                return 39;
            }
            case 1111: {
                DataType type = TYPES_BY_NAME.get(StringUtils.toUpperEnglish(sqlTypeName));
                if (type == null) break;
                return type.type;
            }
        }
        return DataType.convertSQLTypeToValueType(sqlType);
    }

    public static int getValueTypeFromResultSet(ResultSetMetaData meta, int columnIndex) throws SQLException {
        return DataType.convertSQLTypeToValueType(meta.getColumnType(columnIndex), meta.getColumnTypeName(columnIndex));
    }

    public static boolean isBinaryColumn(ResultSetMetaData meta, int column) throws SQLException {
        switch (meta.getColumnType(column)) {
            case -2: {
                if (meta.getColumnTypeName(column).equals("UUID")) break;
            }
            case -4: 
            case -3: 
            case 2000: 
            case 2004: {
                return true;
            }
        }
        return false;
    }

    public static int convertSQLTypeToValueType(SQLType sqlType) {
        if (sqlType instanceof H2Type) {
            return sqlType.getVendorTypeNumber();
        }
        if (sqlType instanceof JDBCType) {
            return DataType.convertSQLTypeToValueType(sqlType.getVendorTypeNumber());
        }
        throw DbException.get(50004, sqlType == null ? "<null>" : DataType.unknownSqlTypeToString(new StringBuilder(), sqlType).toString());
    }

    public static int convertSQLTypeToValueType(int sqlType) {
        switch (sqlType) {
            case -15: 
            case 1: {
                return 1;
            }
            case -16: 
            case -9: 
            case -1: 
            case 12: {
                return 2;
            }
            case 2: 
            case 3: {
                return 13;
            }
            case -7: 
            case 16: {
                return 8;
            }
            case 4: {
                return 11;
            }
            case 5: {
                return 10;
            }
            case -6: {
                return 9;
            }
            case -5: {
                return 12;
            }
            case 7: {
                return 14;
            }
            case 6: 
            case 8: {
                return 15;
            }
            case -2: {
                return 5;
            }
            case -4: 
            case -3: {
                return 6;
            }
            case 1111: {
                return -1;
            }
            case 2000: {
                return 35;
            }
            case 91: {
                return 17;
            }
            case 92: {
                return 18;
            }
            case 93: {
                return 20;
            }
            case 2013: {
                return 19;
            }
            case 2014: {
                return 21;
            }
            case 2004: {
                return 7;
            }
            case 2005: 
            case 2011: {
                return 3;
            }
            case 0: {
                return 0;
            }
            case 2003: {
                return 40;
            }
        }
        throw DbException.get(50004, Integer.toString(sqlType));
    }

    public static String sqlTypeToString(SQLType sqlType) {
        if (sqlType == null) {
            return "null";
        }
        if (sqlType instanceof JDBCType) {
            return "JDBCType." + sqlType.getName();
        }
        if (sqlType instanceof H2Type) {
            return sqlType.toString();
        }
        return DataType.unknownSqlTypeToString(new StringBuilder("/* "), sqlType).append(" */ null").toString();
    }

    private static StringBuilder unknownSqlTypeToString(StringBuilder builder, SQLType sqlType) {
        return builder.append(StringUtils.quoteJavaString(sqlType.getVendor())).append('/').append(StringUtils.quoteJavaString(sqlType.getName())).append(" [").append(sqlType.getVendorTypeNumber()).append(']');
    }

    public static DataType getTypeByName(String s, Mode mode) {
        DataType result = mode.typeByNameMap.get(s);
        if (result == null) {
            result = TYPES_BY_NAME.get(s);
        }
        return result;
    }

    public static boolean isIndexable(TypeInfo type) {
        switch (type.getValueType()) {
            case -1: 
            case 0: 
            case 3: 
            case 7: {
                return false;
            }
            case 40: {
                return DataType.isIndexable((TypeInfo)type.getExtTypeInfo());
            }
            case 41: {
                ExtTypeInfoRow ext = (ExtTypeInfoRow)type.getExtTypeInfo();
                for (Map.Entry<String, TypeInfo> entry : ext.getFields()) {
                    if (DataType.isIndexable(entry.getValue())) continue;
                    return false;
                }
                break;
            }
        }
        return true;
    }

    public static boolean areStableComparable(TypeInfo type1, TypeInfo type2) {
        int t1 = type1.getValueType();
        int t2 = type2.getValueType();
        switch (t1) {
            case -1: 
            case 0: 
            case 3: 
            case 7: 
            case 41: {
                return false;
            }
            case 17: 
            case 20: {
                return t2 == 17 || t2 == 20;
            }
            case 18: 
            case 19: 
            case 21: {
                return t1 == t2;
            }
            case 40: {
                if (t2 == 40) {
                    return DataType.areStableComparable((TypeInfo)type1.getExtTypeInfo(), (TypeInfo)type2.getExtTypeInfo());
                }
                return false;
            }
        }
        switch (t2) {
            case -1: 
            case 0: 
            case 3: 
            case 7: 
            case 41: {
                return false;
            }
        }
        return true;
    }

    public static boolean isDateTimeType(int type) {
        return type >= 17 && type <= 21;
    }

    public static boolean isIntervalType(int type) {
        return type >= 22 && type <= 34;
    }

    public static boolean isYearMonthIntervalType(int type) {
        return type == 22 || type == 23 || type == 28;
    }

    public static boolean isLargeObject(int type) {
        return type == 7 || type == 3;
    }

    public static boolean isNumericType(int type) {
        return type >= 9 && type <= 16;
    }

    public static boolean isBinaryStringType(int type) {
        return type >= 5 && type <= 7;
    }

    public static boolean isCharacterStringType(int type) {
        return type >= 1 && type <= 4;
    }

    public static boolean isStringType(int type) {
        return type == 2 || type == 1 || type == 4;
    }

    public static boolean isBinaryStringOrSpecialBinaryType(int type) {
        switch (type) {
            case 5: 
            case 6: 
            case 7: 
            case 35: 
            case 37: 
            case 38: 
            case 39: {
                return true;
            }
        }
        return false;
    }

    public static boolean hasTotalOrdering(int type) {
        switch (type) {
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: {
                return true;
            }
        }
        return false;
    }

    public static long addPrecision(long p1, long p2) {
        long sum = p1 + p2;
        if ((p1 | p2 | sum) < 0L) {
            return Long.MAX_VALUE;
        }
        return sum;
    }

    public static Object getDefaultForPrimitiveType(Class<?> clazz) {
        if (clazz == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (clazz == Byte.TYPE) {
            return (byte)0;
        }
        if (clazz == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (clazz == Short.TYPE) {
            return (short)0;
        }
        if (clazz == Integer.TYPE) {
            return 0;
        }
        if (clazz == Long.TYPE) {
            return 0L;
        }
        if (clazz == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (clazz == Double.TYPE) {
            return 0.0;
        }
        throw DbException.getInternalError("primitive=" + clazz.toString());
    }

    static {
        DataType dataType = new DataType();
        dataType.minPrecision = 1L;
        dataType.maxPrecision = 1L;
        dataType.defaultPrecision = 1L;
        DataType.add(0, 0, dataType, "NULL");
        DataType.add(1, 1, DataType.createString(true, true), "CHARACTER", "CHAR", "NCHAR", "NATIONAL CHARACTER", "NATIONAL CHAR");
        DataType.add(2, 12, DataType.createString(true, false), "CHARACTER VARYING", "VARCHAR", "CHAR VARYING", "NCHAR VARYING", "NATIONAL CHARACTER VARYING", "NATIONAL CHAR VARYING", "VARCHAR2", "NVARCHAR", "NVARCHAR2", "VARCHAR_CASESENSITIVE", "TID", "LONGVARCHAR", "LONGNVARCHAR", "TINYTEXT", "TEXT", "MEDIUMTEXT", "LONGTEXT", "NTEXT");
        DataType.add(3, 2005, DataType.createLob(true), "CHARACTER LARGE OBJECT", "CLOB", "CHAR LARGE OBJECT", "NCLOB", "NCHAR LARGE OBJECT", "NATIONAL CHARACTER LARGE OBJECT");
        DataType.add(4, 12, DataType.createString(false, false), "VARCHAR_IGNORECASE");
        DataType.add(5, -2, DataType.createBinary(true), "BINARY");
        DataType.add(6, -3, DataType.createBinary(false), "BINARY VARYING", "VARBINARY", "RAW", "BYTEA", "LONG RAW", "LONGVARBINARY");
        DataType.add(7, 2004, DataType.createLob(false), "BINARY LARGE OBJECT", "BLOB", "TINYBLOB", "MEDIUMBLOB", "LONGBLOB", "IMAGE");
        DataType boolType = DataType.createNumeric(1, 0);
        boolType.supportsPrecision = true;
        DataType.add(8, 16, boolType, "BOOLEAN", "BIT", "BOOL");
        DataType.add(9, -6, DataType.createNumeric(8, 0), "TINYINT");
        DataType.add(10, 5, DataType.createNumeric(16, 0), "SMALLINT", "INT2");
        DataType intType = DataType.createNumeric(32, 0);
        intType.supportsPrecision = true;
        intType.minPrecision = 1L;
        DataType.add(11, 4, intType, "INTEGER", "INT", "MEDIUMINT", "INT4", "SIGNED");
        DataType.add(12, -5, DataType.createNumeric(64, 0), "BIGINT", "INT8", "LONG");
        dataType = new DataType();
        dataType.minPrecision = 1L;
        dataType.maxPrecision = 100000L;
        dataType.defaultPrecision = 100000L;
        dataType.defaultScale = 0;
        dataType.maxScale = 100000;
        dataType.minScale = 0;
        dataType.params = "PRECISION,SCALE";
        dataType.supportsPrecision = true;
        dataType.supportsScale = true;
        DataType.add(13, 2, dataType, "NUMERIC", "DECIMAL", "DEC");
        DataType.add(14, 7, DataType.createNumeric(24, 0), "REAL", "FLOAT4");
        DataType.add(15, 8, DataType.createNumeric(53, 0), "DOUBLE PRECISION", "DOUBLE", "FLOAT8");
        DataType.add(15, 6, DataType.createNumeric(53, 0), "FLOAT");
        dataType = new DataType();
        dataType.minPrecision = 1L;
        dataType.maxPrecision = 100000L;
        dataType.defaultPrecision = 100000L;
        dataType.params = "PRECISION";
        dataType.supportsPrecision = true;
        DataType.add(16, 2, dataType, "DECFLOAT");
        DataType.add(17, 91, DataType.createDate(10, 10, "DATE", false, 0, 0), "DATE");
        DataType.add(18, 92, DataType.createDate(18, 8, "TIME", true, 0, 9), "TIME", "TIME WITHOUT TIME ZONE");
        DataType.add(19, 2013, DataType.createDate(24, 14, "TIME WITH TIME ZONE", true, 0, 9), "TIME WITH TIME ZONE");
        DataType.add(20, 93, DataType.createDate(29, 26, "TIMESTAMP", true, 6, 9), "TIMESTAMP", "TIMESTAMP WITHOUT TIME ZONE", "DATETIME", "DATETIME2", "SMALLDATETIME");
        DataType.add(21, 2014, DataType.createDate(35, 32, "TIMESTAMP WITH TIME ZONE", true, 6, 9), "TIMESTAMP WITH TIME ZONE");
        for (int i = 22; i <= 34; ++i) {
            DataType.addInterval(i);
        }
        DataType.add(35, 2000, DataType.createBinary(false), "JAVA_OBJECT", "OBJECT", "OTHER");
        dataType = DataType.createString(false, false);
        dataType.supportsPrecision = false;
        dataType.params = "ELEMENT [,...]";
        DataType.add(36, 1111, dataType, "ENUM");
        DataType.add(37, 1111, DataType.createGeometry(), "GEOMETRY");
        DataType.add(38, 1111, DataType.createString(true, false, "JSON '", "'"), "JSON");
        dataType = new DataType();
        dataType.suffix = "'";
        dataType.prefix = "'";
        dataType.minPrecision = 16L;
        dataType.maxPrecision = 16L;
        dataType.defaultPrecision = 16L;
        DataType.add(39, -2, dataType, "UUID");
        dataType = new DataType();
        dataType.prefix = "ARRAY[";
        dataType.suffix = "]";
        dataType.params = "CARDINALITY";
        dataType.supportsPrecision = true;
        dataType.maxPrecision = 65536L;
        dataType.defaultPrecision = 65536L;
        DataType.add(40, 2003, dataType, "ARRAY");
        dataType = new DataType();
        dataType.prefix = "ROW(";
        dataType.suffix = ")";
        dataType.params = "NAME DATA_TYPE [,...]";
        DataType.add(41, 1111, dataType, "ROW");
    }
}

