/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.util.Arrays;
import java.util.Locale;
import org.h2.engine.CastDataProvider;
import org.h2.message.DbException;
import org.h2.value.ExtTypeInfo;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueEnum;

public final class ExtTypeInfoEnum
extends ExtTypeInfo {
    private final String[] enumerators;
    private final String[] cleaned;
    private TypeInfo type;

    public static ExtTypeInfoEnum getEnumeratorsForBinaryOperation(Value left, Value right) {
        if (left.getValueType() == 36) {
            return ((ValueEnum)left).getEnumerators();
        }
        if (right.getValueType() == 36) {
            return ((ValueEnum)right).getEnumerators();
        }
        throw DbException.get(50004, "type1=" + left.getValueType() + ", type2=" + right.getValueType());
    }

    private static String sanitize(String label) {
        if (label == null) {
            return null;
        }
        int length = label.length();
        if (length > 1000000000) {
            throw DbException.getValueTooLongException("ENUM", label, length);
        }
        return label.trim().toUpperCase(Locale.ENGLISH);
    }

    private static StringBuilder toSQL(StringBuilder builder, String[] enumerators) {
        builder.append('(');
        for (int i = 0; i < enumerators.length; ++i) {
            if (i != 0) {
                builder.append(", ");
            }
            builder.append('\'');
            String s = enumerators[i];
            int length = s.length();
            for (int j = 0; j < length; ++j) {
                char c = s.charAt(j);
                if (c == '\'') {
                    builder.append('\'');
                }
                builder.append(c);
            }
            builder.append('\'');
        }
        return builder.append(')');
    }

    public ExtTypeInfoEnum(String[] enumerators) {
        int length;
        if (enumerators == null || (length = enumerators.length) == 0) {
            throw DbException.get(22032);
        }
        if (length > 65536) {
            throw DbException.getValueTooLongException("ENUM", "(" + length + " elements)", length);
        }
        Object[] cleaned = new String[length];
        for (int i = 0; i < length; ++i) {
            String l = ExtTypeInfoEnum.sanitize(enumerators[i]);
            if (l == null || l.isEmpty()) {
                throw DbException.get(22032);
            }
            for (int j = 0; j < i; ++j) {
                if (!l.equals(cleaned[j])) continue;
                throw DbException.get(22033, ExtTypeInfoEnum.toSQL(new StringBuilder(), enumerators).toString());
            }
            cleaned[i] = l;
        }
        this.enumerators = enumerators;
        this.cleaned = Arrays.equals(cleaned, enumerators) ? enumerators : cleaned;
    }

    TypeInfo getType() {
        TypeInfo type = this.type;
        if (type == null) {
            int p = 0;
            for (String s : this.enumerators) {
                int l = s.length();
                if (l <= p) continue;
                p = l;
            }
            this.type = type = new TypeInfo(36, p, 0, this);
        }
        return type;
    }

    public int getCount() {
        return this.enumerators.length;
    }

    public String getEnumerator(int ordinal) {
        return this.enumerators[ordinal];
    }

    public ValueEnum getValue(int ordinal, CastDataProvider provider) {
        String label;
        if (provider == null || !provider.zeroBasedEnums()) {
            if (ordinal < 1 || ordinal > this.enumerators.length) {
                throw DbException.get(22030, this.getTraceSQL(), Integer.toString(ordinal));
            }
            label = this.enumerators[ordinal - 1];
        } else {
            if (ordinal < 0 || ordinal >= this.enumerators.length) {
                throw DbException.get(22030, this.getTraceSQL(), Integer.toString(ordinal));
            }
            label = this.enumerators[ordinal];
        }
        return new ValueEnum(this, label, ordinal);
    }

    public ValueEnum getValue(String label, CastDataProvider provider) {
        ValueEnum value = this.getValueOrNull(label, provider);
        if (value == null) {
            throw DbException.get(22030, this.toString(), label);
        }
        return value;
    }

    private ValueEnum getValueOrNull(String label, CastDataProvider provider) {
        String l = ExtTypeInfoEnum.sanitize(label);
        if (l != null) {
            int ordinal;
            int i = 0;
            int n = ordinal = provider == null || !provider.zeroBasedEnums() ? 1 : 0;
            while (i < this.cleaned.length) {
                if (l.equals(this.cleaned[i])) {
                    return new ValueEnum(this, this.enumerators[i], ordinal);
                }
                ++i;
                ++ordinal;
            }
        }
        return null;
    }

    public int hashCode() {
        return Arrays.hashCode(this.enumerators) + 203117;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != ExtTypeInfoEnum.class) {
            return false;
        }
        return Arrays.equals(this.enumerators, ((ExtTypeInfoEnum)obj).enumerators);
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        return ExtTypeInfoEnum.toSQL(builder, this.enumerators);
    }
}

