/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.h2.message.DbException;
import org.h2.util.ParserUtil;
import org.h2.value.ExtTypeInfo;
import org.h2.value.TypeInfo;
import org.h2.value.Typed;

public final class ExtTypeInfoRow
extends ExtTypeInfo {
    private final LinkedHashMap<String, TypeInfo> fields;
    private int hash;

    public ExtTypeInfoRow(Typed[] fields) {
        this(fields, fields.length);
    }

    public ExtTypeInfoRow(Typed[] fields, int degree) {
        if (degree > 16384) {
            throw DbException.get(54011, "16384");
        }
        LinkedHashMap<String, TypeInfo> map = new LinkedHashMap<String, TypeInfo>((int)Math.ceil((double)degree / 0.75));
        int i = 0;
        while (i < degree) {
            TypeInfo t = fields[i].getType();
            map.put("C" + ++i, t);
        }
        this.fields = map;
    }

    public ExtTypeInfoRow(LinkedHashMap<String, TypeInfo> fields) {
        if (fields.size() > 16384) {
            throw DbException.get(54011, "16384");
        }
        this.fields = fields;
    }

    public Set<Map.Entry<String, TypeInfo>> getFields() {
        return this.fields.entrySet();
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        builder.append('(');
        boolean f = false;
        for (Map.Entry<String, TypeInfo> field : this.fields.entrySet()) {
            if (f) {
                builder.append(", ");
            }
            f = true;
            ParserUtil.quoteIdentifier(builder, field.getKey(), sqlFlags).append(' ');
            field.getValue().getSQL(builder, sqlFlags);
        }
        return builder.append(')');
    }

    public int hashCode() {
        int h = this.hash;
        if (h != 0) {
            return h;
        }
        h = 67378403;
        for (Map.Entry<String, TypeInfo> entry : this.fields.entrySet()) {
            h = (h * 31 + entry.getKey().hashCode()) * 37 + entry.getValue().hashCode();
        }
        this.hash = h;
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj.getClass() != ExtTypeInfoRow.class) {
            return false;
        }
        LinkedHashMap<String, TypeInfo> fields2 = ((ExtTypeInfoRow)obj).fields;
        int degree = this.fields.size();
        if (degree != fields2.size()) {
            return false;
        }
        Iterator<Map.Entry<String, TypeInfo>> i1 = this.fields.entrySet().iterator();
        Iterator<Map.Entry<String, TypeInfo>> i2 = fields2.entrySet().iterator();
        while (i1.hasNext()) {
            Map.Entry<String, TypeInfo> e1 = i1.next();
            Map.Entry<String, TypeInfo> e2 = i2.next();
            if (e1.getKey().equals(e2.getKey()) && e1.getValue().equals(e2.getValue())) continue;
            return false;
        }
        return true;
    }
}

