/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.h2.api.IntervalQualifier;
import org.h2.message.DbException;
import org.h2.value.ExtTypeInfo;
import org.h2.value.ExtTypeInfoEnum;
import org.h2.value.ExtTypeInfoGeometry;
import org.h2.value.ExtTypeInfoNumeric;
import org.h2.value.ExtTypeInfoRow;
import org.h2.value.Typed;
import org.h2.value.Value;
import org.h2.value.ValueInterval;

public class TypeInfo
extends ExtTypeInfo
implements Typed {
    public static final TypeInfo TYPE_UNKNOWN;
    public static final TypeInfo TYPE_NULL;
    public static final TypeInfo TYPE_CHAR;
    public static final TypeInfo TYPE_VARCHAR;
    public static final TypeInfo TYPE_VARCHAR_IGNORECASE;
    public static final TypeInfo TYPE_CLOB;
    public static final TypeInfo TYPE_BINARY;
    public static final TypeInfo TYPE_VARBINARY;
    public static final TypeInfo TYPE_BLOB;
    public static final TypeInfo TYPE_BOOLEAN;
    public static final TypeInfo TYPE_TINYINT;
    public static final TypeInfo TYPE_SMALLINT;
    public static final TypeInfo TYPE_INTEGER;
    public static final TypeInfo TYPE_BIGINT;
    public static final TypeInfo TYPE_NUMERIC_SCALE_0;
    public static final TypeInfo TYPE_NUMERIC_BIGINT;
    public static final TypeInfo TYPE_NUMERIC_FLOATING_POINT;
    public static final TypeInfo TYPE_REAL;
    public static final TypeInfo TYPE_DOUBLE;
    public static final TypeInfo TYPE_DECFLOAT;
    public static final TypeInfo TYPE_DECFLOAT_BIGINT;
    public static final TypeInfo TYPE_DATE;
    public static final TypeInfo TYPE_TIME;
    public static final TypeInfo TYPE_TIME_TZ;
    public static final TypeInfo TYPE_TIMESTAMP;
    public static final TypeInfo TYPE_TIMESTAMP_TZ;
    public static final TypeInfo TYPE_INTERVAL_DAY;
    public static final TypeInfo TYPE_INTERVAL_YEAR_TO_MONTH;
    public static final TypeInfo TYPE_INTERVAL_DAY_TO_SECOND;
    public static final TypeInfo TYPE_INTERVAL_HOUR_TO_SECOND;
    public static final TypeInfo TYPE_JAVA_OBJECT;
    public static final TypeInfo TYPE_ENUM_UNDEFINED;
    public static final TypeInfo TYPE_GEOMETRY;
    public static final TypeInfo TYPE_JSON;
    public static final TypeInfo TYPE_UUID;
    public static final TypeInfo TYPE_ARRAY_UNKNOWN;
    public static final TypeInfo TYPE_ROW_EMPTY;
    private static final TypeInfo[] TYPE_INFOS_BY_VALUE_TYPE;
    private final int valueType;
    private final long precision;
    private final int scale;
    private final ExtTypeInfo extTypeInfo;

    public static TypeInfo getTypeInfo(int type) {
        TypeInfo t;
        if (type == -1) {
            throw DbException.get(50004, "?");
        }
        if (type >= 0 && type < 42 && (t = TYPE_INFOS_BY_VALUE_TYPE[type]) != null) {
            return t;
        }
        return TYPE_NULL;
    }

    public static TypeInfo getTypeInfo(int type, long precision, int scale, ExtTypeInfo extTypeInfo) {
        switch (type) {
            case 0: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 39: {
                return TYPE_INFOS_BY_VALUE_TYPE[type];
            }
            case -1: {
                return TYPE_UNKNOWN;
            }
            case 1: {
                if (precision < 1L) {
                    return TYPE_CHAR;
                }
                if (precision > 1000000000L) {
                    precision = 1000000000L;
                }
                return new TypeInfo(1, precision);
            }
            case 2: {
                if (precision < 1L || precision >= 1000000000L) {
                    if (precision != 0L) {
                        return TYPE_VARCHAR;
                    }
                    precision = 1L;
                }
                return new TypeInfo(2, precision);
            }
            case 3: {
                if (precision < 1L) {
                    return TYPE_CLOB;
                }
                return new TypeInfo(3, precision);
            }
            case 4: {
                if (precision < 1L || precision >= 1000000000L) {
                    if (precision != 0L) {
                        return TYPE_VARCHAR_IGNORECASE;
                    }
                    precision = 1L;
                }
                return new TypeInfo(4, precision);
            }
            case 5: {
                if (precision < 1L) {
                    return TYPE_BINARY;
                }
                if (precision > 1000000000L) {
                    precision = 1000000000L;
                }
                return new TypeInfo(5, precision);
            }
            case 6: {
                if (precision < 1L || precision >= 1000000000L) {
                    if (precision != 0L) {
                        return TYPE_VARBINARY;
                    }
                    precision = 1L;
                }
                return new TypeInfo(6, precision);
            }
            case 7: {
                if (precision < 1L) {
                    return TYPE_BLOB;
                }
                return new TypeInfo(7, precision);
            }
            case 13: {
                if (precision < 1L) {
                    precision = -1L;
                } else if (precision > 100000L) {
                    precision = 100000L;
                }
                if (scale < 0) {
                    scale = -1;
                } else if (scale > 100000) {
                    scale = 100000;
                }
                return new TypeInfo(13, precision, scale, extTypeInfo instanceof ExtTypeInfoNumeric ? extTypeInfo : null);
            }
            case 14: {
                if (precision >= 1L && precision <= 24L) {
                    return new TypeInfo(14, precision, -1, extTypeInfo);
                }
                return TYPE_REAL;
            }
            case 15: {
                if (precision == 0L || precision >= 25L && precision <= 53L) {
                    return new TypeInfo(15, precision, -1, extTypeInfo);
                }
                return TYPE_DOUBLE;
            }
            case 16: {
                if (precision < 1L) {
                    precision = -1L;
                } else if (precision >= 100000L) {
                    return TYPE_DECFLOAT;
                }
                return new TypeInfo(16, precision, -1, null);
            }
            case 18: {
                if (scale < 0) {
                    scale = -1;
                } else if (scale >= 9) {
                    return TYPE_TIME;
                }
                return new TypeInfo(18, scale);
            }
            case 19: {
                if (scale < 0) {
                    scale = -1;
                } else if (scale >= 9) {
                    return TYPE_TIME_TZ;
                }
                return new TypeInfo(19, scale);
            }
            case 20: {
                if (scale < 0) {
                    scale = -1;
                } else if (scale >= 9) {
                    return TYPE_TIMESTAMP;
                }
                return new TypeInfo(20, scale);
            }
            case 21: {
                if (scale < 0) {
                    scale = -1;
                } else if (scale >= 9) {
                    return TYPE_TIMESTAMP_TZ;
                }
                return new TypeInfo(21, scale);
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 32: {
                if (precision < 1L) {
                    precision = -1L;
                } else if (precision > 18L) {
                    precision = 18L;
                }
                return new TypeInfo(type, precision);
            }
            case 27: 
            case 31: 
            case 33: 
            case 34: {
                if (precision < 1L) {
                    precision = -1L;
                } else if (precision > 18L) {
                    precision = 18L;
                }
                if (scale < 0) {
                    scale = -1;
                } else if (scale > 9) {
                    scale = 9;
                }
                return new TypeInfo(type, precision, scale, null);
            }
            case 35: {
                if (precision < 1L) {
                    return TYPE_JAVA_OBJECT;
                }
                if (precision > 1000000000L) {
                    precision = 1000000000L;
                }
                return new TypeInfo(35, precision);
            }
            case 36: {
                if (extTypeInfo instanceof ExtTypeInfoEnum) {
                    return ((ExtTypeInfoEnum)extTypeInfo).getType();
                }
                return TYPE_ENUM_UNDEFINED;
            }
            case 37: {
                if (extTypeInfo instanceof ExtTypeInfoGeometry) {
                    return new TypeInfo(37, -1L, -1, extTypeInfo);
                }
                return TYPE_GEOMETRY;
            }
            case 38: {
                if (precision < 1L) {
                    return TYPE_JSON;
                }
                if (precision > 1000000000L) {
                    precision = 1000000000L;
                }
                return new TypeInfo(38, precision);
            }
            case 40: {
                if (!(extTypeInfo instanceof TypeInfo)) {
                    throw new IllegalArgumentException();
                }
                if (precision < 0L || precision >= 65536L) {
                    precision = -1L;
                }
                return new TypeInfo(40, precision, -1, extTypeInfo);
            }
            case 41: {
                if (!(extTypeInfo instanceof ExtTypeInfoRow)) {
                    throw new IllegalArgumentException();
                }
                return new TypeInfo(41, -1L, -1, extTypeInfo);
            }
        }
        return TYPE_NULL;
    }

    public static TypeInfo getHigherType(Typed[] values) {
        TypeInfo type;
        int cardinality = values.length;
        if (cardinality == 0) {
            type = TYPE_NULL;
        } else {
            type = values[0].getType();
            boolean hasUnknown = false;
            boolean hasNull = false;
            switch (type.getValueType()) {
                case -1: {
                    hasUnknown = true;
                    break;
                }
                case 0: {
                    hasNull = true;
                }
            }
            block8: for (int i = 1; i < cardinality; ++i) {
                TypeInfo t = values[i].getType();
                switch (t.getValueType()) {
                    case -1: {
                        hasUnknown = true;
                        continue block8;
                    }
                    case 0: {
                        hasNull = true;
                        continue block8;
                    }
                    default: {
                        type = TypeInfo.getHigherType(type, t);
                    }
                }
            }
            if (type.getValueType() <= 0 && hasUnknown) {
                throw DbException.get(50004, hasNull ? "NULL, ?" : "?");
            }
        }
        return type;
    }

    public static TypeInfo getHigherType(TypeInfo type1, TypeInfo type2) {
        long precision;
        int dataType;
        int t2;
        int t1 = type1.getValueType();
        if (t1 == (t2 = type2.getValueType())) {
            if (t1 == -1) {
                throw DbException.get(50004, "?, ?");
            }
            dataType = t1;
        } else {
            if (t1 < t2) {
                int t = t1;
                t1 = t2;
                t2 = t;
                TypeInfo type = type1;
                type1 = type2;
                type2 = type;
            }
            if (t1 == -1) {
                if (t2 == 0) {
                    throw DbException.get(50004, "?, NULL");
                }
                return type2;
            }
            if (t2 == -1) {
                if (t1 == 0) {
                    throw DbException.get(50004, "NULL, ?");
                }
                return type1;
            }
            if (t2 == 0) {
                return type1;
            }
            dataType = Value.getHigherOrderKnown(t1, t2);
        }
        switch (dataType) {
            case 13: {
                int scale;
                type1 = type1.toNumericType();
                type2 = type2.toNumericType();
                long precision1 = type1.getPrecision();
                long precision2 = type2.getPrecision();
                int scale1 = type1.getScale();
                int scale2 = type2.getScale();
                if (scale1 < scale2) {
                    precision1 += (long)(scale2 - scale1);
                    scale = scale2;
                } else {
                    precision2 += (long)(scale1 - scale2);
                    scale = scale1;
                }
                return TypeInfo.getTypeInfo(13, Math.max(precision1, precision2), scale, null);
            }
            case 14: 
            case 15: {
                precision = -1L;
                break;
            }
            case 37: {
                return TypeInfo.getHigherGeometry(type1, type2);
            }
            case 40: {
                return TypeInfo.getHigherArray(type1, type2, TypeInfo.dimensions(type1), TypeInfo.dimensions(type2));
            }
            case 41: {
                return TypeInfo.getHigherRow(type1, type2);
            }
            default: {
                precision = Math.max(type1.getPrecision(), type2.getPrecision());
            }
        }
        ExtTypeInfo ext1 = type1.extTypeInfo;
        return TypeInfo.getTypeInfo(dataType, precision, Math.max(type1.getScale(), type2.getScale()), dataType == t1 && ext1 != null ? ext1 : (dataType == t2 ? type2.extTypeInfo : null));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static TypeInfo getHigherGeometry(TypeInfo type1, TypeInfo type2) {
        ExtTypeInfo ext1 = type1.getExtTypeInfo();
        ExtTypeInfo ext2 = type2.getExtTypeInfo();
        if (ext1 instanceof ExtTypeInfoGeometry) {
            if (!(ext2 instanceof ExtTypeInfoGeometry)) return type2.getValueType() == 37 ? TYPE_GEOMETRY : type1;
            ExtTypeInfoGeometry g1 = (ExtTypeInfoGeometry)ext1;
            ExtTypeInfoGeometry g2 = (ExtTypeInfoGeometry)ext2;
            int t = g1.getType();
            Integer srid = g1.getSrid();
            int t2 = g2.getType();
            Integer srid2 = g2.getSrid();
            if (Objects.equals(srid, srid2)) {
                if (t == t2) {
                    return type1;
                }
                if (srid == null) {
                    return TYPE_GEOMETRY;
                }
                t = 0;
                return new TypeInfo(37, -1L, -1, new ExtTypeInfoGeometry(t, srid));
            } else {
                if (srid != null && srid2 != null) throw DbException.get(90110, type1.getTraceSQL(), type2.getTraceSQL());
                if (t == 0 || t != t2) {
                    return TYPE_GEOMETRY;
                }
                srid = null;
            }
            return new TypeInfo(37, -1L, -1, new ExtTypeInfoGeometry(t, srid));
        } else {
            if (!(ext2 instanceof ExtTypeInfoGeometry)) return TYPE_GEOMETRY;
            return type1.getValueType() == 37 ? TYPE_GEOMETRY : type2;
        }
    }

    private static int dimensions(TypeInfo type) {
        int result = 0;
        while (type.getValueType() == 40) {
            type = (TypeInfo)type.extTypeInfo;
            ++result;
        }
        return result;
    }

    private static TypeInfo getHigherArray(TypeInfo type1, TypeInfo type2, int d1, int d2) {
        long precision;
        if (d1 > d2) {
            --d1;
            precision = Math.max(type1.getPrecision(), 1L);
            type1 = (TypeInfo)type1.extTypeInfo;
        } else if (d1 < d2) {
            --d2;
            precision = Math.max(1L, type2.getPrecision());
            type2 = (TypeInfo)type2.extTypeInfo;
        } else if (d1 > 0) {
            --d1;
            --d2;
            precision = Math.max(type1.getPrecision(), type2.getPrecision());
            type1 = (TypeInfo)type1.extTypeInfo;
            type2 = (TypeInfo)type2.extTypeInfo;
        } else {
            return TypeInfo.getHigherType(type1, type2);
        }
        return TypeInfo.getTypeInfo(40, precision, 0, TypeInfo.getHigherArray(type1, type2, d1, d2));
    }

    private static TypeInfo getHigherRow(TypeInfo type1, TypeInfo type2) {
        ExtTypeInfoRow ext2;
        ExtTypeInfoRow ext1;
        if (type1.getValueType() != 41) {
            type1 = TypeInfo.typeToRow(type1);
        }
        if (type2.getValueType() != 41) {
            type2 = TypeInfo.typeToRow(type2);
        }
        if ((ext1 = (ExtTypeInfoRow)type1.getExtTypeInfo()).equals(ext2 = (ExtTypeInfoRow)type2.getExtTypeInfo())) {
            return type1;
        }
        Set<Map.Entry<String, TypeInfo>> m1 = ext1.getFields();
        Set<Map.Entry<String, TypeInfo>> m2 = ext2.getFields();
        int degree = m1.size();
        if (m2.size() != degree) {
            throw DbException.get(21002);
        }
        LinkedHashMap<String, TypeInfo> m = new LinkedHashMap<String, TypeInfo>((int)Math.ceil((double)degree / 0.75));
        Iterator<Map.Entry<String, TypeInfo>> i1 = m1.iterator();
        Iterator<Map.Entry<String, TypeInfo>> i2 = m2.iterator();
        while (i1.hasNext()) {
            Map.Entry<String, TypeInfo> e1 = i1.next();
            m.put(e1.getKey(), TypeInfo.getHigherType(e1.getValue(), i2.next().getValue()));
        }
        return TypeInfo.getTypeInfo(41, 0L, 0, new ExtTypeInfoRow(m));
    }

    private static TypeInfo typeToRow(TypeInfo type) {
        LinkedHashMap<String, TypeInfo> map = new LinkedHashMap<String, TypeInfo>(2);
        map.put("C1", type);
        return TypeInfo.getTypeInfo(41, 0L, 0, new ExtTypeInfoRow(map));
    }

    public static boolean areSameTypes(TypeInfo t1, TypeInfo t2) {
        int valueType;
        while ((valueType = t1.getValueType()) == t2.getValueType()) {
            ExtTypeInfo ext1 = t1.getExtTypeInfo();
            ExtTypeInfo ext2 = t2.getExtTypeInfo();
            if (valueType != 40) {
                return Objects.equals(ext1, ext2);
            }
            t1 = (TypeInfo)ext1;
            t2 = (TypeInfo)ext2;
        }
        return false;
    }

    public static void checkComparable(TypeInfo t1, TypeInfo t2) {
        if (!TypeInfo.areComparable(t1, t2)) {
            throw DbException.get(90110, t1.getTraceSQL(), t2.getTraceSQL());
        }
    }

    private static boolean areComparable(TypeInfo t1, TypeInfo t2) {
        int vt2;
        int vt1 = (t1 = t1.unwrapRow()).getValueType();
        if (vt1 > (vt2 = (t2 = t2.unwrapRow()).getValueType())) {
            int vt = vt1;
            vt1 = vt2;
            vt2 = vt;
            TypeInfo t = t1;
            t1 = t2;
            t2 = t;
        }
        if (vt1 <= 0) {
            return true;
        }
        if (vt1 == vt2) {
            switch (vt1) {
                case 40: {
                    return TypeInfo.areComparable((TypeInfo)t1.getExtTypeInfo(), (TypeInfo)t2.getExtTypeInfo());
                }
                case 41: {
                    Set<Map.Entry<String, TypeInfo>> f1 = ((ExtTypeInfoRow)t1.getExtTypeInfo()).getFields();
                    Set<Map.Entry<String, TypeInfo>> f2 = ((ExtTypeInfoRow)t2.getExtTypeInfo()).getFields();
                    int degree = f1.size();
                    if (f2.size() != degree) {
                        return false;
                    }
                    Iterator<Map.Entry<String, TypeInfo>> i1 = f1.iterator();
                    Iterator<Map.Entry<String, TypeInfo>> i2 = f2.iterator();
                    while (i1.hasNext()) {
                        if (TypeInfo.areComparable(i1.next().getValue(), i2.next().getValue())) continue;
                        return false;
                    }
                    break;
                }
            }
            return true;
        }
        byte g1 = Value.GROUPS[vt1];
        byte g2 = Value.GROUPS[vt2];
        if (g1 == g2) {
            switch (g1) {
                default: {
                    return true;
                }
                case 5: {
                    return vt1 != 17 || vt2 != 18 && vt2 != 19;
                }
                case 8: 
                case 9: 
            }
            return false;
        }
        switch (g1) {
            case 3: {
                switch (g2) {
                    case 4: {
                        return true;
                    }
                }
                return false;
            }
            case 1: {
                switch (g2) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        return true;
                    }
                    case 8: {
                        switch (vt2) {
                            case 36: 
                            case 37: 
                            case 38: 
                            case 39: {
                                return true;
                            }
                        }
                        return false;
                    }
                }
                return false;
            }
            case 2: {
                switch (vt2) {
                    case 35: 
                    case 37: 
                    case 38: 
                    case 39: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public static boolean haveSameOrdering(TypeInfo t1, TypeInfo t2) {
        int vt2;
        int vt1 = (t1 = t1.unwrapRow()).getValueType();
        if (vt1 > (vt2 = (t2 = t2.unwrapRow()).getValueType())) {
            int vt = vt1;
            vt1 = vt2;
            vt2 = vt;
            TypeInfo t = t1;
            t1 = t2;
            t2 = t;
        }
        if (vt1 <= 0) {
            return true;
        }
        if (vt1 == vt2) {
            switch (vt1) {
                case 40: {
                    return TypeInfo.haveSameOrdering((TypeInfo)t1.getExtTypeInfo(), (TypeInfo)t2.getExtTypeInfo());
                }
                case 41: {
                    Set<Map.Entry<String, TypeInfo>> f1 = ((ExtTypeInfoRow)t1.getExtTypeInfo()).getFields();
                    Set<Map.Entry<String, TypeInfo>> f2 = ((ExtTypeInfoRow)t2.getExtTypeInfo()).getFields();
                    int degree = f1.size();
                    if (f2.size() != degree) {
                        return false;
                    }
                    Iterator<Map.Entry<String, TypeInfo>> i1 = f1.iterator();
                    Iterator<Map.Entry<String, TypeInfo>> i2 = f2.iterator();
                    while (i1.hasNext()) {
                        if (TypeInfo.haveSameOrdering(i1.next().getValue(), i2.next().getValue())) continue;
                        return false;
                    }
                    break;
                }
            }
            return true;
        }
        byte g1 = Value.GROUPS[vt1];
        byte g2 = Value.GROUPS[vt2];
        if (g1 == g2) {
            switch (g1) {
                default: {
                    return true;
                }
                case 1: {
                    return vt1 == 4 == (vt2 == 4);
                }
                case 5: {
                    switch (vt1) {
                        case 17: {
                            return vt2 == 20 || vt2 == 21;
                        }
                        case 18: 
                        case 19: {
                            return vt2 == 18 || vt2 == 19;
                        }
                    }
                    return true;
                }
                case 8: 
                case 9: 
            }
            return false;
        }
        if (g1 == 2) {
            switch (vt2) {
                case 35: 
                case 37: 
                case 38: 
                case 39: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private TypeInfo(int valueType) {
        this.valueType = valueType;
        this.precision = -1L;
        this.scale = -1;
        this.extTypeInfo = null;
    }

    private TypeInfo(int valueType, long precision) {
        this.valueType = valueType;
        this.precision = precision;
        this.scale = -1;
        this.extTypeInfo = null;
    }

    private TypeInfo(int valueType, int scale) {
        this.valueType = valueType;
        this.precision = -1L;
        this.scale = scale;
        this.extTypeInfo = null;
    }

    public TypeInfo(int valueType, long precision, int scale, ExtTypeInfo extTypeInfo) {
        this.valueType = valueType;
        this.precision = precision;
        this.scale = scale;
        this.extTypeInfo = extTypeInfo;
    }

    @Override
    public TypeInfo getType() {
        return this;
    }

    public int getValueType() {
        return this.valueType;
    }

    public long getPrecision() {
        switch (this.valueType) {
            case -1: {
                return -1L;
            }
            case 0: {
                return 1L;
            }
            case 1: 
            case 5: {
                return this.precision >= 0L ? this.precision : 1L;
            }
            case 2: 
            case 4: 
            case 6: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                return this.precision >= 0L ? this.precision : 1000000000L;
            }
            case 3: 
            case 7: {
                return this.precision >= 0L ? this.precision : Long.MAX_VALUE;
            }
            case 8: {
                return 1L;
            }
            case 9: {
                return 8L;
            }
            case 10: {
                return 16L;
            }
            case 11: {
                return 32L;
            }
            case 12: {
                return 64L;
            }
            case 13: {
                return this.precision >= 0L ? this.precision : 100000L;
            }
            case 14: {
                return 24L;
            }
            case 15: {
                return 53L;
            }
            case 16: {
                return this.precision >= 0L ? this.precision : 100000L;
            }
            case 17: {
                return 10L;
            }
            case 18: {
                int s = this.scale >= 0 ? this.scale : 0;
                return s == 0 ? 8L : (long)(9 + s);
            }
            case 19: {
                int s = this.scale >= 0 ? this.scale : 0;
                return s == 0 ? 14L : (long)(15 + s);
            }
            case 20: {
                int s = this.scale >= 0 ? this.scale : 6;
                return s == 0 ? 19L : (long)(20 + s);
            }
            case 21: {
                int s = this.scale >= 0 ? this.scale : 6;
                return s == 0 ? 25L : (long)(26 + s);
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                return this.precision >= 0L ? this.precision : 2L;
            }
            case 41: {
                return Integer.MAX_VALUE;
            }
            case 39: {
                return 16L;
            }
            case 40: {
                return this.precision >= 0L ? this.precision : 65536L;
            }
        }
        return this.precision;
    }

    public long getDeclaredPrecision() {
        return this.precision;
    }

    public int getScale() {
        switch (this.valueType) {
            case -1: {
                return -1;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                return 0;
            }
            case 13: {
                return this.scale >= 0 ? this.scale : 0;
            }
            case 18: 
            case 19: {
                return this.scale >= 0 ? this.scale : 0;
            }
            case 20: 
            case 21: {
                return this.scale >= 0 ? this.scale : 6;
            }
            case 27: 
            case 31: 
            case 33: 
            case 34: {
                return this.scale >= 0 ? this.scale : 6;
            }
        }
        return this.scale;
    }

    public int getDeclaredScale() {
        return this.scale;
    }

    public int getDisplaySize() {
        switch (this.valueType) {
            default: {
                return -1;
            }
            case 0: {
                return 4;
            }
            case 1: {
                return this.precision >= 0L ? (int)this.precision : 1;
            }
            case 2: 
            case 4: 
            case 38: {
                return this.precision >= 0L ? (int)this.precision : 1000000000;
            }
            case 3: {
                return this.precision >= 0L && this.precision <= Integer.MAX_VALUE ? (int)this.precision : Integer.MAX_VALUE;
            }
            case 5: {
                return this.precision >= 0L ? (int)this.precision * 2 : 2;
            }
            case 6: 
            case 35: {
                return this.precision >= 0L ? (int)this.precision * 2 : 2000000000;
            }
            case 7: {
                return this.precision >= 0L && this.precision <= 0x3FFFFFFFL ? (int)this.precision * 2 : Integer.MAX_VALUE;
            }
            case 8: {
                return 5;
            }
            case 9: {
                return 4;
            }
            case 10: {
                return 6;
            }
            case 11: {
                return 11;
            }
            case 12: {
                return 20;
            }
            case 13: {
                return this.precision >= 0L ? (int)this.precision + 2 : 100002;
            }
            case 14: {
                return 15;
            }
            case 15: {
                return 24;
            }
            case 16: {
                return this.precision >= 0L ? (int)this.precision + 12 : 100012;
            }
            case 17: {
                return 10;
            }
            case 18: {
                int s = this.scale >= 0 ? this.scale : 0;
                return s == 0 ? 8 : 9 + s;
            }
            case 19: {
                int s = this.scale >= 0 ? this.scale : 0;
                return s == 0 ? 14 : 15 + s;
            }
            case 20: {
                int s = this.scale >= 0 ? this.scale : 6;
                return s == 0 ? 19 : 20 + s;
            }
            case 21: {
                int s = this.scale >= 0 ? this.scale : 6;
                return s == 0 ? 25 : 26 + s;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                return ValueInterval.getDisplaySize(this.valueType, this.precision >= 0L ? (int)this.precision : 2, this.scale >= 0 ? this.scale : 6);
            }
            case 37: 
            case 40: 
            case 41: {
                return Integer.MAX_VALUE;
            }
            case 36: {
                return this.extTypeInfo != null ? (int)this.precision : 1000000000;
            }
            case 39: 
        }
        return 36;
    }

    public ExtTypeInfo getExtTypeInfo() {
        return this.extTypeInfo;
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        switch (this.valueType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 35: 
            case 38: {
                builder.append(Value.getTypeName(this.valueType));
                if (this.precision < 0L) break;
                builder.append('(').append(this.precision).append(')');
                break;
            }
            case 13: {
                boolean withScale;
                if (this.extTypeInfo != null) {
                    this.extTypeInfo.getSQL(builder, sqlFlags);
                } else {
                    builder.append("NUMERIC");
                }
                boolean withPrecision = this.precision >= 0L;
                boolean bl = withScale = this.scale >= 0;
                if (!withPrecision && !withScale) break;
                builder.append('(').append(withPrecision ? this.precision : 100000L);
                if (withScale) {
                    builder.append(", ").append(this.scale);
                }
                builder.append(')');
                break;
            }
            case 14: 
            case 15: {
                if (this.precision < 0L) {
                    builder.append(Value.getTypeName(this.valueType));
                    break;
                }
                builder.append("FLOAT");
                if (this.precision <= 0L) break;
                builder.append('(').append(this.precision).append(')');
                break;
            }
            case 16: {
                builder.append("DECFLOAT");
                if (this.precision < 0L) break;
                builder.append('(').append(this.precision).append(')');
                break;
            }
            case 18: 
            case 19: {
                builder.append("TIME");
                if (this.scale >= 0) {
                    builder.append('(').append(this.scale).append(')');
                }
                if (this.valueType != 19) break;
                builder.append(" WITH TIME ZONE");
                break;
            }
            case 20: 
            case 21: {
                builder.append("TIMESTAMP");
                if (this.scale >= 0) {
                    builder.append('(').append(this.scale).append(')');
                }
                if (this.valueType != 21) break;
                builder.append(" WITH TIME ZONE");
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                IntervalQualifier.valueOf(this.valueType - 22).getTypeName(builder, (int)this.precision, this.scale, false);
                break;
            }
            case 36: {
                this.extTypeInfo.getSQL(builder.append("ENUM"), sqlFlags);
                break;
            }
            case 37: {
                builder.append("GEOMETRY");
                if (this.extTypeInfo == null) break;
                this.extTypeInfo.getSQL(builder, sqlFlags);
                break;
            }
            case 40: {
                if (this.extTypeInfo != null) {
                    this.extTypeInfo.getSQL(builder, sqlFlags).append(' ');
                }
                builder.append("ARRAY");
                if (this.precision < 0L) break;
                builder.append('[').append(this.precision).append(']');
                break;
            }
            case 41: {
                builder.append("ROW");
                if (this.extTypeInfo == null) break;
                this.extTypeInfo.getSQL(builder, sqlFlags);
                break;
            }
            default: {
                builder.append(Value.getTypeName(this.valueType));
            }
        }
        return builder;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.valueType;
        result = 31 * result + (int)(this.precision ^ this.precision >>> 32);
        result = 31 * result + this.scale;
        result = 31 * result + (this.extTypeInfo == null ? 0 : this.extTypeInfo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != TypeInfo.class) {
            return false;
        }
        TypeInfo other = (TypeInfo)obj;
        return this.valueType == other.valueType && this.precision == other.precision && this.scale == other.scale && Objects.equals(this.extTypeInfo, other.extTypeInfo);
    }

    public TypeInfo toNumericType() {
        switch (this.valueType) {
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return TypeInfo.getTypeInfo(13, this.getDecimalPrecision(), 0, null);
            }
            case 12: {
                return TYPE_NUMERIC_BIGINT;
            }
            case 13: {
                return this;
            }
            case 14: {
                return TypeInfo.getTypeInfo(13, 85L, 46, null);
            }
            case 15: {
                return TypeInfo.getTypeInfo(13, 634L, 325, null);
            }
        }
        return TYPE_NUMERIC_FLOATING_POINT;
    }

    public TypeInfo toDecfloatType() {
        switch (this.valueType) {
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return TypeInfo.getTypeInfo(16, this.getDecimalPrecision(), 0, null);
            }
            case 12: {
                return TYPE_DECFLOAT_BIGINT;
            }
            case 13: {
                return TypeInfo.getTypeInfo(16, this.getPrecision(), 0, null);
            }
            case 14: {
                return TypeInfo.getTypeInfo(16, 7L, 0, null);
            }
            case 15: {
                return TypeInfo.getTypeInfo(16, 7L, 0, null);
            }
            case 16: {
                return this;
            }
        }
        return TYPE_DECFLOAT;
    }

    public TypeInfo unwrapRow() {
        Set<Map.Entry<String, TypeInfo>> fields;
        if (this.valueType == 41 && (fields = ((ExtTypeInfoRow)this.extTypeInfo).getFields()).size() == 1) {
            return fields.iterator().next().getValue().unwrapRow();
        }
        return this;
    }

    public long getDecimalPrecision() {
        switch (this.valueType) {
            case 9: {
                return 3L;
            }
            case 10: {
                return 5L;
            }
            case 11: {
                return 10L;
            }
            case 12: {
                return 19L;
            }
            case 14: {
                return 7L;
            }
            case 15: {
                return 17L;
            }
        }
        return this.precision;
    }

    public String getDeclaredTypeName() {
        switch (this.valueType) {
            case 13: {
                return this.extTypeInfo != null ? "DECIMAL" : "NUMERIC";
            }
            case 14: 
            case 15: {
                if (this.extTypeInfo == null) break;
                return "FLOAT";
            }
            case 36: 
            case 37: 
            case 41: {
                return this.getSQL(0);
            }
            case 40: {
                TypeInfo typeInfo = (TypeInfo)this.extTypeInfo;
                return typeInfo.getSQL(new StringBuilder(), 0).append(" ARRAY").toString();
            }
        }
        return Value.getTypeName(this.valueType);
    }

    static {
        TypeInfo[] infos = new TypeInfo[42];
        TYPE_UNKNOWN = new TypeInfo(-1);
        infos[0] = TYPE_NULL = new TypeInfo(0);
        infos[1] = TYPE_CHAR = new TypeInfo(1, -1L);
        infos[2] = TYPE_VARCHAR = new TypeInfo(2);
        infos[3] = TYPE_CLOB = new TypeInfo(3);
        infos[4] = TYPE_VARCHAR_IGNORECASE = new TypeInfo(4);
        infos[5] = TYPE_BINARY = new TypeInfo(5, -1L);
        infos[6] = TYPE_VARBINARY = new TypeInfo(6);
        infos[7] = TYPE_BLOB = new TypeInfo(7);
        infos[8] = TYPE_BOOLEAN = new TypeInfo(8);
        infos[9] = TYPE_TINYINT = new TypeInfo(9);
        infos[10] = TYPE_SMALLINT = new TypeInfo(10);
        infos[11] = TYPE_INTEGER = new TypeInfo(11);
        infos[12] = TYPE_BIGINT = new TypeInfo(12);
        TYPE_NUMERIC_SCALE_0 = new TypeInfo(13, 100000L, 0, null);
        TYPE_NUMERIC_BIGINT = new TypeInfo(13, 19L, 0, null);
        infos[13] = TYPE_NUMERIC_FLOATING_POINT = new TypeInfo(13, 100000L, 50000, null);
        infos[14] = TYPE_REAL = new TypeInfo(14);
        infos[15] = TYPE_DOUBLE = new TypeInfo(15);
        infos[16] = TYPE_DECFLOAT = new TypeInfo(16);
        TYPE_DECFLOAT_BIGINT = new TypeInfo(16, 19L);
        infos[17] = TYPE_DATE = new TypeInfo(17);
        infos[18] = TYPE_TIME = new TypeInfo(18, 9);
        infos[19] = TYPE_TIME_TZ = new TypeInfo(19, 9);
        infos[20] = TYPE_TIMESTAMP = new TypeInfo(20, 9);
        infos[21] = TYPE_TIMESTAMP_TZ = new TypeInfo(21, 9);
        for (int i = 22; i <= 34; ++i) {
            infos[i] = new TypeInfo(i, 18L, IntervalQualifier.valueOf(i - 22).hasSeconds() ? 9 : -1, null);
        }
        TYPE_INTERVAL_DAY = infos[24];
        TYPE_INTERVAL_YEAR_TO_MONTH = infos[28];
        TYPE_INTERVAL_DAY_TO_SECOND = infos[31];
        TYPE_INTERVAL_HOUR_TO_SECOND = infos[33];
        infos[35] = TYPE_JAVA_OBJECT = new TypeInfo(35);
        infos[36] = TYPE_ENUM_UNDEFINED = new TypeInfo(36);
        infos[37] = TYPE_GEOMETRY = new TypeInfo(37);
        infos[38] = TYPE_JSON = new TypeInfo(38);
        infos[39] = TYPE_UUID = new TypeInfo(39);
        infos[40] = TYPE_ARRAY_UNKNOWN = new TypeInfo(40);
        infos[41] = TYPE_ROW_EMPTY = new TypeInfo(41, -1L, -1, new ExtTypeInfoRow(new LinkedHashMap<String, TypeInfo>()));
        TYPE_INFOS_BY_VALUE_TYPE = infos;
    }
}

