/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.h2.engine.CastDataProvider;
import org.h2.message.DbException;
import org.h2.util.Bits;
import org.h2.value.CompareMode;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

public final class ValueBigint
extends Value {
    public static final ValueBigint MIN = ValueBigint.get(Long.MIN_VALUE);
    public static final ValueBigint MAX = ValueBigint.get(Long.MAX_VALUE);
    public static final BigInteger MAX_BI = BigInteger.valueOf(Long.MAX_VALUE);
    static final int PRECISION = 64;
    public static final int DECIMAL_PRECISION = 19;
    public static final int DISPLAY_SIZE = 20;
    private static final int STATIC_SIZE = 100;
    private static final ValueBigint[] STATIC_CACHE = new ValueBigint[100];
    private final long value;

    private ValueBigint(long value) {
        this.value = value;
    }

    @Override
    public Value add(Value v) {
        long x = this.value;
        long y = ((ValueBigint)v).value;
        long result = x + y;
        if (((x ^ result) & (y ^ result)) < 0L) {
            throw this.getOverflow();
        }
        return ValueBigint.get(result);
    }

    @Override
    public int getSignum() {
        return Long.signum(this.value);
    }

    @Override
    public Value negate() {
        if (this.value == Long.MIN_VALUE) {
            throw this.getOverflow();
        }
        return ValueBigint.get(-this.value);
    }

    private DbException getOverflow() {
        return DbException.get(22003, Long.toString(this.value));
    }

    @Override
    public Value subtract(Value v) {
        long x = this.value;
        long y = ((ValueBigint)v).value;
        long result = x - y;
        if (((x ^ y) & (x ^ result)) < 0L) {
            throw this.getOverflow();
        }
        return ValueBigint.get(result);
    }

    @Override
    public Value multiply(Value v) {
        long x = this.value;
        long y = ((ValueBigint)v).value;
        long result = x * y;
        if ((Math.abs(x) | Math.abs(y)) >>> 31 != 0L && y != 0L && (result / y != x || x == Long.MIN_VALUE && y == -1L)) {
            throw this.getOverflow();
        }
        return ValueBigint.get(result);
    }

    @Override
    public Value divide(Value v, TypeInfo quotientType) {
        long y = ((ValueBigint)v).value;
        if (y == 0L) {
            throw DbException.get(22012, this.getTraceSQL());
        }
        long x = this.value;
        if (x == Long.MIN_VALUE && y == -1L) {
            throw this.getOverflow();
        }
        return ValueBigint.get(x / y);
    }

    @Override
    public Value modulus(Value v) {
        ValueBigint other = (ValueBigint)v;
        if (other.value == 0L) {
            throw DbException.get(22012, this.getTraceSQL());
        }
        return ValueBigint.get(this.value % other.value);
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        if ((sqlFlags & 4) == 0 && this.value == (long)((int)this.value)) {
            return builder.append("CAST(").append(this.value).append(" AS BIGINT)");
        }
        return builder.append(this.value);
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_BIGINT;
    }

    @Override
    public int getValueType() {
        return 12;
    }

    @Override
    public byte[] getBytes() {
        byte[] b = new byte[8];
        Bits.writeLong(b, 0, this.getLong());
        return b;
    }

    @Override
    public long getLong() {
        return this.value;
    }

    @Override
    public BigDecimal getBigDecimal() {
        return BigDecimal.valueOf(this.value);
    }

    @Override
    public float getFloat() {
        return this.value;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public int compareTypeSafe(Value o, CompareMode mode, CastDataProvider provider) {
        return Long.compare(this.value, ((ValueBigint)o).value);
    }

    @Override
    public String getString() {
        return Long.toString(this.value);
    }

    @Override
    public int hashCode() {
        return (int)(this.value ^ this.value >> 32);
    }

    public static ValueBigint get(long i) {
        if (i >= 0L && i < 100L) {
            return STATIC_CACHE[(int)i];
        }
        return (ValueBigint)Value.cache(new ValueBigint(i));
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ValueBigint && this.value == ((ValueBigint)other).value;
    }

    static {
        for (int i = 0; i < 100; ++i) {
            ValueBigint.STATIC_CACHE[i] = new ValueBigint(i);
        }
    }
}

