/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import org.h2.engine.CastDataProvider;
import org.h2.engine.SysProperties;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueStringBase;

public final class ValueChar
extends ValueStringBase {
    private ValueChar(String value) {
        super(value);
    }

    @Override
    public int getValueType() {
        return 1;
    }

    @Override
    public int compareTypeSafe(Value v, CompareMode mode, CastDataProvider provider) {
        return mode.compareString(this.convertToChar().getString(), v.convertToChar().getString(), false);
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        if ((sqlFlags & 4) == 0) {
            int length = this.value.length();
            return StringUtils.quoteStringSQL(builder.append("CAST("), this.value).append(" AS CHAR(").append(length > 0 ? length : 1).append("))");
        }
        return StringUtils.quoteStringSQL(builder, this.value);
    }

    public static ValueChar get(String s) {
        ValueChar obj = new ValueChar(StringUtils.cache(s));
        if (s.length() > SysProperties.OBJECT_CACHE_MAX_PER_ELEMENT_SIZE) {
            return obj;
        }
        return (ValueChar)Value.cache(obj);
    }
}

