/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import org.h2.engine.CastDataProvider;
import org.h2.message.DbException;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public abstract class ValueCollectionBase
extends Value {
    final Value[] values;
    private int hash;

    ValueCollectionBase(Value[] values) {
        this.values = values;
    }

    public Value[] getList() {
        return this.values;
    }

    @Override
    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        int h = this.getValueType();
        for (Value v : this.values) {
            h = h * 31 + v.hashCode();
        }
        this.hash = h;
        return h;
    }

    @Override
    public int compareWithNull(Value v, boolean forEquality, CastDataProvider provider, CompareMode compareMode) {
        if (v == ValueNull.INSTANCE) {
            return Integer.MIN_VALUE;
        }
        ValueCollectionBase l = this;
        int leftType = l.getValueType();
        int rightType = v.getValueType();
        if (rightType != leftType) {
            throw v.getDataConversionError(leftType);
        }
        ValueCollectionBase r = (ValueCollectionBase)v;
        Value[] leftArray = l.values;
        int leftLength = leftArray.length;
        Value[] rightArray = r.values;
        int rightLength = rightArray.length;
        if (leftLength != rightLength) {
            if (leftType == 41) {
                throw DbException.get(21002);
            }
            if (forEquality) {
                return 1;
            }
        }
        if (forEquality) {
            boolean hasNull = false;
            for (int i = 0; i < leftLength; ++i) {
                Value v1 = leftArray[i];
                Value v2 = rightArray[i];
                int comp = v1.compareWithNull(v2, forEquality, provider, compareMode);
                if (comp == 0) continue;
                if (comp != Integer.MIN_VALUE) {
                    return comp;
                }
                hasNull = true;
            }
            return hasNull ? Integer.MIN_VALUE : 0;
        }
        int len = Math.min(leftLength, rightLength);
        for (int i = 0; i < len; ++i) {
            Value v1 = leftArray[i];
            Value v2 = rightArray[i];
            int comp = v1.compareWithNull(v2, forEquality, provider, compareMode);
            if (comp == 0) continue;
            return comp;
        }
        return Integer.compare(leftLength, rightLength);
    }

    @Override
    public boolean containsNull() {
        for (Value v : this.values) {
            if (!v.containsNull()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getMemory() {
        int memory = 72 + this.values.length * 8;
        for (Value v : this.values) {
            memory += v.getMemory();
        }
        return memory;
    }
}

