/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.h2.engine.CastDataProvider;
import org.h2.message.DbException;
import org.h2.value.CompareMode;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBigDecimalBase;

public final class ValueNumeric
extends ValueBigDecimalBase {
    public static final ValueNumeric ZERO = new ValueNumeric(BigDecimal.ZERO);
    public static final ValueNumeric ONE = new ValueNumeric(BigDecimal.ONE);
    public static final int DEFAULT_SCALE = 0;
    public static final int MAXIMUM_SCALE = 100000;

    private ValueNumeric(BigDecimal value) {
        super(value);
        if (value == null) {
            throw new IllegalArgumentException("null");
        }
        int scale = value.scale();
        if (scale < 0 || scale > 100000) {
            throw DbException.get(90151, Integer.toString(scale), "0", "100000");
        }
    }

    @Override
    public String getString() {
        return this.value.toPlainString();
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        String s = this.getString();
        if ((sqlFlags & 4) == 0 && s.indexOf(46) < 0 && this.value.compareTo(MAX_LONG_DECIMAL) <= 0 && this.value.compareTo(MIN_LONG_DECIMAL) >= 0) {
            return builder.append("CAST(").append(this.value).append(" AS NUMERIC(").append(this.value.precision()).append("))");
        }
        return builder.append(s);
    }

    @Override
    public TypeInfo getType() {
        TypeInfo type = this.type;
        if (type == null) {
            this.type = type = new TypeInfo(13, this.value.precision(), this.value.scale(), null);
        }
        return type;
    }

    @Override
    public int getValueType() {
        return 13;
    }

    @Override
    public Value add(Value v) {
        return ValueNumeric.get(this.value.add(((ValueNumeric)v).value));
    }

    @Override
    public Value subtract(Value v) {
        return ValueNumeric.get(this.value.subtract(((ValueNumeric)v).value));
    }

    @Override
    public Value negate() {
        return ValueNumeric.get(this.value.negate());
    }

    @Override
    public Value multiply(Value v) {
        return ValueNumeric.get(this.value.multiply(((ValueNumeric)v).value));
    }

    @Override
    public Value divide(Value v, TypeInfo quotientType) {
        BigDecimal divisor = ((ValueNumeric)v).value;
        if (divisor.signum() == 0) {
            throw DbException.get(22012, this.getTraceSQL());
        }
        return ValueNumeric.get(this.value.divide(divisor, quotientType.getScale(), RoundingMode.HALF_DOWN));
    }

    @Override
    public Value modulus(Value v) {
        ValueNumeric dec = (ValueNumeric)v;
        if (dec.value.signum() == 0) {
            throw DbException.get(22012, this.getTraceSQL());
        }
        return ValueNumeric.get(this.value.remainder(dec.value));
    }

    @Override
    public int compareTypeSafe(Value o, CompareMode mode, CastDataProvider provider) {
        return this.value.compareTo(((ValueNumeric)o).value);
    }

    @Override
    public int getSignum() {
        return this.value.signum();
    }

    @Override
    public BigDecimal getBigDecimal() {
        return this.value;
    }

    @Override
    public float getFloat() {
        return this.value.floatValue();
    }

    @Override
    public double getDouble() {
        return this.value.doubleValue();
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode() * 31 + this.value.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ValueNumeric && this.value.equals(((ValueNumeric)other).value);
    }

    @Override
    public int getMemory() {
        return this.value.precision() + 120;
    }

    public static ValueNumeric get(BigDecimal dec) {
        if (BigDecimal.ZERO.equals(dec)) {
            return ZERO;
        }
        if (BigDecimal.ONE.equals(dec)) {
            return ONE;
        }
        return (ValueNumeric)Value.cache(new ValueNumeric(dec));
    }

    public static ValueNumeric getAnyScale(BigDecimal dec) {
        if (dec.scale() < 0) {
            dec = dec.setScale(0, RoundingMode.UNNECESSARY);
        }
        return ValueNumeric.get(dec);
    }

    public static ValueNumeric get(BigInteger bigInteger) {
        if (bigInteger.signum() == 0) {
            return ZERO;
        }
        if (BigInteger.ONE.equals(bigInteger)) {
            return ONE;
        }
        return (ValueNumeric)Value.cache(new ValueNumeric(new BigDecimal(bigInteger)));
    }

    public static BigDecimal setScale(BigDecimal bd, int scale) {
        if (scale < 0 || scale > 100000) {
            throw DbException.getInvalidValueException("scale", scale);
        }
        return bd.setScale(scale, RoundingMode.HALF_UP);
    }
}

