/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import org.h2.engine.CastDataProvider;
import org.h2.message.DbException;
import org.h2.util.DateTimeUtils;
import org.h2.value.CompareMode;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

public final class ValueTimeTimeZone
extends Value {
    public static final int DEFAULT_PRECISION = 14;
    public static final int MAXIMUM_PRECISION = 24;
    private final long nanos;
    private final int timeZoneOffsetSeconds;

    private ValueTimeTimeZone(long nanos, int timeZoneOffsetSeconds) {
        this.nanos = nanos;
        this.timeZoneOffsetSeconds = timeZoneOffsetSeconds;
    }

    public static ValueTimeTimeZone fromNanos(long nanos, int timeZoneOffsetSeconds) {
        if (nanos < 0L || nanos >= 86400000000000L) {
            throw DbException.get(22007, "TIME WITH TIME ZONE", DateTimeUtils.appendTime(new StringBuilder(), nanos).toString());
        }
        if (timeZoneOffsetSeconds < -64800 || timeZoneOffsetSeconds > 64800) {
            throw new IllegalArgumentException("timeZoneOffsetSeconds " + timeZoneOffsetSeconds);
        }
        return (ValueTimeTimeZone)Value.cache(new ValueTimeTimeZone(nanos, timeZoneOffsetSeconds));
    }

    public static ValueTimeTimeZone parse(String s) {
        try {
            return DateTimeUtils.parseTimeWithTimeZone(s, null);
        }
        catch (Exception e) {
            throw DbException.get(22007, e, "TIME WITH TIME ZONE", s);
        }
    }

    public long getNanos() {
        return this.nanos;
    }

    public int getTimeZoneOffsetSeconds() {
        return this.timeZoneOffsetSeconds;
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_TIME_TZ;
    }

    @Override
    public int getValueType() {
        return 19;
    }

    @Override
    public int getMemory() {
        return 32;
    }

    @Override
    public String getString() {
        return this.toString(new StringBuilder(24)).toString();
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        return this.toString(builder.append("TIME WITH TIME ZONE '")).append('\'');
    }

    private StringBuilder toString(StringBuilder builder) {
        return DateTimeUtils.appendTimeZone(DateTimeUtils.appendTime(builder, this.nanos), this.timeZoneOffsetSeconds);
    }

    @Override
    public int compareTypeSafe(Value o, CompareMode mode, CastDataProvider provider) {
        ValueTimeTimeZone t = (ValueTimeTimeZone)o;
        return Long.compare(this.nanos - (long)this.timeZoneOffsetSeconds * 1000000000L, t.nanos - (long)t.timeZoneOffsetSeconds * 1000000000L);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ValueTimeTimeZone)) {
            return false;
        }
        ValueTimeTimeZone t = (ValueTimeTimeZone)other;
        return this.nanos == t.nanos && this.timeZoneOffsetSeconds == t.timeZoneOffsetSeconds;
    }

    @Override
    public int hashCode() {
        return (int)(this.nanos ^ this.nanos >>> 32 ^ (long)this.timeZoneOffsetSeconds);
    }
}

