/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.math.BigDecimal;
import org.h2.engine.CastDataProvider;
import org.h2.message.DbException;
import org.h2.value.CompareMode;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

public final class ValueTinyint
extends Value {
    static final int PRECISION = 8;
    public static final int DECIMAL_PRECISION = 3;
    static final int DISPLAY_SIZE = 4;
    private final byte value;

    private ValueTinyint(byte value) {
        this.value = value;
    }

    @Override
    public Value add(Value v) {
        ValueTinyint other = (ValueTinyint)v;
        return ValueTinyint.checkRange(this.value + other.value);
    }

    private static ValueTinyint checkRange(int x) {
        if ((byte)x != x) {
            throw DbException.get(22003, Integer.toString(x));
        }
        return ValueTinyint.get((byte)x);
    }

    @Override
    public int getSignum() {
        return Integer.signum(this.value);
    }

    @Override
    public Value negate() {
        return ValueTinyint.checkRange(-this.value);
    }

    @Override
    public Value subtract(Value v) {
        ValueTinyint other = (ValueTinyint)v;
        return ValueTinyint.checkRange(this.value - other.value);
    }

    @Override
    public Value multiply(Value v) {
        ValueTinyint other = (ValueTinyint)v;
        return ValueTinyint.checkRange(this.value * other.value);
    }

    @Override
    public Value divide(Value v, TypeInfo quotientType) {
        ValueTinyint other = (ValueTinyint)v;
        if (other.value == 0) {
            throw DbException.get(22012, this.getTraceSQL());
        }
        return ValueTinyint.checkRange(this.value / other.value);
    }

    @Override
    public Value modulus(Value v) {
        ValueTinyint other = (ValueTinyint)v;
        if (other.value == 0) {
            throw DbException.get(22012, this.getTraceSQL());
        }
        return ValueTinyint.get((byte)(this.value % other.value));
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        if ((sqlFlags & 4) == 0) {
            return builder.append("CAST(").append(this.value).append(" AS TINYINT)");
        }
        return builder.append(this.value);
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_TINYINT;
    }

    @Override
    public int getValueType() {
        return 9;
    }

    @Override
    public byte[] getBytes() {
        return new byte[]{this.value};
    }

    @Override
    public byte getByte() {
        return this.value;
    }

    @Override
    public short getShort() {
        return this.value;
    }

    @Override
    public int getInt() {
        return this.value;
    }

    @Override
    public long getLong() {
        return this.value;
    }

    @Override
    public BigDecimal getBigDecimal() {
        return BigDecimal.valueOf(this.value);
    }

    @Override
    public float getFloat() {
        return this.value;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public int compareTypeSafe(Value o, CompareMode mode, CastDataProvider provider) {
        return Integer.compare(this.value, ((ValueTinyint)o).value);
    }

    @Override
    public String getString() {
        return Integer.toString(this.value);
    }

    @Override
    public int hashCode() {
        return this.value;
    }

    public static ValueTinyint get(byte i) {
        return (ValueTinyint)Value.cache(new ValueTinyint(i));
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ValueTinyint && this.value == ((ValueTinyint)other).value;
    }
}

