/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.util.UUID;
import org.h2.engine.CastDataProvider;
import org.h2.message.DbException;
import org.h2.util.Bits;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

public final class ValueUuid
extends Value {
    static final int PRECISION = 16;
    static final int DISPLAY_SIZE = 36;
    private final long high;
    private final long low;

    private ValueUuid(long high, long low) {
        this.high = high;
        this.low = low;
    }

    @Override
    public int hashCode() {
        return (int)(this.high >>> 32 ^ this.high ^ this.low >>> 32 ^ this.low);
    }

    public static ValueUuid getNewRandom() {
        long high = MathUtils.secureRandomLong();
        long low = MathUtils.secureRandomLong();
        high = high & 0xFFFFFFFFFFFF0FFFL | 0x4000L;
        low = low & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE;
        return new ValueUuid(high, low);
    }

    public static ValueUuid get(byte[] binary) {
        int length = binary.length;
        if (length != 16) {
            throw DbException.get(22018, "UUID requires 16 bytes, got " + length);
        }
        return ValueUuid.get(Bits.readLong(binary, 0), Bits.readLong(binary, 8));
    }

    public static ValueUuid get(long high, long low) {
        return (ValueUuid)Value.cache(new ValueUuid(high, low));
    }

    public static ValueUuid get(UUID uuid) {
        return ValueUuid.get(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    public static ValueUuid get(String s) {
        long low = 0L;
        long high = 0L;
        int j = 0;
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9') {
                low = low << 4 | (long)(c - 48);
            } else if (c >= 'a' && c <= 'f') {
                low = low << 4 | (long)(c - 87);
            } else {
                if (c == '-') continue;
                if (c >= 'A' && c <= 'F') {
                    low = low << 4 | (long)(c - 55);
                } else {
                    if (c <= ' ') continue;
                    throw DbException.get(22018, s);
                }
            }
            if (++j != 16) continue;
            high = low;
            low = 0L;
        }
        if (j != 32) {
            throw DbException.get(22018, s);
        }
        return ValueUuid.get(high, low);
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        return this.addString(builder.append("UUID '")).append('\'');
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_UUID;
    }

    @Override
    public int getMemory() {
        return 32;
    }

    @Override
    public int getValueType() {
        return 39;
    }

    @Override
    public String getString() {
        return this.addString(new StringBuilder(36)).toString();
    }

    @Override
    public byte[] getBytes() {
        return Bits.uuidToBytes(this.high, this.low);
    }

    private StringBuilder addString(StringBuilder builder) {
        StringUtils.appendHex(builder, this.high >> 32, 4).append('-');
        StringUtils.appendHex(builder, this.high >> 16, 2).append('-');
        StringUtils.appendHex(builder, this.high, 2).append('-');
        StringUtils.appendHex(builder, this.low >> 48, 2).append('-');
        return StringUtils.appendHex(builder, this.low, 6);
    }

    @Override
    public int compareTypeSafe(Value o, CompareMode mode, CastDataProvider provider) {
        if (o == this) {
            return 0;
        }
        ValueUuid v = (ValueUuid)o;
        int cmp = Long.compareUnsigned(this.high, v.high);
        return cmp != 0 ? cmp : Long.compareUnsigned(this.low, v.low);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof ValueUuid)) {
            return false;
        }
        ValueUuid v = (ValueUuid)other;
        return this.high == v.high && this.low == v.low;
    }

    public UUID getUuid() {
        return new UUID(this.high, this.low);
    }

    public long getHigh() {
        return this.high;
    }

    public long getLow() {
        return this.low;
    }

    @Override
    public long charLength() {
        return 36L;
    }

    @Override
    public long octetLength() {
        return 16L;
    }
}

