/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.nio.charset.StandardCharsets;
import org.h2.engine.SysProperties;
import org.h2.util.Utils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBytesBase;

public final class ValueVarbinary
extends ValueBytesBase {
    public static final ValueVarbinary EMPTY = new ValueVarbinary(Utils.EMPTY_BYTES);
    private TypeInfo type;

    private ValueVarbinary(byte[] value) {
        super(value);
    }

    public static ValueVarbinary get(byte[] b) {
        if (b.length == 0) {
            return EMPTY;
        }
        b = Utils.cloneByteArray(b);
        return ValueVarbinary.getNoCopy(b);
    }

    public static ValueVarbinary getNoCopy(byte[] b) {
        if (b.length == 0) {
            return EMPTY;
        }
        ValueVarbinary obj = new ValueVarbinary(b);
        if (b.length > SysProperties.OBJECT_CACHE_MAX_PER_ELEMENT_SIZE) {
            return obj;
        }
        return (ValueVarbinary)Value.cache(obj);
    }

    @Override
    public TypeInfo getType() {
        TypeInfo type = this.type;
        if (type == null) {
            long precision = this.value.length;
            this.type = type = new TypeInfo(6, precision, 0, null);
        }
        return type;
    }

    @Override
    public int getValueType() {
        return 6;
    }

    @Override
    public String getString() {
        return new String(this.value, StandardCharsets.UTF_8);
    }
}

