/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.logback;

import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.ElementSelector;
import ch.qos.logback.core.joran.spi.RuleStore;
import ch.qos.logback.core.joran.util.PropertySetter;
import ch.qos.logback.core.joran.util.beans.BeanDescription;
import ch.qos.logback.core.model.ComponentModel;
import ch.qos.logback.core.model.IncludeModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.DefaultProcessor;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.AggregationType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.boot.logging.LoggingInitializationContext;
import org.springframework.boot.logging.logback.SpringProfileAction;
import org.springframework.boot.logging.logback.SpringProfileIfNestedWithinSecondPhaseElementSanityChecker;
import org.springframework.boot.logging.logback.SpringProfileModel;
import org.springframework.boot.logging.logback.SpringProfileModelHandler;
import org.springframework.boot.logging.logback.SpringPropertyAction;
import org.springframework.boot.logging.logback.SpringPropertyModel;
import org.springframework.boot.logging.logback.SpringPropertyModelHandler;
import org.springframework.core.CollectionFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.function.SingletonSupplier;

class SpringBootJoranConfigurator
extends JoranConfigurator {
    private final LoggingInitializationContext initializationContext;

    SpringBootJoranConfigurator(LoggingInitializationContext initializationContext) {
        this.initializationContext = initializationContext;
    }

    protected void sanityCheck(Model topModel) {
        super.sanityCheck(topModel);
        this.performCheck(new SpringProfileIfNestedWithinSecondPhaseElementSanityChecker(), topModel);
    }

    protected void addModelHandlerAssociations(DefaultProcessor defaultProcessor) {
        defaultProcessor.addHandler(SpringPropertyModel.class, (handlerContext, handlerMic) -> new SpringPropertyModelHandler(this.context, this.initializationContext.getEnvironment()));
        defaultProcessor.addHandler(SpringProfileModel.class, (handlerContext, handlerMic) -> new SpringProfileModelHandler(this.context, this.initializationContext.getEnvironment()));
        super.addModelHandlerAssociations(defaultProcessor);
    }

    public void addElementSelectorAndActionAssociations(RuleStore ruleStore) {
        super.addElementSelectorAndActionAssociations(ruleStore);
        ruleStore.addRule(new ElementSelector("configuration/springProperty"), SpringPropertyAction::new);
        ruleStore.addRule(new ElementSelector("*/springProfile"), SpringProfileAction::new);
        ruleStore.addTransparentPathPart("springProfile");
    }

    public void buildModelInterpretationContext() {
        super.buildModelInterpretationContext();
    }

    boolean configureUsingAotGeneratedArtifacts() {
        if (!new PatternRules(this.getContext()).load()) {
            return false;
        }
        Model model = new ModelReader().read();
        this.processModel(model);
        this.registerSafeConfiguration(model);
        return true;
    }

    public void processModel(Model model) {
        super.processModel(model);
    }

    private static final class PatternRules {
        private static final String RESOURCE_LOCATION = "META-INF/spring/logback-pattern-rules";
        private final Context context;

        private PatternRules(Context context) {
            this.context = context;
        }

        private boolean load() {
            try {
                ClassPathResource resource = new ClassPathResource(RESOURCE_LOCATION);
                if (!resource.exists()) {
                    return false;
                }
                Properties properties = PropertiesLoaderUtils.loadProperties((Resource)resource);
                Map<String, String> patternRuleRegistry = this.getRegistryMap();
                for (String word : properties.stringPropertyNames()) {
                    patternRuleRegistry.put(word, properties.getProperty(word));
                }
                return true;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        private Map<String, String> getRegistryMap() {
            HashMap patternRuleRegistry = (HashMap)this.context.getObject("PATTERN_RULE_REGISTRY");
            if (patternRuleRegistry == null) {
                patternRuleRegistry = new HashMap();
                this.context.putObject("PATTERN_RULE_REGISTRY", patternRuleRegistry);
            }
            return patternRuleRegistry;
        }

        private byte[] asBytes(Map<String, String> patternRuleRegistry) {
            Properties properties = CollectionFactory.createSortedProperties((boolean)true);
            patternRuleRegistry.forEach(properties::setProperty);
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            try {
                properties.store(bytes, "");
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            return bytes.toByteArray();
        }
    }

    private static final class ModelReader {
        private ModelReader() {
        }

        /*
         * Exception decompiling
         */
        private Model read() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void markIncludesAsHandled(Model model) {
            if (model instanceof IncludeModel) {
                model.markAsHandled();
            }
            for (Model submodel : model.getSubModels()) {
                this.markIncludesAsHandled(submodel);
            }
        }
    }

    private static final class ModelWriter {
        private static final String MODEL_RESOURCE_LOCATION = "META-INF/spring/logback-model";
        private final Model model;
        private final ModelInterpretationContext modelInterpretationContext;

        private ModelWriter(Model model, ModelInterpretationContext modelInterpretationContext) {
            this.model = model;
            this.modelInterpretationContext = modelInterpretationContext;
        }

        private byte[] serializeModel() {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            try (ObjectOutputStream output = new ObjectOutputStream(bytes);){
                output.writeObject(this.model);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            return bytes.toByteArray();
        }

        private Set<Class<? extends Serializable>> serializationTypes(Model model) {
            HashSet<Class<? extends Serializable>> modelClasses = new HashSet<Class<? extends Serializable>>();
            Class<?> candidate = model.getClass();
            while (Model.class.isAssignableFrom(candidate)) {
                if (!modelClasses.add(candidate)) continue;
                ReflectionUtils.doWithFields(candidate, field -> {
                    Class<?> fieldType;
                    if (Modifier.isStatic(field.getModifiers())) {
                        return;
                    }
                    ReflectionUtils.makeAccessible((Field)field);
                    Object value = field.get(model);
                    if (value != null && Serializable.class.isAssignableFrom(fieldType = value.getClass())) {
                        modelClasses.add(fieldType);
                    }
                });
                candidate = candidate.getSuperclass();
            }
            for (Model submodel : model.getSubModels()) {
                modelClasses.addAll(this.serializationTypes(submodel));
            }
            return modelClasses;
        }

        private Set<Class<?>> reflectionTypes(Model model) {
            return this.reflectionTypes(model, () -> null);
        }

        private Set<Class<?>> reflectionTypes(Model model, Supplier<Object> parent) {
            HashSet reflectionTypes = new HashSet();
            Class<?> componentType = this.determineType(model, parent);
            if (componentType != null) {
                this.processComponent(componentType, reflectionTypes);
            }
            SingletonSupplier componentSupplier = SingletonSupplier.ofNullable(() -> this.instantiate(componentType));
            for (Model submodel : model.getSubModels()) {
                reflectionTypes.addAll(this.reflectionTypes(submodel, (Supplier<Object>)componentSupplier));
            }
            return reflectionTypes;
        }

        private Class<?> determineType(Model model, Supplier<Object> parentSupplier) {
            String className;
            String string = className = model instanceof ComponentModel ? ((ComponentModel)model).getClassName() : null;
            if (className != null) {
                return this.loadImportType(className);
            }
            String tag = model.getTag();
            if (tag != null) {
                className = this.modelInterpretationContext.getDefaultNestedComponentRegistry().findDefaultComponentTypeByTag(tag);
                if (className != null) {
                    return this.loadImportType(className);
                }
                return this.inferTypeFromParent(parentSupplier, tag);
            }
            return null;
        }

        private Class<?> loadImportType(String className) {
            return this.loadComponentType(this.modelInterpretationContext.getImport(className));
        }

        private Class<?> inferTypeFromParent(Supplier<Object> parentSupplier, String tag) {
            Object parent = parentSupplier.get();
            if (parent != null) {
                try {
                    PropertySetter propertySetter = new PropertySetter(this.modelInterpretationContext.getBeanDescriptionCache(), parent);
                    Class typeFromPropertySetter = propertySetter.getClassNameViaImplicitRules(tag, AggregationType.AS_COMPLEX_PROPERTY, this.modelInterpretationContext.getDefaultNestedComponentRegistry());
                    return typeFromPropertySetter;
                }
                catch (Exception ex) {
                    return null;
                }
            }
            return null;
        }

        private Class<?> loadComponentType(String componentType) {
            try {
                return ClassUtils.forName((String)this.modelInterpretationContext.subst(componentType), (ClassLoader)this.getClass().getClassLoader());
            }
            catch (Throwable ex) {
                throw new RuntimeException("Failed to load component type '" + componentType + "'", ex);
            }
        }

        private Object instantiate(Class<?> type) {
            try {
                return type.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                return null;
            }
        }

        private void processComponent(Class<?> componentType, Set<Class<?>> reflectionTypes) {
            BeanDescription beanDescription = this.modelInterpretationContext.getBeanDescriptionCache().getBeanDescription(componentType);
            reflectionTypes.addAll(this.parameterTypesNames(beanDescription.getPropertyNameToAdder().values()));
            reflectionTypes.addAll(this.parameterTypesNames(beanDescription.getPropertyNameToSetter().values()));
            reflectionTypes.add(componentType);
        }

        private Collection<Class<?>> parameterTypesNames(Collection<Method> methods) {
            return methods.stream().filter(method -> !method.getDeclaringClass().equals(ContextAware.class) && !method.getDeclaringClass().equals(ContextAwareBase.class)).map(Method::getParameterTypes).flatMap(Stream::of).filter(type -> !type.isPrimitive() && !type.equals(String.class)).map(type -> type.isArray() ? type.getComponentType() : type).collect(Collectors.toList());
        }
    }
}

