/*
 * Decompiled with CFR 0.152.
 */
package net.xyzsd.dichotomy;

import net.xyzsd.dichotomy.Either;
import net.xyzsd.dichotomy.Result;
import net.xyzsd.dichotomy.trying.Try;
import org.jetbrains.annotations.NotNull;

public interface Conversion {
    @NotNull
    public static <L, R> Either<L, R> toEither(@NotNull Result<R, L> result) {
        return result.fold(Either::ofRight, Either::ofLeft);
    }

    @NotNull
    public static <V> Either<Throwable, V> toEither(@NotNull Try<V> tri) {
        return tri.fold(Either::ofRight, Either::ofLeft);
    }

    @NotNull
    public static <L, R> Result<R, L> toResult(@NotNull Either<L, R> either) {
        return either.fold(Result::ofErr, Result::ofOK);
    }

    @NotNull
    public static <V> Result<V, Throwable> toResult(@NotNull Try<V> tri) {
        return tri.fold(Result::ofOK, Result::ofErr);
    }

    @NotNull
    public static <L extends Exception, R> Try<R> toTry(@NotNull Either<L, R> either) {
        return either.fold(Try::ofFailure, Try::ofSuccess);
    }

    @NotNull
    public static <V, X extends Exception> Try<V> toTry(@NotNull Result<V, X> result) {
        return result.fold(Try::ofSuccess, Try::ofFailure);
    }
}

