/*
 * Decompiled with CFR 0.152.
 */
package net.xyzsd.dichotomy;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface Either<L, R> {
    @NotNull
    public static <L, R> Either<L, R> ofLeft(@NotNull L value) {
        return new Left(value);
    }

    @NotNull
    public static <L, R> Either<L, R> ofRight(@NotNull R value) {
        return new Right(value);
    }

    public boolean isLeft();

    public boolean isRight();

    @NotNull
    public Optional<L> left();

    @NotNull
    public Optional<R> right();

    @NotNull
    public Either<L, R> biMatch(@NotNull Consumer<? super L> var1, @NotNull Consumer<? super R> var2);

    @NotNull
    public <L2, R2> Either<L2, R2> biMap(@NotNull Function<? super L, ? extends L2> var1, @NotNull Function<? super R, ? extends R2> var2);

    @NotNull
    public <L2, R2> Either<L2, R2> biFlatMap(@NotNull Function<? super L, ? extends Either<? extends L2, ? extends R2>> var1, @NotNull Function<? super R, ? extends Either<? extends L2, ? extends R2>> var2);

    @NotNull
    public <T> T fold(@NotNull Function<? super L, ? extends T> var1, @NotNull Function<? super R, ? extends T> var2);

    @NotNull
    public Either<L, R> filter(@NotNull Predicate<? super R> var1, @NotNull Function<? super R, ? extends L> var2);

    @NotNull
    public L forfeit(@NotNull Function<? super R, ? extends L> var1);

    @NotNull
    public R recover(@NotNull Function<? super L, ? extends R> var1);

    @NotNull
    public Stream<R> stream();

    @NotNull
    public Stream<L> streamLeft();

    public boolean contains(@Nullable R var1);

    public boolean containsLeft(@Nullable L var1);

    public boolean ifPredicate(@NotNull Predicate<R> var1);

    public boolean ifPredicateLeft(@NotNull Predicate<L> var1);

    @NotNull
    public <R2> Either<L, R2> map(@NotNull Function<? super R, ? extends R2> var1);

    @NotNull
    public <R2> Either<L, R2> flatMap(@NotNull Function<? super R, ? extends Either<? extends L, ? extends R2>> var1);

    @NotNull
    public <L2> Either<L2, R> mapLeft(@NotNull Function<? super L, ? extends L2> var1);

    @NotNull
    public <L2> Either<L2, R> flatMapLeft(@NotNull Function<? super L, ? extends Either<? extends L2, ? extends R>> var1);

    @NotNull
    public Either<L, R> matchLeft(@NotNull Consumer<? super L> var1);

    @NotNull
    public Either<L, R> match(@NotNull Consumer<? super R> var1);

    default public void consume(@NotNull Consumer<? super R> rightConsumer) {
        this.match(rightConsumer);
    }

    @NotNull
    public R orElse(@NotNull R var1);

    @NotNull
    public L orElseLeft(@NotNull L var1);

    @NotNull
    public R orElseGet(@NotNull Supplier<? extends R> var1);

    @NotNull
    public L orElseGetLeft(@NotNull Supplier<? extends L> var1);

    @NotNull
    public <R2> Either<L, R2> and(@NotNull Either<L, R2> var1);

    @NotNull
    public <R2> Either<L, R2> and(@NotNull Supplier<Either<L, R2>> var1);

    @NotNull
    public <L2> Either<L2, R> or(@NotNull Either<L2, R> var1);

    @NotNull
    public <L2> Either<L2, R> or(@NotNull Supplier<Either<L2, R>> var1);

    @NotNull
    public <X extends Throwable> R expect(@NotNull Supplier<X> var1) throws X;

    @NotNull
    public <X extends Throwable> R getOrThrow(@NotNull Function<L, X> var1) throws X;

    @NotNull
    public Either<R, L> swap();

    public record Left<L, R>(@NotNull L value) implements Either<L, R>
    {
        public Left(@NotNull L value) {
            Objects.requireNonNull(value, "Left: value cannot be null!");
        }

        @NotNull
        public L get() {
            return this.value;
        }

        @Override
        public boolean isLeft() {
            return true;
        }

        @Override
        public boolean isRight() {
            return false;
        }

        @Override
        @NotNull
        public Optional<L> left() {
            return Optional.of(this.value);
        }

        @Override
        @NotNull
        public Optional<R> right() {
            return Optional.empty();
        }

        @Override
        @NotNull
        public Either<L, R> biMatch(@NotNull Consumer<? super L> leftConsumer, @NotNull Consumer<? super R> rightConsumer) {
            Objects.requireNonNull(leftConsumer);
            Objects.requireNonNull(rightConsumer);
            leftConsumer.accept(this.value);
            return this;
        }

        @Override
        @NotNull
        public <L2, R2> Either<L2, R2> biMap(@NotNull Function<? super L, ? extends L2> fnLeft, @NotNull Function<? super R, ? extends R2> fnRight) {
            Objects.requireNonNull(fnLeft);
            Objects.requireNonNull(fnRight);
            return Either.ofLeft(fnLeft.apply(this.value));
        }

        @Override
        @NotNull
        public <L2, R2> Either<L2, R2> biFlatMap(@NotNull Function<? super L, ? extends Either<? extends L2, ? extends R2>> fnLeft, @NotNull Function<? super R, ? extends Either<? extends L2, ? extends R2>> fnRight) {
            Objects.requireNonNull(fnLeft);
            Objects.requireNonNull(fnRight);
            return Objects.requireNonNull(fnLeft.apply(this.value));
        }

        @Override
        @NotNull
        public <T> T fold(@NotNull Function<? super L, ? extends T> fnLeft, @NotNull Function<? super R, ? extends T> fnRight) {
            Objects.requireNonNull(fnLeft);
            Objects.requireNonNull(fnRight);
            return Objects.requireNonNull(fnLeft.apply(this.value));
        }

        @Override
        @NotNull
        public Either<L, R> filter(@NotNull Predicate<? super R> predicate, @NotNull Function<? super R, ? extends L> mapper) {
            Objects.requireNonNull(predicate);
            Objects.requireNonNull(mapper);
            return this;
        }

        @Override
        @NotNull
        public Stream<R> stream() {
            return Stream.empty();
        }

        @Override
        @NotNull
        public Stream<L> streamLeft() {
            return Stream.of(this.value);
        }

        @Override
        public boolean contains(@Nullable R rVal) {
            return false;
        }

        @Override
        public boolean containsLeft(@Nullable L lVal) {
            return this.value.equals(lVal);
        }

        @Override
        public boolean ifPredicate(@NotNull Predicate<R> rp) {
            return false;
        }

        @Override
        public boolean ifPredicateLeft(@NotNull Predicate<L> lp) {
            return Objects.requireNonNull(lp).test(this.value);
        }

        @Override
        @NotNull
        public <L2> Either<L2, R> flatMapLeft(@NotNull Function<? super L, ? extends Either<? extends L2, ? extends R>> leftMapper) {
            Objects.requireNonNull(leftMapper);
            return Objects.requireNonNull(leftMapper.apply(this.value));
        }

        @Override
        @NotNull
        public <R2> Either<L, R2> flatMap(@NotNull Function<? super R, ? extends Either<? extends L, ? extends R2>> rightMapper) {
            Objects.requireNonNull(rightMapper);
            return this.coerce();
        }

        @Override
        @NotNull
        public R orElse(@NotNull R rightAlternate) {
            Objects.requireNonNull(rightAlternate);
            return rightAlternate;
        }

        @Override
        @NotNull
        public L orElseLeft(@NotNull L leftAlternate) {
            Objects.requireNonNull(leftAlternate);
            return this.value;
        }

        @Override
        @NotNull
        public R orElseGet(@NotNull Supplier<? extends R> rightSupplier) {
            Objects.requireNonNull(rightSupplier);
            return Objects.requireNonNull(rightSupplier.get());
        }

        @Override
        @NotNull
        public L orElseGetLeft(@NotNull Supplier<? extends L> leftSupplier) {
            Objects.requireNonNull(leftSupplier);
            return this.value;
        }

        @Override
        @NotNull
        public L forfeit(@NotNull Function<? super R, ? extends L> fn) {
            Objects.requireNonNull(fn);
            return this.value;
        }

        @Override
        @NotNull
        public R recover(@NotNull Function<? super L, ? extends R> fn) {
            Objects.requireNonNull(fn);
            return Objects.requireNonNull(fn.apply(this.value));
        }

        @Override
        @NotNull
        public <R2> Either<L, R2> map(@NotNull Function<? super R, ? extends R2> rightMapper) {
            Objects.requireNonNull(rightMapper);
            return this.coerce();
        }

        @Override
        @NotNull
        public <L2> Either<L2, R> mapLeft(@NotNull Function<? super L, ? extends L2> leftMapper) {
            Objects.requireNonNull(leftMapper);
            return Either.ofLeft(leftMapper.apply(this.value));
        }

        @Override
        @NotNull
        public Either<L, R> matchLeft(@NotNull Consumer<? super L> leftConsumer) {
            Objects.requireNonNull(leftConsumer);
            leftConsumer.accept(this.value);
            return this;
        }

        @Override
        @NotNull
        public Either<L, R> match(@NotNull Consumer<? super R> rightConsumer) {
            Objects.requireNonNull(rightConsumer);
            return this;
        }

        @Override
        @NotNull
        public <L2> Either<L2, R> or(@NotNull Supplier<Either<L2, R>> nextEitherSupplier) {
            Objects.requireNonNull(nextEitherSupplier);
            return Objects.requireNonNull(nextEitherSupplier.get());
        }

        @Override
        @NotNull
        public Either<R, L> swap() {
            return Either.ofRight(this.value);
        }

        @Override
        @NotNull
        public <R2> Either<L, R2> and(@NotNull Either<L, R2> nextEither) {
            Objects.requireNonNull(nextEither);
            return this.coerce();
        }

        @Override
        @NotNull
        public <R2> Either<L, R2> and(@NotNull Supplier<Either<L, R2>> nextEitherSupplier) {
            Objects.requireNonNull(nextEitherSupplier);
            return this.coerce();
        }

        @Override
        @NotNull
        public <L2> Either<L2, R> or(@NotNull Either<L2, R> nextEither) {
            Objects.requireNonNull(nextEither);
            return nextEither;
        }

        @Override
        @NotNull
        public <X extends Throwable> R expect(@NotNull Supplier<X> supplier) throws X {
            Objects.requireNonNull(supplier);
            throw Objects.requireNonNull((Throwable)supplier.get());
        }

        @Override
        @NotNull
        public <X extends Throwable> R getOrThrow(@NotNull Function<L, X> exFn) throws X {
            Objects.requireNonNull(exFn);
            throw Objects.requireNonNull((Throwable)exFn.apply(this.value));
        }

        @NotNull
        private <R2> Either<L, R2> coerce() {
            return this;
        }
    }

    public record Right<L, R>(@NotNull R value) implements Either<L, R>
    {
        public Right(@NotNull R value) {
            Objects.requireNonNull(value, "Right: value cannot be null!");
        }

        @NotNull
        public R get() {
            return this.value;
        }

        @Override
        public boolean isLeft() {
            return false;
        }

        @Override
        public boolean isRight() {
            return true;
        }

        @Override
        @NotNull
        public Optional<L> left() {
            return Optional.empty();
        }

        @Override
        @NotNull
        public Optional<R> right() {
            return Optional.of(this.value);
        }

        @Override
        @NotNull
        public Either<L, R> biMatch(@NotNull Consumer<? super L> leftConsumer, @NotNull Consumer<? super R> rightConsumer) {
            Objects.requireNonNull(leftConsumer);
            Objects.requireNonNull(rightConsumer);
            rightConsumer.accept(this.value);
            return this;
        }

        @Override
        @NotNull
        public <L2, R2> Either<L2, R2> biMap(@NotNull Function<? super L, ? extends L2> fnLeft, @NotNull Function<? super R, ? extends R2> fnRight) {
            Objects.requireNonNull(fnLeft);
            Objects.requireNonNull(fnRight);
            return Either.ofRight(fnRight.apply(this.value));
        }

        @Override
        @NotNull
        public <L2, R2> Either<L2, R2> biFlatMap(@NotNull Function<? super L, ? extends Either<? extends L2, ? extends R2>> fnLeft, @NotNull Function<? super R, ? extends Either<? extends L2, ? extends R2>> fnRight) {
            Objects.requireNonNull(fnLeft);
            Objects.requireNonNull(fnRight);
            return Objects.requireNonNull(fnRight.apply(this.value));
        }

        @Override
        @NotNull
        public <T> T fold(@NotNull Function<? super L, ? extends T> fnLeft, @NotNull Function<? super R, ? extends T> fnRight) {
            Objects.requireNonNull(fnLeft);
            Objects.requireNonNull(fnRight);
            return Objects.requireNonNull(fnRight.apply(this.value));
        }

        @Override
        @NotNull
        public Either<L, R> filter(@NotNull Predicate<? super R> predicate, @NotNull Function<? super R, ? extends L> mapper) {
            Objects.requireNonNull(predicate);
            Objects.requireNonNull(mapper);
            return predicate.test(this.value) ? this : Either.ofLeft(mapper.apply(this.value));
        }

        @Override
        @NotNull
        public Stream<R> stream() {
            return Stream.of(this.value);
        }

        @Override
        @NotNull
        public Stream<L> streamLeft() {
            return Stream.empty();
        }

        @Override
        public boolean contains(@Nullable R rVal) {
            return this.value.equals(rVal);
        }

        @Override
        public boolean containsLeft(@Nullable L lVal) {
            return false;
        }

        @Override
        public boolean ifPredicate(@NotNull Predicate<R> rp) {
            return Objects.requireNonNull(rp).test(this.value);
        }

        @Override
        public boolean ifPredicateLeft(@NotNull Predicate<L> lp) {
            Objects.requireNonNull(lp);
            return false;
        }

        @Override
        @NotNull
        public <L2> Either<L2, R> flatMapLeft(@NotNull Function<? super L, ? extends Either<? extends L2, ? extends R>> leftMapper) {
            Objects.requireNonNull(leftMapper);
            return this.coerce();
        }

        @Override
        @NotNull
        public <R2> Either<L, R2> flatMap(@NotNull Function<? super R, ? extends Either<? extends L, ? extends R2>> rightMapper) {
            Objects.requireNonNull(rightMapper);
            return Objects.requireNonNull(rightMapper.apply(this.value));
        }

        @Override
        @NotNull
        public R orElse(@NotNull R rightAlternate) {
            Objects.requireNonNull(rightAlternate);
            return this.value;
        }

        @Override
        @NotNull
        public L orElseLeft(@NotNull L leftAlternate) {
            Objects.requireNonNull(leftAlternate);
            return leftAlternate;
        }

        @Override
        @NotNull
        public R orElseGet(@NotNull Supplier<? extends R> rightSupplier) {
            Objects.requireNonNull(rightSupplier);
            return this.value;
        }

        @Override
        @NotNull
        public L orElseGetLeft(@NotNull Supplier<? extends L> leftSupplier) {
            Objects.requireNonNull(leftSupplier);
            return Objects.requireNonNull(leftSupplier.get());
        }

        @Override
        @NotNull
        public <R2> Either<L, R2> and(@NotNull Either<L, R2> nextEither) {
            Objects.requireNonNull(nextEither);
            return nextEither;
        }

        @Override
        @NotNull
        public <L2> Either<L2, R> or(@NotNull Either<L2, R> nextEither) {
            Objects.requireNonNull(nextEither);
            return this.coerce();
        }

        @Override
        @NotNull
        public <L2> Either<L2, R> or(@NotNull Supplier<Either<L2, R>> nextEitherSupplier) {
            Objects.requireNonNull(nextEitherSupplier);
            return this.coerce();
        }

        @Override
        @NotNull
        public L forfeit(@NotNull Function<? super R, ? extends L> fn) {
            Objects.requireNonNull(fn);
            return Objects.requireNonNull(fn.apply(this.value));
        }

        @Override
        @NotNull
        public R recover(@NotNull Function<? super L, ? extends R> fn) {
            Objects.requireNonNull(fn);
            return this.value;
        }

        @Override
        @NotNull
        public <R2> Either<L, R2> map(@NotNull Function<? super R, ? extends R2> rightMapper) {
            Objects.requireNonNull(rightMapper);
            return Either.ofRight(rightMapper.apply(this.value));
        }

        @Override
        @NotNull
        public <L2> Either<L2, R> mapLeft(@NotNull Function<? super L, ? extends L2> leftMapper) {
            Objects.requireNonNull(leftMapper);
            return this.coerce();
        }

        @Override
        @NotNull
        public Either<L, R> matchLeft(@NotNull Consumer<? super L> leftConsumer) {
            Objects.requireNonNull(leftConsumer);
            return this;
        }

        @Override
        @NotNull
        public Either<L, R> match(@NotNull Consumer<? super R> rightConsumer) {
            Objects.requireNonNull(rightConsumer);
            rightConsumer.accept(this.value);
            return this;
        }

        @Override
        @NotNull
        public <R2> Either<L, R2> and(@NotNull Supplier<Either<L, R2>> nextEitherSupplier) {
            Objects.requireNonNull(nextEitherSupplier);
            return Objects.requireNonNull(nextEitherSupplier.get());
        }

        @Override
        @NotNull
        public Either<R, L> swap() {
            return Either.ofLeft(this.value);
        }

        @Override
        @NotNull
        public <X extends Throwable> R expect(@NotNull Supplier<X> supplier) {
            Objects.requireNonNull(supplier);
            return this.value;
        }

        @Override
        @NotNull
        public <X extends Throwable> R getOrThrow(@NotNull Function<L, X> exFn) {
            Objects.requireNonNull(exFn);
            return this.value;
        }

        @NotNull
        private <L2> Either<L2, R> coerce() {
            return this;
        }
    }
}

