/*
 * Decompiled with CFR 0.152.
 */
package net.xyzsd.dichotomy;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface Maybe<T> {
    public static <T> Maybe<T> of(@NotNull T value) {
        return new Some<T>(value);
    }

    public static <T> Maybe<T> ofNone() {
        return None.empty();
    }

    public static <T> Maybe<T> ofNullable(@Nullable T value) {
        return value == null ? Maybe.ofNone() : Maybe.of(value);
    }

    @NotNull
    public Maybe<T> biMatch(@NotNull Consumer<? super T> var1, @NotNull Runnable var2);

    @NotNull
    public Maybe<T> filter(@NotNull Predicate<? super T> var1);

    @NotNull
    public <U> U fold(@NotNull Function<? super T, ? extends U> var1, @NotNull Supplier<? extends U> var2);

    @NotNull
    public Stream<T> stream();

    @NotNull
    public <U> Maybe<U> map(@NotNull Function<? super T, ? extends U> var1);

    public Maybe<T> match(@NotNull Consumer<? super T> var1);

    public void consume(@NotNull Consumer<? super T> var1);

    @NotNull
    public <U> Maybe<U> flatMap(@NotNull Function<? super T, ? extends Maybe<? extends U>> var1);

    public boolean matches(@NotNull Predicate<T> var1);

    public boolean contains(@Nullable T var1);

    public boolean hasSome();

    public boolean isNone();

    @NotNull
    public T orElse(@NotNull T var1);

    @NotNull
    public T orElse(@NotNull Supplier<? extends T> var1);

    @NotNull
    public <U> Maybe<U> and(@NotNull Maybe<? extends U> var1);

    @NotNull
    public <U> Maybe<U> and(@NotNull Supplier<Maybe<? extends U>> var1);

    @NotNull
    public Maybe<T> or(@NotNull Maybe<T> var1);

    @NotNull
    public Maybe<T> or(@NotNull Supplier<Maybe<T>> var1);

    @NotNull
    public T expect();

    @NotNull
    public <X extends Throwable> T getOrThrow(@NotNull Supplier<X> var1) throws X;

    public record Some<T>(@NotNull T value) implements Maybe<T>
    {
        public Some(@NotNull T value) {
            Objects.requireNonNull(value);
        }

        @Override
        @NotNull
        public Maybe<T> biMatch(@NotNull Consumer<? super T> someConsumer, @NotNull Runnable noneRunner) {
            Objects.requireNonNull(someConsumer);
            Objects.requireNonNull(noneRunner);
            someConsumer.accept(this.value);
            return this;
        }

        @Override
        @NotNull
        public Maybe<T> filter(@NotNull Predicate<? super T> predicate) {
            Objects.requireNonNull(predicate);
            return predicate.test(this.value) ? this : None.empty();
        }

        @Override
        @NotNull
        public <U> U fold(@NotNull Function<? super T, ? extends U> fnSome, @NotNull Supplier<? extends U> supNone) {
            Objects.requireNonNull(fnSome);
            Objects.requireNonNull(supNone);
            return Objects.requireNonNull(fnSome.apply(this.value));
        }

        @Override
        @NotNull
        public Stream<T> stream() {
            return Stream.of(this.value);
        }

        @Override
        @NotNull
        public <U> Maybe<U> map(@NotNull Function<? super T, ? extends U> fnSome) {
            Objects.requireNonNull(fnSome);
            return new Some<U>(fnSome.apply(this.value));
        }

        @Override
        public Maybe<T> match(@NotNull Consumer<? super T> someConsumer) {
            Objects.requireNonNull(someConsumer);
            someConsumer.accept(this.value);
            return this;
        }

        @Override
        public void consume(@NotNull Consumer<? super T> someConsumer) {
            Objects.requireNonNull(someConsumer);
            someConsumer.accept(this.value);
        }

        @Override
        @NotNull
        public <U> Maybe<U> flatMap(@NotNull Function<? super T, ? extends Maybe<? extends U>> mapper) {
            Objects.requireNonNull(mapper);
            return Objects.requireNonNull(mapper.apply(this.value));
        }

        @Override
        public boolean matches(@NotNull Predicate<T> predicate) {
            Objects.requireNonNull(predicate);
            return predicate.test(this.value);
        }

        @Override
        public boolean contains(@Nullable T v) {
            return Objects.equals(this.value, v);
        }

        @Override
        public boolean hasSome() {
            return true;
        }

        @Override
        public boolean isNone() {
            return false;
        }

        @Override
        @NotNull
        public T orElse(@NotNull T alternate) {
            Objects.requireNonNull(this.value);
            return this.value;
        }

        @Override
        @NotNull
        public T orElse(@NotNull Supplier<? extends T> supplier) {
            Objects.requireNonNull(supplier);
            return this.value;
        }

        @Override
        @NotNull
        public <U> Maybe<U> and(@NotNull Maybe<? extends U> nextMaybe) {
            Objects.requireNonNull(nextMaybe);
            return nextMaybe;
        }

        @Override
        @NotNull
        public <U> Maybe<U> and(@NotNull Supplier<Maybe<? extends U>> nextMaybeSupplier) {
            Objects.requireNonNull(nextMaybeSupplier);
            return Objects.requireNonNull(nextMaybeSupplier.get());
        }

        @Override
        @NotNull
        public Maybe<T> or(@NotNull Maybe<T> nextMaybe) {
            Objects.requireNonNull(nextMaybe);
            return this;
        }

        @Override
        @NotNull
        public Maybe<T> or(@NotNull Supplier<Maybe<T>> nextMaybeSupplier) {
            Objects.requireNonNull(nextMaybeSupplier);
            return this;
        }

        @Override
        @NotNull
        public T expect() {
            return this.value;
        }

        @Override
        @NotNull
        public <X extends Throwable> T getOrThrow(@NotNull Supplier<X> supplier) {
            return this.value;
        }
    }

    public record None<T>() implements Maybe<T>
    {
        private static final None<Object> _NONE_INSTANCE = new None();

        private static <U> None<U> empty() {
            return _NONE_INSTANCE;
        }

        @Override
        @NotNull
        public Maybe<T> biMatch(@NotNull Consumer<? super T> someConsumer, @NotNull Runnable noneRunner) {
            Objects.requireNonNull(someConsumer);
            Objects.requireNonNull(noneRunner);
            noneRunner.run();
            return this;
        }

        @Override
        @NotNull
        public Maybe<T> filter(@NotNull Predicate<? super T> predicate) {
            Objects.requireNonNull(predicate);
            return None.empty();
        }

        @Override
        @NotNull
        public <U> U fold(@NotNull Function<? super T, ? extends U> fnSome, @NotNull Supplier<? extends U> supNone) {
            Objects.requireNonNull(fnSome);
            Objects.requireNonNull(supNone);
            return Objects.requireNonNull(supNone.get());
        }

        @Override
        @NotNull
        public Stream<T> stream() {
            return Stream.empty();
        }

        @Override
        @NotNull
        public <U> Maybe<U> map(@NotNull Function<? super T, ? extends U> fnSome) {
            Objects.requireNonNull(fnSome);
            return None.empty();
        }

        @Override
        public Maybe<T> match(@NotNull Consumer<? super T> someConsumer) {
            Objects.requireNonNull(someConsumer);
            return this;
        }

        @Override
        public void consume(@NotNull Consumer<? super T> someConsumer) {
            Objects.requireNonNull(someConsumer);
        }

        @Override
        @NotNull
        public <U> Maybe<U> flatMap(@NotNull Function<? super T, ? extends Maybe<? extends U>> someConsumer) {
            Objects.requireNonNull(someConsumer);
            return None.empty();
        }

        @Override
        public boolean matches(@NotNull Predicate<T> predicate) {
            Objects.requireNonNull(predicate);
            return false;
        }

        @Override
        public boolean contains(@Nullable T value) {
            return value == null;
        }

        @Override
        public boolean hasSome() {
            return false;
        }

        @Override
        public boolean isNone() {
            return true;
        }

        @Override
        @NotNull
        public T orElse(@NotNull T alternate) {
            Objects.requireNonNull(alternate);
            return alternate;
        }

        @Override
        @NotNull
        public T orElse(@NotNull Supplier<? extends T> supplier) {
            Objects.requireNonNull(supplier);
            return Objects.requireNonNull(supplier.get());
        }

        @Override
        @NotNull
        public <U> Maybe<U> and(@NotNull Maybe<? extends U> nextMaybe) {
            Objects.requireNonNull(nextMaybe);
            return None.empty();
        }

        @Override
        @NotNull
        public <U> Maybe<U> and(@NotNull Supplier<Maybe<? extends U>> nextMaybeSupplier) {
            Objects.requireNonNull(nextMaybeSupplier);
            return None.empty();
        }

        @Override
        @NotNull
        public Maybe<T> or(@NotNull Maybe<T> nextMaybe) {
            Objects.requireNonNull(nextMaybe);
            return nextMaybe;
        }

        @Override
        @NotNull
        public Maybe<T> or(@NotNull Supplier<Maybe<T>> nextMaybeSupplier) {
            Objects.requireNonNull(nextMaybeSupplier);
            return Objects.requireNonNull(nextMaybeSupplier.get());
        }

        @Override
        @NotNull
        public T expect() throws NoSuchElementException {
            throw new NoSuchElementException();
        }

        @Override
        @NotNull
        public <X extends Throwable> T getOrThrow(@NotNull Supplier<X> supplier) throws X {
            throw Objects.requireNonNull((Throwable)supplier.get());
        }
    }
}

