/*
 * Decompiled with CFR 0.152.
 */
package net.xyzsd.dichotomy;

import java.lang.runtime.SwitchBootstraps;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.xyzsd.dichotomy.Empty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface Result<V, E> {
    @NotNull
    public static <V, E> Result<V, E> ofOK(@NotNull V value) {
        return new OK(value);
    }

    @NotNull
    public static <E> Result<Empty, E> ofOK() {
        return new OK(Empty.getInstance());
    }

    @NotNull
    public static <V> Result<V, Empty> ofNullable(@Nullable V value) {
        return value == null ? Result.ofErr(Empty.getInstance()) : Result.ofOK(value);
    }

    @NotNull
    public static <V> Result<V, Empty> from(@NotNull Optional<V> opt) {
        return opt.map(Result::ofOK).orElseGet(() -> Result.ofErr(Empty.getInstance()));
    }

    @NotNull
    public static <V, E> Result<V, E> ofErr(@NotNull E error) {
        return new Err(error);
    }

    public boolean isOK();

    public boolean isErr();

    @NotNull
    public Optional<V> ok();

    @NotNull
    public Optional<E> err();

    @NotNull
    public Result<E, V> swap();

    @NotNull
    public Result<V, E> biMatch(@NotNull Consumer<? super V> var1, @NotNull Consumer<? super E> var2);

    @NotNull
    public <V2, E2> Result<V2, E2> biMap(@NotNull Function<? super V, ? extends V2> var1, @NotNull Function<? super E, ? extends E2> var2);

    @NotNull
    public <V2, E2> Result<V2, E2> biFlatMap(@NotNull Function<? super V, ? extends Result<? extends V2, ? extends E2>> var1, @NotNull Function<? super E, ? extends Result<? extends V2, ? extends E2>> var2);

    @NotNull
    public <T> T fold(@NotNull Function<? super V, ? extends T> var1, @NotNull Function<? super E, ? extends T> var2);

    @NotNull
    public Stream<V> stream();

    @NotNull
    public Result<V, E> filter(@NotNull Predicate<? super V> var1, @NotNull Function<? super V, ? extends E> var2);

    @NotNull
    public Result<V, E> match(@NotNull Consumer<? super V> var1);

    default public void consume(@NotNull Consumer<? super V> okConsumer) {
        this.match(okConsumer);
    }

    @NotNull
    public <V2> Result<V2, E> map(@NotNull Function<? super V, ? extends V2> var1);

    @NotNull
    public <V2> Result<V2, E> flatMap(@NotNull Function<? super V, ? extends Result<? extends V2, ? extends E>> var1);

    public boolean ifPredicate(@NotNull Predicate<V> var1);

    public boolean contains(@Nullable V var1);

    @NotNull
    public V orElse(@NotNull V var1);

    @NotNull
    public V orElse(@NotNull Supplier<? extends V> var1);

    @NotNull
    public V recover(@NotNull Function<? super E, ? extends V> var1);

    @NotNull
    public Stream<E> streamErr();

    @NotNull
    public Result<V, E> matchErr(@NotNull Consumer<? super E> var1);

    @NotNull
    public <E2> Result<V, E2> mapErr(@NotNull Function<? super E, ? extends E2> var1);

    @NotNull
    public <E2> Result<V, E2> flatMapErr(@NotNull Function<? super E, ? extends Result<? extends V, ? extends E2>> var1);

    public boolean ifPredicateErr(@NotNull Predicate<E> var1);

    public boolean containsErr(@Nullable E var1);

    @NotNull
    public E orElseErr(@NotNull E var1);

    @NotNull
    public E orElseErr(@NotNull Supplier<? extends E> var1);

    @NotNull
    public E forfeit(@NotNull Function<? super V, ? extends E> var1);

    @NotNull
    public <V2> Result<V2, E> and(@NotNull Result<V2, E> var1);

    @NotNull
    public <V2> Result<V2, E> and(@NotNull Supplier<Result<V2, E>> var1);

    @NotNull
    public <E2> Result<V, E2> or(@NotNull Result<V, E2> var1);

    @NotNull
    public <E2> Result<V, E2> or(@NotNull Supplier<Result<V, E2>> var1);

    @NotNull
    public V expect() throws RuntimeException;

    @NotNull
    public <X extends Exception> V getOrThrow(@NotNull Function<E, X> var1) throws X;

    public record OK<V, E>(@NotNull V value) implements Result<V, E>
    {
        public OK(@NotNull V value) {
            Objects.requireNonNull(value, "OK: value cannot be null!");
        }

        @NotNull
        public V get() {
            return this.value;
        }

        @Override
        public boolean isOK() {
            return true;
        }

        @Override
        public boolean isErr() {
            return false;
        }

        @Override
        @NotNull
        public Optional<V> ok() {
            return Optional.of(this.value);
        }

        @Override
        @NotNull
        public Optional<E> err() {
            return Optional.empty();
        }

        @Override
        @NotNull
        public Result<E, V> swap() {
            return new Err(this.value);
        }

        @Override
        @NotNull
        public Result<V, E> biMatch(@NotNull Consumer<? super V> okConsumer, @NotNull Consumer<? super E> errConsumer) {
            Objects.requireNonNull(okConsumer);
            Objects.requireNonNull(errConsumer);
            okConsumer.accept(this.value);
            return this;
        }

        @Override
        @NotNull
        public <V2, E2> Result<V2, E2> biMap(@NotNull Function<? super V, ? extends V2> okMapper, @NotNull Function<? super E, ? extends E2> errMapper) {
            Objects.requireNonNull(okMapper);
            Objects.requireNonNull(errMapper);
            return new OK<V2, E>(okMapper.apply(this.value));
        }

        @Override
        @NotNull
        public <V2, E2> Result<V2, E2> biFlatMap(@NotNull Function<? super V, ? extends Result<? extends V2, ? extends E2>> okMapper, @NotNull Function<? super E, ? extends Result<? extends V2, ? extends E2>> errMapper) {
            Objects.requireNonNull(okMapper);
            Objects.requireNonNull(errMapper);
            return Objects.requireNonNull(okMapper.apply(this.value));
        }

        @Override
        @NotNull
        public <T> T fold(@NotNull Function<? super V, ? extends T> fnOK, @NotNull Function<? super E, ? extends T> fnErr) {
            Objects.requireNonNull(fnOK);
            Objects.requireNonNull(fnErr);
            return Objects.requireNonNull(fnOK.apply(this.value));
        }

        @Override
        @NotNull
        public Stream<V> stream() {
            return Stream.of(this.value);
        }

        @Override
        @NotNull
        public Result<V, E> filter(@NotNull Predicate<? super V> predicate, @NotNull Function<? super V, ? extends E> mapper) {
            Objects.requireNonNull(predicate);
            Objects.requireNonNull(mapper);
            if (predicate.test(this.value)) {
                return this;
            }
            return new Err(mapper.apply(this.value));
        }

        @Override
        @NotNull
        public Result<V, E> match(@NotNull Consumer<? super V> okConsumer) {
            Objects.requireNonNull(okConsumer);
            okConsumer.accept(this.value);
            return this;
        }

        @Override
        @NotNull
        public <V2> Result<V2, E> map(@NotNull Function<? super V, ? extends V2> okMapper) {
            Objects.requireNonNull(okMapper);
            return new OK<V2, E>(okMapper.apply(this.value));
        }

        @Override
        @NotNull
        public <V2> Result<V2, E> flatMap(@NotNull Function<? super V, ? extends Result<? extends V2, ? extends E>> okMapper) {
            Objects.requireNonNull(okMapper);
            return Objects.requireNonNull(okMapper.apply(this.value));
        }

        @Override
        public boolean ifPredicate(@NotNull Predicate<V> okPredicate) {
            Objects.requireNonNull(okPredicate);
            return okPredicate.test(this.value);
        }

        @Override
        public boolean contains(@Nullable V okValue) {
            return Objects.equals(this.value, okValue);
        }

        @Override
        @NotNull
        public V orElse(@NotNull V okAlternate) {
            Objects.requireNonNull(okAlternate);
            return this.value;
        }

        @Override
        @NotNull
        public V orElse(@NotNull Supplier<? extends V> okSupplier) {
            Objects.requireNonNull(okSupplier);
            return this.value;
        }

        @Override
        @NotNull
        public V recover(@NotNull Function<? super E, ? extends V> fnE2V) {
            Objects.requireNonNull(fnE2V);
            return this.value;
        }

        @Override
        @NotNull
        public Stream<E> streamErr() {
            return Stream.empty();
        }

        @Override
        @NotNull
        public Result<V, E> matchErr(@NotNull Consumer<? super E> errConsumer) {
            Objects.requireNonNull(errConsumer);
            return this;
        }

        @Override
        @NotNull
        public <E2> Result<V, E2> mapErr(@NotNull Function<? super E, ? extends E2> errMapper) {
            Objects.requireNonNull(errMapper);
            return this.coerce();
        }

        @Override
        @NotNull
        public <E2> Result<V, E2> flatMapErr(@NotNull Function<? super E, ? extends Result<? extends V, ? extends E2>> errMapper) {
            Objects.requireNonNull(errMapper);
            return this.coerce();
        }

        @Override
        public boolean ifPredicateErr(@NotNull Predicate<E> errPredicate) {
            Objects.requireNonNull(errPredicate);
            return false;
        }

        @Override
        public boolean containsErr(@Nullable E errValue) {
            Objects.requireNonNull(errValue);
            return false;
        }

        @Override
        @NotNull
        public E orElseErr(@NotNull E errAlternate) {
            Objects.requireNonNull(errAlternate);
            return errAlternate;
        }

        @Override
        @NotNull
        public E orElseErr(@NotNull Supplier<? extends E> errSupplier) {
            Objects.requireNonNull(errSupplier);
            return Objects.requireNonNull(errSupplier.get());
        }

        @Override
        @NotNull
        public E forfeit(@NotNull Function<? super V, ? extends E> fnV2E) {
            Objects.requireNonNull(fnV2E);
            return Objects.requireNonNull(fnV2E.apply(this.value));
        }

        @Override
        @NotNull
        public <V2> Result<V2, E> and(@NotNull Result<V2, E> nextResult) {
            Objects.requireNonNull(nextResult);
            return nextResult;
        }

        @Override
        @NotNull
        public <V2> Result<V2, E> and(@NotNull Supplier<Result<V2, E>> nextResultSupplier) {
            Objects.requireNonNull(nextResultSupplier);
            return Objects.requireNonNull(nextResultSupplier.get());
        }

        @Override
        @NotNull
        public <E2> Result<V, E2> or(@NotNull Result<V, E2> nextResult) {
            Objects.requireNonNull(nextResult);
            return this.coerce();
        }

        @Override
        @NotNull
        public <E2> Result<V, E2> or(@NotNull Supplier<Result<V, E2>> nextResultSupplier) {
            Objects.requireNonNull(nextResultSupplier);
            return this.coerce();
        }

        @Override
        @NotNull
        public V expect() {
            return this.value;
        }

        @Override
        @NotNull
        public <X extends Exception> V getOrThrow(@NotNull Function<E, X> exFn) {
            return this.value;
        }

        @NotNull
        private <E2> Result<V, E2> coerce() {
            return this;
        }
    }

    public record Err<V, E>(@NotNull E value) implements Result<V, E>
    {
        public Err(@NotNull E value) {
            Objects.requireNonNull(value, "Err: value cannot be null!");
        }

        @NotNull
        public E get() {
            return this.value;
        }

        @Override
        public boolean isOK() {
            return false;
        }

        @Override
        public boolean isErr() {
            return true;
        }

        @Override
        @NotNull
        public Optional<V> ok() {
            return Optional.empty();
        }

        @Override
        @NotNull
        public Optional<E> err() {
            return Optional.of(this.value);
        }

        @Override
        @NotNull
        public Result<E, V> swap() {
            return new OK(this.value);
        }

        @Override
        @NotNull
        public Result<V, E> biMatch(@NotNull Consumer<? super V> okConsumer, @NotNull Consumer<? super E> errConsumer) {
            Objects.requireNonNull(okConsumer);
            Objects.requireNonNull(errConsumer);
            errConsumer.accept(this.value);
            return this;
        }

        @Override
        @NotNull
        public <V2, E2> Result<V2, E2> biMap(@NotNull Function<? super V, ? extends V2> okMapper, @NotNull Function<? super E, ? extends E2> errMapper) {
            Objects.requireNonNull(okMapper);
            Objects.requireNonNull(errMapper);
            return new Err<V, E2>(errMapper.apply(this.value));
        }

        @Override
        @NotNull
        public <V2, E2> Result<V2, E2> biFlatMap(@NotNull Function<? super V, ? extends Result<? extends V2, ? extends E2>> okMapper, @NotNull Function<? super E, ? extends Result<? extends V2, ? extends E2>> errMapper) {
            Objects.requireNonNull(okMapper);
            Objects.requireNonNull(errMapper);
            return Objects.requireNonNull(errMapper.apply(this.value));
        }

        @Override
        @NotNull
        public <T> T fold(@NotNull Function<? super V, ? extends T> fnOK, @NotNull Function<? super E, ? extends T> fnErr) {
            Objects.requireNonNull(fnOK);
            Objects.requireNonNull(fnErr);
            return Objects.requireNonNull(fnErr.apply(this.value));
        }

        @Override
        @NotNull
        public Stream<V> stream() {
            return Stream.empty();
        }

        @Override
        @NotNull
        public Result<V, E> filter(@NotNull Predicate<? super V> predicate, @NotNull Function<? super V, ? extends E> mapper) {
            Objects.requireNonNull(predicate);
            Objects.requireNonNull(mapper);
            return this;
        }

        @Override
        @NotNull
        public Result<V, E> match(@NotNull Consumer<? super V> okConsumer) {
            Objects.requireNonNull(okConsumer);
            return this;
        }

        @Override
        @NotNull
        public <V2> Result<V2, E> map(@NotNull Function<? super V, ? extends V2> okMapper) {
            Objects.requireNonNull(okMapper);
            return this.coerce();
        }

        @Override
        @NotNull
        public <V2> Result<V2, E> flatMap(@NotNull Function<? super V, ? extends Result<? extends V2, ? extends E>> okMapper) {
            Objects.requireNonNull(okMapper);
            return this.coerce();
        }

        @Override
        public boolean ifPredicate(@NotNull Predicate<V> okPredicate) {
            Objects.requireNonNull(okPredicate);
            return false;
        }

        @Override
        public boolean contains(@Nullable V okValue) {
            Objects.requireNonNull(okValue);
            return false;
        }

        @Override
        @NotNull
        public V orElse(@NotNull V okAlternate) {
            Objects.requireNonNull(okAlternate);
            return okAlternate;
        }

        @Override
        @NotNull
        public V orElse(@NotNull Supplier<? extends V> okSupplier) {
            Objects.requireNonNull(okSupplier);
            return Objects.requireNonNull(okSupplier.get());
        }

        @Override
        @NotNull
        public V recover(@NotNull Function<? super E, ? extends V> fnE2V) {
            Objects.requireNonNull(fnE2V);
            return Objects.requireNonNull(fnE2V.apply(this.value));
        }

        @Override
        @NotNull
        public Stream<E> streamErr() {
            return Stream.of(this.value);
        }

        @Override
        @NotNull
        public Result<V, E> matchErr(@NotNull Consumer<? super E> errConsumer) {
            Objects.requireNonNull(errConsumer);
            errConsumer.accept(this.value);
            return this;
        }

        @Override
        @NotNull
        public <E2> Result<V, E2> mapErr(@NotNull Function<? super E, ? extends E2> errMapper) {
            Objects.requireNonNull(errMapper);
            return new Err<V, E2>(errMapper.apply(this.value));
        }

        @Override
        @NotNull
        public <E2> Result<V, E2> flatMapErr(@NotNull Function<? super E, ? extends Result<? extends V, ? extends E2>> errMapper) {
            Objects.requireNonNull(errMapper);
            return Objects.requireNonNull(errMapper.apply(this.value));
        }

        @Override
        public boolean ifPredicateErr(@NotNull Predicate<E> errPredicate) {
            Objects.requireNonNull(errPredicate);
            return errPredicate.test(this.value);
        }

        @Override
        public boolean containsErr(@Nullable E errValue) {
            Objects.requireNonNull(errValue);
            return Objects.equals(this.value, errValue);
        }

        @Override
        @NotNull
        public E orElseErr(@NotNull E errAlternate) {
            Objects.requireNonNull(errAlternate);
            return this.value;
        }

        @Override
        @NotNull
        public E orElseErr(@NotNull Supplier<? extends E> errSupplier) {
            Objects.requireNonNull(errSupplier);
            return this.value;
        }

        @Override
        @NotNull
        public E forfeit(@NotNull Function<? super V, ? extends E> fnV2E) {
            Objects.requireNonNull(fnV2E);
            return this.value;
        }

        @Override
        @NotNull
        public <V2> Result<V2, E> and(@NotNull Result<V2, E> nextResult) {
            Objects.requireNonNull(nextResult);
            return this.coerce();
        }

        @Override
        @NotNull
        public <V2> Result<V2, E> and(@NotNull Supplier<Result<V2, E>> nextResultSupplier) {
            Objects.requireNonNull(nextResultSupplier);
            return this.coerce();
        }

        @Override
        @NotNull
        public <E2> Result<V, E2> or(@NotNull Result<V, E2> nextResult) {
            Objects.requireNonNull(nextResult);
            return nextResult;
        }

        @Override
        @NotNull
        public <E2> Result<V, E2> or(@NotNull Supplier<Result<V, E2>> nextResultSupplier) {
            Objects.requireNonNull(nextResultSupplier);
            return Objects.requireNonNull(nextResultSupplier.get());
        }

        @Override
        @NotNull
        public V expect() throws RuntimeException {
            E e = this.value;
            Objects.requireNonNull(e);
            E e2 = e;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RuntimeException.class, Throwable.class}, e2, n)) {
                case 0: {
                    RuntimeException e3 = (RuntimeException)e2;
                    throw e3;
                }
                case 1: {
                    Throwable t = (Throwable)e2;
                    throw new NoSuchElementException(t);
                }
            }
            throw new NoSuchElementException(String.valueOf(this.value));
        }

        @Override
        @NotNull
        public <X extends Exception> V getOrThrow(@NotNull Function<E, X> exFn) throws X {
            Objects.requireNonNull(exFn);
            throw Objects.requireNonNull((Exception)exFn.apply(this.value));
        }

        @NotNull
        private <V2> Result<V2, E> coerce() {
            return this;
        }
    }
}

