/*
 * Decompiled with CFR 0.152.
 */
package net.xyzsd.dichotomy.collectors;

import java.util.ArrayList;
import java.util.List;
import net.xyzsd.dichotomy.Result;

final class Accumulator<OK, ERR> {
    final List<OK> okList = new ArrayList<OK>();
    final List<ERR> errList = new ArrayList<ERR>();

    Accumulator() {
    }

    Accumulator<OK, ERR> append(Accumulator<OK, ERR> in) {
        this.okList.addAll(in.okList);
        this.errList.addAll(in.errList);
        return this;
    }

    Result<List<OK>, List<ERR>> finishBiasOK() {
        if (this.errList.isEmpty() || !this.okList.isEmpty()) {
            return Result.ofOK(List.copyOf(this.okList));
        }
        return Result.ofErr(List.copyOf(this.errList));
    }

    Result<List<OK>, List<ERR>> finishBiasErr() {
        if (this.okList.isEmpty() || !this.errList.isEmpty()) {
            return Result.ofErr(List.copyOf(this.errList));
        }
        return Result.ofOK(List.copyOf(this.okList));
    }
}

