/*
 * Decompiled with CFR 0.152.
 */
package net.xyzsd.dichotomy.trying;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.xyzsd.dichotomy.Empty;
import net.xyzsd.dichotomy.trying.function.ExBiFunction;
import net.xyzsd.dichotomy.trying.function.ExConsumer;
import net.xyzsd.dichotomy.trying.function.ExFunction;
import net.xyzsd.dichotomy.trying.function.ExRunnable;
import net.xyzsd.dichotomy.trying.function.ExSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface Try<V> {
    @NotNull
    public static <T> Try<T> ofSuccess(@NotNull T value) {
        return Success.of(value);
    }

    @NotNull
    public static <T> Try<T> ofFailure(@NotNull Throwable failure) {
        return Failure.of(failure);
    }

    @NotNull
    public static <T> Try<T> wrap(@NotNull ExSupplier<T> xSupplier) {
        Objects.requireNonNull(xSupplier);
        try {
            return Success.of(Objects.requireNonNull(xSupplier.get()));
        }
        catch (Throwable t) {
            return Failure.of(t);
        }
    }

    @NotNull
    public static Try<Empty> wrap(@NotNull ExRunnable runnable) {
        Objects.requireNonNull(runnable);
        try {
            runnable.run();
            return Success.of();
        }
        catch (Throwable t) {
            return Failure.of(t);
        }
    }

    public static <T, AC extends AutoCloseable> Try<T> withResources(ExSupplier<AC> supplier, ExFunction<AC, T> fn) {
        Success<T> success;
        block8: {
            Objects.requireNonNull(supplier);
            Objects.requireNonNull(fn);
            AutoCloseable ac = (AutoCloseable)supplier.get();
            try {
                success = Success.of(fn.apply(ac));
                if (ac == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ac != null) {
                        try {
                            ac.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    return Failure.of(t);
                }
            }
            ac.close();
        }
        return success;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static <T, AC1 extends AutoCloseable, AC2 extends AutoCloseable> Try<T> withResources(ExSupplier<AC1> supplier1, ExSupplier<AC2> supplier2, ExBiFunction<AC1, AC2, T> biFn) {
        Objects.requireNonNull(supplier1);
        Objects.requireNonNull(supplier2);
        Objects.requireNonNull(biFn);
        try (AutoCloseable ac1 = (AutoCloseable)supplier1.get();){
            Success<AutoCloseable> success;
            block14: {
                AutoCloseable ac2 = (AutoCloseable)supplier2.get();
                try {
                    success = Success.of(biFn.apply(ac1, ac2));
                    if (ac2 == null) break block14;
                }
                catch (Throwable throwable) {
                    if (ac2 != null) {
                        try {
                            ac2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ac2.close();
            }
            return success;
        }
        catch (Throwable t) {
            return Failure.of(t);
        }
    }

    public boolean isFailure();

    public boolean isSuccess();

    @NotNull
    public <V2> Try<V2> biFlatMap(@NotNull ExFunction<? super V, ? extends Try<? extends V2>> var1, @NotNull ExFunction<? super Throwable, ? extends Try<? extends V2>> var2);

    @NotNull
    public <T> T fold(@NotNull Function<? super V, ? extends T> var1, @NotNull Function<? super Throwable, ? extends T> var2);

    @NotNull
    public Stream<V> stream();

    @NotNull
    public Try<V> filter(@NotNull Predicate<? super V> var1, @NotNull ExFunction<? super V, ? extends Throwable> var2);

    @NotNull
    public Try<V> exec(@NotNull ExConsumer<? super V> var1);

    public void consume(@NotNull Consumer<? super V> var1);

    public void consumeErr(@NotNull Consumer<? super Throwable> var1);

    @NotNull
    public <V2> Try<V2> map(@NotNull ExFunction<? super V, ? extends V2> var1);

    @NotNull
    public Try<V> mapErr(@NotNull ExFunction<? super Throwable, ? extends Throwable> var1);

    @NotNull
    public <V2> Try<V2> biMap(@NotNull ExFunction<? super V, ? extends V2> var1, @NotNull ExFunction<? super Throwable, ? extends Throwable> var2);

    @NotNull
    public <V2> Try<V2> flatMap(@NotNull ExFunction<? super V, ? extends Try<? extends V2>> var1);

    @NotNull
    public Try<V> flatMapErr(@NotNull ExFunction<? super Throwable, ? extends Try<? extends V>> var1);

    public boolean ifPredicate(@NotNull Predicate<V> var1);

    public boolean contains(@Nullable V var1);

    @NotNull
    public V orElse(@NotNull V var1);

    @NotNull
    public V orElseGet(@NotNull Supplier<? extends V> var1);

    @NotNull
    public <V2> Try<V2> and(@NotNull Try<V2> var1);

    @NotNull
    default public <V2> Try<V2> and(@NotNull ExSupplier<Try<V2>> nextTrySupplier) {
        Objects.requireNonNull(nextTrySupplier);
        return this.flatMap(v -> (Try)nextTrySupplier.get());
    }

    @NotNull
    public Try<V> or(@NotNull Try<V> var1);

    @NotNull
    default public Try<V> or(@NotNull ExSupplier<Try<V>> nextTrySupplier) {
        Objects.requireNonNull(nextTrySupplier);
        return this.flatMapErr(t -> (Try)nextTrySupplier.get());
    }

    @NotNull
    public V recover(@NotNull Function<? super Throwable, ? extends V> var1);

    @NotNull
    public Throwable forfeit(@NotNull Function<? super V, ? extends Throwable> var1);

    @NotNull
    public V expect() throws NoSuchElementException;

    @NotNull
    public <X extends Exception> V getOrThrow(@NotNull Function<? super Throwable, X> var1) throws X;

    private static <IN, OUT> Try<OUT> mapChecked(IN in, ExFunction<? super IN, ? extends OUT> fn) {
        try {
            return Success.of(fn.apply(in));
        }
        catch (Throwable t) {
            return Failure.of(t);
        }
    }

    private static <IN, OUT> Try<OUT> flatMapChecked(IN in, ExFunction<? super IN, ? extends Try<? extends OUT>> fn) {
        try {
            return Objects.requireNonNull(fn.apply(in));
        }
        catch (Throwable t) {
            return Failure.of(t);
        }
    }

    private static <E extends Throwable> void sneakyThrow(Throwable e) throws E {
        throw e;
    }

    public record Success<T>(@NotNull T value) implements Try<T>
    {
        public Success(@NotNull T value) {
            Objects.requireNonNull(value);
        }

        public static Success<Empty> of() {
            return new Success<Empty>(Empty.getInstance());
        }

        public static <U> Success<U> of(@NotNull U value) {
            return new Success<U>(value);
        }

        @Override
        public boolean isFailure() {
            return false;
        }

        @Override
        public boolean isSuccess() {
            return true;
        }

        @Override
        @NotNull
        public <V2> Try<V2> biFlatMap(@NotNull ExFunction<? super T, ? extends Try<? extends V2>> fnSuccess, @NotNull ExFunction<? super Throwable, ? extends Try<? extends V2>> fnFailure) {
            Objects.requireNonNull(fnFailure);
            return this.flatMap(fnSuccess);
        }

        @Override
        @NotNull
        public <V2> Try<V2> biMap(@NotNull ExFunction<? super T, ? extends V2> fnSuccess, @NotNull ExFunction<? super Throwable, ? extends Throwable> fnFailure) {
            Objects.requireNonNull(fnSuccess);
            Objects.requireNonNull(fnFailure);
            return Try.mapChecked(this.value, fnSuccess);
        }

        @Override
        @NotNull
        public <T1> T1 fold(@NotNull Function<? super T, ? extends T1> fnSuccess, @NotNull Function<? super Throwable, ? extends T1> fnFailure) {
            Objects.requireNonNull(fnSuccess);
            Objects.requireNonNull(fnFailure);
            return Objects.requireNonNull(fnSuccess.apply(this.value));
        }

        @Override
        @NotNull
        public Stream<T> stream() {
            return Stream.of(this.value);
        }

        @Override
        @NotNull
        public Try<T> filter(@NotNull Predicate<? super T> predicate, @NotNull ExFunction<? super T, ? extends Throwable> fnUnmatched) {
            Objects.requireNonNull(predicate);
            Objects.requireNonNull(fnUnmatched);
            try {
                if (predicate.test(this.value)) {
                    return this;
                }
                return Failure.of(fnUnmatched.apply(this.value));
            }
            catch (Throwable t) {
                return Failure.of(t);
            }
        }

        @Override
        @NotNull
        public Try<T> exec(@NotNull ExConsumer<? super T> successConsumer) {
            Objects.requireNonNull(successConsumer);
            try {
                successConsumer.accept(this.value);
                return this;
            }
            catch (Throwable t) {
                return Failure.of(t);
            }
        }

        @Override
        public void consume(@NotNull Consumer<? super T> successConsumer) {
            Objects.requireNonNull(successConsumer);
            successConsumer.accept(this.value);
        }

        @Override
        public void consumeErr(@NotNull Consumer<? super Throwable> failureConsumer) {
            Objects.requireNonNull(failureConsumer);
        }

        @Override
        @NotNull
        public <V2> Try<V2> map(@NotNull ExFunction<? super T, ? extends V2> fnSuccess) {
            Objects.requireNonNull(fnSuccess);
            return Try.mapChecked(this.value, fnSuccess);
        }

        @Override
        @NotNull
        public <V2> Try<V2> flatMap(@NotNull ExFunction<? super T, ? extends Try<? extends V2>> fnSuccess) {
            Objects.requireNonNull(fnSuccess);
            return Try.flatMapChecked(this.value, fnSuccess);
        }

        @Override
        @NotNull
        public Try<T> mapErr(@NotNull ExFunction<? super Throwable, ? extends Throwable> fnFailure) {
            Objects.requireNonNull(fnFailure);
            return this;
        }

        @Override
        @NotNull
        public Try<T> flatMapErr(@NotNull ExFunction<? super Throwable, ? extends Try<? extends T>> fnFailure) {
            Objects.requireNonNull(fnFailure);
            return this;
        }

        @Override
        public boolean ifPredicate(@NotNull Predicate<T> okPredicate) {
            Objects.requireNonNull(okPredicate);
            return okPredicate.test(this.value);
        }

        @Override
        public boolean contains(@Nullable T okValue) {
            return Objects.equals(this.value, okValue);
        }

        @Override
        @NotNull
        public T orElse(@NotNull T okAlternate) {
            Objects.requireNonNull(okAlternate);
            return this.value;
        }

        @Override
        @NotNull
        public T orElseGet(@NotNull Supplier<? extends T> okSupplier) {
            Objects.requireNonNull(okSupplier);
            return this.value;
        }

        @Override
        @NotNull
        public <V2> Try<V2> and(@NotNull Try<V2> nextTry) {
            Objects.requireNonNull(nextTry);
            return nextTry;
        }

        @Override
        @NotNull
        public Try<T> or(@NotNull Try<T> nextTry) {
            Objects.requireNonNull(nextTry);
            return this;
        }

        @Override
        @NotNull
        public T recover(@NotNull Function<? super Throwable, ? extends T> fnFailureToSuccess) {
            Objects.requireNonNull(fnFailureToSuccess);
            return this.value;
        }

        @Override
        @NotNull
        public Throwable forfeit(@NotNull Function<? super T, ? extends Throwable> fnSuccessToFailure) {
            Objects.requireNonNull(fnSuccessToFailure);
            return Objects.requireNonNull(fnSuccessToFailure.apply(this.value));
        }

        @Override
        @NotNull
        public T expect() throws NoSuchElementException {
            return this.value;
        }

        @Override
        @NotNull
        public <X extends Exception> T getOrThrow(@NotNull Function<? super Throwable, X> exFn) throws X {
            Objects.requireNonNull(exFn);
            return this.value;
        }
    }

    public record Failure<T>(@NotNull Throwable err) implements Try<T>
    {
        public Failure(@NotNull Throwable err) {
            Objects.requireNonNull(err);
            Failure.throwIfFatal(err);
        }

        public static <U> Failure<U> of(@NotNull Throwable t) {
            return new Failure(t);
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @Override
        public boolean isSuccess() {
            return false;
        }

        @Override
        @NotNull
        public <V2> Try<V2> biFlatMap(@NotNull ExFunction<? super T, ? extends Try<? extends V2>> fnSuccess, @NotNull ExFunction<? super Throwable, ? extends Try<? extends V2>> fnFailure) {
            Objects.requireNonNull(fnSuccess);
            Objects.requireNonNull(fnFailure);
            return Try.flatMapChecked(this.err, fnFailure);
        }

        @Override
        @NotNull
        public <V2> Try<V2> biMap(@NotNull ExFunction<? super T, ? extends V2> fnSuccess, @NotNull ExFunction<? super Throwable, ? extends Throwable> fnFailure) {
            Objects.requireNonNull(fnSuccess);
            Objects.requireNonNull(fnFailure);
            return this.failMap(fnFailure);
        }

        private <V2> Try<V2> failMap(ExFunction<? super Throwable, ? extends Throwable> fnFailure) {
            try {
                return Failure.of(Objects.requireNonNull(fnFailure.apply(this.err)));
            }
            catch (Throwable t) {
                return Failure.of(t);
            }
        }

        @Override
        @NotNull
        public <U> U fold(@NotNull Function<? super T, ? extends U> fnSuccess, @NotNull Function<? super Throwable, ? extends U> fnFailure) {
            Objects.requireNonNull(fnSuccess);
            Objects.requireNonNull(fnFailure);
            return Objects.requireNonNull(fnFailure.apply(this.err));
        }

        @Override
        @NotNull
        public Stream<T> stream() {
            return Stream.empty();
        }

        @Override
        @NotNull
        public Try<T> filter(@NotNull Predicate<? super T> predicate, @NotNull ExFunction<? super T, ? extends Throwable> fnUnmatched) {
            Objects.requireNonNull(predicate);
            Objects.requireNonNull(fnUnmatched);
            return this;
        }

        @Override
        @NotNull
        public Try<T> exec(@NotNull ExConsumer<? super T> successConsumer) {
            Objects.requireNonNull(successConsumer);
            return this;
        }

        @Override
        public void consume(@NotNull Consumer<? super T> successConsumer) {
            Objects.requireNonNull(successConsumer);
        }

        @Override
        @NotNull
        public <V2> Try<V2> map(@NotNull ExFunction<? super T, ? extends V2> fnSuccess) {
            Objects.requireNonNull(fnSuccess);
            return this.coerce();
        }

        @Override
        @NotNull
        public <V2> Try<V2> flatMap(@NotNull ExFunction<? super T, ? extends Try<? extends V2>> fnSuccess) {
            Objects.requireNonNull(fnSuccess);
            return this.coerce();
        }

        @Override
        @NotNull
        public Try<T> mapErr(@NotNull ExFunction<? super Throwable, ? extends Throwable> fnFailure) {
            Objects.requireNonNull(fnFailure);
            return this.failMap(fnFailure);
        }

        @Override
        @NotNull
        public Try<T> flatMapErr(@NotNull ExFunction<? super Throwable, ? extends Try<? extends T>> fnFailure) {
            Objects.requireNonNull(fnFailure);
            return Try.flatMapChecked(this.err, fnFailure);
        }

        @Override
        public boolean ifPredicate(@NotNull Predicate<T> okPredicate) {
            Objects.requireNonNull(okPredicate);
            return false;
        }

        @Override
        public boolean contains(@Nullable T okValue) {
            return false;
        }

        @Override
        @NotNull
        public T orElse(@NotNull T okAlternate) {
            Objects.requireNonNull(okAlternate);
            return okAlternate;
        }

        @Override
        @NotNull
        public T orElseGet(@NotNull Supplier<? extends T> okSupplier) {
            Objects.requireNonNull(okSupplier);
            return Objects.requireNonNull(okSupplier.get());
        }

        @Override
        @NotNull
        public <V2> Try<V2> and(@NotNull Try<V2> nextTry) {
            Objects.requireNonNull(nextTry);
            return this.coerce();
        }

        @Override
        @NotNull
        public Try<T> or(@NotNull Try<T> nextTry) {
            Objects.requireNonNull(nextTry);
            return nextTry;
        }

        @Override
        @NotNull
        public T recover(@NotNull Function<? super Throwable, ? extends T> fnFailureToSuccess) {
            Objects.requireNonNull(fnFailureToSuccess);
            return Objects.requireNonNull(fnFailureToSuccess.apply(this.err));
        }

        @Override
        @NotNull
        public Throwable forfeit(@NotNull Function<? super T, ? extends Throwable> fnSuccessToFailure) {
            Objects.requireNonNull(fnSuccessToFailure);
            return this.err;
        }

        @Override
        public void consumeErr(@NotNull Consumer<? super Throwable> failureConsumer) {
            Objects.requireNonNull(failureConsumer);
            failureConsumer.accept(this.err);
        }

        @Override
        @NotNull
        public T expect() throws NoSuchElementException {
            throw new NoSuchElementException(this.err);
        }

        @Override
        @NotNull
        public <X extends Exception> T getOrThrow(@NotNull Function<? super Throwable, X> exFn) throws X {
            Objects.requireNonNull(exFn);
            throw Objects.requireNonNull((Exception)exFn.apply(this.err));
        }

        private <V2> Failure<V2> coerce() {
            return this;
        }

        private static void throwIfFatal(Throwable t) {
            if (t instanceof VirtualMachineError || t instanceof LinkageError) {
                throw (Error)t;
            }
            if (t instanceof MatchException) {
                MatchException me = (MatchException)t;
                throw me;
            }
            if (t instanceof InterruptedException) {
                Try.sneakyThrow(t);
            }
        }
    }
}

