/*
 * Decompiled with CFR 0.152.
 */
package net.xyzsd.dichotomy.trying.function;

import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface ExFunction<T, R> {
    @NotNull
    public R apply(T var1) throws Throwable;

    @NotNull
    public static <IN, OUT> ExFunction<IN, OUT> from(@NotNull Function<IN, OUT> fn) {
        Objects.requireNonNull(fn);
        return Objects.requireNonNull(fn::apply);
    }

    @NotNull
    default public <V> ExFunction<V, R> compose(@NotNull ExFunction<? super V, ? extends T> before) {
        Objects.requireNonNull(before);
        return v -> this.apply(before.apply((Object)v));
    }

    @NotNull
    default public <V> ExFunction<T, V> andThen(@NotNull ExFunction<? super R, ? extends V> after) {
        Objects.requireNonNull(after);
        return t -> after.apply((R)this.apply(t));
    }

    @NotNull
    public static <T> ExFunction<T, T> identity() {
        return t -> t;
    }
}

