/*
 * Decompiled with CFR 0.152.
 */
package fluent.functions.icu;

import fluent.functions.FluentFunction;
import fluent.functions.FluentFunctionFactory;
import fluent.functions.FluentImplicit;
import fluent.functions.FunctionResources;
import fluent.functions.icu.ICUPluralSelector;
import fluent.functions.icu.list.CountFn;
import fluent.functions.icu.list.JoinFn;
import fluent.functions.icu.list.NumSortFn;
import fluent.functions.icu.list.StringSortFn;
import fluent.functions.icu.numeric.AbsFn;
import fluent.functions.icu.numeric.AddFn;
import fluent.functions.icu.numeric.CompactFn;
import fluent.functions.icu.numeric.CurrencyFn;
import fluent.functions.icu.numeric.DecimalFn;
import fluent.functions.icu.numeric.NumberFn;
import fluent.functions.icu.numeric.SignFn;
import fluent.functions.icu.string.CaseFn;
import fluent.functions.icu.temporal.TemporalFn;
import java.util.Locale;
import java.util.Set;

public enum ICUFunctionFactory implements FluentFunctionFactory
{
    INSTANCE;

    private final Set<FluentImplicit> implicits = Set.of(new NumberFn(), new JoinFn(), new TemporalFn());
    private final Set<FluentFunction> functions = Set.of(new CountFn(), new NumSortFn(), new StringSortFn(), new AbsFn(), new AddFn(), new CompactFn(), new CurrencyFn(), new DecimalFn(), new SignFn(), new CaseFn());

    public Set<FluentImplicit> implicits() {
        return this.implicits;
    }

    public Set<FluentFunction> functions() {
        return this.functions;
    }

    public FunctionResources resources(Locale locale) {
        return new ICUPluralSelector(locale);
    }
}

