/*
 * Decompiled with CFR 0.152.
 */
package fluent.functions.icu;

import com.ibm.icu.number.FormattedNumber;
import com.ibm.icu.number.LocalizedNumberFormatter;
import com.ibm.icu.number.NumberFormatter;
import com.ibm.icu.number.Precision;
import com.ibm.icu.text.PluralRules;
import fluent.functions.FunctionResources;
import java.math.BigDecimal;
import java.util.Locale;

public class ICUPluralSelector
implements FunctionResources {
    private final PluralRules cardinalRule;
    private final PluralRules ordinalRule;
    private final LocalizedNumberFormatter lnf;
    private final Locale locale;

    ICUPluralSelector(Locale locale) {
        this.locale = locale;
        this.cardinalRule = PluralRules.forLocale((Locale)locale, (PluralRules.PluralType)PluralRules.PluralType.CARDINAL);
        this.ordinalRule = PluralRules.forLocale((Locale)locale, (PluralRules.PluralType)PluralRules.PluralType.ORDINAL);
        this.lnf = NumberFormatter.withLocale((Locale)locale);
    }

    public Locale locale() {
        return this.locale;
    }

    public String selectCardinal(Number num) {
        return this.cardinalRule.select(this.toFormattedNumber(num));
    }

    public String selectOrdinal(Number num) {
        return this.ordinalRule.select(this.toFormattedNumber(num));
    }

    private FormattedNumber toFormattedNumber(Number num) {
        if (num instanceof Long) {
            return this.lnf.format(num.longValue());
        }
        BigDecimal bigDecimal = num instanceof BigDecimal ? (BigDecimal)num : BigDecimal.valueOf(num.doubleValue());
        int v = Math.max(0, bigDecimal.scale());
        return ((LocalizedNumberFormatter)this.lnf.precision((Precision)Precision.fixedFraction((int)v))).format((Number)bigDecimal);
    }
}

