/*
 * Decompiled with CFR 0.152.
 */
package fluent.functions.icu.list;

import fluent.bundle.resolver.Scope;
import fluent.functions.FluentImplicit;
import fluent.functions.ImplicitReducer;
import fluent.functions.ResolvedParameters;
import fluent.syntax.AST.SelectExpression;
import fluent.types.FluentString;
import fluent.types.FluentValue;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class JoinFn
implements FluentImplicit,
ImplicitReducer {
    private static final String DEFAULT_SEPARATOR = ", ";

    public FluentImplicit.Implicit id() {
        return FluentImplicit.Implicit.JOIN;
    }

    public List<FluentValue<?>> apply(ResolvedParameters params, Scope scope) {
        return List.of(FluentString.of((String)JoinFn.reduceToString(params, scope)));
    }

    public String reduce(List<FluentValue<?>> in, Scope scope) {
        if (in.size() == 1) {
            return in.get(0).format(scope);
        }
        if (in.isEmpty()) {
            return "";
        }
        return JoinFn.reduceToString(ResolvedParameters.from(in, (Scope)scope), scope);
    }

    public List<FluentValue<?>> select(SelectExpression selectExpression, ResolvedParameters params, Scope initialScope) {
        return params.valuesAll().map(v -> v.select(selectExpression, params, initialScope)).map(v -> v.value().resolve(initialScope)).flatMap(Collection::stream).toList();
    }

    private static String reduceToString(ResolvedParameters params, Scope scope) {
        if (params.noPositionals()) {
            return "";
        }
        FluentValue<?> single = JoinFn.hasSinglePositional(params);
        if (single != null) {
            return single.format(scope);
        }
        if (params.options().isEmpty()) {
            return params.valuesAll().map(v -> v.format(scope)).filter(Predicate.not(String::isEmpty)).collect(Collectors.joining(DEFAULT_SEPARATOR));
        }
        String separator = params.options().asString("separator").orElse(DEFAULT_SEPARATOR);
        String junction = params.options().asString("junction").orElse(DEFAULT_SEPARATOR);
        String pairSeparator = params.options().asString("pairSeparator").orElse(junction);
        List list = params.valuesAll().toList();
        assert (list.size() > 1);
        StringBuilder sb = new StringBuilder(128);
        if (list.size() == 2) {
            sb.append(((FluentValue)list.get(0)).format(scope));
            sb.append(pairSeparator);
            sb.append(((FluentValue)list.get(1)).format(scope));
        } else {
            int sizeM2 = list.size() - 2;
            for (int i = 0; i < sizeM2; ++i) {
                sb.append(((FluentValue)list.get(i)).format(scope));
                sb.append(separator);
            }
            sb.append(((FluentValue)list.get(sizeM2)).format(scope));
            sb.append(junction);
            sb.append(((FluentValue)list.get(sizeM2 + 1)).format(scope));
        }
        return sb.toString();
    }

    @Nullable
    private static FluentValue<?> hasSinglePositional(ResolvedParameters params) {
        if (params.positionalCount() == 1 && params.valueCount(ResolvedParameters.Positional.FIRST) == 1) {
            return (FluentValue)params.valueFirst(ResolvedParameters.Positional.FIRST).orElseThrow();
        }
        return null;
    }
}

