/*
 * Decompiled with CFR 0.152.
 */
package fluent.functions.icu.list;

import fluent.bundle.resolver.Scope;
import fluent.functions.FluentFunction;
import fluent.functions.FluentFunctionException;
import fluent.functions.ResolvedParameters;
import fluent.types.FluentNumber;
import fluent.types.FluentValue;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;

public class NumSortFn
implements FluentFunction {
    public static final String NAME = "NUMSORT";

    public String name() {
        return NAME;
    }

    public List<FluentValue<?>> apply(ResolvedParameters params, Scope scope) {
        FluentFunction.ensureInput((ResolvedParameters)params);
        Order order = params.options().asEnum(Order.class, "order").orElse(Order.ASCENDING);
        return params.valuesAll().map(NumSortFn::toBigDecimal).sorted(order.comparator()).map(FluentNumber::of).toList();
    }

    private static BigDecimal toBigDecimal(FluentValue<?> in) {
        FluentValue<?> fluentValue = in;
        if (fluentValue instanceof FluentNumber) {
            FluentNumber fluentNumber = (FluentNumber)fluentValue;
            return fluentNumber.asBigDecimal();
        }
        throw FluentFunctionException.create((String)"Expected numeric value, not non-numeric FluentValue: '%s'", (Object[])new Object[]{in});
    }

    private static enum Order {
        ASCENDING(Comparator.naturalOrder()),
        DESCENDING(Comparator.reverseOrder());

        private final Comparator<BigDecimal> cmp;

        private Order(Comparator<BigDecimal> comparator) {
            this.cmp = comparator;
        }

        Comparator<BigDecimal> comparator() {
            return this.cmp;
        }
    }
}

