/*
 * Decompiled with CFR 0.152.
 */
package fluent.functions.icu.list;

import fluent.bundle.resolver.Scope;
import fluent.functions.FluentFunction;
import fluent.functions.ResolvedParameters;
import fluent.types.FluentString;
import fluent.types.FluentValue;
import java.text.Collator;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;

public class StringSortFn
implements FluentFunction {
    public static final String NAME = "STRINGSORT";

    public String name() {
        return NAME;
    }

    public List<FluentValue<?>> apply(ResolvedParameters params, Scope scope) {
        FluentFunction.ensureInput((ResolvedParameters)params);
        Order order = params.options().asEnum(Order.class, "order").orElse(Order.NATURAL);
        Strength strength = params.options().asEnum(Strength.class, "strength").orElse(Strength.PRIMARY);
        Decomposition decomposition = params.options().asEnum(Decomposition.class, "decomposition").orElse(Decomposition.NONE);
        Collator col = Collator.getInstance(scope.bundle().locale());
        col.setStrength(strength.ordinal());
        col.setDecomposition(decomposition.ordinal());
        Comparator comparator = (fs1, fs2) -> col.compare(fs1.value(), fs2.value());
        comparator = order == Order.REVERSED ? comparator.reversed() : comparator;
        return params.valuesAll().map(v -> this.toFS((FluentValue<?>)v, scope)).sorted(comparator).map(Function.identity()).toList();
    }

    private FluentString toFS(FluentValue<?> in, Scope scope) {
        FluentValue<?> fluentValue = in;
        if (fluentValue instanceof FluentString) {
            FluentString fs = (FluentString)fluentValue;
            return fs;
        }
        return FluentString.of((String)in.format(scope));
    }

    private static enum Order {
        NATURAL,
        REVERSED;

    }

    private static enum Strength {
        PRIMARY,
        SECONDARY,
        TERTIARY,
        IDENTICAL;

    }

    private static enum Decomposition {
        NONE,
        CANONICAL,
        FULL;

    }
}

