/*
 * Decompiled with CFR 0.152.
 */
package fluent.functions.icu.numeric;

import fluent.bundle.resolver.Scope;
import fluent.functions.FluentFunction;
import fluent.functions.ResolvedParameters;
import fluent.types.FluentNumber;
import fluent.types.FluentValue;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Stream;

public class AbsFn
implements FluentFunction {
    public static final String NAME = "ABS";

    public String name() {
        return NAME;
    }

    public List<FluentValue<?>> apply(ResolvedParameters params, Scope scope) {
        FluentFunction.ensureInput((ResolvedParameters)params);
        return FluentFunction.mapOverNumbers((Stream)params.valuesAll(), (Scope)scope, AbsFn::abs);
    }

    private static FluentValue<?> abs(Number number) {
        Number number2 = number;
        if (number2 instanceof Long) {
            Long v = (Long)number2;
            return FluentNumber.of((long)Math.abs(v));
        }
        number2 = number;
        if (number2 instanceof Double) {
            Double v = (Double)number2;
            return FluentNumber.of((double)Math.abs(v));
        }
        number2 = number;
        if (number2 instanceof BigDecimal) {
            BigDecimal v = (BigDecimal)number2;
            return FluentNumber.of((BigDecimal)v.abs());
        }
        throw new IllegalStateException(String.valueOf(number));
    }
}

