/*
 * Decompiled with CFR 0.152.
 */
package fluent.functions.icu.numeric;

import fluent.bundle.resolver.Scope;
import fluent.functions.FluentFunction;
import fluent.functions.FluentFunctionException;
import fluent.functions.ResolvedParameters;
import fluent.types.FluentNumber;
import fluent.types.FluentValue;
import java.util.List;

public class AddFn
implements FluentFunction {
    public static final String NAME = "IADD";

    public String name() {
        return NAME;
    }

    public List<FluentValue<?>> apply(ResolvedParameters params, Scope scope) {
        FluentFunction.ensureInput((ResolvedParameters)params);
        long addend = params.options().asLong("addend").orElseThrow(() -> FluentFunctionException.create((String)"Missing required option 'addend'", (Object[])new Object[0]));
        return params.valuesAll().peek(FluentFunction::validate).map(v -> AddFn.asLongAndAdd(v, addend)).toList();
    }

    private static FluentValue<?> asLongAndAdd(FluentValue<?> in, long addend) {
        Long augend = ((FluentNumber.FluentLong)FluentFunction.asFluentValue(FluentNumber.FluentLong.class, in)).value();
        return FluentNumber.of((long)(augend + addend));
    }
}

