/*
 * Decompiled with CFR 0.152.
 */
package fluent.functions.icu.numeric;

import fluent.bundle.resolver.Scope;
import fluent.functions.FluentFunction;
import fluent.functions.ResolvedParameters;
import fluent.types.FluentValue;
import java.text.CompactNumberFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.stream.Stream;

public class CompactFn
implements FluentFunction {
    public static final String NAME = "COMPACT";

    public String name() {
        return NAME;
    }

    public List<FluentValue<?>> apply(ResolvedParameters params, Scope scope) {
        FluentFunction.ensureInput((ResolvedParameters)params);
        NumberFormat.Style style = params.options().asEnum(NumberFormat.Style.class, "style").orElse(NumberFormat.Style.SHORT);
        int minFractionDigits = params.options().asInt("minimumFractionDigits").orElse(0);
        CompactNumberFormat fmt = (CompactNumberFormat)NumberFormat.getCompactNumberInstance(scope.bundle().locale(), style);
        fmt.setMinimumFractionDigits(minFractionDigits);
        return FluentFunction.mapOverNumbers((Stream)params.valuesAll(), (Scope)scope, fmt::format);
    }
}

