/*
 * Decompiled with CFR 0.152.
 */
package fluent.functions.icu.numeric;

import fluent.bundle.resolver.Scope;
import fluent.functions.FluentFunction;
import fluent.functions.ResolvedParameters;
import fluent.types.FluentValue;
import java.text.NumberFormat;
import java.util.List;
import java.util.stream.Stream;

public class CurrencyFn
implements FluentFunction {
    public static final String NAME = "CURRENCY";

    public String name() {
        return NAME;
    }

    public List<FluentValue<?>> apply(ResolvedParameters params, Scope scope) {
        FluentFunction.ensureInput((ResolvedParameters)params);
        NumberFormat fmt = NumberFormat.getCurrencyInstance(scope.bundle().locale());
        fmt.setMinimumFractionDigits(params.options().asInt("minimumFractionDigits").orElse(fmt.getMinimumFractionDigits()));
        return FluentFunction.mapOverNumbers((Stream)params.valuesAll(), (Scope)scope, fmt::format);
    }
}

