/*
 * Decompiled with CFR 0.152.
 */
package fluent.functions.icu.numeric;

import fluent.bundle.resolver.Scope;
import fluent.functions.FluentFunction;
import fluent.functions.FluentFunctionException;
import fluent.functions.ResolvedParameters;
import fluent.types.FluentValue;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.stream.Stream;

public class DecimalFn
implements FluentFunction {
    public static final String NAME = "DECIMAL";

    public String name() {
        return NAME;
    }

    public List<FluentValue<?>> apply(ResolvedParameters params, Scope scope) {
        FluentFunction.ensureInput((ResolvedParameters)params);
        DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(scope.bundle().locale());
        df.setMinimumFractionDigits(params.options().asInt("minimumFractionDigits").orElse(df.getMinimumFractionDigits()));
        params.options().asString("pattern").ifPresent(pattern -> DecimalFn.applyPattern(df, pattern));
        return FluentFunction.mapOverNumbers((Stream)params.valuesAll(), (Scope)scope, df::format);
    }

    private static void applyPattern(DecimalFormat df, String pattern) {
        try {
            df.applyPattern(pattern);
        }
        catch (IllegalArgumentException e) {
            throw FluentFunctionException.create((String)"Invalid format pattern '%s'", (Object[])new Object[]{pattern});
        }
    }
}

