/*
 * Decompiled with CFR 0.152.
 */
package fluent.functions.icu.numeric;

import fluent.bundle.resolver.Scope;
import fluent.functions.FluentFunction;
import fluent.functions.FluentFunctionException;
import fluent.functions.FluentImplicit;
import fluent.functions.ImplicitFormatter;
import fluent.functions.Options;
import fluent.functions.ResolvedParameters;
import fluent.functions.icu.ICUPluralSelector;
import fluent.syntax.AST.SelectExpression;
import fluent.types.FluentNumber;
import fluent.types.FluentValue;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.stream.Stream;

public class NumberFn
implements FluentImplicit,
ImplicitFormatter {
    public FluentImplicit.Implicit id() {
        return FluentImplicit.Implicit.NUMBER;
    }

    public List<FluentValue<?>> apply(ResolvedParameters params, Scope scope) {
        FluentFunction.ensureInput((ResolvedParameters)params);
        SelectType type = params.options().asEnum(SelectType.class, "type").orElse(SelectType.STRING);
        return this.applyType(type, params, scope);
    }

    public List<FluentValue<?>> select(SelectExpression selectExpression, ResolvedParameters params, Scope scope) {
        FluentFunction.ensureInput((ResolvedParameters)params);
        SelectType type = params.options().asEnum(SelectType.class, "type").orElse(SelectType.CARDINAL);
        return this.applyType(type, params, scope);
    }

    private List<FluentValue<?>> applyType(SelectType type, ResolvedParameters params, Scope scope) {
        ICUPluralSelector pluralSelector = (ICUPluralSelector)scope.fnResources;
        Function<Number, String> pluralFn = switch (type) {
            case SelectType.CARDINAL -> pluralSelector::selectCardinal;
            case SelectType.ORDINAL -> pluralSelector::selectOrdinal;
            case SelectType.STRING -> {
                CustomFormatter formatter = CustomFormatter.create(params.options(), scope.bundle().locale());
                yield formatter::format;
            }
            default -> throw new IncompatibleClassChangeError();
        };
        return FluentFunction.mapOverNumbers((Stream)params.valuesAll(), (Scope)scope, pluralFn);
    }

    public String format(FluentValue<?> in, Scope scope) {
        assert (in instanceof FluentNumber);
        CustomFormatter formatter = CustomFormatter.create(scope.options(), scope.bundle().locale());
        return formatter.format((Number)((FluentNumber)in).value());
    }

    private static enum SelectType {
        CARDINAL,
        ORDINAL,
        STRING;

    }

    private static class CustomFormatter {
        private final NumberFormat formatter;
        private final int minSig;
        private final int maxSig;

        private CustomFormatter(NumberFormat primary, int minSig, int maxSig) {
            this.formatter = primary;
            this.minSig = minSig;
            this.maxSig = maxSig;
        }

        private CustomFormatter(NumberFormat primary) {
            this.formatter = primary;
            this.minSig = -1;
            this.maxSig = -1;
        }

        String format(Number number) {
            if (this.useSigFig()) {
                return this.sigFigFormat(number);
            }
            return this.formatter.format(number);
        }

        private String sigFigFormat(Number number) {
            if (!this.isFinite(number)) {
                return this.formatter.format(number);
            }
            MathContext mc = new MathContext(this.maxSig);
            BigDecimal bigDecimal = null;
            Number number2 = number;
            if (number2 instanceof BigDecimal) {
                BigDecimal bdIn = (BigDecimal)number2;
                bigDecimal = bdIn.round(mc);
            } else {
                bigDecimal = new BigDecimal(number.toString(), mc);
            }
            assert (bigDecimal != null);
            if (bigDecimal.precision() < this.minSig && bigDecimal.scale() >= 0) {
                int newScale = bigDecimal.precision() - bigDecimal.scale();
                bigDecimal = bigDecimal.setScale(newScale, RoundingMode.HALF_UP);
                int minFDOriginal = this.formatter.getMinimumFractionDigits();
                this.formatter.setMinimumFractionDigits(newScale);
                String result = this.formatter.format(bigDecimal);
                this.formatter.setMinimumFractionDigits(minFDOriginal);
                return result;
            }
            return this.formatter.format(bigDecimal);
        }

        private boolean useSigFig() {
            return this.minSig != -1 && this.maxSig != -1;
        }

        private boolean isFinite(Number number) {
            Double dbl;
            assert (!(number instanceof Float));
            Number number2 = number;
            return number2 instanceof Double && Double.isFinite(dbl = (Double)number2);
        }

        static CustomFormatter create(Options options, Locale locale) {
            if (options.isEmpty()) {
                DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(locale);
                df.setRoundingMode(RoundingMode.HALF_UP);
                return new CustomFormatter(df);
            }
            NFStyle style = options.asEnum(NFStyle.class, "style").orElse(NFStyle.DECIMAL);
            NumberFormat nf = switch (style) {
                case NFStyle.DECIMAL -> NumberFormat.getNumberInstance(locale);
                case NFStyle.CURRENCY -> NumberFormat.getCurrencyInstance(locale);
                case NFStyle.PERCENT -> NumberFormat.getPercentInstance(locale);
                default -> throw new IncompatibleClassChangeError();
            };
            nf.setRoundingMode(RoundingMode.HALF_UP);
            options.asBoolean("useGrouping").ifPresent(nf::setGroupingUsed);
            if (options.has("minimumSignificantDigits") || options.has("maximumSignificantDigits")) {
                int minSig = options.asInt("minimumSignificantDigits").orElse(1);
                int maxSig = options.asInt("maximumSignificantDigits").orElse(21);
                if (minSig < 1 || maxSig > 21 || minSig > maxSig) {
                    throw FluentFunctionException.create((String)"significant digits out of range (<1 or >21) or max < min", (Object[])new Object[0]);
                }
                return new CustomFormatter(nf, minSig, maxSig);
            }
            nf.setMinimumIntegerDigits(options.asInt("minimumIntegerDigits").stream().filter(v -> v >= 1 && v <= 21).findAny().orElse(nf.getMinimumIntegerDigits()));
            nf.setMinimumFractionDigits(options.asInt("minimumFractionDigits").stream().filter(v -> v >= 0 && v <= 21).findAny().orElse(nf.getMinimumFractionDigits()));
            nf.setMaximumFractionDigits(options.asInt("maximumFractionDigits").stream().filter(v -> v >= 0 && v <= 21 && v >= nf.getMinimumFractionDigits()).findAny().orElse(Math.max(nf.getMinimumFractionDigits(), nf.getMaximumFractionDigits())));
            return new CustomFormatter(nf);
        }
    }

    private static enum NFStyle {
        DECIMAL,
        CURRENCY,
        PERCENT;

    }
}

