/*
 * Decompiled with CFR 0.152.
 */
package fluent.functions.icu.numeric;

import fluent.bundle.resolver.Scope;
import fluent.functions.FluentFunction;
import fluent.functions.ResolvedParameters;
import fluent.types.FluentString;
import fluent.types.FluentValue;
import java.util.List;
import java.util.stream.Stream;

public class SignFn
implements FluentFunction {
    public static final String NAME = "SIGN";

    public String name() {
        return NAME;
    }

    public List<FluentValue<?>> apply(ResolvedParameters params, Scope scope) {
        FluentFunction.ensureInput((ResolvedParameters)params);
        return FluentFunction.mapOverNumbers((Stream)params.valuesAll(), (Scope)scope, SignFn::sign);
    }

    private static FluentValue<?> sign(Number number) {
        long l;
        Number number2 = number;
        if (number2 instanceof Double) {
            Double d = (Double)number2;
            if (Double.isNaN(d)) {
                return new FluentString("nan");
            }
            if (d == Double.POSITIVE_INFINITY) {
                return new FluentString("positiveInfinity");
            }
            if (d == Double.NEGATIVE_INFINITY) {
                return new FluentString("negativeInfinity");
            }
        }
        if ((l = number.longValue()) == 0L) {
            return new FluentString("zero");
        }
        return new FluentString(l > 0L ? "positive" : "negative");
    }
}

